/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import org.gradle.BuildResult;
import org.gradle.api.Describable;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.execution.taskgraph.TaskListenerInternal;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.internal.InternalBuildListener;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.time.Clock;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.ContinuousOperation;
import org.gradle.profile.FragmentedOperation;
import org.gradle.profile.ProfileListener;
import org.gradle.profile.ProjectProfile;
import org.gradle.profile.TaskExecution;

public class ProfileEventAdapter
implements InternalBuildListener,
ProjectEvaluationListener,
TaskListenerInternal,
DependencyResolutionListener,
BuildCompletionListener,
ArtifactTransformListener {
    private final BuildStartedTime buildStartedTime;
    private final Clock clock;
    private final ProfileListener listener;
    private final ThreadLocal<ContinuousOperation> currentTransformation = new ThreadLocal();
    private BuildProfile buildProfile;

    public ProfileEventAdapter(BuildStartedTime buildStartedTime, Clock clock, ProfileListener listener) {
        this.buildStartedTime = buildStartedTime;
        this.clock = clock;
        this.listener = listener;
    }

    public void buildStarted(Gradle gradle) {
        long now = this.clock.getCurrentTime();
        this.buildProfile = new BuildProfile(gradle.getStartParameter());
        this.buildProfile.setBuildStarted(now);
        this.buildProfile.setProfilingStarted(this.buildStartedTime.getStartTime());
    }

    public void settingsEvaluated(Settings settings) {
        this.buildProfile.setSettingsEvaluated(this.clock.getCurrentTime());
    }

    public void projectsLoaded(Gradle gradle) {
        this.buildProfile.setProjectsLoaded(this.clock.getCurrentTime());
    }

    public void projectsEvaluated(Gradle gradle) {
        this.buildProfile.setProjectsEvaluated(this.clock.getCurrentTime());
    }

    public void buildFinished(BuildResult result) {
        this.buildProfile.setSuccessful(result.getFailure() == null);
    }

    public void completed() {
        if (this.buildProfile != null) {
            this.buildProfile.setBuildFinished(this.clock.getCurrentTime());
            try {
                this.listener.buildFinished(this.buildProfile);
            }
            finally {
                this.buildProfile = null;
            }
        }
    }

    public void beforeEvaluate(Project project) {
        long now = this.clock.getCurrentTime();
        this.buildProfile.getProjectProfile(project.getPath()).getConfigurationOperation().setStart(now);
    }

    public void afterEvaluate(Project project, ProjectState state) {
        long now = this.clock.getCurrentTime();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project.getPath());
        projectProfile.getConfigurationOperation().setFinish(now);
    }

    public void beforeExecute(TaskIdentity taskIdentity) {
        long now = this.clock.getCurrentTime();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(taskIdentity.getProjectPath());
        projectProfile.getTaskProfile(taskIdentity.getTaskPath()).setStart(now);
    }

    public void afterExecute(TaskIdentity taskIdentity, TaskState state) {
        long now = this.clock.getCurrentTime();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(taskIdentity.getProjectPath());
        TaskExecution taskExecution = projectProfile.getTaskProfile(taskIdentity.getTaskPath());
        taskExecution.setFinish(now);
        taskExecution.completed(state);
    }

    public void beforeResolve(ResolvableDependencies dependencies) {
        long now = this.clock.getCurrentTime();
        this.buildProfile.getDependencySetProfile(dependencies.getPath()).setStart(now);
    }

    public void afterResolve(ResolvableDependencies dependencies) {
        long now = this.clock.getCurrentTime();
        this.buildProfile.getDependencySetProfile(dependencies.getPath()).setFinish(now);
    }

    public void beforeTransformerInvocation(Describable transformer, Describable subject) {
        long now = this.clock.getCurrentTime();
        String transformationDescription = subject.getDisplayName() + " with " + transformer.getDisplayName();
        FragmentedOperation transformationProfile = this.buildProfile.getTransformationProfile(transformationDescription);
        this.currentTransformation.set(transformationProfile.start(now));
    }

    public void afterTransformerInvocation(Describable transformer, Describable subject) {
        long now = this.clock.getCurrentTime();
        this.currentTransformation.get().setFinish(now);
        this.currentTransformation.remove();
    }
}

