/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal.tooling;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppComponent;
import org.gradle.language.cpp.CppExecutable;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppSharedLibrary;
import org.gradle.language.cpp.CppStaticLibrary;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultCppLibrary;
import org.gradle.language.cpp.internal.tooling.DefaultCompilationDetails;
import org.gradle.language.cpp.internal.tooling.DefaultCppApplicationModel;
import org.gradle.language.cpp.internal.tooling.DefaultCppBinaryModel;
import org.gradle.language.cpp.internal.tooling.DefaultCppComponentModel;
import org.gradle.language.cpp.internal.tooling.DefaultCppExecutableModel;
import org.gradle.language.cpp.internal.tooling.DefaultCppLibraryModel;
import org.gradle.language.cpp.internal.tooling.DefaultCppProjectModel;
import org.gradle.language.cpp.internal.tooling.DefaultCppSharedLibraryModel;
import org.gradle.language.cpp.internal.tooling.DefaultCppStaticLibraryModel;
import org.gradle.language.cpp.internal.tooling.DefaultCppTestSuiteModel;
import org.gradle.language.cpp.internal.tooling.DefaultLinkageDetails;
import org.gradle.language.cpp.internal.tooling.DefaultMacroDirective;
import org.gradle.language.cpp.internal.tooling.DefaultSourceFile;
import org.gradle.language.cpp.tasks.CppCompile;
import org.gradle.language.nativeplatform.ComponentWithExecutable;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingScheme;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;
import org.gradle.plugins.ide.internal.tooling.ToolingModelBuilderSupport;
import org.gradle.plugins.ide.internal.tooling.model.LaunchableGradleTask;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.model.cpp.CppProject;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class CppModelBuilder
implements ToolingModelBuilder {
    public boolean canBuild(String modelName) {
        return modelName.equals(CppProject.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        DefaultProjectIdentifier projectIdentifier = new DefaultProjectIdentifier(project.getRootDir(), project.getPath());
        CompilerOutputFileNamingSchemeFactory namingSchemeFactory = new CompilerOutputFileNamingSchemeFactory((RelativeFilePathResolver)((ProjectInternal)project).getFileResolver());
        DefaultCppComponentModel mainComponent = null;
        CppApplication application = (CppApplication)project.getComponents().withType(CppApplication.class).findByName("main");
        if (application != null) {
            mainComponent = new DefaultCppApplicationModel(application.getName(), (String)application.getBaseName().get(), this.binariesFor((CppComponent)application, (Iterable<File>)application.getPrivateHeaderDirs(), projectIdentifier, namingSchemeFactory));
        } else {
            DefaultCppLibrary library = (DefaultCppLibrary)project.getComponents().withType(CppLibrary.class).findByName("main");
            if (library != null) {
                mainComponent = new DefaultCppLibraryModel(library.getName(), (String)library.getBaseName().get(), this.binariesFor((CppComponent)library, (Iterable<File>)library.getAllHeaderDirs(), projectIdentifier, namingSchemeFactory));
            }
        }
        DefaultCppTestSuiteModel testComponent = null;
        CppTestSuite testSuite = (CppTestSuite)project.getComponents().withType(CppTestSuite.class).findByName("test");
        if (testSuite != null) {
            testComponent = new DefaultCppTestSuiteModel(testSuite.getName(), (String)testSuite.getBaseName().get(), this.binariesFor((CppComponent)testSuite, (Iterable<File>)testSuite.getPrivateHeaderDirs(), projectIdentifier, namingSchemeFactory));
        }
        return new DefaultCppProjectModel(projectIdentifier, mainComponent, testComponent);
    }

    private List<DefaultCppBinaryModel> binariesFor(CppComponent component, Iterable<File> headerDirs, DefaultProjectIdentifier projectIdentifier, CompilerOutputFileNamingSchemeFactory namingSchemeFactory) {
        ImmutableList headerDirsCopy = ImmutableList.copyOf(headerDirs);
        ArrayList<DefaultCppBinaryModel> binaries = new ArrayList<DefaultCppBinaryModel>();
        for (CppBinary binary : component.getBinaries().get()) {
            DefaultLinkageDetails linkageDetails;
            LaunchableGradleTask linkTaskModel;
            LinkExecutable linkTask;
            DefaultCppBinary cppBinary = (DefaultCppBinary)binary;
            PlatformToolProvider platformToolProvider = cppBinary.getPlatformToolProvider();
            CppCompile compileTask = (CppCompile)binary.getCompileTask().get();
            List<DefaultSourceFile> sourceFiles = this.sourceFiles(namingSchemeFactory, platformToolProvider, ((Directory)compileTask.getObjectFileDir().get()).getAsFile(), binary.getCppSource().getFiles());
            ImmutableList systemIncludes = ImmutableList.copyOf((Collection)compileTask.getSystemIncludes().getFiles());
            ImmutableList userIncludes = ImmutableList.copyOf((Collection)compileTask.getIncludes().getFiles());
            List<DefaultMacroDirective> macroDefines = this.macroDefines(compileTask);
            List<String> additionalArgs = this.args((List)compileTask.getCompilerArgs().get());
            CommandLineToolSearchResult compilerLookup = platformToolProvider.locateTool(ToolType.CPP_COMPILER);
            File compilerExe = compilerLookup.isAvailable() ? compilerLookup.getTool() : null;
            LaunchableGradleTask compileTaskModel = ToolingModelBuilderSupport.buildFromTask((LaunchableGradleTask)new LaunchableGradleTask(), (DefaultProjectIdentifier)projectIdentifier, (Task)compileTask);
            DefaultCompilationDetails compilationDetails = new DefaultCompilationDetails(compileTaskModel, compilerExe, ((Directory)compileTask.getObjectFileDir().get()).getAsFile(), sourceFiles, (List<File>)headerDirsCopy, (List<File>)systemIncludes, (List<File>)userIncludes, macroDefines, additionalArgs);
            if (binary instanceof CppExecutable || binary instanceof CppTestExecutable) {
                ComponentWithExecutable componentWithExecutable = (ComponentWithExecutable)binary;
                linkTask = (LinkExecutable)componentWithExecutable.getLinkTask().get();
                linkTaskModel = ToolingModelBuilderSupport.buildFromTask((LaunchableGradleTask)new LaunchableGradleTask(), (DefaultProjectIdentifier)projectIdentifier, (Task)((Task)componentWithExecutable.getExecutableFileProducer().get()));
                linkageDetails = new DefaultLinkageDetails(linkTaskModel, ((RegularFile)componentWithExecutable.getExecutableFile().get()).getAsFile(), this.args((List)linkTask.getLinkerArgs().get()));
                binaries.add(new DefaultCppExecutableModel(binary.getName(), cppBinary.getIdentity().getName(), (String)binary.getBaseName().get(), compilationDetails, linkageDetails));
                continue;
            }
            if (binary instanceof CppSharedLibrary) {
                CppSharedLibrary sharedLibrary = (CppSharedLibrary)binary;
                linkTask = (LinkSharedLibrary)sharedLibrary.getLinkTask().get();
                linkTaskModel = ToolingModelBuilderSupport.buildFromTask((LaunchableGradleTask)new LaunchableGradleTask(), (DefaultProjectIdentifier)projectIdentifier, (Task)((Task)sharedLibrary.getLinkFileProducer().get()));
                linkageDetails = new DefaultLinkageDetails(linkTaskModel, ((RegularFile)sharedLibrary.getLinkFile().get()).getAsFile(), this.args((List)linkTask.getLinkerArgs().get()));
                binaries.add(new DefaultCppSharedLibraryModel(binary.getName(), cppBinary.getIdentity().getName(), (String)binary.getBaseName().get(), compilationDetails, linkageDetails));
                continue;
            }
            if (!(binary instanceof CppStaticLibrary)) continue;
            CppStaticLibrary staticLibrary = (CppStaticLibrary)binary;
            LaunchableGradleTask createTaskModel = ToolingModelBuilderSupport.buildFromTask((LaunchableGradleTask)new LaunchableGradleTask(), (DefaultProjectIdentifier)projectIdentifier, (Task)((Task)staticLibrary.getLinkFileProducer().get()));
            DefaultLinkageDetails linkageDetails2 = new DefaultLinkageDetails(createTaskModel, ((RegularFile)staticLibrary.getLinkFile().get()).getAsFile(), Collections.emptyList());
            binaries.add(new DefaultCppStaticLibraryModel(binary.getName(), cppBinary.getIdentity().getName(), (String)binary.getBaseName().get(), compilationDetails, linkageDetails2));
        }
        return binaries;
    }

    private List<DefaultSourceFile> sourceFiles(CompilerOutputFileNamingSchemeFactory namingSchemeFactory, PlatformToolProvider platformToolProvider, File objDir, Set<File> files) {
        CompilerOutputFileNamingScheme namingScheme = namingSchemeFactory.create().withObjectFileNameSuffix(platformToolProvider.getObjectFileExtension()).withOutputBaseFolder(objDir);
        ArrayList<DefaultSourceFile> result = new ArrayList<DefaultSourceFile>(files.size());
        for (File file : files) {
            result.add(new DefaultSourceFile(file, namingScheme.map(file)));
        }
        return result;
    }

    private List<String> args(List<String> compilerArgs) {
        return ImmutableList.copyOf(compilerArgs);
    }

    private List<DefaultMacroDirective> macroDefines(CppCompile compileTask) {
        if (compileTask.getMacros().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DefaultMacroDirective> macros = new ArrayList<DefaultMacroDirective>(compileTask.getMacros().size());
        for (Map.Entry entry : compileTask.getMacros().entrySet()) {
            macros.add(new DefaultMacroDirective((String)entry.getKey(), (String)entry.getValue()));
        }
        return macros;
    }
}

