/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;

public class MerkleDirectorySnapshotBuilder
implements FileSystemSnapshotVisitor {
    private static final HashCode DIR_SIGNATURE = Hashing.signature((String)"DIR");
    private final RelativePathSegmentsTracker relativePathSegmentsTracker = new RelativePathSegmentsTracker();
    private final Deque<List<FileSystemLocationSnapshot>> levelHolder = new ArrayDeque<List<FileSystemLocationSnapshot>>();
    private final Deque<String> directoryAbsolutePaths = new ArrayDeque<String>();
    private final boolean sortingRequired;
    private FileSystemLocationSnapshot result;

    public static MerkleDirectorySnapshotBuilder sortingRequired() {
        return new MerkleDirectorySnapshotBuilder(true);
    }

    public static MerkleDirectorySnapshotBuilder noSortingRequired() {
        return new MerkleDirectorySnapshotBuilder(false);
    }

    private MerkleDirectorySnapshotBuilder(boolean sortingRequired) {
        this.sortingRequired = sortingRequired;
    }

    public void preVisitDirectory(String absolutePath, String name) {
        this.relativePathSegmentsTracker.enter(name);
        this.levelHolder.addLast(new ArrayList());
        this.directoryAbsolutePaths.addLast(absolutePath);
    }

    @Override
    public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
        this.preVisitDirectory(directorySnapshot.getAbsolutePath(), directorySnapshot.getName());
        return true;
    }

    @Override
    public void visitFile(FileSystemLocationSnapshot fileSnapshot) {
        if (this.relativePathSegmentsTracker.isRoot()) {
            this.result = fileSnapshot;
        } else {
            this.levelHolder.peekLast().add(fileSnapshot);
        }
    }

    @Override
    public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
        this.postVisitDirectory(true);
    }

    public void postVisitDirectory() {
        this.postVisitDirectory(true);
    }

    public boolean postVisitDirectory(boolean includeEmpty) {
        String name = this.relativePathSegmentsTracker.leave();
        List<FileSystemLocationSnapshot> children = this.levelHolder.removeLast();
        String absolutePath = this.directoryAbsolutePaths.removeLast();
        if (children.isEmpty() && !includeEmpty) {
            return false;
        }
        if (this.sortingRequired) {
            children.sort(FileSystemLocationSnapshot.BY_NAME);
        }
        Hasher hasher = Hashing.newHasher();
        hasher.putHash(DIR_SIGNATURE);
        for (FileSystemLocationSnapshot child : children) {
            hasher.putString((CharSequence)child.getName());
            hasher.putHash(child.getHash());
        }
        DirectorySnapshot directorySnapshot = new DirectorySnapshot(absolutePath, name, children, hasher.hash());
        List<FileSystemLocationSnapshot> siblings = this.levelHolder.peekLast();
        if (siblings != null) {
            siblings.add(directorySnapshot);
        } else {
            this.result = directorySnapshot;
        }
        return true;
    }

    public boolean isRoot() {
        return this.relativePathSegmentsTracker.isRoot();
    }

    public Iterable<String> getRelativePath() {
        return this.relativePathSegmentsTracker.getRelativePath();
    }

    @Nullable
    public FileSystemLocationSnapshot getResult() {
        return this.result;
    }
}

