/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.CacheableInvocation;
import org.gradle.api.internal.artifacts.transform.CachingTransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceIdentity;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceProvider;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvocationFactory;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.internal.Try;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.execution.CachingResult;
import org.gradle.internal.execution.Context;
import org.gradle.internal.execution.ExecutionRequestContext;
import org.gradle.internal.execution.InputChangesContext;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.WorkExecutor;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.fingerprint.FileCollectionSnapshotter;
import org.gradle.internal.fingerprint.OutputNormalizer;
import org.gradle.internal.fingerprint.overlap.OverlappingOutputs;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.CompositeFileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.work.InputChanges;

public class DefaultTransformerInvocationFactory
implements TransformerInvocationFactory {
    private static final CachingDisabledReason NOT_CACHEABLE = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching not enabled.");
    private static final String INPUT_ARTIFACT_PROPERTY_NAME = "inputArtifact";
    private static final String DEPENDENCIES_PROPERTY_NAME = "inputArtifactDependencies";
    private static final String SECONDARY_INPUTS_HASH_PROPERTY_NAME = "inputPropertiesHash";
    private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "outputDirectory";
    private static final String RESULTS_FILE_PROPERTY_NAME = "resultsFile";
    private static final String INPUT_FILE_PATH_PREFIX = "i/";
    private static final String OUTPUT_FILE_PATH_PREFIX = "o/";
    private final VirtualFileSystem virtualFileSystem;
    private final WorkExecutor<ExecutionRequestContext, CachingResult> workExecutor;
    private final ArtifactTransformListener artifactTransformListener;
    private final CachingTransformationWorkspaceProvider immutableTransformationWorkspaceProvider;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileCollectionSnapshotter fileCollectionSnapshotter;
    private final ProjectFinder projectFinder;
    private final BuildOperationExecutor buildOperationExecutor;

    public DefaultTransformerInvocationFactory(WorkExecutor<ExecutionRequestContext, CachingResult> workExecutor, VirtualFileSystem virtualFileSystem, ArtifactTransformListener artifactTransformListener, CachingTransformationWorkspaceProvider immutableTransformationWorkspaceProvider, FileCollectionFactory fileCollectionFactory, FileCollectionSnapshotter fileCollectionSnapshotter, ProjectFinder projectFinder, BuildOperationExecutor buildOperationExecutor) {
        this.workExecutor = workExecutor;
        this.virtualFileSystem = virtualFileSystem;
        this.artifactTransformListener = artifactTransformListener;
        this.immutableTransformationWorkspaceProvider = immutableTransformationWorkspaceProvider;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileCollectionSnapshotter = fileCollectionSnapshotter;
        this.projectFinder = projectFinder;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public CacheableInvocation<ImmutableList<File>> createInvocation(final Transformer transformer, final File inputArtifact, final ArtifactTransformDependencies dependencies, final TransformationSubject subject, FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        ProjectInternal producerProject = this.determineProducerProject(subject);
        final CachingTransformationWorkspaceProvider workspaceProvider = this.determineWorkspaceProvider(producerProject);
        final FileCollectionFingerprinter inputArtifactFingerprinter = fingerprinterRegistry.getFingerprinter(transformer.getInputArtifactNormalizer());
        final FileCollectionFingerprinter outputFingerprinter = fingerprinterRegistry.getFingerprinter(OutputNormalizer.class);
        FileCollectionFingerprinter dependencyFingerprinter = fingerprinterRegistry.getFingerprinter(transformer.getInputArtifactDependenciesNormalizer());
        final CompleteFileSystemLocationSnapshot inputArtifactSnapshot = (CompleteFileSystemLocationSnapshot)this.virtualFileSystem.read(inputArtifact.getAbsolutePath(), Function.identity());
        String normalizedInputPath = inputArtifactFingerprinter.normalizePath(inputArtifactSnapshot);
        final CurrentFileCollectionFingerprint dependenciesFingerprint = dependencies.fingerprint(dependencyFingerprinter);
        final TransformationWorkspaceIdentity identity = DefaultTransformerInvocationFactory.getTransformationIdentity(producerProject, inputArtifactSnapshot, normalizedInputPath, transformer, dependenciesFingerprint);
        return new CacheableInvocation<ImmutableList<File>>(){
            private Try<ImmutableList<File>> cachedResult;

            @Override
            public Try<ImmutableList<File>> invoke() {
                return this.cachedResult != null ? this.cachedResult : DefaultTransformerInvocationFactory.this.doTransform(workspaceProvider, identity, transformer, subject, inputArtifact, inputArtifactSnapshot, dependencies, dependenciesFingerprint, inputArtifactFingerprinter, outputFingerprinter);
            }

            @Override
            public Optional<Try<ImmutableList<File>>> getCachedResult() {
                this.cachedResult = workspaceProvider.getCachedResult(identity);
                return Optional.ofNullable(this.cachedResult);
            }
        };
    }

    private Try<ImmutableList<File>> doTransform(final CachingTransformationWorkspaceProvider workspaceProvider, TransformationWorkspaceIdentity identity, final Transformer transformer, final TransformationSubject subject, final File inputArtifact, final CompleteFileSystemLocationSnapshot inputArtifactSnapshot, final ArtifactTransformDependencies dependencies, final CurrentFileCollectionFingerprint dependenciesFingerprint, final FileCollectionFingerprinter inputArtifactFingerprinter, final FileCollectionFingerprinter outputFingerprinter) {
        return workspaceProvider.withWorkspace(identity, (identityString, workspace) -> (Try)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Try<ImmutableList<File>>>(){

            public Try<ImmutableList<File>> call(BuildOperationContext context) {
                return DefaultTransformerInvocationFactory.this.fireTransformListeners(transformer, subject, () -> {
                    String transformIdentity = "transform/" + identityString;
                    ExecutionHistoryStore executionHistoryStore = workspaceProvider.getExecutionHistoryStore();
                    ImmutableSortedMap outputsBeforeExecution = DefaultTransformerInvocationFactory.snapshotOutputs(DefaultTransformerInvocationFactory.this.fileCollectionSnapshotter, DefaultTransformerInvocationFactory.this.fileCollectionFactory, workspace);
                    final TransformerExecution execution = new TransformerExecution(transformer, workspace, transformIdentity, inputArtifact, inputArtifactSnapshot, dependencies, dependenciesFingerprint, (ImmutableSortedMap<String, FileSystemSnapshot>)outputsBeforeExecution, executionHistoryStore, DefaultTransformerInvocationFactory.this.fileCollectionFactory, DefaultTransformerInvocationFactory.this.fileCollectionSnapshotter, inputArtifactFingerprinter, outputFingerprinter);
                    CachingResult outcome = (CachingResult)DefaultTransformerInvocationFactory.this.workExecutor.execute((Context)new ExecutionRequestContext(){

                        public UnitOfWork getWork() {
                            return execution;
                        }

                        public Optional<String> getRebuildReason() {
                            return Optional.empty();
                        }
                    });
                    return outcome.getOutcome().tryMap(outcome1 -> execution.loadResultsFile()).mapFailure(failure -> new TransformException(String.format("Execution failed for %s.", execution.getDisplayName()), (Throwable)failure));
                });
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = transformer.getDisplayName() + " " + inputArtifact.getName();
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName);
            }
        }));
    }

    private static TransformationWorkspaceIdentity getTransformationIdentity(@Nullable ProjectInternal project, CompleteFileSystemLocationSnapshot inputArtifactSnapshot, String inputArtifactPath, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return project == null ? DefaultTransformerInvocationFactory.getImmutableTransformationIdentity(inputArtifactPath, inputArtifactSnapshot, transformer, dependenciesFingerprint) : DefaultTransformerInvocationFactory.getMutableTransformationIdentity(inputArtifactSnapshot, transformer, dependenciesFingerprint);
    }

    private static TransformationWorkspaceIdentity getImmutableTransformationIdentity(String inputArtifactPath, CompleteFileSystemLocationSnapshot inputArtifactSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return new ImmutableTransformationWorkspaceIdentity(inputArtifactPath, inputArtifactSnapshot.getHash(), transformer.getSecondaryInputHash(), dependenciesFingerprint.getHash());
    }

    private static TransformationWorkspaceIdentity getMutableTransformationIdentity(CompleteFileSystemLocationSnapshot inputArtifactSnapshot, Transformer transformer, CurrentFileCollectionFingerprint dependenciesFingerprint) {
        return new MutableTransformationWorkspaceIdentity(inputArtifactSnapshot.getAbsolutePath(), transformer.getSecondaryInputHash(), dependenciesFingerprint.getHash());
    }

    private CachingTransformationWorkspaceProvider determineWorkspaceProvider(@Nullable ProjectInternal producerProject) {
        if (producerProject == null) {
            return this.immutableTransformationWorkspaceProvider;
        }
        return (CachingTransformationWorkspaceProvider)producerProject.getServices().get(CachingTransformationWorkspaceProvider.class);
    }

    @Nullable
    private ProjectInternal determineProducerProject(TransformationSubject subject) {
        if (!subject.getProducer().isPresent()) {
            return null;
        }
        ProjectComponentIdentifier projectComponentIdentifier = subject.getProducer().get();
        return this.projectFinder.findProject(projectComponentIdentifier.getBuild(), projectComponentIdentifier.getProjectPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Try<ImmutableList<File>> fireTransformListeners(Transformer transformer, TransformationSubject subject, Supplier<Try<ImmutableList<File>>> execution) {
        this.artifactTransformListener.beforeTransformerInvocation((Describable)transformer, (Describable)subject);
        try {
            Try<ImmutableList<File>> try_ = execution.get();
            return try_;
        }
        finally {
            this.artifactTransformListener.afterTransformerInvocation((Describable)transformer, (Describable)subject);
        }
    }

    private static ImmutableSortedMap<String, FileSystemSnapshot> snapshotOutputs(FileCollectionSnapshotter fileCollectionSnapshotter, FileCollectionFactory fileCollectionFactory, TransformationWorkspaceProvider.TransformationWorkspace workspace) {
        List outputFingerprint = fileCollectionSnapshotter.snapshot((FileCollection)fileCollectionFactory.fixed(new File[]{workspace.getOutputDirectory()}));
        List resultsFileFingerprint = fileCollectionSnapshotter.snapshot((FileCollection)fileCollectionFactory.fixed(new File[]{workspace.getResultsFile()}));
        return ImmutableSortedMap.of((Comparable)((Object)OUTPUT_DIRECTORY_PROPERTY_NAME), (Object)CompositeFileSystemSnapshot.of((Collection)outputFingerprint), (Comparable)((Object)RESULTS_FILE_PROPERTY_NAME), (Object)CompositeFileSystemSnapshot.of((Collection)resultsFileFingerprint));
    }

    public static class MutableTransformationWorkspaceIdentity
    implements TransformationWorkspaceIdentity {
        private final String inputArtifactAbsolutePath;
        private final HashCode secondaryInputsHash;
        private final HashCode dependenciesHash;

        public MutableTransformationWorkspaceIdentity(String inputArtifactAbsolutePath, HashCode secondaryInputsHash, HashCode dependenciesHash) {
            this.inputArtifactAbsolutePath = inputArtifactAbsolutePath;
            this.secondaryInputsHash = secondaryInputsHash;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getIdentity() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.inputArtifactAbsolutePath);
            hasher.putHash(this.secondaryInputsHash);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MutableTransformationWorkspaceIdentity that = (MutableTransformationWorkspaceIdentity)o;
            if (!this.secondaryInputsHash.equals((Object)that.secondaryInputsHash)) {
                return false;
            }
            if (!this.dependenciesHash.equals((Object)that.dependenciesHash)) {
                return false;
            }
            return this.inputArtifactAbsolutePath.equals(that.inputArtifactAbsolutePath);
        }

        public int hashCode() {
            int result = this.inputArtifactAbsolutePath.hashCode();
            result = 31 * result + this.secondaryInputsHash.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static class ImmutableTransformationWorkspaceIdentity
    implements TransformationWorkspaceIdentity {
        private final String inputArtifactPath;
        private final HashCode inputArtifactHash;
        private final HashCode secondaryInputHash;
        private final HashCode dependenciesHash;

        public ImmutableTransformationWorkspaceIdentity(String inputArtifactPath, HashCode inputArtifactHash, HashCode secondaryInputHash, HashCode dependenciesHash) {
            this.inputArtifactPath = inputArtifactPath;
            this.inputArtifactHash = inputArtifactHash;
            this.secondaryInputHash = secondaryInputHash;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getIdentity() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString((CharSequence)this.inputArtifactPath);
            hasher.putHash(this.inputArtifactHash);
            hasher.putHash(this.secondaryInputHash);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableTransformationWorkspaceIdentity that = (ImmutableTransformationWorkspaceIdentity)o;
            if (!this.inputArtifactHash.equals((Object)that.inputArtifactHash)) {
                return false;
            }
            if (!this.inputArtifactPath.equals(that.inputArtifactPath)) {
                return false;
            }
            if (!this.secondaryInputHash.equals((Object)that.secondaryInputHash)) {
                return false;
            }
            return this.dependenciesHash.equals((Object)that.dependenciesHash);
        }

        public int hashCode() {
            int result = this.inputArtifactHash.hashCode();
            result = 31 * result + this.secondaryInputHash.hashCode();
            result = 31 * result + this.dependenciesHash.hashCode();
            return result;
        }
    }

    private static class TransformerExecution
    implements UnitOfWork {
        private final Transformer transformer;
        private final TransformationWorkspaceProvider.TransformationWorkspace workspace;
        private final File inputArtifact;
        private final String identityString;
        private final ExecutionHistoryStore executionHistoryStore;
        private final CompleteFileSystemLocationSnapshot inputArtifactSnapshot;
        private final ArtifactTransformDependencies dependencies;
        private final CurrentFileCollectionFingerprint dependenciesFingerprint;
        private final ImmutableSortedMap<String, FileSystemSnapshot> outputFileSnapshotsBeforeExecution;
        private final FileCollectionFactory fileCollectionFactory;
        private final FileCollectionSnapshotter fileCollectionSnapshotter;
        private final FileCollectionFingerprinter inputArtifactFingerprinter;
        private final FileCollectionFingerprinter outputFingerprinter;
        private final Timer executionTimer;
        private final Provider<FileSystemLocation> inputArtifactProvider;

        public TransformerExecution(Transformer transformer, TransformationWorkspaceProvider.TransformationWorkspace workspace, String identityString, File inputArtifact, CompleteFileSystemLocationSnapshot inputArtifactSnapshot, ArtifactTransformDependencies dependencies, CurrentFileCollectionFingerprint dependenciesFingerprint, ImmutableSortedMap<String, FileSystemSnapshot> outputFileSnapshotsBeforeExecution, ExecutionHistoryStore executionHistoryStore, FileCollectionFactory fileCollectionFactory, FileCollectionSnapshotter fileCollectionSnapshotter, FileCollectionFingerprinter inputArtifactFingerprinter, FileCollectionFingerprinter outputFingerprinter) {
            this.inputArtifactSnapshot = inputArtifactSnapshot;
            this.dependenciesFingerprint = dependenciesFingerprint;
            this.fileCollectionFactory = fileCollectionFactory;
            this.inputArtifact = inputArtifact;
            this.transformer = transformer;
            this.workspace = workspace;
            this.identityString = identityString;
            this.executionHistoryStore = executionHistoryStore;
            this.dependencies = dependencies;
            this.fileCollectionSnapshotter = fileCollectionSnapshotter;
            this.inputArtifactFingerprinter = inputArtifactFingerprinter;
            this.outputFingerprinter = outputFingerprinter;
            this.outputFileSnapshotsBeforeExecution = outputFileSnapshotsBeforeExecution;
            this.executionTimer = Time.startTimer();
            this.inputArtifactProvider = Providers.of((Object)new DefaultFileSystemLocation(inputArtifact));
        }

        public UnitOfWork.WorkResult execute(@Nullable InputChangesInternal inputChanges, InputChangesContext context) {
            File outputDir = this.workspace.getOutputDirectory();
            File resultsFile = this.workspace.getResultsFile();
            ImmutableList<File> result = this.transformer.transform(this.inputArtifactProvider, outputDir, this.dependencies, (InputChanges)inputChanges);
            this.writeResultsFile(outputDir, resultsFile, result);
            return UnitOfWork.WorkResult.DID_WORK;
        }

        private void writeResultsFile(File outputDir, File resultsFile, ImmutableList<File> result) {
            String outputDirPrefix = outputDir.getPath() + File.separator;
            String inputFilePrefix = this.inputArtifact.getPath() + File.separator;
            Stream<String> relativePaths = result.stream().map(file -> {
                if (file.equals(outputDir)) {
                    return DefaultTransformerInvocationFactory.OUTPUT_FILE_PATH_PREFIX;
                }
                if (file.equals(this.inputArtifact)) {
                    return DefaultTransformerInvocationFactory.INPUT_FILE_PATH_PREFIX;
                }
                String absolutePath = file.getAbsolutePath();
                if (absolutePath.startsWith(outputDirPrefix)) {
                    return DefaultTransformerInvocationFactory.OUTPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(outputDirPrefix.length())).getPathString();
                }
                if (absolutePath.startsWith(inputFilePrefix)) {
                    return DefaultTransformerInvocationFactory.INPUT_FILE_PATH_PREFIX + RelativePath.parse((boolean)true, (String)absolutePath.substring(inputFilePrefix.length())).getPathString();
                }
                throw new IllegalStateException("Invalid result path: " + absolutePath);
            });
            UncheckedException.callUnchecked(() -> Files.write(resultsFile.toPath(), relativePaths::iterator, new OpenOption[0]));
        }

        private ImmutableList<File> loadResultsFile() {
            Path transformerResultsPath = this.workspace.getResultsFile().toPath();
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                List<String> paths = Files.readAllLines(transformerResultsPath, StandardCharsets.UTF_8);
                for (String path : paths) {
                    if (path.startsWith(DefaultTransformerInvocationFactory.OUTPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.workspace.getOutputDirectory(), path.substring(2)));
                        continue;
                    }
                    if (path.startsWith(DefaultTransformerInvocationFactory.INPUT_FILE_PATH_PREFIX)) {
                        builder.add((Object)new File(this.inputArtifact, path.substring(2)));
                        continue;
                    }
                    throw new IllegalStateException("Cannot parse result path string: " + path);
                }
                return builder.build();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public Optional<ExecutionHistoryStore> getExecutionHistoryStore() {
            return Optional.of(this.executionHistoryStore);
        }

        public Optional<Duration> getTimeout() {
            return Optional.empty();
        }

        public UnitOfWork.InputChangeTrackingStrategy getInputChangeTrackingStrategy() {
            return this.transformer.requiresInputChanges() ? UnitOfWork.InputChangeTrackingStrategy.INCREMENTAL_PARAMETERS : UnitOfWork.InputChangeTrackingStrategy.NONE;
        }

        public void visitImplementations(UnitOfWork.ImplementationVisitor visitor) {
            visitor.visitImplementation(this.transformer.getImplementationClass());
        }

        public void visitInputProperties(UnitOfWork.InputPropertyVisitor visitor) {
            visitor.visitInputProperty(DefaultTransformerInvocationFactory.SECONDARY_INPUTS_HASH_PROPERTY_NAME, (Object)this.transformer.getSecondaryInputHash().toString());
        }

        public void visitInputFileProperties(UnitOfWork.InputFilePropertyVisitor visitor) {
            visitor.visitInputFileProperty(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_PROPERTY_NAME, this.inputArtifactProvider, true, () -> this.inputArtifactFingerprinter.fingerprint((Iterable)ImmutableList.of((Object)this.inputArtifactSnapshot)));
            visitor.visitInputFileProperty(DefaultTransformerInvocationFactory.DEPENDENCIES_PROPERTY_NAME, (Object)this.dependencies, false, () -> this.dependenciesFingerprint);
        }

        public void visitOutputProperties(UnitOfWork.OutputPropertyVisitor visitor) {
            visitor.visitOutputProperty(DefaultTransformerInvocationFactory.OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, this.workspace.getOutputDirectory());
            visitor.visitOutputProperty(DefaultTransformerInvocationFactory.RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, this.workspace.getResultsFile());
        }

        public boolean shouldCleanupOutputsOnNonIncrementalExecution() {
            return true;
        }

        public long markExecutionTime() {
            return this.executionTimer.getElapsedMillis();
        }

        public void visitLocalState(UnitOfWork.LocalStateVisitor visitor) {
        }

        public void validate(UnitOfWork.WorkValidationContext validationContext) {
        }

        public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
            return this.transformer.isCacheable() ? Optional.empty() : Optional.of(NOT_CACHEABLE);
        }

        public boolean isAllowedToLoadFromCache() {
            return true;
        }

        public Optional<? extends Iterable<String>> getChangingOutputs() {
            return Optional.of(ImmutableList.of((Object)this.workspace.getOutputDirectory().getAbsolutePath(), (Object)this.workspace.getResultsFile().getAbsolutePath()));
        }

        public ImmutableSortedMap<String, FileSystemSnapshot> snapshotOutputsBeforeExecution() {
            return this.outputFileSnapshotsBeforeExecution;
        }

        public ImmutableSortedMap<String, FileSystemSnapshot> snapshotOutputsAfterExecution() {
            return DefaultTransformerInvocationFactory.snapshotOutputs(this.fileCollectionSnapshotter, this.fileCollectionFactory, this.workspace);
        }

        public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> fingerprintAndFilterOutputSnapshots(ImmutableSortedMap<String, FileCollectionFingerprint> afterPreviousExecutionOutputFingerprints, ImmutableSortedMap<String, FileSystemSnapshot> beforeExecutionOutputSnapshots, ImmutableSortedMap<String, FileSystemSnapshot> afterExecutionOutputSnapshots, boolean hasDetectedOverlappingOutputs) {
            return ImmutableSortedMap.copyOfSorted((SortedMap)Maps.transformEntries(afterExecutionOutputSnapshots, (key, value) -> this.outputFingerprinter.fingerprint((Iterable)ImmutableList.of((Object)value))));
        }

        public String getIdentity() {
            return this.identityString;
        }

        public void visitOutputTrees(CacheableEntity.CacheableTreeVisitor visitor) {
            visitor.visitOutputTree(DefaultTransformerInvocationFactory.OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, this.workspace.getOutputDirectory());
            visitor.visitOutputTree(DefaultTransformerInvocationFactory.RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, this.workspace.getResultsFile());
        }

        public String getDisplayName() {
            return this.transformer.getDisplayName() + ": " + this.inputArtifact;
        }
    }
}

