/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.registry;

import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.RegistryValue;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;

public class Registry {
    private static Reference<ResourceBundle> ourBundle;
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final ConcurrentMap<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private final Map<String, RegistryKeyDescriptor> myContributedKeys = new THashMap();
    private static final Registry ourInstance;

    @NotNull
    public static RegistryValue get(@NotNull String key) {
        if (key == null) {
            Registry.$$$reportNull$$$0(0);
        }
        Registry registry = Registry.getInstance();
        RegistryValue value2 = (RegistryValue)registry.myValues.get(key);
        if (value2 == null) {
            value2 = ConcurrencyUtil.cacheOrGet(registry.myValues, key, new RegistryValue(registry, key, registry.myContributedKeys.get(key)));
        }
        RegistryValue registryValue = value2;
        if (registryValue == null) {
            Registry.$$$reportNull$$$0(1);
        }
        return registryValue;
    }

    public static boolean is(@NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(2);
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NotNull String key, boolean defaultValue2) {
        if (key == null) {
            Registry.$$$reportNull$$$0(3);
        }
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ex) {
            return defaultValue2;
        }
    }

    public static int intValue(@NotNull String key) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(4);
        }
        return Registry.get(key).asInteger();
    }

    public static int intValue(@NotNull String key, int defaultValue2) {
        if (key == null) {
            Registry.$$$reportNull$$$0(5);
        }
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ex) {
            return defaultValue2;
        }
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("misc.registry");
            ourBundle = new SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            Registry.$$$reportNull$$$0(10);
        }
        return resourceBundle;
    }

    public String getBundleValue(@NotNull String key, boolean mustExist) throws MissingResourceException {
        if (key == null) {
            Registry.$$$reportNull$$$0(11);
        }
        if (this.myContributedKeys.containsKey(key)) {
            return this.myContributedKeys.get(key).getDefaultValue();
        }
        try {
            return Registry.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            if (mustExist) {
                throw e;
            }
            return null;
        }
    }

    @NotNull
    public static Registry getInstance() {
        Registry registry = ourInstance;
        if (registry == null) {
            Registry.$$$reportNull$$$0(12);
        }
        return registry;
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map2 = this.myUserProperties;
        if (map2 == null) {
            Registry.$$$reportNull$$$0(15);
        }
        return map2;
    }

    static {
        ourInstance = new Registry();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/registry/Registry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBundle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserProperties";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doubleValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "stringValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBundleValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isRestartNeeded";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addKey";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addKeys";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

