/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.storage;

import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.AccessToken;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;

public class HeavyProcessLatch {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.storage.HeavyProcessLatch");
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = new THashSet();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);
    private final List<Runnable> toExecuteOutOfHeavyActivity = new ArrayList<Runnable>();

    private HeavyProcessLatch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AccessToken processStarted(final @NotNull String operationName) {
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(0);
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.add(operationName);
        }
        this.myEventDispatcher.getMulticaster().processStarted();
        AccessToken accessToken = new AccessToken(){

            @Override
            public void finish() {
                HeavyProcessLatch.this.processFinished(operationName);
            }
        };
        if (accessToken == null) {
            HeavyProcessLatch.$$$reportNull$$$0(1);
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinished(@NotNull String operationName) {
        List<Runnable> toRunNow;
        if (operationName == null) {
            HeavyProcessLatch.$$$reportNull$$$0(2);
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.remove(operationName);
        }
        this.myEventDispatcher.getMulticaster().processFinished();
        Set<String> set2 = this.myHeavyProcesses;
        synchronized (set2) {
            if (this.isRunning()) {
                toRunNow = Collections.emptyList();
            } else {
                toRunNow = new ArrayList<Runnable>(this.toExecuteOutOfHeavyActivity);
                this.toExecuteOutOfHeavyActivity.clear();
            }
        }
        for (Runnable runnable : toRunNow) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return !this.myHeavyProcesses.isEmpty();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/storage/HeavyProcessLatch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/storage/HeavyProcessLatch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "processStarted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processStarted";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processFinished";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeOutOfHeavyProcess";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface HeavyProcessListener
    extends EventListener {
        public void processStarted();

        public void processFinished();
    }
}

