/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.HashMultimap;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportInfo;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.LazyExplicitImportScope;
import org.jetbrains.kotlin.resolve.PlatformClassesMappedToKotlinChecker;
import org.jetbrains.kotlin.resolve.lazy.ImportForceResolver;
import org.jetbrains.kotlin.resolve.lazy.ImportResolutionComponents;
import org.jetbrains.kotlin.resolve.lazy.IndexedImports;
import org.jetbrains.kotlin.resolve.lazy.LazyImportResolver;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/lazy/LazyImportResolverForKtImportDirective;", "Lorg/jetbrains/kotlin/resolve/lazy/LazyImportResolver;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lorg/jetbrains/kotlin/resolve/lazy/ImportForceResolver;", "components", "Lorg/jetbrains/kotlin/resolve/lazy/ImportResolutionComponents;", "indexedImports", "Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;", "excludedImportNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "traceForImportResolve", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "packageFragment", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "(Lorg/jetbrains/kotlin/resolve/lazy/ImportResolutionComponents;Lorg/jetbrains/kotlin/resolve/lazy/IndexedImports;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;)V", "forceResolveImportDirective", "Lorg/jetbrains/kotlin/storage/MemoizedFunctionToNotNull;", "", "forceResolveNonDefaultImportsTask", "Lorg/jetbrains/kotlin/storage/NotNullLazyValue;", "checkResolvedImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportInfo;", "forceResolveImport", "forceResolveNonDefaultImports", "frontend"})
public final class LazyImportResolverForKtImportDirective
extends LazyImportResolver<KtImportDirective>
implements ImportForceResolver {
    private final MemoizedFunctionToNotNull<KtImportDirective, Unit> forceResolveImportDirective;
    private final NotNullLazyValue<Unit> forceResolveNonDefaultImportsTask;

    @Override
    public void forceResolveNonDefaultImports() {
        this.forceResolveNonDefaultImportsTask.invoke();
    }

    private final void checkResolvedImportDirective(KtImportInfo importDirective) {
        if (!(importDirective instanceof KtImportDirective)) {
            return;
        }
        KtExpression ktExpression = ((KtImportDirective)importDirective).getImportedReference();
        if (ktExpression == null) {
            return;
        }
        KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtil.getLastReference(ktExpression);
        if (ktSimpleNameExpression == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"KtPsiUtil.getLastReferen\u2026ence ?: return) ?: return");
        KtSimpleNameExpression importedReference = ktSimpleNameExpression;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)this.getTraceForImportResolve().getBindingContext().get(BindingContext.REFERENCE_TARGET, importedReference);
        if (declarationDescriptor == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"traceForImportResolve.bi\u2026ortedReference) ?: return");
        DeclarationDescriptor importedDescriptor = declarationDescriptor;
        String aliasName = importDirective.getAliasName();
        if (importedDescriptor instanceof FunctionDescriptor && ((FunctionDescriptor)importedDescriptor).isOperator() && aliasName != null && OperatorConventions.isConventionName(Name.identifier(aliasName))) {
            this.getTraceForImportResolve().report(Errors.OPERATOR_RENAMED_ON_IMPORT.on((KtSimpleNameExpression)((PsiElement)importedReference)));
        }
    }

    @Override
    public void forceResolveImport(@NotNull KtImportDirective importDirective) {
        Intrinsics.checkParameterIsNotNull((Object)importDirective, (String)"importDirective");
        this.forceResolveImportDirective.invoke(importDirective);
    }

    public LazyImportResolverForKtImportDirective(@NotNull ImportResolutionComponents components, @NotNull IndexedImports<KtImportDirective> indexedImports, @NotNull Collection<FqName> excludedImportNames, @NotNull BindingTrace traceForImportResolve, @Nullable PackageFragmentDescriptor packageFragment) {
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        Intrinsics.checkParameterIsNotNull(indexedImports, (String)"indexedImports");
        Intrinsics.checkParameterIsNotNull(excludedImportNames, (String)"excludedImportNames");
        Intrinsics.checkParameterIsNotNull((Object)traceForImportResolve, (String)"traceForImportResolve");
        super(components, indexedImports, excludedImportNames, traceForImportResolve, packageFragment);
        this.forceResolveImportDirective = components.getStorageManager().createMemoizedFunction((Function1)new Function1<KtImportDirective, Unit>(this, components, traceForImportResolve){
            final /* synthetic */ LazyImportResolverForKtImportDirective this$0;
            final /* synthetic */ ImportResolutionComponents $components;
            final /* synthetic */ BindingTrace $traceForImportResolve;

            public final void invoke(@NotNull KtImportDirective directive) {
                Intrinsics.checkParameterIsNotNull((Object)directive, (String)"directive");
                ImportingScope scope = this.this$0.getImportScope(directive);
                if (scope instanceof LazyExplicitImportScope) {
                    Collection<DeclarationDescriptor> allDescriptors2 = ((LazyExplicitImportScope)scope).storeReferencesToDescriptors$frontend();
                    PlatformClassesMappedToKotlinChecker.checkPlatformClassesMappedToKotlin(this.$components.getPlatformToKotlinClassMap(), this.$traceForImportResolve, directive, allDescriptors2);
                }
            }
            {
                this.this$0 = lazyImportResolverForKtImportDirective;
                this.$components = importResolutionComponents;
                this.$traceForImportResolve = bindingTrace;
                super(1);
            }
        });
        this.forceResolveNonDefaultImportsTask = components.getStorageManager().createLazyValue((Function0)new Function0<Unit>(this, indexedImports, traceForImportResolve){
            final /* synthetic */ LazyImportResolverForKtImportDirective this$0;
            final /* synthetic */ IndexedImports $indexedImports;
            final /* synthetic */ BindingTrace $traceForImportResolve;

            public final void invoke() {
                Object lookupLocation;
                HashMultimap<K, V> explicitClassImports = HashMultimap.create();
                for (Object importInfo : this.$indexedImports.getImports()) {
                    this.this$0.forceResolveImport((KtImportDirective)importInfo);
                    ImportingScope scope = this.this$0.getImportScope((KtImportInfo)importInfo);
                    Name alias = ((KtImportDirective)importInfo).getImportedName();
                    if (alias != null && scope.getContributedClassifier(alias, (LookupLocation)(lookupLocation = new KotlinLookupLocation((KtElement)importInfo))) != null) {
                        explicitClassImports.put(alias.asString(), importInfo);
                    }
                    LazyImportResolverForKtImportDirective.access$checkResolvedImportDirective(this.this$0, (KtImportInfo)importInfo);
                }
                Iterator<Object> iterator2 = explicitClassImports.entries().iterator();
                while (iterator2.hasNext()) {
                    boolean bl;
                    KtImportDirective ktImportDirective;
                    block6: {
                        Object importInfo;
                        lookupLocation = importInfo = (Map.Entry)iterator2.next();
                        boolean bl2 = false;
                        String alias = (String)lookupLocation.getKey();
                        lookupLocation = importInfo;
                        bl2 = false;
                        ktImportDirective = (KtImportDirective)lookupLocation.getValue();
                        String string2 = alias;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"alias");
                        CharSequence $this$all$iv = string2;
                        boolean $i$f$all = false;
                        CharSequence charSequence = $this$all$iv;
                        for (int i = 0; i < charSequence.length(); ++i) {
                            char element$iv;
                            char it = element$iv = charSequence.charAt(i);
                            boolean bl3 = false;
                            if (it == '_') continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                    if (!bl) continue;
                    this.$traceForImportResolve.report(Errors.UNDERSCORE_IS_RESERVED.on(ktImportDirective));
                }
                for (String alias : explicitClassImports.keySet()) {
                    Set imports = explicitClassImports.get(alias);
                    if (imports.size() <= 1) continue;
                    Set set = imports;
                    Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"imports");
                    Iterable $this$forEach$iv = set;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        KtImportDirective it = (KtImportDirective)element$iv;
                        boolean bl = false;
                        this.$traceForImportResolve.report(Errors.CONFLICTING_IMPORT.on((KtImportDirective)((PsiElement)it), alias));
                    }
                }
            }
            {
                this.this$0 = lazyImportResolverForKtImportDirective;
                this.$indexedImports = indexedImports;
                this.$traceForImportResolve = bindingTrace;
                super(0);
            }
        });
    }

    public static final /* synthetic */ void access$checkResolvedImportDirective(LazyImportResolverForKtImportDirective $this, KtImportInfo importDirective) {
        $this.checkResolvedImportDirective(importDirective);
    }
}

