/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.tasks.testing.TestResult;

public class TestMethodResult {
    private final long id;
    private final String name;
    private final String displayName;
    private TestResult.ResultType resultType;
    private long duration;
    private long endTime;
    private List<TestFailure> failures = new ArrayList<TestFailure>();

    public TestMethodResult(long id, String name) {
        this(id, name, name);
    }

    public TestMethodResult(long id, String name, String displayName) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
    }

    public TestMethodResult(long id, String name, TestResult.ResultType resultType, long duration, long endTime) {
        this(id, name, name, resultType, duration, endTime);
    }

    public TestMethodResult(long id, String name, String displayName, TestResult.ResultType resultType, long duration, long endTime) {
        if (id < 1L) {
            throw new IllegalArgumentException("id must be > 0");
        }
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.resultType = resultType;
        this.duration = duration;
        this.endTime = endTime;
    }

    public TestMethodResult completed(TestResult result) {
        this.resultType = result.getResultType();
        this.duration = result.getEndTime() - result.getStartTime();
        this.endTime = result.getEndTime();
        return this;
    }

    public TestMethodResult addFailure(String message, String stackTrace, String exceptionType) {
        this.failures.add(new TestFailure(message, stackTrace, exceptionType));
        return this;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<TestFailure> getFailures() {
        return this.failures;
    }

    public TestResult.ResultType getResultType() {
        return this.resultType;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEndTime() {
        return this.endTime;
    }
}

