/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Optional;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.AbstractCompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.PathUtil;
import org.gradle.internal.snapshot.VfsRelativePath;

public class MissingFileSnapshot
extends AbstractCompleteFileSystemLocationSnapshot {
    private static final HashCode SIGNATURE = Hashing.signature(MissingFileSnapshot.class);

    public MissingFileSnapshot(String absolutePath, String name) {
        super(absolutePath, name);
    }

    public MissingFileSnapshot(String absolutePath) {
        super(absolutePath, PathUtil.getFileName(absolutePath));
    }

    @Override
    public FileType getType() {
        return FileType.Missing;
    }

    @Override
    public HashCode getHash() {
        return SIGNATURE;
    }

    @Override
    public boolean isContentAndMetadataUpToDate(CompleteFileSystemLocationSnapshot other) {
        return other instanceof MissingFileSnapshot;
    }

    @Override
    public void accept(FileSystemSnapshotVisitor visitor) {
        visitor.visitFile(this);
    }

    @Override
    public void accept(FileSystemNode.NodeVisitor visitor) {
        visitor.visitNode(this);
    }

    @Override
    public Optional<FileSystemNode> invalidate(VfsRelativePath relativePath, CaseSensitivity caseSensitivity) {
        return Optional.empty();
    }
}

