/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.gradle.internal.file.FileType;
import org.gradle.internal.vfs.WatchingVirtualFileSystem;
import org.gradle.internal.vfs.impl.AbstractDelegatingVirtualFileSystem;
import org.gradle.internal.vfs.impl.AbstractVirtualFileSystem;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWatchingVirtualFileSystem
extends AbstractDelegatingVirtualFileSystem
implements WatchingVirtualFileSystem,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWatchingVirtualFileSystem.class);
    private final FileWatcherRegistryFactory watcherRegistryFactory;
    private final Predicate<Path> watchFilter;
    private FileWatcherRegistry watchRegistry;

    public DefaultWatchingVirtualFileSystem(FileWatcherRegistryFactory watcherRegistryFactory, AbstractVirtualFileSystem delegate, Predicate<Path> watchFilter) {
        super(delegate);
        this.watcherRegistryFactory = watcherRegistryFactory;
        this.watchFilter = watchFilter;
    }

    @Override
    public void startWatching() {
        if (this.watchRegistry != null) {
            throw new IllegalStateException("Watch service already started");
        }
        try {
            this.watchRegistry = this.watcherRegistryFactory.createRegistry();
            HashSet visited = new HashSet();
            this.getRoot().visitSnapshots(snapshot -> {
                Path path = Paths.get(snapshot.getAbsolutePath(), new String[0]);
                if (!this.watchFilter.test(path)) {
                    return;
                }
                try {
                    Path ancestor = path;
                    while ((ancestor = ancestor.getParent()) != null) {
                        if (!Files.exists(ancestor, new LinkOption[0])) continue;
                        this.watch(ancestor, visited);
                        break;
                    }
                    if (snapshot.getType() == FileType.Directory) {
                        this.watch(path, visited);
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error("Couldn't create watch service, not tracking changes between builds", (Throwable)ex);
            this.invalidateAll();
            this.close();
        }
    }

    private void watch(Path directory, Set<Path> visited) throws IOException {
        if (!visited.add(directory)) {
            return;
        }
        LOGGER.warn("Start watching {}", (Object)directory);
        this.watchRegistry.registerWatchPoint(directory);
    }

    @Override
    public void stopWatching() {
        if (this.watchRegistry == null) {
            return;
        }
        try {
            this.watchRegistry.stopWatching(new FileWatcherRegistry.ChangeHandler(){

                @Override
                public void handleChange(FileWatcherRegistry.Type type, Path path) {
                    DefaultWatchingVirtualFileSystem.this.update(Collections.singleton(path.toString()), () -> {});
                }

                @Override
                public void handleOverflow() {
                    DefaultWatchingVirtualFileSystem.this.invalidateAll();
                }
            });
        }
        catch (IOException ex) {
            LOGGER.error("Couldn't fetch file changes, dropping VFS state", (Throwable)ex);
            this.invalidateAll();
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.watchRegistry != null) {
            try {
                this.watchRegistry.close();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't close watch service", (Throwable)ex);
            }
            this.watchRegistry = null;
        }
    }
}

