/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.component.Artifact;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.DependencyVerifyingModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.verification.DependencyVerifier;
import org.gradle.api.internal.artifacts.verification.serializer.DependencyVerificationsXmlReader;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.operations.BuildOperationExecutor;

public class ChecksumVerificationOverride
implements DependencyVerificationOverride,
ArtifactVerificationOperation {
    private static final Comparator<Map.Entry<ModuleComponentArtifactIdentifier, DependencyVerifier.VerificationFailure>> DELETED_LAST = Comparator.comparing(e -> e.getValue() == DependencyVerifier.VerificationFailure.DELETED ? 1 : 0);
    private static final Comparator<Map.Entry<ModuleComponentArtifactIdentifier, DependencyVerifier.VerificationFailure>> MISSING_LAST = Comparator.comparing(e -> e.getValue() == DependencyVerifier.VerificationFailure.MISSING ? 1 : 0);
    private static final Comparator<Map.Entry<ModuleComponentArtifactIdentifier, DependencyVerifier.VerificationFailure>> BY_MODULE_ID = Comparator.comparing(e -> ((ModuleComponentArtifactIdentifier)e.getKey()).getDisplayName());
    private final DependencyVerifier verifier;
    private final Map<ModuleComponentArtifactIdentifier, DependencyVerifier.VerificationFailure> failures = Maps.newLinkedHashMapWithExpectedSize((int)2);
    private final BuildOperationExecutor buildOperationExecutor;
    private final ChecksumService checksumService;

    public ChecksumVerificationOverride(BuildOperationExecutor buildOperationExecutor, File verificationsFile, ChecksumService checksumService) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.checksumService = checksumService;
        try {
            this.verifier = DependencyVerificationsXmlReader.readFromXml(new FileInputStream(verificationsFile));
        }
        catch (FileNotFoundException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    @Override
    public void onArtifact(ModuleComponentArtifactIdentifier artifact, File path) {
        this.verifier.verify(this.buildOperationExecutor, this.checksumService, artifact, path, (Action<DependencyVerifier.VerificationFailure>)((Action)f -> {
            Map<ModuleComponentArtifactIdentifier, DependencyVerifier.VerificationFailure> map = this.failures;
            synchronized (map) {
                this.failures.put(artifact, (DependencyVerifier.VerificationFailure)f);
            }
        }));
    }

    @Override
    public ModuleComponentRepository overrideDependencyVerification(ModuleComponentRepository original) {
        return new DependencyVerifyingModuleComponentRepository(original, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void artifactsAccessed(String displayName) {
        Map<ModuleComponentArtifactIdentifier, DependencyVerifier.VerificationFailure> map = this.failures;
        synchronized (map) {
            if (!this.failures.isEmpty()) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node("Dependency verification failed for " + displayName);
                formatter.startChildren();
                AtomicBoolean maybeCompromised = new AtomicBoolean();
                AtomicBoolean hasMissing = new AtomicBoolean();
                this.failures.entrySet().stream().sorted(DELETED_LAST.thenComparing(MISSING_LAST).thenComparing(BY_MODULE_ID)).forEachOrdered(entry -> {
                    DependencyVerifier.VerificationFailure failure = (DependencyVerifier.VerificationFailure)entry.getValue();
                    if (failure == DependencyVerifier.VerificationFailure.DELETED) {
                        formatter.node("Artifact " + entry.getKey() + " has been deleted from local cache so verification cannot be performed");
                    } else if (failure == DependencyVerifier.VerificationFailure.MISSING) {
                        hasMissing.set(true);
                        formatter.node("Artifact " + entry.getKey() + " checksum is missing from verification metadata.");
                    } else {
                        maybeCompromised.set(true);
                        formatter.node("On artifact " + entry.getKey() + ": expected a '" + (Object)((Object)failure.getKind()) + "' checksum of '" + failure.getExpected() + "' but was '" + failure.getActual() + "'");
                    }
                });
                formatter.endChildren();
                if (maybeCompromised.get()) {
                    formatter.node("This can indicate that a dependency has been compromised. Please verify carefully the checksums.");
                } else if (hasMissing.get()) {
                    formatter.node("Please update the file either manually (preferred) or by adding the --write-verification-metadata flag (unsafe).");
                }
                throw new InvalidUserDataException(formatter.toString());
            }
        }
    }

    @Override
    public ResolvedArtifactResult verifiedArtifact(final ResolvedArtifactResult artifact) {
        return new ResolvedArtifactResult(){

            public File getFile() {
                ChecksumVerificationOverride.this.artifactsAccessed(artifact.getVariant().getDisplayName());
                return artifact.getFile();
            }

            public ResolvedVariantResult getVariant() {
                return artifact.getVariant();
            }

            public ComponentArtifactIdentifier getId() {
                return artifact.getId();
            }

            public Class<? extends Artifact> getType() {
                return artifact.getType();
            }
        };
    }
}

