/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.resolver;

import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyMetadata;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.model.ForcingDependencyMetadata;

public abstract class AbstractDependencyMetadataAdapter<T extends DependencyMetadata>
implements DependencyMetadata<T> {
    private final List<ModuleDependencyMetadata> container;
    private final int originalIndex;
    private final ImmutableAttributesFactory attributesFactory;

    public AbstractDependencyMetadataAdapter(ImmutableAttributesFactory attributesFactory, List<ModuleDependencyMetadata> container, int originalIndex) {
        this.attributesFactory = attributesFactory;
        this.container = container;
        this.originalIndex = originalIndex;
    }

    protected ModuleDependencyMetadata getOriginalMetadata() {
        return this.container.get(this.originalIndex);
    }

    protected void updateMetadata(ModuleDependencyMetadata modifiedMetadata) {
        this.container.set(this.originalIndex, modifiedMetadata);
    }

    public String getGroup() {
        return this.getOriginalMetadata().getSelector().getGroup();
    }

    public String getName() {
        return this.getOriginalMetadata().getSelector().getModule();
    }

    public VersionConstraint getVersionConstraint() {
        return this.getOriginalMetadata().getSelector().getVersionConstraint();
    }

    public T version(Action<? super MutableVersionConstraint> configureAction) {
        DefaultMutableVersionConstraint mutableVersionConstraint = new DefaultMutableVersionConstraint(this.getVersionConstraint());
        configureAction.execute((Object)mutableVersionConstraint);
        ModuleDependencyMetadata dependencyMetadata = this.getOriginalMetadata().withRequestedVersion(mutableVersionConstraint);
        this.updateMetadata(dependencyMetadata);
        return (T)((DependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public T because(String reason) {
        this.updateMetadata(this.getOriginalMetadata().withReason(reason));
        return (T)((DependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public ModuleIdentifier getModule() {
        return this.getOriginalMetadata().getSelector().getModuleIdentifier();
    }

    public String getReason() {
        return this.getOriginalMetadata().getReason();
    }

    public String toString() {
        return this.getGroup() + ":" + this.getName() + ":" + this.getVersionConstraint();
    }

    public AttributeContainer getAttributes() {
        return this.getOriginalMetadata().getSelector().getAttributes();
    }

    public T attributes(Action<? super AttributeContainer> configureAction) {
        ModuleComponentSelector selector = this.getOriginalMetadata().getSelector();
        AttributeContainerInternal attributes = this.attributesFactory.mutable((AttributeContainerInternal)selector.getAttributes());
        configureAction.execute((Object)attributes);
        ModuleComponentSelector target = DefaultModuleComponentSelector.newSelector(selector.getModuleIdentifier(), selector.getVersionConstraint(), (AttributeContainer)attributes.asImmutable(), selector.getRequestedCapabilities());
        ModuleDependencyMetadata metadata = (ModuleDependencyMetadata)this.getOriginalMetadata().withTarget((ComponentSelector)target);
        this.updateMetadata(metadata);
        return (T)((DependencyMetadata)Cast.uncheckedCast((Object)this));
    }

    public void forced() {
        ModuleDependencyMetadata originalMetadata = this.getOriginalMetadata();
        if (originalMetadata instanceof ForcingDependencyMetadata) {
            this.updateMetadata((ModuleDependencyMetadata)((Object)((ForcingDependencyMetadata)((Object)originalMetadata)).forced()));
        }
    }
}

