/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.initialization.ProjectSpec;

public abstract class AbstractProjectSpec
implements ProjectSpec {
    private static final String UNRELATED_BUILD_HINT = " If this is an unrelated build, it must have its own settings file.";

    @Override
    public boolean containsProject(ProjectRegistry<? extends ProjectIdentifier> registry) {
        this.checkPreconditions(registry);
        ArrayList matches = new ArrayList();
        this.select(registry, matches);
        return !matches.isEmpty();
    }

    @Override
    public <T extends ProjectIdentifier> T selectProject(String settingsDescription, ProjectRegistry<? extends T> registry) {
        this.checkPreconditions(registry);
        ArrayList matches = new ArrayList();
        this.select(registry, matches);
        if (matches.isEmpty()) {
            String message = this.formatNoMatchesMessage(settingsDescription) + UNRELATED_BUILD_HINT;
            throw new InvalidUserDataException(message);
        }
        if (matches.size() != 1) {
            throw new InvalidUserDataException(this.formatMultipleMatchesMessage(matches));
        }
        return (T)((ProjectIdentifier)matches.get(0));
    }

    protected void checkPreconditions(ProjectRegistry<?> registry) {
    }

    protected abstract String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> var1);

    protected abstract String formatNoMatchesMessage(String var1);

    protected abstract <T extends ProjectIdentifier> void select(ProjectRegistry<? extends T> var1, List<? super T> var2);
}

