/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.translate.callTranslator.CallTranslator;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.DestructuringDeclarationTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator;
import org.jetbrains.kotlin.js.translate.expression.LoopTranslator$WhenMappings;
import org.jetbrains.kotlin.js.translate.expression.RangeLiteral;
import org.jetbrains.kotlin.js.translate.expression.RangeType;
import org.jetbrains.kotlin.js.translate.expression.WithIndexInfo;
import org.jetbrains.kotlin.js.translate.expression.WithIndexReceiverType;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.BuiltInPropertyIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtWhileExpressionBase;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"downToFunctionName", "Lorg/jetbrains/kotlin/name/FqName;", "indicesFqName", "intProgressionName", "intRangeName", "rangeToFunctionName", "sequenceFqName", "sequenceWithIndexFqName", "stepFunctionName", "untilFunctionName", "withIndexFqName", "createWhile", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "doWhile", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhileExpressionBase;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "translateForExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "js.translator"})
@JvmName(name="LoopTranslator")
public final class LoopTranslator {
    private static final FqName rangeToFunctionName = new FqName("kotlin.Int.rangeTo");
    private static final FqName untilFunctionName = new FqName("kotlin.ranges.until");
    private static final FqName downToFunctionName = new FqName("kotlin.ranges.downTo");
    private static final FqName stepFunctionName = new FqName("kotlin.ranges.step");
    private static final FqName intRangeName = new FqName("kotlin.ranges.IntRange");
    private static final FqName intProgressionName = new FqName("kotlin.ranges.IntProgression");
    private static final FqName withIndexFqName = new FqName("kotlin.collections.withIndex");
    private static final FqName sequenceWithIndexFqName = new FqName("kotlin.sequences.withIndex");
    private static final FqName indicesFqName = new FqName("kotlin.collections.indices");
    private static final FqName sequenceFqName = new FqName("kotlin.sequences.Sequence");

    @NotNull
    public static final JsNode createWhile(boolean doWhile, @NotNull KtWhileExpressionBase expression2, @NotNull TranslationContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        KtExpression ktExpression = expression2.getCondition();
        if (ktExpression == null) {
            throw (Throwable)new IllegalArgumentException("condition expression should not be null: " + expression2.getText());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.condition ?:\n\u2026ull: ${expression.text}\")");
        KtExpression conditionExpression = ktExpression;
        JsBlock conditionBlock = new JsBlock();
        JsExpression jsExpression = Translation.translateAsExpression(conditionExpression, context2, conditionBlock);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"Translation.translateAsE\u2026 context, conditionBlock)");
        JsExpression jsCondition = jsExpression;
        KtExpression body2 = expression2.getBody();
        JsStatement jsStatement = body2 != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(body2, context2) : (JsStatement)JsEmpty.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsStatement, (String)"if (body != null)\n      \u2026 else\n            JsEmpty");
        JsStatement bodyStatement = jsStatement;
        if (!conditionBlock.isEmpty()) {
            SourceInfoAwareJsNode sourceInfoAwareJsNode = new JsBreak();
            SourceInfoAwareJsNode sourceInfoAwareJsNode2 = JsAstUtils.not(jsCondition);
            boolean bl = false;
            boolean bl2 = false;
            JsBreak $this$apply = sourceInfoAwareJsNode;
            boolean bl3 = false;
            $this$apply.setSource(expression2);
            JsBreak jsBreak = sourceInfoAwareJsNode;
            JsStatement jsStatement2 = jsBreak;
            JsExpression jsExpression2 = sourceInfoAwareJsNode2;
            sourceInfoAwareJsNode = new JsIf(jsExpression2, jsStatement2);
            bl = false;
            bl2 = false;
            $this$apply = sourceInfoAwareJsNode;
            boolean bl4 = false;
            $this$apply.setSource(expression2);
            SourceInfoAwareJsNode breakIfConditionIsFalseStatement = sourceInfoAwareJsNode;
            JsBlock jsBlock = JsAstUtils.convertToBlock(bodyStatement);
            Intrinsics.checkExpressionValueIsNotNull((Object)jsBlock, (String)"convertToBlock(bodyStatement)");
            JsBlock bodyBlock = jsBlock;
            jsCondition = new JsBooleanLiteral(true);
            if (doWhile) {
                JsIf ifStatement;
                JsExpression jsExpression3 = context2.defineTemporary(new JsBooleanLiteral(false).source(expression2));
                Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"context.defineTemporary(\u2026alse).source(expression))");
                JsExpression secondRun = jsExpression3;
                conditionBlock.getStatements().add((JsStatement)((Object)breakIfConditionIsFalseStatement));
                JsIf jsIf = ifStatement = new JsIf(secondRun, conditionBlock, JsAstUtils.assignment(secondRun, new JsBooleanLiteral(true)).source(expression2).makeStmt());
                int n = 0;
                List<JsStatement> list2 = bodyBlock.getStatements();
                boolean bl5 = false;
                boolean bl6 = false;
                JsIf $this$apply2 = jsIf;
                boolean bl7 = false;
                $this$apply2.setSource(expression2);
                sourceInfoAwareJsNode2 = jsIf;
                list2.add(n, (JsStatement)((Object)sourceInfoAwareJsNode2));
            } else {
                conditionBlock.getStatements().add((JsStatement)((Object)breakIfConditionIsFalseStatement));
                List<JsStatement> list3 = bodyBlock.getStatements();
                List<JsStatement> list4 = conditionBlock.getStatements();
                Intrinsics.checkExpressionValueIsNotNull(list4, (String)"conditionBlock.statements");
                list3.addAll(0, (Collection<JsStatement>)list4);
            }
            bodyStatement = bodyBlock;
        }
        JsWhile result2 = doWhile ? (JsWhile)new JsDoWhile() : new JsWhile();
        result2.setCondition(jsCondition);
        result2.setBody(bodyStatement);
        JsNode jsNode = result2.source(expression2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsNode, (String)"result.source(expression)");
        return jsNode;
    }

    @NotNull
    public static final JsStatement translateForExpression(@NotNull KtForExpression expression2, @NotNull TranslationContext context2) {
        JsStatement result2;
        Object object;
        block7: {
            Function0<JsStatement> $fun$translateForOverIterator$16;
            Function0<JsStatement> $fun$translateForOverArray$9;
            Function0<JsStatement> $fun$translateForOverRange$8;
            Function0<Boolean> $fun$isForOverArray$3;
            Function0<Boolean> $fun$isForOverRange$1;
            block8: {
                Object withIndexCall;
                Function1<WithIndexInfo, JsStatement> $fun$translateForOverCollectionWithIndex$15;
                Function1<WithIndexInfo, JsStatement> $fun$translateForOverCollectionIndices$12;
                Function1<WithIndexInfo, JsStatement> $fun$translateForOverArrayWithIndex$10;
                block6: {
                    Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                    Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                    KtExpression ktExpression = PsiUtils.getLoopRange(expression2);
                    boolean bl = false;
                    boolean bl2 = false;
                    KtExpression it = ktExpression;
                    boolean bl3 = false;
                    KtExpression ktExpression2 = KtPsiUtil.deparenthesize(it);
                    if (ktExpression2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"KtPsiUtil.deparenthesize(it)!!");
                    KtExpression deparenthesized = ktExpression2;
                    KtExpression ktExpression3 = deparenthesized instanceof KtStringTemplateExpression ? it : deparenthesized;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"getLoopRange(expression)\u2026lse deparenthesized\n    }");
                    KtExpression loopRange = ktExpression3;
                    KotlinType kotlinType2 = BindingUtils.getTypeForExpression(context2.bindingContext(), loopRange);
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"getTypeForExpression(con\u2026dingContext(), loopRange)");
                    KotlinType rangeType = kotlinType2;
                    $fun$isForOverRange$1 = new Function0<Boolean>(rangeType){
                        final /* synthetic */ KotlinType $rangeType;

                        public final boolean invoke() {
                            Object object = this.$rangeType.getConstructor().getDeclarationDescriptor();
                            if (object == null || (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) == null) {
                                return false;
                            }
                            Object fqn = object;
                            return Intrinsics.areEqual((Object)fqn, (Object)LoopTranslator.access$getIntRangeName$p());
                        }
                        {
                            this.$rangeType = kotlinType2;
                            super(0);
                        }
                    };
                    Function0<RangeLiteral> $fun$extractForOverRangeLiteral$2 = new Function0<RangeLiteral>(rangeType, loopRange, context2){
                        final /* synthetic */ KotlinType $rangeType;
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ TranslationContext $context;

                        @Nullable
                        public final RangeLiteral invoke() {
                            RangeType rangeType;
                            Object object;
                            ReceiverValue receiverValue;
                            ReceiverValue receiverValue2;
                            KtExpression step;
                            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                            block17: {
                                ResolvedCall<? extends CallableDescriptor> resolvedCall3;
                                block19: {
                                    block18: {
                                        FqName fqn;
                                        ClassifierDescriptor classifierDescriptor = this.$rangeType.getConstructor().getDeclarationDescriptor();
                                        FqName fqName2 = fqn = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null;
                                        if (Intrinsics.areEqual((Object)fqn, (Object)LoopTranslator.access$getIntRangeName$p()) ^ true && Intrinsics.areEqual((Object)fqn, (Object)LoopTranslator.access$getIntProgressionName$p()) ^ true) {
                                            return null;
                                        }
                                        KtElement ktElement = this.$loopRange;
                                        BindingContext bindingContext = this.$context.bindingContext();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.bindingContext()");
                                        ResolvedCall<? extends CallableDescriptor> resolvedCall4 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                                        if (resolvedCall4 == null) {
                                            return null;
                                        }
                                        resolvedCall2 = resolvedCall4;
                                        step = null;
                                        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor()), (Object)LoopTranslator.access$getStepFunctionName$p())) break block17;
                                        Call call2 = resolvedCall2.getCall();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"resolvedCall.call");
                                        KtExpression ktExpression = call2.getValueArguments().get(0).getArgumentExpression();
                                        if (ktExpression == null) {
                                            return null;
                                        }
                                        step = ktExpression;
                                        ReceiverValue receiverValue3 = resolvedCall2.getExtensionReceiver();
                                        if (!(receiverValue3 instanceof ExpressionReceiver)) {
                                            receiverValue3 = null;
                                        }
                                        if ((resolvedCall3 = (ExpressionReceiver)receiverValue3) == null || (resolvedCall3 = resolvedCall3.getExpression()) == null) break block18;
                                        KtElement ktElement2 = (KtElement)((Object)resolvedCall3);
                                        BindingContext bindingContext2 = this.$context.bindingContext();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context.bindingContext()");
                                        resolvedCall3 = CallUtilKt.getResolvedCall(ktElement2, bindingContext2);
                                        if (resolvedCall3 != null) break block19;
                                    }
                                    return null;
                                }
                                resolvedCall2 = resolvedCall3;
                            }
                            if ((receiverValue2 = resolvedCall2.getExtensionReceiver()) == null) {
                                receiverValue2 = receiverValue = resolvedCall2.getDispatchReceiver();
                            }
                            if (!(receiverValue2 instanceof ExpressionReceiver)) {
                                receiverValue = null;
                            }
                            if ((object = (ExpressionReceiver)receiverValue) == null || (object = object.getExpression()) == null) {
                                return null;
                            }
                            Object first2 = object;
                            List<ResolvedValueArgument> list2 = resolvedCall2.getValueArgumentsByIndex();
                            if (list2 == null || (list2 = (ResolvedValueArgument)CollectionsKt.firstOrNull(list2)) == null || (list2 = list2.getArguments()) == null || (list2 = (ValueArgument)CollectionsKt.firstOrNull(list2)) == null || (list2 = list2.getArgumentExpression()) == null) {
                                return null;
                            }
                            List<ResolvedValueArgument> second = list2;
                            FqName fqName3 = DescriptorUtilsKt.getFqNameSafe(resolvedCall2.getResultingDescriptor());
                            if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getRangeToFunctionName$p())) {
                                rangeType = RangeType.RANGE_TO;
                            } else if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getUntilFunctionName$p())) {
                                rangeType = RangeType.UNTIL;
                            } else if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getDownToFunctionName$p())) {
                                rangeType = RangeType.DOWN_TO;
                            } else {
                                return null;
                            }
                            RangeType type2 = rangeType;
                            return new RangeLiteral(type2, (KtExpression)first2, (KtExpression)((Object)second), step);
                        }
                        {
                            this.$rangeType = kotlinType2;
                            this.$loopRange = ktExpression;
                            this.$context = translationContext;
                            super(0);
                        }
                    };
                    $fun$isForOverArray$3 = new Function0<Boolean>(rangeType){
                        final /* synthetic */ KotlinType $rangeType;

                        public final boolean invoke() {
                            return KotlinBuiltIns.isArray(this.$rangeType) || KotlinBuiltIns.isPrimitiveArray(this.$rangeType);
                        }
                        {
                            this.$rangeType = kotlinType2;
                            super(0);
                        }
                    };
                    KtParameter ktParameter = expression2.getLoopParameter();
                    if (ktParameter == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"expression.loopParameter!!");
                    KtParameter loopParameter = ktParameter;
                    KtDestructuringDeclaration destructuringParameter = loopParameter.getDestructuringDeclaration();
                    JsName jsName = destructuringParameter == null ? context2.getNameForElement(loopParameter) : JsScope.declareTemporary();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"if (destructuringParamet\u2026.declareTemporary()\n    }");
                    JsName parameterName = jsName;
                    Function1<KtDeclaration, VariableDescriptor> $fun$extractDescriptor$4 = new Function1<KtDeclaration, VariableDescriptor>(context2){
                        final /* synthetic */ TranslationContext $context;

                        @Nullable
                        public final VariableDescriptor invoke(@NotNull KtDeclaration $this$extractDescriptor) {
                            VariableDescriptor variableDescriptor;
                            Intrinsics.checkParameterIsNotNull((Object)$this$extractDescriptor, (String)"$this$extractDescriptor");
                            VariableDescriptor variableDescriptor2 = (VariableDescriptor)this.$context.bindingContext().get(BindingContext.VARIABLE, $this$extractDescriptor);
                            if (variableDescriptor2 != null) {
                                VariableDescriptor variableDescriptor3 = variableDescriptor2;
                                boolean bl = false;
                                boolean bl2 = false;
                                VariableDescriptor it = variableDescriptor3;
                                boolean bl3 = false;
                                VariableDescriptor variableDescriptor4 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)variableDescriptor4, (String)"it");
                                Name name = variableDescriptor4.getName();
                                Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"it.name");
                                variableDescriptor = !name.isSpecial() ? variableDescriptor3 : null;
                            } else {
                                variableDescriptor = null;
                            }
                            return variableDescriptor;
                        }
                        {
                            this.$context = translationContext;
                            super(1);
                        }
                    };
                    Function0<WithIndexInfo> $fun$extractWithIndexCall$5 = new Function0<WithIndexInfo>(loopRange, context2, destructuringParameter, $fun$extractDescriptor$4, loopParameter){
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtDestructuringDeclaration $destructuringParameter;
                        final /* synthetic */ translateForExpression.4 $extractDescriptor$4;
                        final /* synthetic */ KtParameter $loopParameter;

                        /*
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final WithIndexInfo invoke() {
                            void indexDescriptor;
                            JsExpression jsExpression;
                            ReceiverValue receiver;
                            WithIndexReceiverType withIndexReceiverType;
                            ClassifierDescriptor classifierDescriptor;
                            Pair pair;
                            FqName fqName2;
                            KtElement ktElement = this.$loopRange;
                            BindingContext bindingContext = this.$context.bindingContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.bindingContext()");
                            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
                            if (resolvedCall2 == null) {
                                return null;
                            }
                            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                            FqName fqName3 = fqName2 = DescriptorUtilsKt.getFqNameSafe(resolvedCall3.getResultingDescriptor());
                            if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getWithIndexFqName$p()) || Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getSequenceWithIndexFqName$p())) {
                                if (this.$destructuringParameter == null) {
                                    return null;
                                }
                                List<KtDestructuringDeclarationEntry> list2 = this.$destructuringParameter.getEntries();
                                boolean bl = false;
                                boolean bl2 = false;
                                List<KtDestructuringDeclarationEntry> it = list2;
                                boolean bl3 = false;
                                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it.get(0);
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"it[0]");
                                VariableDescriptor variableDescriptor = this.$extractDescriptor$4.invoke(ktDestructuringDeclarationEntry);
                                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry2 = it.get(1);
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry2, (String)"it[1]");
                                pair = new Pair((Object)variableDescriptor, (Object)this.$extractDescriptor$4.invoke(ktDestructuringDeclarationEntry2));
                            } else if (Intrinsics.areEqual((Object)fqName3, (Object)LoopTranslator.access$getIndicesFqName$p())) {
                                if (this.$destructuringParameter != null) {
                                    return null;
                                }
                                DeclarationDescriptor declarationDescriptor = this.$context.bindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, this.$loopParameter);
                                if (!(declarationDescriptor instanceof VariableDescriptor)) {
                                    declarationDescriptor = null;
                                }
                                VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
                                if (variableDescriptor == null) {
                                    return null;
                                }
                                VariableDescriptor varDescriptor = variableDescriptor;
                                pair = new Pair((Object)varDescriptor, null);
                            } else {
                                return null;
                            }
                            Pair pair2 = pair;
                            VariableDescriptor variableDescriptor = (VariableDescriptor)pair2.component1();
                            VariableDescriptor elementDescriptor = (VariableDescriptor)pair2.component2();
                            Object object = resolvedCall3.getResultingDescriptor().getExtensionReceiverParameter();
                            if (!((object != null && (object = object.getType()) != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
                                classifierDescriptor = null;
                            }
                            ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
                            if (classDescriptor2 == null) {
                                return null;
                            }
                            ClassDescriptor receiverClass = classDescriptor2;
                            if (KotlinBuiltIns.isArrayOrPrimitiveArray(receiverClass)) {
                                withIndexReceiverType = WithIndexReceiverType.ARRAY;
                            } else if (KotlinBuiltIns.isCollectionOrNullableCollection(receiverClass.getDefaultType())) {
                                withIndexReceiverType = WithIndexReceiverType.COLLECTION;
                            } else if (KotlinBuiltIns.isIterableOrNullableIterable(receiverClass.getDefaultType())) {
                                withIndexReceiverType = WithIndexReceiverType.ITERABLE;
                            } else if (Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(receiverClass), (Object)LoopTranslator.access$getSequenceFqName$p())) {
                                withIndexReceiverType = WithIndexReceiverType.SEQUENCE;
                            } else {
                                return null;
                            }
                            WithIndexReceiverType receiverType = withIndexReceiverType;
                            ReceiverValue receiverValue = resolvedCall3.getExtensionReceiver();
                            if (receiverValue == null) {
                                return null;
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"resolvedCall.extensionReceiver ?: return null");
                            ReceiverValue receiverValue2 = receiver = receiverValue;
                            if (receiverValue2 instanceof ExpressionReceiver) {
                                jsExpression = Translation.translateAsExpression(((ExpressionReceiver)receiver).getExpression(), this.$context);
                            } else if (receiverValue2 instanceof ImplicitReceiver) {
                                jsExpression = this.$context.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForReceiver(receiver));
                            } else {
                                return null;
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"when (receiver) {\n      \u2026 -> return null\n        }");
                            JsExpression arrayExpr = jsExpression;
                            return new WithIndexInfo(receiverType, (VariableDescriptor)indexDescriptor, elementDescriptor, arrayExpr);
                        }
                        {
                            this.$loopRange = ktExpression;
                            this.$context = translationContext;
                            this.$destructuringParameter = ktDestructuringDeclaration;
                            this.$extractDescriptor$4 = var4_4;
                            this.$loopParameter = ktParameter;
                            super(0);
                        }
                    };
                    Function1<JsExpression, JsStatement> $fun$translateBody$6 = new Function1<JsExpression, JsStatement>(expression2, context2, destructuringParameter, loopParameter, parameterName){
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtDestructuringDeclaration $destructuringParameter;
                        final /* synthetic */ KtParameter $loopParameter;
                        final /* synthetic */ JsName $parameterName;

                        @Nullable
                        public final JsStatement invoke(@Nullable JsExpression itemValue) {
                            List<JsStatement> list2;
                            SourceInfoAwareJsNode sourceInfoAwareJsNode;
                            JsStatement realBody;
                            JsStatement jsStatement;
                            KtExpression ktExpression = this.$expression.getBody();
                            if (ktExpression != null) {
                                KtExpression ktExpression2 = ktExpression;
                                boolean bl = false;
                                boolean bl2 = false;
                                KtExpression it = ktExpression2;
                                boolean bl3 = false;
                                jsStatement = Translation.translateAsStatementAndMergeInBlockIfNeeded(it, this.$context);
                            } else {
                                jsStatement = realBody = null;
                            }
                            if (itemValue == null && this.$destructuringParameter == null) {
                                return realBody;
                            }
                            JsBlock block = new JsBlock();
                            if (this.$destructuringParameter == null) {
                                JsExpression jsExpression;
                                boolean bl;
                                boolean bl4;
                                SourceInfoAwareJsNode sourceInfoAwareJsNode2;
                                DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(this.$context.bindingContext(), this.$loopParameter);
                                if (declarationDescriptor == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableDescriptor");
                                }
                                CallableDescriptor loopParameterDescriptor = (CallableDescriptor)declarationDescriptor;
                                KotlinType kotlinType2 = loopParameterDescriptor.getReturnType();
                                if (kotlinType2 == null) {
                                    kotlinType2 = this.$context.getCurrentModule().getBuiltIns().getAnyType();
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"loopParameterDescriptor.\u2026ntModule.builtIns.anyType");
                                KotlinType loopParameterType = kotlinType2;
                                JsExpression jsExpression2 = itemValue;
                                if (jsExpression2 != null) {
                                    sourceInfoAwareJsNode2 = jsExpression2;
                                    bl4 = false;
                                    bl = false;
                                    JsExpression it = sourceInfoAwareJsNode2;
                                    boolean bl5 = false;
                                    jsExpression = TranslationUtils.coerce(this.$context, it, loopParameterType);
                                } else {
                                    jsExpression = null;
                                }
                                JsExpression coercedItemValue = jsExpression;
                                sourceInfoAwareJsNode2 = JsAstUtils.newVar(this.$parameterName, coercedItemValue);
                                bl4 = false;
                                bl = false;
                                SourceInfoAwareJsNode $this$apply = sourceInfoAwareJsNode2;
                                boolean bl6 = false;
                                $this$apply.setSource(this.$expression.getLoopRange());
                                sourceInfoAwareJsNode = sourceInfoAwareJsNode2;
                            } else {
                                TranslationContext translationContext = this.$context.innerBlock(block);
                                Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context.innerBlock(block)");
                                TranslationContext innerBlockContext = translationContext;
                                if (itemValue != null) {
                                    JsVars jsVars = JsAstUtils.newVar(this.$parameterName, itemValue);
                                    boolean bl = false;
                                    boolean bl7 = false;
                                    JsVars $this$apply = jsVars;
                                    boolean bl8 = false;
                                    $this$apply.setSource(this.$expression.getLoopRange());
                                    JsVars jsVars2 = jsVars;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jsVars2, (String)"JsAstUtils.newVar(parame\u2026 = expression.loopRange }");
                                    JsVars parameterStatement = jsVars2;
                                    innerBlockContext.addStatementToCurrentBlock(parameterStatement);
                                }
                                sourceInfoAwareJsNode = DestructuringDeclarationTranslator.translate(this.$destructuringParameter, JsAstUtils.pureFqn(this.$parameterName, null), innerBlockContext);
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)sourceInfoAwareJsNode, (String)"if (destructuringParamet\u2026ontext)\n                }");
                            JsVars currentVarInit = sourceInfoAwareJsNode;
                            Collection collection = block.getStatements();
                            boolean bl = false;
                            collection.add(currentVarInit);
                            collection = block.getStatements();
                            if (realBody instanceof JsBlock) {
                                List<JsStatement> list3 = ((JsBlock)realBody).getStatements();
                                list2 = list3;
                                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"realBody.statements");
                            } else {
                                list2 = CollectionsKt.listOfNotNull((Object)realBody);
                            }
                            Iterable iterable = list2;
                            boolean bl9 = false;
                            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
                            return block;
                        }
                        {
                            this.$expression = ktForExpression;
                            this.$context = translationContext;
                            this.$destructuringParameter = ktDestructuringDeclaration;
                            this.$loopParameter = ktParameter;
                            this.$parameterName = jsName;
                            super(1);
                        }
                    };
                    Function1<RangeLiteral, JsStatement> $fun$translateForOverLiteralRange$7 = new Function1<RangeLiteral, JsStatement>(context2, $fun$translateBody$6, parameterName, expression2){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ translateForExpression.6 $translateBody$6;
                        final /* synthetic */ JsName $parameterName;
                        final /* synthetic */ KtForExpression $expression;

                        @NotNull
                        public final JsStatement invoke(@NotNull RangeLiteral literal) {
                            JsExpression jsExpression;
                            Enum incrementOperator;
                            JsBinaryOperation jsBinaryOperation;
                            JsExpression jsExpression2;
                            JsExpression jsExpression3;
                            boolean bl;
                            Object it;
                            Intrinsics.checkParameterIsNotNull((Object)literal, (String)"literal");
                            JsBlock startBlock = new JsBlock();
                            JsExpression jsExpression4 = Translation.translateAsExpression(literal.getFirst(), this.$context, startBlock);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression4, (String)"Translation.translateAsE\u2026rst, context, startBlock)");
                            JsExpression leftExpression = jsExpression4;
                            JsBlock endBlock = new JsBlock();
                            JsExpression jsExpression5 = Translation.translateAsExpression(literal.getSecond(), this.$context, endBlock);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression5, (String)"Translation.translateAsE\u2026econd, context, endBlock)");
                            JsExpression rightExpression = jsExpression5;
                            JsBlock stepBlock = new JsBlock();
                            KtExpression ktExpression = literal.getStep();
                            if (ktExpression != null) {
                                KtExpression ktExpression2 = ktExpression;
                                boolean bl2 = false;
                                boolean bl3 = false;
                                it = ktExpression2;
                                bl = false;
                                jsExpression3 = Translation.translateAsExpression((KtExpression)it, this.$context, stepBlock);
                            } else {
                                jsExpression3 = null;
                            }
                            JsExpression stepExpression = jsExpression3;
                            this.$context.addStatementsToCurrentBlockFrom(startBlock);
                            JsExpression jsExpression6 = this.$context.cacheExpressionIfNeeded(leftExpression);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression6, (String)"context.cacheExpressionIfNeeded(leftExpression)");
                            JsExpression rangeStart = jsExpression6;
                            this.$context.addStatementsToCurrentBlockFrom(endBlock);
                            JsExpression jsExpression7 = this.$context.defineTemporary(rightExpression);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression7, (String)"context.defineTemporary(rightExpression)");
                            JsExpression rangeEnd = jsExpression7;
                            this.$context.addStatementsToCurrentBlockFrom(stepBlock);
                            JsExpression jsExpression8 = stepExpression;
                            if (jsExpression8 != null) {
                                it = jsExpression8;
                                bl = false;
                                boolean bl4 = false;
                                Object it2 = it;
                                boolean bl5 = false;
                                jsExpression2 = this.$context.defineTemporary((JsExpression)it2);
                            } else {
                                jsExpression2 = null;
                            }
                            JsExpression step = jsExpression2;
                            JsStatement body2 = this.$translateBody$6.invoke(null);
                            switch (LoopTranslator$WhenMappings.$EnumSwitchMapping$0[literal.getType().ordinal()]) {
                                case 1: {
                                    jsBinaryOperation = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), rangeEnd);
                                    break;
                                }
                                case 2: {
                                    jsBinaryOperation = JsAstUtils.lessThan(this.$parameterName.makeRef(), rangeEnd);
                                    break;
                                }
                                case 3: {
                                    jsBinaryOperation = JsAstUtils.greaterThanEq(this.$parameterName.makeRef(), rangeEnd);
                                    break;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                            JsExpression conditionExpression = jsBinaryOperation.source(this.$expression);
                            if (step == null) {
                                JsUnaryOperator jsUnaryOperator;
                                switch (LoopTranslator$WhenMappings.$EnumSwitchMapping$1[literal.getType().ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        jsUnaryOperator = JsUnaryOperator.INC;
                                        break;
                                    }
                                    case 3: {
                                        jsUnaryOperator = JsUnaryOperator.DEC;
                                        break;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                incrementOperator = jsUnaryOperator;
                                jsExpression = new JsPostfixOperation((JsUnaryOperator)incrementOperator, this.$parameterName.makeRef()).source(this.$expression);
                            } else {
                                JsBinaryOperator jsBinaryOperator;
                                switch (LoopTranslator$WhenMappings.$EnumSwitchMapping$2[literal.getType().ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        jsBinaryOperator = JsBinaryOperator.ASG_ADD;
                                        break;
                                    }
                                    case 3: {
                                        jsBinaryOperator = JsBinaryOperator.ASG_SUB;
                                        break;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                incrementOperator = jsBinaryOperator;
                                jsExpression = new JsBinaryOperation((JsBinaryOperator)incrementOperator, this.$parameterName.makeRef(), step).source(this.$expression);
                            }
                            JsExpression incrementExpression = jsExpression;
                            JsVars jsVars = JsAstUtils.newVar(this.$parameterName, rangeStart);
                            boolean bl6 = false;
                            boolean bl7 = false;
                            JsVars $this$apply = jsVars;
                            boolean bl8 = false;
                            $this$apply.setSource(this.$expression);
                            JsVars jsVars2 = jsVars;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsVars2, (String)"newVar(parameterName, ra\u2026y { source = expression }");
                            JsVars initVars = jsVars2;
                            return new JsFor(initVars, conditionExpression, incrementExpression, body2);
                        }
                        {
                            this.$context = translationContext;
                            this.$translateBody$6 = var2_2;
                            this.$parameterName = jsName;
                            this.$expression = ktForExpression;
                            super(1);
                        }
                    };
                    $fun$translateForOverRange$8 = new Function0<JsStatement>(context2, loopRange, $fun$translateBody$6, parameterName, expression2){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ translateForExpression.6 $translateBody$6;
                        final /* synthetic */ JsName $parameterName;
                        final /* synthetic */ KtForExpression $expression;

                        @NotNull
                        public final JsStatement invoke() {
                            JsExpression jsExpression = this.$context.defineTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"context.defineTemporary(\u2026sion(loopRange, context))");
                            JsExpression rangeExpression = jsExpression;
                            Function1<String, JsExpression> $fun$getProperty$1 = new Function1<String, JsExpression>(this, rangeExpression){
                                final /* synthetic */ translateForExpression.8 this$0;
                                final /* synthetic */ JsExpression $rangeExpression;

                                @NotNull
                                public final JsExpression invoke(@NotNull String funName) {
                                    Intrinsics.checkParameterIsNotNull((Object)funName, (String)"funName");
                                    JsExpression jsExpression = new JsNameRef(funName, this.$rangeExpression).source(this.this$0.$loopRange);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"JsNameRef(funName, range\u2026ession).source(loopRange)");
                                    return jsExpression;
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$rangeExpression = jsExpression;
                                    super(1);
                                }
                            };
                            JsExpression jsExpression2 = this.$context.defineTemporary($fun$getProperty$1.invoke("first"));
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"context.defineTemporary(getProperty(\"first\"))");
                            JsExpression start = jsExpression2;
                            JsExpression jsExpression3 = this.$context.defineTemporary($fun$getProperty$1.invoke("last"));
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"context.defineTemporary(getProperty(\"last\"))");
                            JsExpression end = jsExpression3;
                            JsExpression jsExpression4 = this.$context.defineTemporary($fun$getProperty$1.invoke("step"));
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression4, (String)"context.defineTemporary(getProperty(\"step\"))");
                            JsExpression increment = jsExpression4;
                            JsStatement body2 = this.$translateBody$6.invoke(null);
                            JsExpression conditionExpression = JsAstUtils.lessThanEq(this.$parameterName.makeRef(), end).source(this.$expression);
                            JsExpression incrementExpression = JsAstUtils.addAssign(this.$parameterName.makeRef(), increment).source(this.$expression);
                            JsVars jsVars = JsAstUtils.newVar(this.$parameterName, start);
                            boolean bl = false;
                            boolean bl2 = false;
                            JsVars $this$apply = jsVars;
                            boolean bl3 = false;
                            $this$apply.setSource(this.$expression);
                            JsVars jsVars2 = jsVars;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsVars2, (String)"newVar(parameterName, st\u2026y { source = expression }");
                            JsVars initVars = jsVars2;
                            return new JsFor(initVars, conditionExpression, incrementExpression, body2);
                        }
                        {
                            this.$context = translationContext;
                            this.$loopRange = ktExpression;
                            this.$translateBody$6 = var3_3;
                            this.$parameterName = jsName;
                            this.$expression = ktForExpression;
                            super(0);
                        }
                    };
                    $fun$translateForOverArray$9 = new Function0<JsStatement>(context2, loopRange, expression2, $fun$translateBody$6){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ translateForExpression.6 $translateBody$6;

                        @NotNull
                        public final JsStatement invoke() {
                            JsExpression rangeExpression;
                            JsExpression jsExpression = this.$context.defineTemporary(Translation.translateAsExpression(this.$loopRange, this.$context));
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"context.defineTemporary(\u2026sion(loopRange, context))");
                            JsExpression jsExpression2 = rangeExpression = jsExpression;
                            BuiltInPropertyIntrinsic builtInPropertyIntrinsic = ArrayFIF.LENGTH_PROPERTY_INTRINSIC;
                            boolean bl = false;
                            List list2 = CollectionsKt.emptyList();
                            JsExpression jsExpression3 = builtInPropertyIntrinsic.apply(jsExpression2, (List<? extends JsExpression>)list2, this.$context);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression3, (String)"ArrayFIF.LENGTH_PROPERTY\u2026ssion, listOf(), context)");
                            JsExpression length = jsExpression3;
                            JsExpression jsExpression4 = this.$context.defineTemporary(length);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression4, (String)"context.defineTemporary(length)");
                            JsExpression end = jsExpression4;
                            TemporaryVariable temporaryVariable = this.$context.declareTemporary(new JsIntLiteral(0), this.$expression);
                            Intrinsics.checkExpressionValueIsNotNull((Object)temporaryVariable, (String)"context.declareTemporary\u2026ntLiteral(0), expression)");
                            TemporaryVariable index2 = temporaryVariable;
                            JsExpression arrayAccess = new JsArrayAccess(rangeExpression, index2.reference()).source(this.$expression);
                            JsStatement body2 = this.$translateBody$6.invoke(arrayAccess);
                            JsExpression initExpression = JsAstUtils.assignment(index2.reference(), new JsIntLiteral(0)).source(this.$expression);
                            JsExpression conditionExpression = JsAstUtils.inequality(index2.reference(), end).source(this.$expression);
                            JsExpression incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, index2.reference()).source(this.$expression);
                            return new JsFor(initExpression, conditionExpression, incrementExpression, body2);
                        }
                        {
                            this.$context = translationContext;
                            this.$loopRange = ktExpression;
                            this.$expression = ktForExpression;
                            this.$translateBody$6 = var4_4;
                            super(0);
                        }
                    };
                    $fun$translateForOverArrayWithIndex$10 = new Function1<WithIndexInfo, JsStatement>(context2, expression2){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtForExpression $expression;

                        @NotNull
                        public final JsStatement invoke(@NotNull WithIndexInfo info2) {
                            JsBlock body2;
                            JsExpression incrementExpression;
                            JsExpression conditionExpression;
                            JsVars initExpression;
                            block8: {
                                boolean bl;
                                Object object;
                                JsName jsName;
                                boolean bl2;
                                Object object2;
                                JsExpression range;
                                block7: {
                                    block6: {
                                        Intrinsics.checkParameterIsNotNull((Object)info2, (String)"info");
                                        JsExpression jsExpression = this.$context.cacheExpressionIfNeeded(info2.getRange());
                                        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"context.cacheExpressionIfNeeded(info.range)");
                                        range = jsExpression;
                                        object2 = info2.getIndex();
                                        if (object2 == null) break block6;
                                        VariableDescriptor variableDescriptor = object2;
                                        boolean bl3 = false;
                                        bl2 = false;
                                        VariableDescriptor it = variableDescriptor;
                                        boolean bl4 = false;
                                        object2 = this.$context.getNameForDescriptor(it);
                                        if (object2 != null) break block7;
                                    }
                                    object2 = JsScope.declareTemporary();
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"info.index?.let { contex\u2026sScope.declareTemporary()");
                                Object indexVar = object2;
                                VariableDescriptor variableDescriptor = info2.getValue();
                                if (variableDescriptor != null) {
                                    VariableDescriptor variableDescriptor2 = variableDescriptor;
                                    bl2 = false;
                                    boolean it = false;
                                    VariableDescriptor it2 = variableDescriptor2;
                                    boolean bl5 = false;
                                    jsName = this.$context.getNameForDescriptor(it2);
                                } else {
                                    jsName = null;
                                }
                                JsName valueVar = jsName;
                                JsVars jsVars = JsAstUtils.newVar((JsName)indexVar, new JsIntLiteral(0));
                                boolean it = false;
                                boolean it2 = false;
                                JsVars $this$apply = jsVars;
                                boolean bl6 = false;
                                $this$apply.setSource(this.$expression);
                                JsVars jsVars2 = jsVars;
                                Intrinsics.checkExpressionValueIsNotNull((Object)jsVars2, (String)"newVar(indexVar, JsIntLi\u2026y { source = expression }");
                                initExpression = jsVars2;
                                conditionExpression = JsAstUtils.inequality(((JsName)indexVar).makeRef(), new JsNameRef("length", range)).source(this.$expression);
                                incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, ((JsName)indexVar).makeRef()).source(this.$expression);
                                body2 = new JsBlock();
                                if (valueVar != null) {
                                    object = body2.getStatements();
                                    JsVars jsVars3 = JsAstUtils.newVar(valueVar, new JsArrayAccess(range, ((JsName)indexVar).makeRef()));
                                    bl = false;
                                    boolean bl7 = false;
                                    JsVars $this$apply2 = jsVars3;
                                    boolean bl8 = false;
                                    $this$apply2.setSource(this.$expression);
                                    bl = false;
                                    object.add(jsVars3);
                                }
                                KtExpression ktExpression = this.$expression.getBody();
                                if (ktExpression == null) break block8;
                                object = ktExpression;
                                boolean bl9 = false;
                                bl = false;
                                Object it3 = object;
                                boolean bl10 = false;
                                Collection collection = body2.getStatements();
                                JsStatement jsStatement = Translation.translateAsStatement((KtExpression)it3, this.$context.innerBlock(body2));
                                boolean bl11 = false;
                                collection.add(jsStatement);
                            }
                            return new JsFor(initExpression, conditionExpression, incrementExpression, (JsStatement)body2);
                        }
                        {
                            this.$context = translationContext;
                            this.$expression = ktForExpression;
                            super(1);
                        }
                    };
                    Function0<ClassDescriptor> $fun$findCollection$11 = new Function0<ClassDescriptor>(context2){
                        final /* synthetic */ TranslationContext $context;

                        @NotNull
                        public final ClassDescriptor invoke() {
                            ModuleDescriptor moduleDescriptor = this.$context.getCurrentModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"context.currentModule");
                            ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.collection);
                            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(KotlinB\u2026tIns.FQ_NAMES.collection)");
                            ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
                            if (classDescriptor2 == null) {
                                Intrinsics.throwNpe();
                            }
                            return classDescriptor2;
                        }
                        {
                            this.$context = translationContext;
                            super(0);
                        }
                    };
                    $fun$translateForOverCollectionIndices$12 = new Function1<WithIndexInfo, JsStatement>(context2, expression2, $fun$findCollection$11){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ translateForExpression.11 $findCollection$11;

                        @NotNull
                        public final JsStatement invoke(@NotNull WithIndexInfo info2) {
                            JsBlock body2;
                            JsExpression incrementExpression;
                            JsExpression conditionExpression;
                            JsVars initExpression;
                            block4: {
                                boolean bl;
                                Object object;
                                JsExpression range;
                                block3: {
                                    block2: {
                                        Intrinsics.checkParameterIsNotNull((Object)info2, (String)"info");
                                        JsExpression jsExpression = this.$context.cacheExpressionIfNeeded(info2.getRange());
                                        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"context.cacheExpressionIfNeeded(info.range)");
                                        range = jsExpression;
                                        object = info2.getIndex();
                                        if (object == null) break block2;
                                        VariableDescriptor variableDescriptor = object;
                                        boolean bl2 = false;
                                        bl = false;
                                        VariableDescriptor it = variableDescriptor;
                                        boolean bl3 = false;
                                        object = this.$context.getNameForDescriptor(it);
                                        if (object != null) break block3;
                                    }
                                    object = JsScope.declareTemporary();
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"info.index?.let { contex\u2026sScope.declareTemporary()");
                                Object indexVar = object;
                                JsVars jsVars = JsAstUtils.newVar((JsName)indexVar, new JsIntLiteral(0));
                                bl = false;
                                boolean it = false;
                                JsVars $this$apply = jsVars;
                                boolean bl4 = false;
                                $this$apply.setSource(this.$expression);
                                JsVars jsVars2 = jsVars;
                                Intrinsics.checkExpressionValueIsNotNull((Object)jsVars2, (String)"newVar(indexVar, JsIntLi\u2026y { source = expression }");
                                initExpression = jsVars2;
                                PropertyDescriptor propertyDescriptor2 = DescriptorUtils.getPropertyByName(this.$findCollection$11.invoke().getUnsubstitutedMemberScope(), Name.identifier("size"));
                                Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"getPropertyByName(findCo\u2026 Name.identifier(\"size\"))");
                                PropertyDescriptor sizeDescriptor = propertyDescriptor2;
                                JsName jsName = this.$context.getNameForDescriptor(sizeDescriptor);
                                Intrinsics.checkExpressionValueIsNotNull((Object)jsName, (String)"context.getNameForDescriptor(sizeDescriptor)");
                                JsName sizeName = jsName;
                                conditionExpression = JsAstUtils.inequality(((JsName)indexVar).makeRef(), new JsNameRef(sizeName, range)).source(this.$expression);
                                incrementExpression = new JsPrefixOperation(JsUnaryOperator.INC, ((JsName)indexVar).makeRef()).source(this.$expression);
                                body2 = new JsBlock();
                                KtExpression ktExpression = this.$expression.getBody();
                                if (ktExpression == null) break block4;
                                KtExpression ktExpression2 = ktExpression;
                                boolean bl5 = false;
                                boolean bl6 = false;
                                KtExpression it2 = ktExpression2;
                                boolean bl7 = false;
                                Collection collection = body2.getStatements();
                                JsStatement jsStatement = Translation.translateAsStatement(it2, this.$context.innerBlock(body2));
                                boolean bl8 = false;
                                collection.add(jsStatement);
                            }
                            return new JsFor(initExpression, conditionExpression, incrementExpression, (JsStatement)body2);
                        }
                        {
                            this.$context = translationContext;
                            this.$expression = ktForExpression;
                            this.$findCollection$11 = var3_3;
                            super(1);
                        }
                    };
                    Function0<ClassDescriptor> $fun$findIterable$13 = new Function0<ClassDescriptor>(context2){
                        final /* synthetic */ TranslationContext $context;

                        @NotNull
                        public final ClassDescriptor invoke() {
                            ModuleDescriptor moduleDescriptor = this.$context.getCurrentModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"context.currentModule");
                            ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable);
                            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.iterable)");
                            ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
                            if (classDescriptor2 == null) {
                                Intrinsics.throwNpe();
                            }
                            return classDescriptor2;
                        }
                        {
                            this.$context = translationContext;
                            super(0);
                        }
                    };
                    Function0<ClassDescriptor> $fun$findSequence$14 = new Function0<ClassDescriptor>(context2){
                        final /* synthetic */ TranslationContext $context;

                        @NotNull
                        public final ClassDescriptor invoke() {
                            ModuleDescriptor moduleDescriptor = this.$context.getCurrentModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"context.currentModule");
                            ClassId classId = ClassId.topLevel(LoopTranslator.access$getSequenceFqName$p());
                            Intrinsics.checkExpressionValueIsNotNull((Object)classId, (String)"ClassId.topLevel(sequenceFqName)");
                            ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
                            if (classDescriptor2 == null) {
                                Intrinsics.throwNpe();
                            }
                            return classDescriptor2;
                        }
                        {
                            this.$context = translationContext;
                            super(0);
                        }
                    };
                    $fun$translateForOverCollectionWithIndex$15 = new Function1<WithIndexInfo, JsStatement>(context2, expression2, $fun$findSequence$14, $fun$findIterable$13){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ translateForExpression.14 $findSequence$14;
                        final /* synthetic */ translateForExpression.13 $findIterable$13;

                        @NotNull
                        public final JsStatement invoke(@NotNull WithIndexInfo info2) {
                            JsStatement jsStatement;
                            JsStatement jsStatement2;
                            JsExpression jsExpression;
                            boolean bl;
                            boolean bl2;
                            JsVars jsVars;
                            JsName jsName;
                            JsName jsName2;
                            boolean bl3;
                            Intrinsics.checkParameterIsNotNull((Object)info2, (String)"info");
                            JsExpression jsExpression2 = this.$context.cacheExpressionIfNeeded(info2.getRange());
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"context.cacheExpressionIfNeeded(info.range)");
                            JsExpression range = jsExpression2;
                            VariableDescriptor variableDescriptor = info2.getIndex();
                            if (variableDescriptor != null) {
                                VariableDescriptor variableDescriptor2 = variableDescriptor;
                                boolean bl4 = false;
                                bl3 = false;
                                VariableDescriptor it = variableDescriptor2;
                                boolean bl5 = false;
                                jsName2 = this.$context.getNameForDescriptor(it);
                            } else {
                                jsName2 = null;
                            }
                            JsName indexVar = jsName2;
                            VariableDescriptor variableDescriptor3 = info2.getValue();
                            if (variableDescriptor3 != null) {
                                VariableDescriptor variableDescriptor4 = variableDescriptor3;
                                bl3 = false;
                                boolean it = false;
                                VariableDescriptor it2 = variableDescriptor4;
                                boolean bl6 = false;
                                jsName = this.$context.getNameForDescriptor(it2);
                            } else {
                                jsName = null;
                            }
                            JsName valueVar = jsName;
                            JsName jsName3 = indexVar;
                            if (jsName3 != null) {
                                JsName jsName4 = jsName3;
                                bl3 = false;
                                boolean it = false;
                                JsName it3 = jsName4;
                                boolean bl7 = false;
                                jsVars = JsAstUtils.newVar(it3, new JsIntLiteral(0));
                                TranslationContext translationContext = this.$context;
                                bl2 = false;
                                boolean bl8 = false;
                                JsVars $this$apply = jsVars;
                                boolean bl9 = false;
                                $this$apply.setSource(this.$expression);
                                JsVars jsVars2 = jsVars;
                                translationContext.addStatementToCurrentBlock(jsVars2);
                            }
                            JsName jsName5 = JsScope.declareTemporary();
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsName5, (String)"JsScope.declareTemporary()");
                            JsName iteratorVar = jsName5;
                            Object rangeOwner = info2.getReceiverType() == WithIndexReceiverType.SEQUENCE ? this.$findSequence$14.invoke() : this.$findIterable$13.invoke();
                            FunctionDescriptor functionDescriptor = DescriptorUtils.getFunctionByName(rangeOwner.getUnsubstitutedMemberScope(), Name.identifier("iterator"));
                            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor, (String)"getFunctionByName(rangeO\u2026e.identifier(\"iterator\"))");
                            FunctionDescriptor iteratorDescriptor = functionDescriptor;
                            JsName jsName6 = this.$context.getNameForDescriptor(iteratorDescriptor);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsName6, (String)"context.getNameForDescriptor(iteratorDescriptor)");
                            JsName iteratorName = jsName6;
                            jsVars = JsAstUtils.newVar(iteratorVar, new JsInvocation((JsExpression)JsAstUtils.pureFqn(iteratorName, range), new JsExpression[0]));
                            boolean bl10 = false;
                            bl2 = false;
                            JsVars $this$apply = jsVars;
                            boolean bl11 = false;
                            $this$apply.setSource(this.$expression);
                            JsVars jsVars3 = jsVars;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsVars3, (String)"newVar(iteratorVar, JsIn\u2026y { source = expression }");
                            JsVars initExpression = jsVars3;
                            KotlinType kotlinType2 = iteratorDescriptor.getReturnType();
                            if (kotlinType2 == null) {
                                Intrinsics.throwNpe();
                            }
                            ClassifierDescriptor classifierDescriptor = kotlinType2.getConstructor().getDeclarationDescriptor();
                            if (classifierDescriptor == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                            }
                            ClassDescriptor iteratorClassDescriptor = (ClassDescriptor)classifierDescriptor;
                            FunctionDescriptor functionDescriptor2 = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("hasNext"));
                            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"getFunctionByName(iterat\u2026me.identifier(\"hasNext\"))");
                            FunctionDescriptor hasNextDescriptor = functionDescriptor2;
                            JsName jsName7 = this.$context.getNameForDescriptor(hasNextDescriptor);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsName7, (String)"context.getNameForDescriptor(hasNextDescriptor)");
                            JsName hasNextName = jsName7;
                            JsNode hasNextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(hasNextName, (JsExpression)iteratorVar.makeRef()), new JsExpression[0]).source(this.$expression);
                            FunctionDescriptor functionDescriptor3 = DescriptorUtils.getFunctionByName(iteratorClassDescriptor.getUnsubstitutedMemberScope(), Name.identifier("next"));
                            Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor3, (String)"getFunctionByName(iterat\u2026 Name.identifier(\"next\"))");
                            FunctionDescriptor nextDescriptor = functionDescriptor3;
                            JsName jsName8 = this.$context.getNameForDescriptor(nextDescriptor);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsName8, (String)"context.getNameForDescriptor(nextDescriptor)");
                            JsName nextName = jsName8;
                            JsNode nextInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn(nextName, (JsExpression)iteratorVar.makeRef()), new JsExpression[0]).source(this.$expression);
                            JsName jsName9 = indexVar;
                            if (jsName9 != null) {
                                JsName jsName10 = jsName9;
                                boolean bl12 = false;
                                boolean bl13 = false;
                                JsName it = jsName10;
                                bl = false;
                                jsExpression = new JsPrefixOperation(JsUnaryOperator.INC, it.makeRef()).source(this.$expression);
                            } else {
                                jsExpression = null;
                            }
                            JsExpression incrementExpression = jsExpression;
                            JsBlock body2 = new JsBlock();
                            Object object = body2.getStatements();
                            if (valueVar != null) {
                                jsStatement2 = JsAstUtils.newVar(valueVar, (JsExpression)nextInvocation);
                                boolean bl14 = false;
                                bl = false;
                                JsStatement $this$apply2 = jsStatement2;
                                boolean bl15 = false;
                                ((SourceInfoAwareJsNode)((Object)$this$apply2)).setSource(this.$expression);
                                jsStatement = jsStatement2;
                            } else {
                                jsStatement = JsAstUtils.asSyntheticStatement((JsExpression)nextInvocation);
                            }
                            jsStatement2 = jsStatement;
                            boolean bl16 = false;
                            object.add(jsStatement2);
                            KtExpression ktExpression = this.$expression.getBody();
                            if (ktExpression != null) {
                                object = ktExpression;
                                boolean bl17 = false;
                                bl16 = false;
                                Object it = object;
                                boolean bl18 = false;
                                Collection collection = body2.getStatements();
                                JsStatement jsStatement3 = Translation.translateAsStatement((KtExpression)it, this.$context.innerBlock(body2));
                                boolean bl19 = false;
                                collection.add(jsStatement3);
                            }
                            object = new JsFor(initExpression, (JsExpression)hasNextInvocation, incrementExpression);
                            boolean bl20 = false;
                            bl16 = false;
                            Object it = object;
                            boolean bl21 = false;
                            ((JsFor)it).setBody(body2);
                            return (JsStatement)object;
                        }
                        {
                            this.$context = translationContext;
                            this.$expression = ktForExpression;
                            this.$findSequence$14 = var3_3;
                            this.$findIterable$13 = var4_4;
                            super(1);
                        }
                    };
                    $fun$translateForOverIterator$16 = new Function0<JsStatement>(context2, loopRange, expression2, $fun$translateBody$6){
                        final /* synthetic */ TranslationContext $context;
                        final /* synthetic */ KtExpression $loopRange;
                        final /* synthetic */ KtForExpression $expression;
                        final /* synthetic */ translateForExpression.6 $translateBody$6;

                        @NotNull
                        public final JsStatement invoke() {
                            List<JsStatement> list2;
                            boolean bl;
                            boolean bl2;
                            Object object;
                            Collection collection;
                            JsExpression jsExpression;
                            Function3<JsExpression, ResolvedCall<FunctionDescriptor>, JsBlock, JsExpression> $fun$translateMethodInvocation$1 = new Function3<JsExpression, ResolvedCall<FunctionDescriptor>, JsBlock, JsExpression>(this){
                                final /* synthetic */ translateForExpression.16 this$0;

                                @NotNull
                                public final JsExpression invoke(@Nullable JsExpression receiver, @NotNull ResolvedCall<FunctionDescriptor> resolvedCall2, @NotNull JsBlock block) {
                                    Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
                                    Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                                    TranslationContext translationContext = this.this$0.$context.innerBlock(block);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)translationContext, (String)"context.innerBlock(block)");
                                    return CallTranslator.translate(translationContext, resolvedCall2, receiver);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(3);
                                }
                            };
                            Function0<JsExpression> $fun$iteratorMethodInvocation$2 = new Function0<JsExpression>(this){
                                final /* synthetic */ translateForExpression.16 this$0;

                                @NotNull
                                public final JsExpression invoke() {
                                    JsExpression jsExpression = Translation.translateAsExpression(this.this$0.$loopRange, this.this$0.$context);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"Translation.translateAsE\u2026ssion(loopRange, context)");
                                    JsExpression range = jsExpression;
                                    ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getIteratorFunction(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                                    Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, (String)"getIteratorFunction(cont\u2026dingContext(), loopRange)");
                                    ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
                                    return CallTranslator.translate(this.this$0.$context, resolvedCall3, range);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            };
                            JsExpression jsExpression2 = this.$context.defineTemporary((JsExpression)$fun$iteratorMethodInvocation$2.invoke());
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression2, (String)"context.defineTemporary(\u2026eratorMethodInvocation())");
                            JsExpression iteratorVar = jsExpression2;
                            Function1<JsBlock, JsExpression> $fun$hasNextMethodInvocation$3 = new Function1<JsBlock, JsExpression>(this, $fun$translateMethodInvocation$1, iteratorVar){
                                final /* synthetic */ translateForExpression.16 this$0;
                                final /* synthetic */ translateForExpression.1 $translateMethodInvocation$1;
                                final /* synthetic */ JsExpression $iteratorVar;

                                @NotNull
                                public final JsExpression invoke(@NotNull JsBlock block) {
                                    Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                                    ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getHasNextCallable(this.this$0.$context.bindingContext(), this.this$0.$loopRange);
                                    Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, (String)"getHasNextCallable(conte\u2026dingContext(), loopRange)");
                                    ResolvedCall<FunctionDescriptor> resolvedCall3 = resolvedCall2;
                                    return this.$translateMethodInvocation$1.invoke(this.$iteratorVar, resolvedCall3, block);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$translateMethodInvocation$1 = var2_2;
                                    this.$iteratorVar = jsExpression;
                                    super(1);
                                }
                            };
                            JsBlock hasNextBlock = new JsBlock();
                            JsExpression hasNextInvocation = $fun$hasNextMethodInvocation$3.invoke(hasNextBlock);
                            JsBlock nextBlock = new JsBlock();
                            ResolvedCall<FunctionDescriptor> resolvedCall2 = BindingUtils.getNextFunction(this.$context.bindingContext(), this.$loopRange);
                            Intrinsics.checkExpressionValueIsNotNull(resolvedCall2, (String)"getNextFunction(context.\u2026dingContext(), loopRange)");
                            JsExpression nextInvoke = $fun$translateMethodInvocation$1.invoke(iteratorVar, resolvedCall2, nextBlock);
                            boolean bl3 = false;
                            List bodyStatements = new ArrayList<E>();
                            if (hasNextBlock.isEmpty()) {
                                jsExpression = hasNextInvocation;
                            } else {
                                collection = bodyStatements;
                                List<JsStatement> list3 = hasNextBlock.getStatements();
                                Intrinsics.checkExpressionValueIsNotNull(list3, (String)"hasNextBlock.statements");
                                object = list3;
                                bl2 = false;
                                CollectionsKt.addAll((Collection)collection, (Iterable)object);
                                collection = bodyStatements;
                                object = new JsBreak();
                                JsExpression jsExpression3 = JsAstUtils.notOptimized(hasNextInvocation);
                                bl2 = false;
                                bl = false;
                                Object $this$apply = object;
                                boolean bl4 = false;
                                ((SourceInfoAwareJsNode)$this$apply).setSource(this.$expression);
                                Object object2 = object;
                                JsStatement jsStatement = (JsStatement)object2;
                                JsExpression jsExpression4 = jsExpression3;
                                object = new JsIf(jsExpression4, jsStatement);
                                bl2 = false;
                                bl = false;
                                $this$apply = object;
                                boolean bl5 = false;
                                ((SourceInfoAwareJsNode)$this$apply).setSource(this.$expression);
                                bl2 = false;
                                collection.add(object);
                                jsExpression = new JsBooleanLiteral(true);
                            }
                            JsExpression exitCondition = jsExpression;
                            collection = bodyStatements;
                            List<JsStatement> list4 = nextBlock.getStatements();
                            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"nextBlock.statements");
                            object = list4;
                            bl2 = false;
                            CollectionsKt.addAll((Collection)collection, (Iterable)object);
                            collection = bodyStatements;
                            JsStatement jsStatement = this.$translateBody$6.invoke(nextInvoke);
                            if (jsStatement != null) {
                                object = jsStatement;
                                bl2 = false;
                                bl = false;
                                Object p1 = object;
                                boolean bl6 = false;
                                list2 = JsAstUtils.flattenStatement((JsStatement)p1);
                            } else {
                                list2 = null;
                            }
                            object = list2;
                            bl2 = false;
                            Object object3 = object;
                            if (object3 == null) {
                                object3 = CollectionsKt.emptyList();
                            }
                            object = (Iterable)object3;
                            bl2 = false;
                            CollectionsKt.addAll((Collection)collection, (Iterable)object);
                            JsStatement jsStatement2 = (JsStatement)CollectionsKt.singleOrNull((List)bodyStatements);
                            if (jsStatement2 == null) {
                                jsStatement2 = new JsBlock(bodyStatements);
                            }
                            return new JsWhile(exitCondition, jsStatement2);
                        }
                        {
                            this.$context = translationContext;
                            this.$loopRange = ktExpression;
                            this.$expression = ktForExpression;
                            this.$translateBody$6 = var4_4;
                            super(0);
                        }
                    };
                    Object rangeLiteral = $fun$extractForOverRangeLiteral$2.invoke();
                    withIndexCall = $fun$extractWithIndexCall$5.invoke();
                    if (rangeLiteral == null) break block6;
                    object = $fun$translateForOverLiteralRange$7.invoke((RangeLiteral)rangeLiteral);
                    break block7;
                }
                if (withIndexCall == null) break block8;
                switch (LoopTranslator$WhenMappings.$EnumSwitchMapping$3[((WithIndexInfo)withIndexCall).getReceiverType().ordinal()]) {
                    case 1: {
                        object = $fun$translateForOverArrayWithIndex$10.invoke((WithIndexInfo)withIndexCall);
                        break block7;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        object = ((WithIndexInfo)withIndexCall).getValue() == null && ((WithIndexInfo)withIndexCall).getReceiverType() == WithIndexReceiverType.COLLECTION ? $fun$translateForOverCollectionIndices$12.invoke((WithIndexInfo)withIndexCall) : $fun$translateForOverCollectionWithIndex$15.invoke((WithIndexInfo)withIndexCall);
                        break block7;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            object = $fun$isForOverRange$1.invoke() ? $fun$translateForOverRange$8.invoke() : ($fun$isForOverArray$3.invoke() ? $fun$translateForOverArray$9.invoke() : $fun$translateForOverIterator$16.invoke());
        }
        JsStatement jsStatement = result2 = object;
        boolean bl = false;
        boolean bl4 = false;
        JsStatement $this$apply = jsStatement;
        boolean bl5 = false;
        $this$apply.setSource(expression2);
        return jsStatement;
    }

    public static final /* synthetic */ FqName access$getIntRangeName$p() {
        return intRangeName;
    }

    public static final /* synthetic */ FqName access$getIntProgressionName$p() {
        return intProgressionName;
    }

    public static final /* synthetic */ FqName access$getStepFunctionName$p() {
        return stepFunctionName;
    }

    public static final /* synthetic */ FqName access$getRangeToFunctionName$p() {
        return rangeToFunctionName;
    }

    public static final /* synthetic */ FqName access$getUntilFunctionName$p() {
        return untilFunctionName;
    }

    public static final /* synthetic */ FqName access$getDownToFunctionName$p() {
        return downToFunctionName;
    }

    public static final /* synthetic */ FqName access$getWithIndexFqName$p() {
        return withIndexFqName;
    }

    public static final /* synthetic */ FqName access$getSequenceWithIndexFqName$p() {
        return sequenceWithIndexFqName;
    }

    public static final /* synthetic */ FqName access$getIndicesFqName$p() {
        return indicesFqName;
    }

    public static final /* synthetic */ FqName access$getSequenceFqName$p() {
        return sequenceFqName;
    }
}

