/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.light;

import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.OriginInfoAwareElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIdentifier;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.ElementPresentationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightModifierList;
import org.jetbrains.kotlin.com.intellij.ui.IconManager;
import org.jetbrains.kotlin.com.intellij.ui.icons.RowIcon;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.PlatformIcons;

public abstract class LightVariableBase
extends LightElement
implements OriginInfoAwareElement,
PsiVariable {
    protected PsiElement myScope;
    protected PsiIdentifier myNameIdentifier;
    protected PsiType myType;
    protected final PsiModifierList myModifierList;
    protected boolean myWritable;
    private String myOriginInfo;

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, PsiType type2, boolean writable, PsiElement scope) {
        this(manager, nameIdentifier, JavaLanguage.INSTANCE, type2, writable, scope);
    }

    public LightVariableBase(PsiManager manager, PsiIdentifier nameIdentifier, Language language, PsiType type2, boolean writable, PsiElement scope) {
        super(manager, language);
        this.myNameIdentifier = nameIdentifier;
        this.myWritable = writable;
        this.myType = type2;
        this.myScope = scope;
        this.myModifierList = this.createModifierList();
    }

    protected PsiModifierList createModifierList() {
        return new LightModifierList(this.getManager());
    }

    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.myScope;
        if (psiElement == null) {
            LightVariableBase.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return this.myNameIdentifier;
    }

    @Override
    public boolean isValid() {
        return this.myNameIdentifier == null || this.myNameIdentifier.isValid();
    }

    @Override
    @NotNull
    public String getName() {
        String string2 = StringUtil.notNullize(this.getNameIdentifier().getText());
        if (string2 == null) {
            LightVariableBase.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            LightVariableBase.$$$reportNull$$$0(2);
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        if (this.myType == null) {
            this.myType = this.computeType();
        }
        PsiType psiType2 = this.myType;
        if (psiType2 == null) {
            LightVariableBase.$$$reportNull$$$0(3);
        }
        return psiType2;
    }

    @NotNull
    protected PsiType computeType() {
        PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
        if (psiPrimitiveType == null) {
            LightVariableBase.$$$reportNull$$$0(4);
        }
        return psiPrimitiveType;
    }

    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        PsiTypeElement psiTypeElement = JavaPsiFacade.getElementFactory(this.getProject()).createTypeElement(this.myType);
        if (psiTypeElement == null) {
            LightVariableBase.$$$reportNull$$$0(5);
        }
        return psiTypeElement;
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.myModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            LightVariableBase.$$$reportNull$$$0(6);
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public String getText() {
        return this.myNameIdentifier.getText();
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public boolean isWritable() {
        return this.myWritable;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(this, PlatformIcons.VARIABLE_ICON, ElementPresentationUtil.getFlags(this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(String originInfo) {
        this.myOriginInfo = originInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/light/LightVariableBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

