/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.openapi.application.ReadAction;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiDirectory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFileSystemItem;
import org.jetbrains.kotlin.com.intellij.psi.PsiInvalidElementAccessException;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiReference;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.StubBasedPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaData;
import org.jetbrains.kotlin.com.intellij.psi.meta.PsiMetaOwner;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.PsiElementProcessor;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.TimeoutUtil;

public class PsiUtilCore {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.util.PsiUtilCore");
    public static final PsiElement NULL_PSI_ELEMENT = new NullPsiElement();
    public static final PsiFile NULL_PSI_FILE = new NullPsiFile();

    @NotNull
    public static PsiElement[] toPsiElementArray(@NotNull Collection<? extends PsiElement> collection) {
        if (collection == null) {
            PsiUtilCore.$$$reportNull$$$0(0);
        }
        PsiElement[] psiElementArray = collection.isEmpty() ? PsiElement.EMPTY_ARRAY : collection.toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            PsiUtilCore.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    public static Language getNotAnyLanguage(ASTNode node) {
        if (node == null) {
            return Language.ANY;
        }
        Language lang = node.getElementType().getLanguage();
        return lang == Language.ANY ? PsiUtilCore.getNotAnyLanguage(node.getTreeParent()) : lang;
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        PsiFile originalFile;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFileSystemItem) {
            return element.isValid() ? ((PsiFileSystemItem)element).getVirtualFile() : null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null || !containingFile.isValid()) {
            return null;
        }
        VirtualFile file2 = containingFile.getVirtualFile();
        if (file2 == null && (originalFile = containingFile.getOriginalFile()) != containingFile && originalFile.isValid()) {
            file2 = originalFile.getVirtualFile();
        }
        return file2;
    }

    public static int compareElementsByPosition(@Nullable PsiElement element1, @Nullable PsiElement element2) {
        if (element1 != null && element2 != null) {
            PsiFile psiFile2;
            if (element1.equals(element2)) {
                return 0;
            }
            PsiFile psiFile1 = element1.getContainingFile();
            if (Comparing.equal(psiFile1, psiFile2 = element2.getContainingFile())) {
                TextRange textRange1 = element1.getTextRange();
                TextRange textRange2 = element2.getTextRange();
                if (textRange1 != null && textRange2 != null) {
                    return textRange1.getStartOffset() - textRange2.getStartOffset();
                }
            } else if (psiFile1 != null && psiFile2 != null) {
                String name1 = psiFile1.getName();
                String name2 = psiFile2.getName();
                return name1.compareToIgnoreCase(name2);
            }
        }
        return 0;
    }

    public static boolean hasErrorElementChild(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilCore.$$$reportNull$$$0(2);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static PsiElement getElementAtOffset(@NotNull PsiFile file2, int offset2) {
        PsiElement elt;
        if (file2 == null) {
            PsiUtilCore.$$$reportNull$$$0(3);
        }
        if ((elt = file2.findElementAt(offset2)) == null && offset2 > 0) {
            elt = file2.findElementAt(offset2 - 1);
        }
        PsiElement psiElement = elt == null ? file2 : elt;
        if (psiElement == null) {
            PsiUtilCore.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public static PsiFile getTemplateLanguageFile(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @NotNull
    public static PsiFile[] toPsiFileArray(@NotNull Collection<? extends PsiFile> collection) {
        if (collection == null) {
            PsiUtilCore.$$$reportNull$$$0(5);
        }
        if (collection.isEmpty()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                PsiUtilCore.$$$reportNull$$$0(6);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFileArray = collection.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            PsiUtilCore.$$$reportNull$$$0(7);
        }
        return psiFileArray;
    }

    @NotNull
    public static <VF extends VirtualFile> List<PsiFile> toPsiFiles(@NotNull PsiManager psiManager, @NotNull Collection<VF> virtualFiles) {
        if (psiManager == null) {
            PsiUtilCore.$$$reportNull$$$0(8);
        }
        if (virtualFiles == null) {
            PsiUtilCore.$$$reportNull$$$0(9);
        }
        List<PsiFile> list2 = virtualFiles.stream().map(psiManager::findFile).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2 == null) {
            PsiUtilCore.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public static String getName(PsiElement element) {
        PsiMetaData data;
        String name = null;
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            name = data.getName(element);
        }
        if (name == null && element instanceof PsiNamedElement) {
            name = ((PsiNamedElement)element).getName();
        }
        return name;
    }

    public static String getQualifiedNameAfterRename(String qName, String newName2) {
        if (qName == null) {
            return newName2;
        }
        int index2 = qName.lastIndexOf(46);
        return index2 < 0 ? newName2 : qName.substring(0, index2 + 1) + newName2;
    }

    public static Language getDialect(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilCore.$$$reportNull$$$0(11);
        }
        return PsiUtilCore.narrowLanguage(element.getLanguage(), element.getContainingFile().getLanguage());
    }

    static Language narrowLanguage(Language language, @NotNull Language candidate2) {
        if (candidate2 == null) {
            PsiUtilCore.$$$reportNull$$$0(12);
        }
        if (candidate2.isKindOf(language)) {
            return candidate2;
        }
        return language;
    }

    public static void ensureValid(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilCore.$$$reportNull$$$0(13);
        }
        if (!element.isValid()) {
            TimeoutUtil.sleep(1L);
            if (element.isValid()) {
                LOG.error("PSI resurrected: " + element + " of " + element.getClass());
                return;
            }
            throw new PsiInvalidElementAccessException(element);
        }
    }

    @Nullable
    public static PsiFileSystemItem findFileSystemItem(@Nullable Project project, @Nullable VirtualFile file2) {
        if (project == null || file2 == null) {
            return null;
        }
        if (project.isDisposed() || !file2.isValid()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance(project);
        return file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
    }

    @NotNull
    public static PsiFile getPsiFile(@NotNull Project project, @NotNull VirtualFile file2) {
        PsiManager psiManager;
        PsiFile psi;
        if (project == null) {
            PsiUtilCore.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            PsiUtilCore.$$$reportNull$$$0(15);
        }
        if ((psi = (psiManager = PsiManager.getInstance(project)).findFile(file2)) != null) {
            PsiFile psiFile = psi;
            if (psiFile == null) {
                PsiUtilCore.$$$reportNull$$$0(16);
            }
            return psiFile;
        }
        FileType fileType = file2.getFileType();
        FileViewProvider viewProvider = psiManager.findViewProvider(file2);
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        boolean ignored = !(file2 instanceof LightVirtualFile) && FileTypeRegistry.getInstance().isFileIgnored(file2);
        VirtualFile vDir = file2.getParent();
        PsiDirectory psiDir = vDir == null ? null : PsiManager.getInstance(project).findDirectory(vDir);
        FileIndexFacade indexFacade = FileIndexFacade.getInstance(project);
        StringBuilder sb = new StringBuilder();
        sb.append("valid=").append(file2.isValid()).append(" isDirectory=").append(file2.isDirectory()).append(" hasDocument=").append(document != null).append(" length=").append(file2.getLength());
        sb.append("\nproject=").append(project.getName()).append(" default=").append(project.isDefault()).append(" open=").append(project.isOpen());
        sb.append("\nfileType=").append(fileType.getName()).append("/").append(fileType.getClass().getName());
        sb.append("\nisIgnored=").append(ignored);
        sb.append(" underIgnored=").append(indexFacade.isUnderIgnored(file2));
        sb.append(" inLibrary=").append(indexFacade.isInLibrarySource(file2) || indexFacade.isInLibraryClasses(file2));
        sb.append(" parentDir=").append(vDir == null ? "no-vfs" : (vDir.isDirectory() ? "has-vfs-dir" : "has-vfs-file")).append("/").append(psiDir == null ? "no-psi" : "has-psi");
        sb.append("\nviewProvider=").append(viewProvider == null ? "null" : viewProvider.getClass().getName());
        if (viewProvider != null) {
            List<PsiFile> files2 = viewProvider.getAllFiles();
            sb.append(" language=").append(viewProvider.getBaseLanguage().getID());
            sb.append(" physical=").append(viewProvider.isPhysical());
            sb.append(" rootCount=").append(files2.size());
            for (PsiFile o : files2) {
                sb.append("\n  root=").append(o.getLanguage().getID()).append("/").append(o.getClass().getName());
            }
        }
        LOG.error("no PSI for file '" + file2.getName() + "'", new Attachment(file2.getPresentableUrl(), sb.toString()));
        throw new AssertionError();
    }

    @Deprecated
    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psiElement, @NotNull Class<? extends T> elementClass) {
        T parent2;
        PsiFile psiFile;
        PsiFile originalFile;
        if (psiElement == null) {
            PsiUtilCore.$$$reportNull$$$0(17);
        }
        if (elementClass == null) {
            PsiUtilCore.$$$reportNull$$$0(18);
        }
        if ((originalFile = (psiFile = psiElement.getContainingFile()).getOriginalFile()) == psiFile) {
            return psiElement;
        }
        TextRange range = psiElement.getTextRange();
        PsiElement element = originalFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        T next = parent2 = PsiTreeUtil.getParentOfType(element, elementClass, false);
        while (next != null && next.getTextLength() <= maxLength) {
            parent2 = next;
            next = PsiTreeUtil.getParentOfType(next, elementClass, true);
        }
        return parent2;
    }

    @NotNull
    public static Language findLanguageFromElement(@NotNull PsiElement elt) {
        PsiElement parent2;
        if (elt == null) {
            PsiUtilCore.$$$reportNull$$$0(19);
        }
        if (!(elt instanceof PsiFile) && elt.getFirstChild() == null && (parent2 = elt.getParent()) != null) {
            Language language = parent2.getLanguage();
            if (language == null) {
                PsiUtilCore.$$$reportNull$$$0(20);
            }
            return language;
        }
        Language language = elt.getLanguage();
        if (language == null) {
            PsiUtilCore.$$$reportNull$$$0(21);
        }
        return language;
    }

    @NotNull
    public static Language getLanguageAtOffset(@NotNull PsiFile file2, int offset2) {
        PsiElement elt;
        if (file2 == null) {
            PsiUtilCore.$$$reportNull$$$0(22);
        }
        if ((elt = file2.findElementAt(offset2)) == null) {
            Language language = file2.getLanguage();
            if (language == null) {
                PsiUtilCore.$$$reportNull$$$0(23);
            }
            return language;
        }
        if (elt instanceof PsiWhiteSpace) {
            int decremented;
            TextRange textRange = elt.getTextRange();
            if (!textRange.contains(offset2)) {
                LOG.error("PSI corrupted: in file " + file2 + " (" + file2.getViewProvider().getVirtualFile() + ") offset=" + offset2 + " returned element " + elt + " with text range " + textRange);
            }
            if ((decremented = textRange.getStartOffset() - 1) >= 0) {
                Language language = PsiUtilCore.getLanguageAtOffset(file2, decremented);
                if (language == null) {
                    PsiUtilCore.$$$reportNull$$$0(24);
                }
                return language;
            }
        }
        Language language = PsiUtilCore.findLanguageFromElement(elt);
        if (language == null) {
            PsiUtilCore.$$$reportNull$$$0(25);
        }
        return language;
    }

    @NotNull
    public static Project getProjectInReadAction(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtilCore.$$$reportNull$$$0(26);
        }
        Project project = ReadAction.compute(() -> element.getProject());
        if (project == null) {
            PsiUtilCore.$$$reportNull$$$0(27);
        }
        return project;
    }

    @Contract(value="null -> null;!null -> !null")
    public static IElementType getElementType(@Nullable ASTNode node) {
        return node == null ? null : node.getElementType();
    }

    @Contract(value="null -> null")
    public static IElementType getElementType(@Nullable PsiElement element) {
        return element == null ? null : (element instanceof StubBasedPsiElement ? ((StubBasedPsiElement)element).getElementType() : (element instanceof PsiFile ? ((PsiFile)element).getFileElementType() : PsiUtilCore.getElementType(element.getNode())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiElementArray";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAtOffset";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiFileArray";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toPsiFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findLanguageFromElement";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageAtOffset";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectInReadAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toPsiElementArray";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasErrorElementChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementAtOffset";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toPsiFileArray";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toPsiFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDialect";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "narrowLanguage";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "ensureValid";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPsiFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findLanguageFromElement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageAtOffset";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getProjectInReadAction";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullPsiFile
    extends NullPsiElement
    implements PsiFile {
        private NullPsiFile() {
        }

        @Override
        public FileASTNode getNode() {
            throw this.createException();
        }

        @Override
        public PsiDirectory getParent() {
            throw this.createException();
        }

        @Override
        public VirtualFile getVirtualFile() {
            throw this.createException();
        }

        @Override
        public PsiDirectory getContainingDirectory() {
            throw this.createException();
        }

        @Override
        public long getModificationStamp() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiFile getOriginalFile() {
            throw this.createException();
        }

        @Override
        @NotNull
        public FileType getFileType() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiFile[] getPsiRoots() {
            throw this.createException();
        }

        @Override
        @NotNull
        public FileViewProvider getViewProvider() {
            throw this.createException();
        }

        @Override
        public void subtreeChanged() {
            throw this.createException();
        }

        @Override
        public boolean isDirectory() {
            throw this.createException();
        }

        @Override
        @NotNull
        public String getName() {
            throw this.createException();
        }

        @Override
        public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
            if (processor2 == null) {
                NullPsiFile.$$$reportNull$$$0(0);
            }
            throw this.createException();
        }

        @Override
        @Nullable
        public ItemPresentation getPresentation() {
            throw this.createException();
        }

        @Override
        public void navigate(boolean requestFocus) {
            throw this.createException();
        }

        @Override
        public boolean canNavigate() {
            throw this.createException();
        }

        @Override
        public boolean canNavigateToSource() {
            throw this.createException();
        }

        @Override
        public void checkSetName(String name) throws IncorrectOperationException {
            throw this.createException();
        }

        @Override
        public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
            if (name == null) {
                NullPsiFile.$$$reportNull$$$0(1);
            }
            throw this.createException();
        }

        @Override
        public String toString() {
            return "NULL_PSI_FILE";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiFile";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static class NullPsiElement
    implements PsiElement {
        protected NullPsiElement() {
        }

        @Override
        @NotNull
        public Project getProject() {
            throw this.createException();
        }

        @Override
        @NotNull
        public Language getLanguage() {
            throw this.createException();
        }

        @Override
        public PsiManager getManager() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiElement[] getChildren() {
            throw this.createException();
        }

        @Override
        public PsiElement getParent() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getFirstChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getLastChild() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getNextSibling() {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiElement getPrevSibling() {
            throw this.createException();
        }

        @Override
        public PsiFile getContainingFile() {
            throw this.createException();
        }

        @Override
        public TextRange getTextRange() {
            throw this.createException();
        }

        @Override
        public int getStartOffsetInParent() {
            throw this.createException();
        }

        @Override
        public int getTextLength() {
            throw this.createException();
        }

        @Override
        public PsiElement findElementAt(int offset2) {
            throw this.createException();
        }

        @Override
        @Nullable
        public PsiReference findReferenceAt(int offset2) {
            throw this.createException();
        }

        @Override
        public int getTextOffset() {
            throw this.createException();
        }

        @Override
        public String getText() {
            throw this.createException();
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            throw this.createException();
        }

        @Override
        public PsiElement getNavigationElement() {
            throw this.createException();
        }

        @Override
        public PsiElement getOriginalElement() {
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull CharSequence text2) {
            if (text2 == null) {
                NullPsiElement.$$$reportNull$$$0(0);
            }
            throw this.createException();
        }

        @Override
        public boolean textMatches(@NotNull PsiElement element) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(1);
            }
            throw this.createException();
        }

        @Override
        public boolean textContains(char c) {
            throw this.createException();
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                NullPsiElement.$$$reportNull$$$0(2);
            }
            throw this.createException();
        }

        @Override
        public void acceptChildren(@NotNull PsiElementVisitor visitor2) {
            if (visitor2 == null) {
                NullPsiElement.$$$reportNull$$$0(3);
            }
            throw this.createException();
        }

        @Override
        public PsiElement copy() {
            throw this.createException();
        }

        @Override
        public PsiElement add(@NotNull PsiElement element) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(4);
            }
            throw this.createException();
        }

        @Override
        public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor2) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(5);
            }
            throw this.createException();
        }

        @Override
        public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor2) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(6);
            }
            throw this.createException();
        }

        @Override
        public void checkAdd(@NotNull PsiElement element) {
            if (element == null) {
                NullPsiElement.$$$reportNull$$$0(7);
            }
            throw this.createException();
        }

        @Override
        public PsiElement addRange(PsiElement first2, PsiElement last2) {
            throw this.createException();
        }

        @Override
        public PsiElement addRangeBefore(@NotNull PsiElement first2, @NotNull PsiElement last2, PsiElement anchor2) {
            if (first2 == null) {
                NullPsiElement.$$$reportNull$$$0(8);
            }
            if (last2 == null) {
                NullPsiElement.$$$reportNull$$$0(9);
            }
            throw this.createException();
        }

        @Override
        public PsiElement addRangeAfter(PsiElement first2, PsiElement last2, PsiElement anchor2) {
            throw this.createException();
        }

        @Override
        public void delete() {
            throw this.createException();
        }

        @Override
        public void checkDelete() {
            throw this.createException();
        }

        @Override
        public void deleteChildRange(PsiElement first2, PsiElement last2) {
            throw this.createException();
        }

        @Override
        public PsiElement replace(@NotNull PsiElement newElement) {
            if (newElement == null) {
                NullPsiElement.$$$reportNull$$$0(10);
            }
            throw this.createException();
        }

        @Override
        public boolean isValid() {
            throw this.createException();
        }

        @Override
        public boolean isWritable() {
            throw this.createException();
        }

        PsiInvalidElementAccessException createException() {
            return new PsiInvalidElementAccessException(this, this.toString(), null);
        }

        @Override
        @Nullable
        public PsiReference getReference() {
            throw this.createException();
        }

        @Override
        @NotNull
        public PsiReference[] getReferences() {
            throw this.createException();
        }

        @Override
        public <T> T getCopyableUserData(Key<T> key) {
            throw this.createException();
        }

        @Override
        public <T> void putCopyableUserData(Key<T> key, T value2) {
            throw this.createException();
        }

        @Override
        public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor2 == null) {
                NullPsiElement.$$$reportNull$$$0(11);
            }
            if (state == null) {
                NullPsiElement.$$$reportNull$$$0(12);
            }
            if (place == null) {
                NullPsiElement.$$$reportNull$$$0(13);
            }
            throw this.createException();
        }

        @Override
        public PsiElement getContext() {
            throw this.createException();
        }

        @Override
        public boolean isPhysical() {
            throw this.createException();
        }

        @Override
        @NotNull
        public GlobalSearchScope getResolveScope() {
            throw this.createException();
        }

        @Override
        @NotNull
        public SearchScope getUseScope() {
            throw this.createException();
        }

        @Override
        public ASTNode getNode() {
            throw this.createException();
        }

        @Override
        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                NullPsiElement.$$$reportNull$$$0(14);
            }
            throw this.createException();
        }

        @Override
        public <T> void putUserData(@NotNull Key<T> key, T value2) {
            if (key == null) {
                NullPsiElement.$$$reportNull$$$0(15);
            }
            throw this.createException();
        }

        @Override
        public Icon getIcon(int flags) {
            throw this.createException();
        }

        @Override
        public boolean isEquivalentTo(PsiElement another) {
            return this == another;
        }

        @Override
        public String toString() {
            return "NULL_PSI_ELEMENT";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElement";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/PsiUtilCore$NullPsiElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "textMatches";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addBefore";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addAfter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkAdd";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRangeBefore";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDeclarations";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUserData";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putUserData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

