/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.Action;
import org.gradle.internal.Actions;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.work.AbstractConditionalExecution;
import org.gradle.internal.work.AsyncWorkCompletion;
import org.gradle.internal.work.AsyncWorkTracker;
import org.gradle.internal.work.ConditionalExecution;
import org.gradle.internal.work.ConditionalExecutionQueue;
import org.gradle.internal.work.NoAvailableWorkerLeaseException;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaForkOptionsFactory;
import org.gradle.process.internal.JavaForkOptionsInternal;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.util.CollectionUtils;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutionException;
import org.gradle.workers.WorkerExecutor;
import org.gradle.workers.WorkerSpec;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.AdapterWorkAction;
import org.gradle.workers.internal.AdapterWorkParameters;
import org.gradle.workers.internal.BuildOperationAwareWorker;
import org.gradle.workers.internal.ClassLoaderStructureProvider;
import org.gradle.workers.internal.DaemonForkOptionsBuilder;
import org.gradle.workers.internal.DefaultClassLoaderWorkerSpec;
import org.gradle.workers.internal.DefaultProcessWorkerSpec;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.DefaultWorkerConfiguration;
import org.gradle.workers.internal.DefaultWorkerSpec;
import org.gradle.workers.internal.FixedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.ForkedWorkerRequirement;
import org.gradle.workers.internal.IsolatedClassLoaderWorkerRequirement;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerExecutionQueueFactory;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerRequirement;

public class DefaultWorkerExecutor
implements WorkerExecutor {
    private final ConditionalExecutionQueue<DefaultWorkResult> executionQueue;
    private final WorkerFactory daemonWorkerFactory;
    private final WorkerFactory isolatedClassloaderWorkerFactory;
    private final WorkerFactory noIsolationWorkerFactory;
    private final JavaForkOptionsFactory forkOptionsFactory;
    private final WorkerLeaseRegistry workerLeaseRegistry;
    private final BuildOperationExecutor buildOperationExecutor;
    private final AsyncWorkTracker asyncWorkTracker;
    private final WorkerDirectoryProvider workerDirectoryProvider;
    private final ClassLoaderStructureProvider classLoaderStructureProvider;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private final Instantiator instantiator;
    private final IsolationScheme<WorkAction, WorkParameters> isolationScheme = new IsolationScheme(WorkAction.class, WorkParameters.class, WorkParameters.None.class);
    private final File baseDir;

    public DefaultWorkerExecutor(WorkerFactory daemonWorkerFactory, WorkerFactory isolatedClassloaderWorkerFactory, WorkerFactory noIsolationWorkerFactory, JavaForkOptionsFactory forkOptionsFactory, WorkerLeaseRegistry workerLeaseRegistry, BuildOperationExecutor buildOperationExecutor, AsyncWorkTracker asyncWorkTracker, WorkerDirectoryProvider workerDirectoryProvider, WorkerExecutionQueueFactory workerExecutionQueueFactory, ClassLoaderStructureProvider classLoaderStructureProvider, ActionExecutionSpecFactory actionExecutionSpecFactory, Instantiator instantiator, File baseDir) {
        this.daemonWorkerFactory = daemonWorkerFactory;
        this.isolatedClassloaderWorkerFactory = isolatedClassloaderWorkerFactory;
        this.noIsolationWorkerFactory = noIsolationWorkerFactory;
        this.forkOptionsFactory = forkOptionsFactory;
        this.executionQueue = workerExecutionQueueFactory.create();
        this.workerLeaseRegistry = workerLeaseRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
        this.asyncWorkTracker = asyncWorkTracker;
        this.workerDirectoryProvider = workerDirectoryProvider;
        this.classLoaderStructureProvider = classLoaderStructureProvider;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
        this.instantiator = instantiator;
        this.baseDir = baseDir;
    }

    @Override
    public WorkQueue noIsolation() {
        return this.noIsolation((Action<? super WorkerSpec>)Actions.doNothing());
    }

    @Override
    public WorkQueue classLoaderIsolation() {
        return this.classLoaderIsolation((Action<? super ClassLoaderWorkerSpec>)Actions.doNothing());
    }

    @Override
    public WorkQueue processIsolation() {
        return this.processIsolation((Action<? super ProcessWorkerSpec>)Actions.doNothing());
    }

    @Override
    public WorkQueue noIsolation(Action<? super WorkerSpec> action) {
        DefaultWorkerSpec spec = (DefaultWorkerSpec)this.instantiator.newInstance(DefaultWorkerSpec.class, new Object[0]);
        action.execute((Object)spec);
        return (WorkQueue)this.instantiator.newInstance(DefaultWorkQueue.class, new Object[]{this, spec, this.noIsolationWorkerFactory});
    }

    @Override
    public WorkQueue classLoaderIsolation(Action<? super ClassLoaderWorkerSpec> action) {
        DefaultClassLoaderWorkerSpec spec = (DefaultClassLoaderWorkerSpec)this.instantiator.newInstance(DefaultClassLoaderWorkerSpec.class, new Object[0]);
        action.execute((Object)spec);
        return (WorkQueue)this.instantiator.newInstance(DefaultWorkQueue.class, new Object[]{this, spec, this.isolatedClassloaderWorkerFactory});
    }

    @Override
    public WorkQueue processIsolation(Action<? super ProcessWorkerSpec> action) {
        DefaultProcessWorkerSpec spec = (DefaultProcessWorkerSpec)this.instantiator.newInstance(DefaultProcessWorkerSpec.class, new Object[]{this.forkOptionsFactory.newDecoratedJavaForkOptions()});
        File defaultWorkingDir = spec.getForkOptions().getWorkingDir();
        File workingDirectory = this.workerDirectoryProvider.getWorkingDirectory();
        action.execute((Object)spec);
        if (!defaultWorkingDir.equals(spec.getForkOptions().getWorkingDir())) {
            throw new IllegalArgumentException("Setting the working directory of a worker is not supported.");
        }
        spec.getForkOptions().setWorkingDir(workingDirectory);
        return (WorkQueue)this.instantiator.newInstance(DefaultWorkQueue.class, new Object[]{this, spec, this.daemonWorkerFactory});
    }

    @Override
    public void submit(Class<? extends Runnable> actionClass, Action<? super WorkerConfiguration> configAction) {
        WorkQueue workQueue;
        DefaultWorkerConfiguration configuration = new DefaultWorkerConfiguration(this.forkOptionsFactory);
        configAction.execute((Object)configuration);
        Action parametersAction = parameters -> {
            parameters.setImplementationClassName(actionClass.getName());
            parameters.setParams(configuration.getParams());
            parameters.setDisplayName(configuration.getDisplayName());
        };
        switch (configuration.getIsolationMode()) {
            case NONE: 
            case AUTO: {
                workQueue = this.noIsolation(this.getWorkerSpecAdapterAction(configuration));
                break;
            }
            case CLASSLOADER: {
                workQueue = this.classLoaderIsolation(this.getWorkerSpecAdapterAction(configuration));
                break;
            }
            case PROCESS: {
                workQueue = this.processIsolation(this.getWorkerSpecAdapterAction(configuration));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown isolation mode: " + (Object)((Object)configuration.getIsolationMode()));
            }
        }
        workQueue.submit(AdapterWorkAction.class, parametersAction);
    }

    <T extends WorkerSpec> Action<T> getWorkerSpecAdapterAction(DefaultWorkerConfiguration configuration) {
        return spec -> configuration.adaptTo((WorkerSpec)spec);
    }

    private <T extends WorkParameters> AsyncWorkCompletion submitWork(Class<? extends WorkAction<T>> workActionClass, Action<? super T> parameterAction, WorkerSpec workerSpec, WorkerFactory workerFactory) {
        IsolatedParametersActionExecutionSpec<WorkParameters> spec;
        WorkParameters parameters;
        Class parameterType = this.isolationScheme.parameterTypeFor(workActionClass);
        WorkParameters workParameters = parameters = parameterType == null ? null : (WorkParameters)this.instantiator.newInstance(parameterType, new Object[0]);
        if (parameters != null) {
            parameterAction.execute((Object)parameters);
        }
        String description = DefaultWorkerExecutor.getWorkerDisplayName(workActionClass, parameters);
        WorkerRequirement workerRequirement = this.getWorkerRequirement(workActionClass, workerSpec, parameters);
        try {
            spec = this.actionExecutionSpecFactory.newIsolatedSpec(description, workActionClass, parameters, workerRequirement, false);
        }
        catch (Throwable t) {
            throw new WorkExecutionException(description, t);
        }
        return this.submitWork(spec, workerFactory, workerRequirement);
    }

    private AsyncWorkCompletion submitWork(IsolatedParametersActionExecutionSpec<?> spec, WorkerFactory workerFactory, WorkerRequirement workerRequirement) {
        WorkerLeaseRegistry.WorkerLease currentWorkerWorkerLease = this.getCurrentWorkerLease();
        BuildOperationRef currentBuildOperation = this.buildOperationExecutor.getCurrentOperation();
        WorkItemExecution execution = new WorkItemExecution(spec.getDisplayName(), currentWorkerWorkerLease, () -> {
            try {
                BuildOperationAwareWorker worker = workerFactory.getWorker(workerRequirement);
                return worker.execute(spec, currentBuildOperation);
            }
            catch (Throwable t) {
                throw new WorkExecutionException(spec.getDisplayName(), t);
            }
        });
        this.executionQueue.submit((ConditionalExecution)execution);
        this.asyncWorkTracker.registerWork(currentBuildOperation, (AsyncWorkCompletion)execution);
        return execution;
    }

    private static String getWorkerDisplayName(Class<?> workActionClass, WorkParameters parameters) {
        if (workActionClass == AdapterWorkAction.class) {
            AdapterWorkParameters adapterWorkParameters = (AdapterWorkParameters)parameters;
            if (adapterWorkParameters.getDisplayName() != null) {
                return adapterWorkParameters.getDisplayName();
            }
            return adapterWorkParameters.getImplementationClassName();
        }
        return workActionClass.getName();
    }

    private WorkerLeaseRegistry.WorkerLease getCurrentWorkerLease() {
        try {
            return this.workerLeaseRegistry.getCurrentWorkerLease();
        }
        catch (NoAvailableWorkerLeaseException e) {
            throw new IllegalStateException("An attempt was made to submit work from a thread not managed by Gradle.  Work may only be submitted from a Gradle-managed thread.", e);
        }
    }

    @Override
    public void await() throws WorkerExecutionException {
        BuildOperationRef currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            if (this.asyncWorkTracker.hasUncompletedWork(currentOperation)) {
                this.executionQueue.expand();
            }
            this.asyncWorkTracker.waitForCompletion(currentOperation, AsyncWorkTracker.ProjectLockRetention.RETAIN_PROJECT_LOCKS);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private void await(List<AsyncWorkCompletion> workItems) throws WorkExecutionException {
        BuildOperationRef currentOperation = this.buildOperationExecutor.getCurrentOperation();
        try {
            if (CollectionUtils.any(workItems, workItem -> !workItem.isComplete())) {
                this.executionQueue.expand();
            }
            this.asyncWorkTracker.waitForCompletion(currentOperation, workItems, AsyncWorkTracker.ProjectLockRetention.RETAIN_PROJECT_LOCKS);
        }
        catch (DefaultMultiCauseException e) {
            throw this.workerExecutionException(e.getCauses());
        }
    }

    private WorkerExecutionException workerExecutionException(List<? extends Throwable> failures) {
        if (failures.size() == 1) {
            throw new WorkerExecutionException("There was a failure while executing work items", failures);
        }
        throw new WorkerExecutionException("There were multiple failures while executing work items", failures);
    }

    WorkerRequirement getWorkerRequirement(Class<?> executionClass, WorkerSpec configuration, WorkParameters parameters) {
        if (configuration instanceof ProcessWorkerSpec) {
            DaemonForkOptionsBuilder builder = new DaemonForkOptionsBuilder(this.forkOptionsFactory).keepAliveMode(KeepAliveMode.DAEMON);
            ProcessWorkerSpec processConfiguration = (ProcessWorkerSpec)configuration;
            JavaForkOptionsInternal forkOptions = this.forkOptionsFactory.newJavaForkOptions();
            processConfiguration.getForkOptions().copyTo((JavaForkOptions)forkOptions);
            forkOptions.setWorkingDir(this.workerDirectoryProvider.getWorkingDirectory());
            builder.javaForkOptions((JavaForkOptions)forkOptions).withClassLoaderStructure(this.classLoaderStructureProvider.getWorkerProcessClassLoaderStructure((Iterable<File>)processConfiguration.getClasspath(), this.getParamClasses(executionClass, parameters)));
            return new ForkedWorkerRequirement(this.baseDir, builder.build());
        }
        if (configuration instanceof ClassLoaderWorkerSpec) {
            ClassLoaderWorkerSpec classLoaderConfiguration = (ClassLoaderWorkerSpec)configuration;
            return new IsolatedClassLoaderWorkerRequirement(this.baseDir, this.classLoaderStructureProvider.getInProcessClassLoaderStructure((Iterable<File>)classLoaderConfiguration.getClasspath(), this.getParamClasses(executionClass, parameters)));
        }
        return new FixedClassLoaderWorkerRequirement(this.baseDir, Thread.currentThread().getContextClassLoader());
    }

    private Class<?>[] getParamClasses(Class<?> actionClass, WorkParameters parameters) {
        Object[] params;
        Class implementationClass;
        if (parameters instanceof AdapterWorkParameters) {
            AdapterWorkParameters adapterWorkParameters = (AdapterWorkParameters)parameters;
            implementationClass = ClassLoaderUtils.classFromContextLoader((String)adapterWorkParameters.getImplementationClassName());
            params = adapterWorkParameters.getParams();
        } else {
            implementationClass = actionClass;
            params = new Object[]{parameters};
        }
        ArrayList classes = Lists.newArrayList();
        classes.add(implementationClass);
        for (Object param : params) {
            if (param == null) continue;
            classes.add(param.getClass());
        }
        return classes.toArray(new Class[0]);
    }

    @NotThreadSafe
    static class DefaultWorkQueue
    implements WorkQueue {
        private final DefaultWorkerExecutor workerExecutor;
        private final WorkerSpec spec;
        private final WorkerFactory workerFactory;
        private final List<AsyncWorkCompletion> workItems = Lists.newArrayList();

        public DefaultWorkQueue(DefaultWorkerExecutor workerExecutor, WorkerSpec spec, WorkerFactory workerFactory) {
            this.workerExecutor = workerExecutor;
            this.spec = spec;
            this.workerFactory = workerFactory;
        }

        @Override
        public <T extends WorkParameters> void submit(Class<? extends WorkAction<T>> workActionClass, Action<? super T> parameterAction) {
            this.workItems.add(this.workerExecutor.submitWork(workActionClass, parameterAction, this.spec, this.workerFactory));
        }

        @Override
        public void await() throws WorkerExecutionException {
            this.workerExecutor.await(this.workItems);
        }
    }

    private static class LazyChildWorkerLeaseLock
    implements ResourceLock {
        private final WorkerLeaseRegistry.WorkerLease parentWorkerLease;
        private WorkerLeaseRegistry.WorkerLease child;

        public LazyChildWorkerLeaseLock(WorkerLeaseRegistry.WorkerLease parentWorkerLease) {
            this.parentWorkerLease = parentWorkerLease;
        }

        public boolean isLocked() {
            return this.getChild().isLocked();
        }

        public boolean isLockedByCurrentThread() {
            return this.getChild().isLockedByCurrentThread();
        }

        public boolean tryLock() {
            this.child = this.parentWorkerLease.createChild();
            if (this.child.tryLock()) {
                return true;
            }
            this.child = null;
            return false;
        }

        public void unlock() {
            this.getChild().unlock();
        }

        public String getDisplayName() {
            return this.getChild().getDisplayName();
        }

        private WorkerLeaseRegistry.WorkerLease getChild() {
            if (this.child == null) {
                throw new IllegalStateException("Detected attempt to access LazyChildWorkerLeaseLock before tryLock() has succeeded.  tryLock must be succeed before other methods are called.");
            }
            return this.child;
        }
    }

    private static class WorkItemExecution
    extends AbstractConditionalExecution<DefaultWorkResult>
    implements AsyncWorkCompletion {
        private final String description;

        public WorkItemExecution(String description, WorkerLeaseRegistry.WorkerLease parentWorkerLease, Callable<DefaultWorkResult> callable) {
            super(callable, (ResourceLock)new LazyChildWorkerLeaseLock(parentWorkerLease));
            this.description = description;
        }

        public void waitForCompletion() {
            DefaultWorkResult result = (DefaultWorkResult)this.await();
            if (!result.isSuccess()) {
                throw new WorkExecutionException(this.description, result.getException());
            }
        }
    }

    @Contextual
    private static class WorkExecutionException
    extends RuntimeException {
        WorkExecutionException(String description, Throwable cause) {
            super(WorkExecutionException.toMessage(description), cause);
        }

        private static String toMessage(String description) {
            return "A failure occurred while executing " + description;
        }
    }
}

