/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.provider.OwnerAware;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.DisplayName;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.service.ServiceLookup;

public class ManagedObjectFactory {
    private final ServiceLookup serviceLookup;
    private final InstanceGenerator instantiator;

    public ManagedObjectFactory(ServiceLookup serviceLookup, InstanceGenerator instantiator) {
        this.serviceLookup = serviceLookup;
        this.instantiator = instantiator;
    }

    public static <T> T attachOwner(GeneratedSubclass owner, @Nullable Describable ownerDisplayName, String propertyName, T instance) {
        if (instance instanceof OwnerAware) {
            ManagedPropertyName property = ManagedObjectFactory.displayNameFor(owner, ownerDisplayName, propertyName);
            ((OwnerAware)instance).attachDisplayName(property);
        }
        return instance;
    }

    public Object newInstance(GeneratedSubclass owner, @Nullable Describable ownerDisplayName, String propertyName, Class<?> type) {
        if (type.isAssignableFrom(ConfigurableFileCollection.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().fileCollection());
        }
        if (type.isAssignableFrom(ConfigurableFileTree.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().fileTree());
        }
        if (type.isAssignableFrom(DirectoryProperty.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().directoryProperty());
        }
        if (type.isAssignableFrom(RegularFileProperty.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().fileProperty());
        }
        return this.instantiator.newInstanceWithDisplayName(type, (Describable)ManagedObjectFactory.displayNameFor(owner, ownerDisplayName, propertyName), new Object[0]);
    }

    public Object newInstance(GeneratedSubclass owner, @Nullable Describable ownerDisplayName, String propertyName, Class<?> type, Class<?> paramType) {
        if (type.isAssignableFrom(Property.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().property(paramType));
        }
        if (type.isAssignableFrom(ListProperty.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().listProperty(paramType));
        }
        if (type.isAssignableFrom(SetProperty.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().setProperty(paramType));
        }
        if (type.isAssignableFrom(NamedDomainObjectContainer.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().domainObjectContainer(paramType));
        }
        if (type.isAssignableFrom(DomainObjectSet.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().domainObjectSet(paramType));
        }
        throw new IllegalArgumentException("Don't know how to create an instance of type " + type.getName());
    }

    public Object newInstance(GeneratedSubclass owner, @Nullable Describable ownerDisplayName, String propertyName, Class<?> type, Class<?> keyType, Class<?> valueType) {
        if (type.isAssignableFrom(MapProperty.class)) {
            return ManagedObjectFactory.attachOwner(owner, ownerDisplayName, propertyName, this.getObjectFactory().mapProperty(keyType, valueType));
        }
        throw new IllegalArgumentException("Don't know how to create an instance of type " + type.getName());
    }

    private static ManagedPropertyName displayNameFor(GeneratedSubclass owner, @Nullable Describable ownerDisplayName, String propertyName) {
        if (ownerDisplayName instanceof ManagedPropertyName) {
            ManagedPropertyName root = (ManagedPropertyName)ownerDisplayName;
            return new ManagedPropertyName(root.owner, root.propertyName + "." + propertyName);
        }
        return new ManagedPropertyName(owner, propertyName);
    }

    private ObjectFactory getObjectFactory() {
        return (ObjectFactory)this.serviceLookup.get(ObjectFactory.class);
    }

    private static class ManagedPropertyName
    implements DisplayName {
        private final GeneratedSubclass owner;
        private final String propertyName;

        public ManagedPropertyName(GeneratedSubclass owner, String propertyName) {
            this.owner = owner;
            this.propertyName = propertyName;
        }

        public String toString() {
            return this.getDisplayName();
        }

        public String getCapitalizedDisplayName() {
            return StringUtils.capitalize((String)this.getDisplayName());
        }

        public String getDisplayName() {
            if (this.owner.hasUsefulDisplayName()) {
                return this.owner + " property '" + this.propertyName + "'";
            }
            return "property '" + this.propertyName + "'";
        }
    }
}

