/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.caching;

import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.internal.resolve.caching.CrossBuildCachingRuleExecutor;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.util.BuildCommencedTimeProvider;

public class ComponentMetadataSupplierRuleExecutor
extends CrossBuildCachingRuleExecutor<ModuleVersionIdentifier, ComponentMetadataSupplierDetails, ComponentMetadata> {
    private static final Transformer<String, ModuleVersionIdentifier> KEY_TO_SNAPSHOTTABLE = Object::toString;

    public ComponentMetadataSupplierRuleExecutor(CacheRepository cacheRepository, InMemoryCacheDecoratorFactory cacheDecoratorFactory, ValueSnapshotter snapshotter, BuildCommencedTimeProvider timeProvider, Serializer<ComponentMetadata> componentMetadataSerializer) {
        super("md-supplier", cacheRepository, cacheDecoratorFactory, snapshotter, timeProvider, ComponentMetadataSupplierRuleExecutor.createValidator(timeProvider), KEY_TO_SNAPSHOTTABLE, componentMetadataSerializer);
    }

    public static CrossBuildCachingRuleExecutor.EntryValidator<ComponentMetadata> createValidator(BuildCommencedTimeProvider timeProvider) {
        return (policy, entry) -> {
            long age = timeProvider.getCurrentTime() - entry.getTimestamp();
            ComponentMetadata result = (ComponentMetadata)entry.getResult();
            boolean mustRefreshModule = policy.mustRefreshModule(new SimpleResolvedModuleVersion(result), age, result.isChanging());
            return !mustRefreshModule;
        };
    }

    private static class SimpleResolvedModuleVersion
    implements ResolvedModuleVersion {
        private final ComponentMetadata result;

        public SimpleResolvedModuleVersion(ComponentMetadata result) {
            this.result = result;
        }

        public ModuleVersionIdentifier getId() {
            return this.result.getId();
        }
    }
}

