/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs.watch.impl;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.internal.vfs.SnapshotHierarchy;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.gradle.internal.vfs.watch.FileWatcherRegistryFactory;
import org.gradle.internal.vfs.watch.WatchRootUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkFileWatcherRegistry
implements FileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkFileWatcherRegistry.class);
    private final WatchService watchService;

    public JdkFileWatcherRegistry(WatchService watchService, Iterable<Path> watchRoots) throws IOException {
        this.watchService = watchService;
        for (Path watchRoot : watchRoots) {
            LOGGER.debug("Started watching {}", (Object)watchRoot);
            watchRoot.register(watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW}, SensitivityWatchEventModifier.HIGH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopWatching(FileWatcherRegistry.ChangeHandler handler) throws IOException {
        try {
            boolean overflow = false;
            block3: while (!overflow) {
                WatchKey watchKey = this.watchService.poll();
                if (watchKey == null) {
                    break;
                }
                watchKey.cancel();
                Path watchRoot = (Path)watchKey.watchable();
                LOGGER.debug("Stopped watching {}", (Object)watchRoot);
                for (WatchEvent<?> event : watchKey.pollEvents()) {
                    FileWatcherRegistry.Type type;
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        LOGGER.warn("Too many modifications for path {} since last build, dropping all VFS state", (Object)watchRoot);
                        handler.handleLostState();
                        overflow = true;
                        continue block3;
                    }
                    Path changedPath = watchRoot.resolve((Path)event.context());
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        type = FileWatcherRegistry.Type.CREATED;
                    } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        type = FileWatcherRegistry.Type.MODIFIED;
                    } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                        type = FileWatcherRegistry.Type.REMOVED;
                    } else {
                        throw new AssertionError();
                    }
                    handler.handleChange(type, changedPath);
                }
            }
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.watchService.close();
    }

    public static class Factory
    implements FileWatcherRegistryFactory {
        @Override
        public FileWatcherRegistry startWatching(SnapshotHierarchy root, Predicate<String> watchFilter, Collection<File> mustWatchDirectories) throws IOException {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            Set<Path> directories = WatchRootUtil.resolveDirectoriesToWatch(root, watchFilter, mustWatchDirectories).stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toSet());
            LOGGER.warn("Watching {} directories to track changes between builds", (Object)directories.size());
            return new JdkFileWatcherRegistry(watchService, directories);
        }
    }
}

