/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.execution;

import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;

public class ParametersListUtil {
    public static final Function<String, List<String>> DEFAULT_LINE_PARSER = text2 -> ParametersListUtil.parse(text2, true);
    public static final Function<List<String>, String> DEFAULT_LINE_JOINER = strings2 -> StringUtil.join(strings2, " ");
    public static final Function<String, List<String>> COLON_LINE_PARSER = text2 -> {
        ArrayList<String> result2 = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer((String)text2, ";", false);
        while (tokenizer.hasMoreTokens()) {
            result2.add(tokenizer.nextToken());
        }
        return result2;
    };
    public static final Function<List<String>, String> COLON_LINE_JOINER = strings2 -> StringUtil.join(strings2, ";");

    @NotNull
    public static List<String> parse(@NotNull String parameterString) {
        if (parameterString == null) {
            ParametersListUtil.$$$reportNull$$$0(5);
        }
        List<String> list2 = ParametersListUtil.parse(parameterString, false);
        if (list2 == null) {
            ParametersListUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes) {
        if (parameterString == null) {
            ParametersListUtil.$$$reportNull$$$0(7);
        }
        List<String> list2 = ParametersListUtil.parse(parameterString, keepQuotes, false);
        if (list2 == null) {
            ParametersListUtil.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @NotNull
    public static List<String> parse(@NotNull String parameterString, boolean keepQuotes, boolean supportSingleQuotes) {
        if (parameterString == null) {
            ParametersListUtil.$$$reportNull$$$0(9);
        }
        parameterString = parameterString.trim();
        ArrayList<String> params = new ArrayList<String>();
        if (parameterString.isEmpty()) {
            ArrayList<String> arrayList = params;
            if (arrayList == null) {
                ParametersListUtil.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        TIntHashSet possibleQuoteChars = new TIntHashSet();
        possibleQuoteChars.add(34);
        if (supportSingleQuotes) {
            possibleQuoteChars.add(39);
        }
        char currentQuote = '\u0000';
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (inQuotes ? currentQuote == ch : possibleQuoteChars.contains((int)ch)) {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    currentQuote = ch;
                    nonEmpty = true;
                    if (!keepQuotes) continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1) {
                char nextchar = parameterString.charAt(i + 1);
                if (inQuotes ? currentQuote == nextchar : possibleQuoteChars.contains((int)nextchar)) {
                    escapedQuote = true;
                    if (!keepQuotes) continue;
                }
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        ArrayList<String> arrayList = params;
        if (arrayList == null) {
            ParametersListUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/execution/ParametersListUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterString";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/execution/ParametersListUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToArray";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "encode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseToArray";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "encode";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "encodeParam";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

