/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.verification.model.ArtifactVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.Checksum;
import org.gradle.api.internal.artifacts.verification.model.ComponentVerificationMetadata;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerificationConfiguration;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerifier;
import org.gradle.internal.xml.SimpleMarkupWriter;
import org.gradle.internal.xml.SimpleXmlWriter;

public class DependencyVerificationsXmlWriter {
    private static final String SPACES = "   ";
    private final SimpleXmlWriter writer;

    private DependencyVerificationsXmlWriter(OutputStream out) throws IOException {
        this.writer = new SimpleXmlWriter(out, SPACES);
    }

    public static void serialize(DependencyVerifier verifier, OutputStream out) throws IOException {
        try {
            DependencyVerificationsXmlWriter writer = new DependencyVerificationsXmlWriter(out);
            writer.write(verifier);
        }
        finally {
            out.close();
        }
    }

    private void write(DependencyVerifier verifier) throws IOException {
        this.writer.startElement("verification-metadata");
        this.writeAttribute("xmlns", "https://schema.gradle.org/dependency-verification");
        this.writeAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.writeAttribute("xsi:schemaLocation", "https://schema.gradle.org/dependency-verification https://schema.gradle.org/dependency-verification/dependency-verification-1.0.xsd");
        this.writeConfiguration(verifier.getConfiguration());
        this.writeVerifications(verifier.getVerificationMetadata());
        this.writer.endElement();
        this.writer.close();
    }

    private void writeConfiguration(DependencyVerificationConfiguration configuration) throws IOException {
        this.writer.startElement("configuration");
        this.writeVerifyMetadata(configuration);
        this.writeSignatureCheck(configuration);
        this.writeKeyServers(configuration);
        this.writeTrustedArtifacts(configuration);
        this.writIgnoredKeys(configuration);
        this.writeGloballyTrustedKeys(configuration);
        this.writer.endElement();
    }

    private void writeGloballyTrustedKeys(DependencyVerificationConfiguration configuration) throws IOException {
        List<DependencyVerificationConfiguration.TrustedKey> keys = configuration.getTrustedKeys();
        if (keys.isEmpty()) {
            return;
        }
        this.writer.startElement("trusted-keys");
        Map groupedByKeyId = keys.stream().collect(Collectors.groupingBy(DependencyVerificationConfiguration.TrustedKey::getKeyId, TreeMap::new, Collectors.toList()));
        for (Map.Entry e : groupedByKeyId.entrySet()) {
            String key = (String)e.getKey();
            List trustedKeys = (List)e.getValue();
            if (trustedKeys.size() == 1) {
                this.writeTrustedKey((DependencyVerificationConfiguration.TrustedKey)trustedKeys.get(0));
                continue;
            }
            this.writeGroupedTrustedKey(key, trustedKeys);
        }
        this.writer.endElement();
    }

    private void writeGroupedTrustedKey(String keyId, List<DependencyVerificationConfiguration.TrustedKey> trustedKeys) throws IOException {
        this.writer.startElement("trusted-key");
        this.writeAttribute("id", keyId);
        for (DependencyVerificationConfiguration.TrustedKey trustedKey : trustedKeys) {
            this.writer.startElement("trusting");
            this.writeTrustCoordinates(trustedKey);
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    private void writeTrustedKey(DependencyVerificationConfiguration.TrustedKey key) throws IOException {
        this.writer.startElement("trusted-key");
        this.writeAttribute("id", key.getKeyId());
        this.writeTrustCoordinates(key);
        this.writer.endElement();
    }

    private void writIgnoredKeys(DependencyVerificationConfiguration configuration) throws IOException {
        Set<IgnoredKey> ignoredKeys = configuration.getIgnoredKeys();
        if (!ignoredKeys.isEmpty()) {
            this.writer.startElement("ignored-keys");
            for (IgnoredKey ignoredKey : ignoredKeys) {
                this.writeIgnoredKey(ignoredKey);
            }
            this.writer.endElement();
        }
    }

    private void writeIgnoredKey(IgnoredKey ignoredKey) throws IOException {
        this.writer.startElement("ignored-key");
        this.writeAttribute("id", ignoredKey.getKeyId());
        this.writeNullableAttribute("reason", ignoredKey.getReason());
        this.writer.endElement();
    }

    private void writeTrustedArtifacts(DependencyVerificationConfiguration configuration) throws IOException {
        List<DependencyVerificationConfiguration.TrustedArtifact> trustedArtifacts = configuration.getTrustedArtifacts();
        if (trustedArtifacts.isEmpty()) {
            return;
        }
        this.writer.startElement("trusted-artifacts");
        for (DependencyVerificationConfiguration.TrustedArtifact trustedArtifact : trustedArtifacts) {
            this.writeTrustedArtifact(trustedArtifact);
        }
        this.writer.endElement();
    }

    private void writeTrustedArtifact(DependencyVerificationConfiguration.TrustedArtifact trustedArtifact) throws IOException {
        this.writer.startElement("trust");
        this.writeTrustCoordinates(trustedArtifact);
        this.writer.endElement();
    }

    private void writeTrustCoordinates(DependencyVerificationConfiguration.TrustCoordinates trustedArtifact) throws IOException {
        this.writeNullableAttribute("group", trustedArtifact.getGroup());
        this.writeNullableAttribute("name", trustedArtifact.getName());
        this.writeNullableAttribute("version", trustedArtifact.getVersion());
        this.writeNullableAttribute("file", trustedArtifact.getFileName());
        if (trustedArtifact.isRegex()) {
            this.writeAttribute("regex", "true");
        }
    }

    private void writeSignatureCheck(DependencyVerificationConfiguration configuration) throws IOException {
        this.writer.startElement("verify-signatures");
        this.writer.write(String.valueOf(configuration.isVerifySignatures()));
        this.writer.endElement();
    }

    private void writeVerifyMetadata(DependencyVerificationConfiguration configuration) throws IOException {
        this.writer.startElement("verify-metadata");
        this.writer.write(String.valueOf(configuration.isVerifyMetadata()));
        this.writer.endElement();
    }

    private void writeKeyServers(DependencyVerificationConfiguration configuration) throws IOException {
        List<URI> keyServers = configuration.getKeyServers();
        if (!keyServers.isEmpty()) {
            this.writer.startElement("key-servers");
            for (URI keyServer : keyServers) {
                this.writer.startElement("key-server");
                this.writeAttribute("uri", keyServer.toASCIIString());
                this.writer.endElement();
            }
            this.writer.endElement();
        }
    }

    private SimpleMarkupWriter writeAttribute(String name, String value) throws IOException {
        return this.writer.attribute(name, value);
    }

    private SimpleMarkupWriter writeNullableAttribute(String name, @Nullable String value) throws IOException {
        if (value == null) {
            return this.writer;
        }
        return this.writeAttribute(name, value);
    }

    private void writeVerifications(Collection<ComponentVerificationMetadata> verifications) throws IOException {
        this.writer.startElement("components");
        for (ComponentVerificationMetadata verification : verifications) {
            this.writeVerification(verification);
        }
        this.writer.endElement();
    }

    private void writeVerification(ComponentVerificationMetadata verification) throws IOException {
        ModuleComponentIdentifier mci = verification.getComponentId();
        this.writer.startElement("component");
        this.writeAttribute("group", mci.getGroup());
        this.writeAttribute("name", mci.getModule());
        this.writeAttribute("version", mci.getVersion());
        this.writeArtifactVerifications(verification.getArtifactVerifications());
        this.writer.endElement();
    }

    private void writeArtifactVerifications(List<ArtifactVerificationMetadata> verifications) throws IOException {
        for (ArtifactVerificationMetadata verification : verifications) {
            this.writeArtifactVerification(verification);
        }
    }

    private void writeArtifactVerification(ArtifactVerificationMetadata verification) throws IOException {
        String artifact = verification.getArtifactName();
        this.writer.startElement("artifact");
        this.writeAttribute("name", artifact);
        this.writeTrustedKeys(verification.getTrustedPgpKeys());
        this.writeIgnoredKeys(verification.getIgnoredPgpKeys());
        this.writeChecksums(verification.getChecksums());
        this.writer.endElement();
    }

    private void writeIgnoredKeys(Set<IgnoredKey> ignoredPgpKeys) throws IOException {
        if (ignoredPgpKeys.isEmpty()) {
            return;
        }
        this.writer.startElement("ignored-keys");
        for (IgnoredKey ignoredPgpKey : ignoredPgpKeys) {
            this.writeIgnoredKey(ignoredPgpKey);
        }
        this.writer.endElement();
    }

    private void writeTrustedKeys(Set<String> trustedPgpKeys) throws IOException {
        for (String key : trustedPgpKeys) {
            this.writer.startElement("pgp");
            this.writeAttribute("value", key);
            this.writer.endElement();
        }
    }

    private void writeChecksums(List<Checksum> checksums) throws IOException {
        for (Checksum checksum : checksums) {
            Set<String> alternatives;
            String kind = checksum.getKind().name();
            String value = checksum.getValue();
            this.writer.startElement(kind);
            this.writeAttribute("value", value);
            String origin = checksum.getOrigin();
            if (origin != null) {
                this.writeAttribute("origin", origin);
            }
            if ((alternatives = checksum.getAlternatives()) != null) {
                for (String alternative : alternatives) {
                    this.writer.startElement("also-trust");
                    this.writeAttribute("value", alternative);
                    this.writer.endElement();
                }
            }
            this.writer.endElement();
        }
    }
}

