/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.vfs;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.rubygrapefruit.platform.file.FileWatcher;
import net.rubygrapefruit.platform.file.FileWatcherCallback;
import org.gradle.internal.vfs.watch.FileWatcherRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventDrivenFileWatcherRegistry
implements FileWatcherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventDrivenFileWatcherRegistry.class);
    private final FileWatcher watcher;
    private final AtomicReference<MutableFileWatchingStatistics> fileWatchingStatistics = new AtomicReference<MutableFileWatchingStatistics>(new MutableFileWatchingStatistics());

    public AbstractEventDrivenFileWatcherRegistry(FileWatcherCreator watcherCreator, FileWatcherRegistry.ChangeHandler handler) {
        this.watcher = this.createWatcher(watcherCreator, handler);
    }

    public FileWatcher getWatcher() {
        return this.watcher;
    }

    private FileWatcher createWatcher(FileWatcherCreator watcherCreator, final FileWatcherRegistry.ChangeHandler handler) {
        return watcherCreator.createWatcher(new FileWatcherCallback(){

            public void pathChanged(FileWatcherCallback.Type type, String path) {
                AbstractEventDrivenFileWatcherRegistry.this.handleEvent(type, path, handler);
            }

            public void reportError(Throwable ex) {
                LOGGER.error("Error while receiving file changes", ex);
                AbstractEventDrivenFileWatcherRegistry.this.fileWatchingStatistics.updateAndGet(statistics -> statistics.errorWhileReceivingFileChanges(ex));
                handler.handleLostState();
            }
        });
    }

    private void handleEvent(FileWatcherCallback.Type type, String path, FileWatcherRegistry.ChangeHandler handler) {
        if (type == FileWatcherCallback.Type.UNKNOWN) {
            this.fileWatchingStatistics.updateAndGet(MutableFileWatchingStatistics::unknownEventEncountered);
            handler.handleLostState();
        } else {
            this.fileWatchingStatistics.updateAndGet(MutableFileWatchingStatistics::eventReceived);
            handler.handleChange(AbstractEventDrivenFileWatcherRegistry.convertType(type), Paths.get(path, new String[0]));
        }
    }

    private static FileWatcherRegistry.Type convertType(FileWatcherCallback.Type type) {
        switch (type) {
            case CREATED: {
                return FileWatcherRegistry.Type.CREATED;
            }
            case MODIFIED: {
                return FileWatcherRegistry.Type.MODIFIED;
            }
            case REMOVED: {
                return FileWatcherRegistry.Type.REMOVED;
            }
            case INVALIDATE: {
                return FileWatcherRegistry.Type.INVALIDATE;
            }
        }
        throw new AssertionError();
    }

    public FileWatcherRegistry.FileWatchingStatistics getAndResetStatistics() {
        return this.fileWatchingStatistics.getAndSet(new MutableFileWatchingStatistics());
    }

    public void close() throws IOException {
        this.watcher.close();
    }

    private static class MutableFileWatchingStatistics
    implements FileWatcherRegistry.FileWatchingStatistics {
        private boolean unknownEventEncountered;
        private int numberOfReceivedEvents;
        private Throwable errorWhileReceivingFileChanges;

        private MutableFileWatchingStatistics() {
        }

        public Optional<Throwable> getErrorWhileReceivingFileChanges() {
            return Optional.ofNullable(this.errorWhileReceivingFileChanges);
        }

        public boolean isUnknownEventEncountered() {
            return this.unknownEventEncountered;
        }

        public int getNumberOfReceivedEvents() {
            return this.numberOfReceivedEvents;
        }

        public MutableFileWatchingStatistics eventReceived() {
            ++this.numberOfReceivedEvents;
            return this;
        }

        public MutableFileWatchingStatistics errorWhileReceivingFileChanges(Throwable error) {
            if (this.errorWhileReceivingFileChanges != null) {
                this.errorWhileReceivingFileChanges = error;
            }
            return this;
        }

        public MutableFileWatchingStatistics unknownEventEncountered() {
            this.unknownEventEncountered = true;
            return this;
        }
    }

    protected static interface FileWatcherCreator {
        public FileWatcher createWatcher(FileWatcherCallback var1);
    }
}

