/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.Actions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.GccCompatibleToolChain;
import org.gradle.nativeplatform.toolchain.GccPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.ExtendableToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeLanguage;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.SymbolExtractorOsConfig;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.UnavailablePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.UnsupportedPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.gcc.DefaultGccPlatformToolChain;
import org.gradle.nativeplatform.toolchain.internal.gcc.GccPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.gcc.TargetPlatformConfiguration;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadata;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.SystemLibraryDiscovery;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerType;
import org.gradle.nativeplatform.toolchain.internal.tools.CommandLineToolSearchResult;
import org.gradle.nativeplatform.toolchain.internal.tools.DefaultGccCommandLineToolConfiguration;
import org.gradle.nativeplatform.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolSearchPath;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.platform.base.internal.toolchain.ToolChainAvailability;
import org.gradle.platform.base.internal.toolchain.ToolSearchResult;
import org.gradle.process.internal.ExecActionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public abstract class AbstractGccCompatibleToolChain
extends ExtendableToolChain<GccPlatformToolChain>
implements GccCompatibleToolChain {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGccCompatibleToolChain.class);
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final ExecActionFactory execActionFactory;
    private final ToolSearchPath toolSearchPath;
    private final List<TargetPlatformConfiguration> platformConfigs = new ArrayList<TargetPlatformConfiguration>();
    private final Map<NativePlatform, PlatformToolProvider> toolProviders = Maps.newHashMap();
    private final CompilerMetaDataProvider<GccMetadata> metaDataProvider;
    private final SystemLibraryDiscovery standardLibraryDiscovery;
    private final Instantiator instantiator;
    private final WorkerLeaseService workerLeaseService;
    private int configInsertLocation;

    public AbstractGccCompatibleToolChain(String name, BuildOperationExecutor buildOperationExecutor, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, CompilerMetaDataProvider<GccMetadata> metaDataProvider, SystemLibraryDiscovery standardLibraryDiscovery, Instantiator instantiator, WorkerLeaseService workerLeaseService) {
        this(name, buildOperationExecutor, operatingSystem, fileResolver, execActionFactory, compilerOutputFileNamingSchemeFactory, new ToolSearchPath(operatingSystem), metaDataProvider, standardLibraryDiscovery, instantiator, workerLeaseService);
    }

    AbstractGccCompatibleToolChain(String name, BuildOperationExecutor buildOperationExecutor, OperatingSystem operatingSystem, FileResolver fileResolver, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, ToolSearchPath tools, CompilerMetaDataProvider<GccMetadata> metaDataProvider, SystemLibraryDiscovery standardLibraryDiscovery, Instantiator instantiator, WorkerLeaseService workerLeaseService) {
        super(name, buildOperationExecutor, operatingSystem, (PathToFileResolver)fileResolver);
        this.execActionFactory = execActionFactory;
        this.toolSearchPath = tools;
        this.metaDataProvider = metaDataProvider;
        this.instantiator = instantiator;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.workerLeaseService = workerLeaseService;
        this.standardLibraryDiscovery = standardLibraryDiscovery;
        this.target(new Intel32Architecture());
        this.target(new Intel64Architecture());
        this.configInsertLocation = 0;
    }

    protected CommandLineToolSearchResult locate(GccCommandLineToolConfigurationInternal tool) {
        return this.toolSearchPath.locate(tool.getToolType(), tool.getExecutable());
    }

    @Override
    public List<File> getPath() {
        return this.toolSearchPath.getPath();
    }

    @Override
    public void path(Object ... pathEntries) {
        for (Object path : pathEntries) {
            this.toolSearchPath.path(this.resolve(path));
        }
    }

    protected CompilerMetaDataProvider<GccMetadata> getMetaDataProvider() {
        return this.metaDataProvider;
    }

    @Override
    public void target(String platformName) {
        this.target(platformName, (Action<? super GccPlatformToolChain>)Actions.doNothing());
    }

    @Override
    public void target(String platformName, Action<? super GccPlatformToolChain> action) {
        this.target(new DefaultTargetPlatformConfiguration(Arrays.asList(platformName), action));
    }

    public void target(List<String> platformNames, Action<? super GccPlatformToolChain> action) {
        this.target(new DefaultTargetPlatformConfiguration(platformNames, action));
    }

    private void target(TargetPlatformConfiguration targetPlatformConfiguration) {
        this.platformConfigs.add(this.configInsertLocation, targetPlatformConfiguration);
        ++this.configInsertLocation;
    }

    @Override
    public void setTargets(String ... platformNames) {
        this.platformConfigs.clear();
        this.configInsertLocation = 0;
        for (String platformName : platformNames) {
            this.target(platformName);
        }
    }

    @Override
    public PlatformToolProvider select(NativePlatformInternal targetPlatform) {
        return this.select(NativeLanguage.ANY, targetPlatform);
    }

    private PlatformToolProvider getProviderForPlatform(NativePlatformInternal targetPlatform) {
        PlatformToolProvider toolProvider = this.toolProviders.get(targetPlatform);
        if (toolProvider == null) {
            toolProvider = this.createPlatformToolProvider(targetPlatform);
            this.toolProviders.put(targetPlatform, toolProvider);
        }
        return toolProvider;
    }

    @Override
    public PlatformToolProvider select(NativeLanguage sourceLanguage, NativePlatformInternal targetMachine) {
        PlatformToolProvider toolProvider = this.getProviderForPlatform(targetMachine);
        switch (sourceLanguage) {
            case CPP: {
                if (toolProvider instanceof UnsupportedPlatformToolProvider) {
                    return toolProvider;
                }
                CommandLineToolSearchResult cppCompiler = toolProvider.locateTool(ToolType.CPP_COMPILER);
                if (cppCompiler.isAvailable()) {
                    return toolProvider;
                }
                return new UnavailablePlatformToolProvider(targetMachine.getOperatingSystem(), cppCompiler);
            }
            case ANY: {
                if (toolProvider instanceof UnsupportedPlatformToolProvider) {
                    return toolProvider;
                }
                CommandLineToolSearchResult cCompiler = toolProvider.locateTool(ToolType.C_COMPILER);
                if (cCompiler.isAvailable()) {
                    return toolProvider;
                }
                CommandLineToolSearchResult compiler = toolProvider.locateTool(ToolType.CPP_COMPILER);
                if (compiler.isAvailable()) {
                    return toolProvider;
                }
                compiler = toolProvider.locateTool(ToolType.OBJECTIVEC_COMPILER);
                if (compiler.isAvailable()) {
                    return toolProvider;
                }
                compiler = toolProvider.locateTool(ToolType.OBJECTIVECPP_COMPILER);
                if (compiler.isAvailable()) {
                    return toolProvider;
                }
                return new UnavailablePlatformToolProvider(targetMachine.getOperatingSystem(), cCompiler);
            }
        }
        return new UnsupportedPlatformToolProvider(targetMachine.getOperatingSystem(), String.format("Don't know how to compile language %s.", new Object[]{sourceLanguage}));
    }

    private PlatformToolProvider createPlatformToolProvider(NativePlatformInternal targetPlatform) {
        TargetPlatformConfiguration targetPlatformConfigurationConfiguration = this.getPlatformConfiguration(targetPlatform);
        if (targetPlatformConfigurationConfiguration == null) {
            return new UnsupportedPlatformToolProvider(targetPlatform.getOperatingSystem(), String.format("Don't know how to build for %s.", targetPlatform.getDisplayName()));
        }
        DefaultGccPlatformToolChain configurableToolChain = (DefaultGccPlatformToolChain)this.instantiator.newInstance(DefaultGccPlatformToolChain.class, new Object[]{targetPlatform});
        this.addDefaultTools(configurableToolChain);
        this.configureDefaultTools(configurableToolChain);
        targetPlatformConfigurationConfiguration.apply(configurableToolChain);
        this.configureActions.execute((Object)configurableToolChain);
        configurableToolChain.compilerProbeArgs(this.standardLibraryDiscovery.compilerProbeArgs(targetPlatform));
        ToolChainAvailability result = new ToolChainAvailability();
        this.initTools(configurableToolChain, result);
        if (!result.isAvailable()) {
            return new UnavailablePlatformToolProvider(targetPlatform.getOperatingSystem(), (ToolSearchResult)result);
        }
        return new GccPlatformToolProvider(this.buildOperationExecutor, targetPlatform.getOperatingSystem(), this.toolSearchPath, configurableToolChain, this.execActionFactory, this.compilerOutputFileNamingSchemeFactory, configurableToolChain.isCanUseCommandFile(), this.workerLeaseService, new CompilerMetaDataProviderWithDefaultArgs(configurableToolChain.getCompilerProbeArgs(), this.metaDataProvider));
    }

    protected void initTools(DefaultGccPlatformToolChain platformToolChain, ToolChainAvailability availability) {
        for (GccCommandLineToolConfigurationInternal tool : platformToolChain.getCompilers()) {
            CommandLineToolSearchResult compiler = this.locate(tool);
            if (!compiler.isAvailable()) continue;
            SearchResult<GccMetadata> gccMetadata = this.getMetaDataProvider().getCompilerMetaData(this.toolSearchPath.getPath(), (Action<CompilerMetaDataProvider.CompilerExecSpec>)((Action)spec -> spec.executable(compiler.getTool()).args(platformToolChain.getCompilerProbeArgs())));
            availability.mustBeAvailable(gccMetadata);
            if (!gccMetadata.isAvailable()) {
                return;
            }
            LOGGER.debug("Found {} with version {}", (Object)tool.getToolType().getToolName(), gccMetadata);
            this.initForImplementation(platformToolChain, (GccMetadata)gccMetadata.getComponent());
            break;
        }
    }

    protected void initForImplementation(DefaultGccPlatformToolChain platformToolChain, GccMetadata versionResult) {
    }

    private void addDefaultTools(DefaultGccPlatformToolChain toolChain) {
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.C_COMPILER, "gcc"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.CPP_COMPILER, "g++"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.LINKER, "g++"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.STATIC_LIB_ARCHIVER, "ar"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.OBJECTIVECPP_COMPILER, "g++"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.OBJECTIVEC_COMPILER, "gcc"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.ASSEMBLER, "gcc"}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.SYMBOL_EXTRACTOR, SymbolExtractorOsConfig.current().getExecutableName()}));
        toolChain.add((DefaultGccCommandLineToolConfiguration)this.instantiator.newInstance(DefaultGccCommandLineToolConfiguration.class, new Object[]{ToolType.STRIPPER, "strip"}));
    }

    protected void configureDefaultTools(DefaultGccPlatformToolChain toolChain) {
    }

    @Nullable
    protected TargetPlatformConfiguration getPlatformConfiguration(NativePlatformInternal targetPlatform) {
        for (TargetPlatformConfiguration platformConfig : this.platformConfigs) {
            if (!platformConfig.supportsPlatform(targetPlatform)) continue;
            return platformConfig;
        }
        return null;
    }

    private static class CompilerMetaDataProviderWithDefaultArgs
    implements CompilerMetaDataProvider<GccMetadata> {
        private final List<String> compilerProbeArgs;
        private final CompilerMetaDataProvider<GccMetadata> delegate;

        public CompilerMetaDataProviderWithDefaultArgs(List<String> compilerProbeArgs, CompilerMetaDataProvider<GccMetadata> delegate) {
            this.compilerProbeArgs = compilerProbeArgs;
            this.delegate = delegate;
        }

        @Override
        public SearchResult<GccMetadata> getCompilerMetaData(List<File> searchPath, Action<? super CompilerMetaDataProvider.CompilerExecSpec> configureAction) {
            return this.delegate.getCompilerMetaData(searchPath, (Action<CompilerMetaDataProvider.CompilerExecSpec>)((Action)execSpec -> {
                execSpec.args(this.compilerProbeArgs);
                configureAction.execute(execSpec);
            }));
        }

        @Override
        public CompilerType getCompilerType() {
            return this.delegate.getCompilerType();
        }
    }

    private static class DefaultTargetPlatformConfiguration
    implements TargetPlatformConfiguration {
        private final Collection<String> platformNames;
        private Action<? super GccPlatformToolChain> configurationAction;

        public DefaultTargetPlatformConfiguration(Collection<String> targetPlatformNames, Action<? super GccPlatformToolChain> configurationAction) {
            this.platformNames = targetPlatformNames;
            this.configurationAction = configurationAction;
        }

        @Override
        public boolean supportsPlatform(NativePlatformInternal targetPlatform) {
            return this.platformNames.contains(targetPlatform.getName());
        }

        @Override
        public void apply(DefaultGccPlatformToolChain platformToolChain) {
            this.configurationAction.execute((Object)platformToolChain);
        }
    }

    private static class Intel64Architecture
    implements TargetPlatformConfiguration {
        private Intel64Architecture() {
        }

        @Override
        public boolean supportsPlatform(NativePlatformInternal targetPlatform) {
            return targetPlatform.getOperatingSystem().isCurrent() && targetPlatform.getArchitecture().isAmd64();
        }

        @Override
        public void apply(DefaultGccPlatformToolChain gccToolChain) {
            gccToolChain.compilerProbeArgs("-m64");
            Action<List<String>> m64args = new Action<List<String>>(){

                public void execute(List<String> args) {
                    args.add("-m64");
                }
            };
            gccToolChain.getCppCompiler().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getcCompiler().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getObjcCompiler().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getObjcppCompiler().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getLinker().withArguments((Action<? super List<String>>)m64args);
            gccToolChain.getAssembler().withArguments((Action<? super List<String>>)m64args);
        }
    }

    private static class Intel32Architecture
    implements TargetPlatformConfiguration {
        private Intel32Architecture() {
        }

        @Override
        public boolean supportsPlatform(NativePlatformInternal targetPlatform) {
            return targetPlatform.getOperatingSystem().isCurrent() && targetPlatform.getArchitecture().isI386();
        }

        @Override
        public void apply(DefaultGccPlatformToolChain gccToolChain) {
            gccToolChain.compilerProbeArgs("-m32");
            Action<List<String>> m32args = new Action<List<String>>(){

                public void execute(List<String> args) {
                    args.add("-m32");
                }
            };
            gccToolChain.getCppCompiler().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getcCompiler().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getObjcCompiler().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getObjcppCompiler().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getLinker().withArguments((Action<? super List<String>>)m32args);
            gccToolChain.getAssembler().withArguments((Action<? super List<String>>)m32args);
        }
    }
}

