/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.PropertyListTransformer;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeBinary;
import org.gradle.ide.xcode.internal.XcodePropertyAdapter;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.XcodeUtils;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXBuildFile;
import org.gradle.ide.xcode.internal.xcodeproj.PBXFileReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXGroup;
import org.gradle.ide.xcode.internal.xcodeproj.PBXLegacyTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXNativeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXProject;
import org.gradle.ide.xcode.internal.xcodeproj.PBXReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXShellScriptBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.PBXSourcesBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.internal.xcodeproj.XCBuildConfiguration;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.gradle.ide.xcode.tasks.internal.XcodeProjectFile;
import org.gradle.internal.Cast;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.plugins.ide.api.PropertyListGeneratorTask;

@Incubating
public class GenerateXcodeProjectFileTask
extends PropertyListGeneratorTask<XcodeProjectFile> {
    private static final String PRODUCTS_GROUP_NAME = "Products";
    private static final String UNBUILDABLE_BUILD_CONFIGURATION_NAME = "unbuildable";
    private final String projectPath = this.getProject().getPath();
    private final GidGenerator gidGenerator;
    private DefaultXcodeProject xcodeProject;
    private Map<String, PBXFileReference> pathToFileReference = new HashMap<String, PBXFileReference>();

    @Inject
    public GenerateXcodeProjectFileTask(GidGenerator gidGenerator) {
        this.gidGenerator = gidGenerator;
    }

    @Override
    protected void configure(XcodeProjectFile projectFile) {
        PBXProject project = new PBXProject(this.projectPath);
        this.addToGroup(project.getMainGroup(), (FileCollection)this.xcodeProject.getGroups().getSources(), "Sources");
        this.addToGroup(project.getMainGroup(), (FileCollection)this.xcodeProject.getGroups().getHeaders(), "Headers");
        this.addToGroup(project.getMainGroup(), (FileCollection)this.xcodeProject.getGroups().getTests(), "Tests");
        this.addToGroup(project.getMainGroup(), (Iterable<File>)this.xcodeProject.getGroups().getRoot());
        for (XcodeTarget xcodeTarget : this.xcodeProject.getTargets()) {
            if (xcodeTarget.isBuildable()) {
                project.getTargets().add(this.toGradlePbxTarget(xcodeTarget));
            } else {
                this.getLogger().warn("'" + xcodeTarget.getName() + "' component in project '" + this.projectPath + "' is not buildable.");
            }
            project.getTargets().add(this.toIndexPbxTarget(xcodeTarget));
            if (xcodeTarget.isUnitTest() || !xcodeTarget.getDebugOutputFile().isPresent()) continue;
            File debugOutputFile = ((FileSystemLocation)xcodeTarget.getDebugOutputFile().get()).getAsFile();
            PBXFileReference fileReference = new PBXFileReference(debugOutputFile.getName(), debugOutputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE);
            fileReference.setExplicitFileType((Optional<String>)Optional.of((Object)xcodeTarget.getOutputFileType()));
            project.getMainGroup().getOrCreateChildGroupByName(PRODUCTS_GROUP_NAME).getChildren().add(fileReference);
        }
        project.getTargets().stream().flatMap(it -> it.getBuildConfigurationList().getBuildConfigurationsByName().asMap().keySet().stream()).forEach(arg_0 -> project.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked(arg_0));
        XcodeprojSerializer serializer = new XcodeprojSerializer(this.gidGenerator, project);
        final NSDictionary rootObject = serializer.toPlist();
        projectFile.transformAction(new Action<NSDictionary>(){

            public void execute(NSDictionary dict) {
                dict.clear();
                dict.putAll((Map)rootObject);
            }
        });
    }

    private void addToGroup(PBXGroup mainGroup, FileCollection sources, String groupName) {
        if (!sources.isEmpty()) {
            this.addToGroup(mainGroup.getOrCreateChildGroupByName(groupName), (Iterable<File>)sources);
        }
    }

    private void addToGroup(PBXGroup group, Iterable<File> sources) {
        for (File source : sources) {
            PBXFileReference fileReference = this.toFileReference(source);
            this.pathToFileReference.put(source.getAbsolutePath(), fileReference);
            group.getChildren().add(fileReference);
        }
    }

    private List<XcodeBinary> getAllBinaries() {
        return this.xcodeProject.getTargets().stream().map(XcodeTarget::getBinaries).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    protected XcodeProjectFile create() {
        return new XcodeProjectFile((PropertyListTransformer)Cast.uncheckedNonnullCast((Object)this.getPropertyListTransformer()));
    }

    private PBXFileReference toFileReference(File file) {
        return new PBXFileReference(file.getName(), file.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE);
    }

    private PBXTarget toGradlePbxTarget(XcodeTarget xcodeTarget) {
        if (xcodeTarget.isUnitTest()) {
            return this.toXCTestPbxTarget(xcodeTarget);
        }
        return this.toToolAndLibraryPbxTarget(xcodeTarget);
    }

    private PBXTarget toToolAndLibraryPbxTarget(XcodeTarget xcodeTarget) {
        PBXLegacyTarget target = new PBXLegacyTarget(xcodeTarget.getName(), xcodeTarget.getProductType());
        target.setProductName(xcodeTarget.getProductName());
        target.setBuildToolPath(xcodeTarget.getGradleCommand());
        target.setBuildArgumentsString(this.buildGradleArgs(xcodeTarget));
        target.setGlobalID(xcodeTarget.getId());
        File outputFile = ((FileSystemLocation)xcodeTarget.getDebugOutputFile().get()).getAsFile();
        target.setProductReference(new PBXFileReference(outputFile.getName(), outputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE));
        xcodeTarget.getBinaries().forEach(xcodeBinary -> {
            NSDictionary settings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)xcodeBinary.getBuildConfigurationName())).getBuildSettings();
            File binaryOutputFile = ((FileSystemLocation)xcodeBinary.getOutputFile().get()).getAsFile();
            settings.put("CONFIGURATION_BUILD_DIR", (NSObject)new NSString(binaryOutputFile.getParentFile().getAbsolutePath()));
            settings.put("PRODUCT_NAME", (Object)target.getProductName());
            settings.put("SWIFT_VERSION", (Object)GenerateXcodeProjectFileTask.toXcodeSwiftVersion(xcodeTarget.getSwiftSourceCompatibility()));
            settings.put("ARCHS", (Object)GenerateXcodeProjectFileTask.toXcodeArchitecture(xcodeBinary.getArchitectureName()));
            settings.put("VALID_ARCHS", (Object)xcodeTarget.getBinaries().stream().map(XcodeBinary::getArchitectureName).map(GenerateXcodeProjectFileTask::toXcodeArchitecture).distinct().collect(Collectors.joining(" ")));
        });
        return target;
    }

    private String buildGradleArgs(XcodeTarget xcodeTarget) {
        return Joiner.on((char)' ').join(XcodePropertyAdapter.getAdapterCommandLine()) + " " + xcodeTarget.getTaskName();
    }

    private PBXTarget toXCTestPbxTarget(XcodeTarget xcodeTarget) {
        PBXShellScriptBuildPhase hackBuildPhase = new PBXShellScriptBuildPhase();
        hackBuildPhase.setShellPath("/bin/sh");
        hackBuildPhase.setShellScript("# Script to generate specific Swift files Xcode expects when running tests.\nset -eu\nARCH_ARRAY=($ARCHS)\nSUFFIXES=(swiftdoc swiftmodule h)\nfor ARCH in \"${ARCH_ARRAY[@]}\"\ndo\n  for SUFFIX in \"${SUFFIXES[@]}\"\n  do\n    touch \"$OBJECT_FILE_DIR_normal/$ARCH/$PRODUCT_NAME.$SUFFIX\"\n  done\ndone");
        PBXShellScriptBuildPhase gradleBuildPhase = new PBXShellScriptBuildPhase();
        gradleBuildPhase.setShellPath("/bin/sh");
        gradleBuildPhase.setShellScript("exec \"" + xcodeTarget.getGradleCommand() + "\" " + this.buildGradleArgs(xcodeTarget) + " < /dev/null");
        PBXNativeTarget target = new PBXNativeTarget(xcodeTarget.getName(), xcodeTarget.getProductType());
        target.setProductName(xcodeTarget.getProductName());
        target.setGlobalID(xcodeTarget.getId());
        target.getBuildPhases().add(hackBuildPhase);
        target.getBuildPhases().add(this.newSourceBuildPhase((FileCollection)xcodeTarget.getSources()));
        target.getBuildPhases().add(gradleBuildPhase);
        File outputFile = ((FileSystemLocation)xcodeTarget.getDebugOutputFile().get()).getAsFile();
        target.setProductReference(new PBXFileReference(outputFile.getName(), outputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE));
        this.getAllBinaries().stream().filter(it -> !Objects.equals(it.getBuildConfigurationName(), "__GradleTestRunner_Debug")).forEach(this.configureBuildSettings(xcodeTarget, target));
        NSDictionary testRunnerSettings = ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"__GradleTestRunner_Debug")).getBuildSettings();
        if (!xcodeTarget.getCompileModules().isEmpty()) {
            testRunnerSettings.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(GenerateXcodeProjectFileTask.parentDirs((Iterable<File>)xcodeTarget.getCompileModules())));
        }
        testRunnerSettings.put("SWIFT_VERSION", (Object)GenerateXcodeProjectFileTask.toXcodeSwiftVersion(xcodeTarget.getSwiftSourceCompatibility()));
        testRunnerSettings.put("PRODUCT_NAME", (Object)target.getProductName());
        testRunnerSettings.put("OTHER_LDFLAGS", (Object)"-help");
        testRunnerSettings.put("OTHER_CFLAGS", (Object)"-help");
        testRunnerSettings.put("OTHER_SWIFT_FLAGS", (Object)"-help");
        testRunnerSettings.put("SWIFT_INSTALL_OBJC_HEADER", (Object)"NO");
        testRunnerSettings.put("SWIFT_OBJC_INTERFACE_HEADER_NAME", (Object)"$(PRODUCT_NAME).h");
        return target;
    }

    private PBXTarget toIndexPbxTarget(XcodeTarget xcodeTarget) {
        PBXNativeTarget target = new PBXNativeTarget("[INDEXING ONLY] " + xcodeTarget.getName(), PBXTarget.ProductType.INDEXER);
        target.setProductName(xcodeTarget.getProductName());
        target.getBuildPhases().add(this.newSourceBuildPhase((FileCollection)xcodeTarget.getSources()));
        xcodeTarget.getBinaries().forEach(this.configureBuildSettings(xcodeTarget, target));
        if (xcodeTarget.getBinaries().isEmpty()) {
            NSDictionary settings = this.newBuildSettings(xcodeTarget);
            ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)UNBUILDABLE_BUILD_CONFIGURATION_NAME)).setBuildSettings(settings);
        }
        return target;
    }

    private Consumer<XcodeBinary> configureBuildSettings(XcodeTarget xcodeTarget, PBXNativeTarget target) {
        return xcodeBinary -> {
            NSDictionary settings = this.newBuildSettings(xcodeTarget);
            settings.put("ARCHS", (Object)GenerateXcodeProjectFileTask.toXcodeArchitecture(xcodeBinary.getArchitectureName()));
            settings.put("VALID_ARCHS", (Object)xcodeTarget.getBinaries().stream().map(it -> GenerateXcodeProjectFileTask.toXcodeArchitecture(it.getArchitectureName())).distinct().collect(Collectors.joining(" ")));
            ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)xcodeBinary.getBuildConfigurationName())).setBuildSettings(settings);
        };
    }

    private PBXSourcesBuildPhase newSourceBuildPhase(FileCollection sourceFiles) {
        PBXSourcesBuildPhase result = new PBXSourcesBuildPhase();
        for (File file : sourceFiles) {
            PBXFileReference fileReference = this.pathToFileReference.get(file.getAbsolutePath());
            result.getFiles().add(new PBXBuildFile(fileReference));
        }
        return result;
    }

    private NSDictionary newBuildSettings(XcodeTarget xcodeTarget) {
        NSDictionary result = new NSDictionary();
        result.put("SWIFT_VERSION", (Object)GenerateXcodeProjectFileTask.toXcodeSwiftVersion(xcodeTarget.getSwiftSourceCompatibility()));
        result.put("PRODUCT_NAME", (Object)xcodeTarget.getProductName());
        if (!xcodeTarget.getHeaderSearchPaths().isEmpty()) {
            result.put("HEADER_SEARCH_PATHS", (Object)XcodeUtils.toSpaceSeparatedList((Iterable<File>)xcodeTarget.getHeaderSearchPaths()));
        }
        if (!xcodeTarget.getCompileModules().isEmpty()) {
            result.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList(GenerateXcodeProjectFileTask.parentDirs((Iterable<File>)xcodeTarget.getCompileModules())));
        }
        return result;
    }

    private static String toXcodeArchitecture(String architectureName) {
        if (architectureName.equals("x86")) {
            return "i386";
        }
        if (architectureName.equals("x86-64")) {
            return "x86_64";
        }
        return architectureName;
    }

    private static String toXcodeSwiftVersion(Provider<SwiftVersion> swiftVersion) {
        if (swiftVersion.isPresent()) {
            return String.format("%d.0", ((SwiftVersion)swiftVersion.get()).getVersion());
        }
        return null;
    }

    private static Iterable<File> parentDirs(Iterable<File> files) {
        ArrayList<File> parents = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                parents.add(file);
                continue;
            }
            parents.add(file.getParentFile());
        }
        return parents;
    }

    @Internal
    public XcodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setXcodeProject(XcodeProject xcodeProject) {
        this.xcodeProject = (DefaultXcodeProject)xcodeProject;
    }
}

