/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.snapshot.AtomicSnapshotHierarchyReference;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.MetadataSnapshot;

public interface SnapshotHierarchy {
    public Optional<MetadataSnapshot> getMetadata(String var1);

    default public Optional<CompleteFileSystemLocationSnapshot> getSnapshot(String absolutePath) {
        return this.getMetadata(absolutePath).filter(CompleteFileSystemLocationSnapshot.class::isInstance).map(CompleteFileSystemLocationSnapshot.class::cast);
    }

    @CheckReturnValue
    public SnapshotHierarchy store(String var1, MetadataSnapshot var2, NodeDiffListener var3);

    @CheckReturnValue
    public SnapshotHierarchy invalidate(String var1, NodeDiffListener var2);

    @CheckReturnValue
    public SnapshotHierarchy empty();

    public void visitSnapshotRoots(SnapshotVisitor var1);

    public static interface DiffCapturingUpdateFunctionDecorator {
        public static final DiffCapturingUpdateFunctionDecorator NOOP = updateFunction -> root -> updateFunction.update(root, NodeDiffListener.NOOP);

        public AtomicSnapshotHierarchyReference.UpdateFunction decorate(DiffCapturingUpdateFunction var1);
    }

    public static interface DiffCapturingUpdateFunction {
        public SnapshotHierarchy update(SnapshotHierarchy var1, NodeDiffListener var2);
    }

    public static interface SnapshotDiffListener {
        public static final SnapshotDiffListener NOOP = (removedSnapshots, addedSnapshots) -> {};

        public void changed(Collection<CompleteFileSystemLocationSnapshot> var1, Collection<CompleteFileSystemLocationSnapshot> var2);
    }

    public static interface NodeDiffListener {
        public static final NodeDiffListener NOOP = new NodeDiffListener(){

            @Override
            public void nodeRemoved(FileSystemNode node) {
            }

            @Override
            public void nodeAdded(FileSystemNode node) {
            }
        };

        public void nodeRemoved(FileSystemNode var1);

        public void nodeAdded(FileSystemNode var1);
    }

    public static interface SnapshotVisitor {
        public void visitSnapshotRoot(CompleteFileSystemLocationSnapshot var1);
    }
}

