/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InetAddresses {
    private static final int REACHABLE_TIMEOUT_MS = 50;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<InetAddress> loopback = new ArrayList<InetAddress>();
    private final List<InetAddress> remote = new ArrayList<InetAddress>();

    InetAddresses() throws SocketException {
        this.analyzeNetworkInterfaces();
    }

    private void analyzeNetworkInterfaces() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            while (interfaces.hasMoreElements()) {
                this.analyzeNetworkInterface(interfaces.nextElement());
            }
        }
    }

    private void analyzeNetworkInterface(NetworkInterface networkInterface) {
        this.logger.debug("Adding IP addresses for network interface {}", (Object)networkInterface.getDisplayName());
        try {
            boolean isLoopbackInterface = networkInterface.isLoopback();
            this.logger.debug("Is this a loopback interface? {}", (Object)isLoopbackInterface);
            Enumeration<InetAddress> candidates = networkInterface.getInetAddresses();
            while (candidates.hasMoreElements()) {
                InetAddress candidate = candidates.nextElement();
                if (isLoopbackInterface) {
                    if (candidate.isLoopbackAddress()) {
                        if (candidate.isReachable(50)) {
                            this.logger.debug("Adding loopback address {}", (Object)candidate);
                            this.loopback.add(candidate);
                            continue;
                        }
                        this.logger.debug("Ignoring unreachable local address on loopback interface {}", (Object)candidate);
                        continue;
                    }
                    this.logger.debug("Ignoring remote address on loopback interface {}", (Object)candidate);
                    continue;
                }
                if (candidate.isLoopbackAddress()) {
                    this.logger.debug("Ignoring loopback address on remote interface {}", (Object)candidate);
                    continue;
                }
                this.logger.debug("Adding remote address {}", (Object)candidate);
                this.remote.add(candidate);
            }
        }
        catch (SocketException e) {
            this.logger.debug("Error while querying interface {} for IP addresses", (Object)networkInterface, (Object)e);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("Could not determine the IP addresses for network interface %s", networkInterface.getName()), e);
        }
    }

    public List<InetAddress> getLoopback() {
        return this.loopback;
    }

    public List<InetAddress> getRemote() {
        return this.remote;
    }
}

