/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.InputArtifactDependencies;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.artifacts.transform.VariantTransformConfigurationException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.transform.AbstractTransformer;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.DefaultTransformOutputs;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.properties.FileParameterUtils;
import org.gradle.api.internal.tasks.properties.InputFilePropertyType;
import org.gradle.api.internal.tasks.properties.InputParameterUtils;
import org.gradle.api.internal.tasks.properties.OutputFilePropertyType;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.InjectionPointQualifier;
import org.gradle.api.tasks.FileNormalizer;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.fingerprint.AbsolutePathInputNormalizer;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FileCollectionFingerprinterRegistry;
import org.gradle.internal.hash.ClassLoaderHierarchyHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationType;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.reflect.DefaultTypeValidationContext;
import org.gradle.internal.reflect.TypeValidationContext;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.model.internal.type.ModelType;
import org.gradle.work.InputChanges;

public class DefaultTransformer
extends AbstractTransformer<TransformAction<?>> {
    private final TransformParameters parameterObject;
    private final ModelContainer<?> owner;
    private final Class<? extends FileNormalizer> fileNormalizer;
    private final Class<? extends FileNormalizer> dependenciesNormalizer;
    private final BuildOperationExecutor buildOperationExecutor;
    private final ClassLoaderHierarchyHasher classLoaderHierarchyHasher;
    private final IsolatableFactory isolatableFactory;
    private final ValueSnapshotter valueSnapshotter;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileLookup fileLookup;
    private final PropertyWalker parameterPropertyWalker;
    private final ServiceLookup internalServices;
    private final boolean requiresDependencies;
    private final boolean requiresInputChanges;
    private final InstanceFactory<? extends TransformAction<?>> instanceFactory;
    private final boolean cacheable;
    private final CalculatedModelValue<IsolatedParameters> isolatedParameters;

    public DefaultTransformer(Class<? extends TransformAction<?>> implementationClass, @Nullable TransformParameters parameterObject, @Nullable IsolatedParameters isolatedParameters, ImmutableAttributes fromAttributes, Class<? extends FileNormalizer> inputArtifactNormalizer, Class<? extends FileNormalizer> dependenciesNormalizer, boolean cacheable, BuildOperationExecutor buildOperationExecutor, ClassLoaderHierarchyHasher classLoaderHierarchyHasher, IsolatableFactory isolatableFactory, ValueSnapshotter valueSnapshotter, FileCollectionFactory fileCollectionFactory, FileLookup fileLookup, PropertyWalker parameterPropertyWalker, InstantiationScheme actionInstantiationScheme, ModelContainer<?> owner, ServiceLookup internalServices) {
        super(implementationClass, fromAttributes);
        this.parameterObject = parameterObject;
        this.owner = owner;
        this.isolatedParameters = owner.newCalculatedValue((Object)isolatedParameters);
        this.fileNormalizer = inputArtifactNormalizer;
        this.dependenciesNormalizer = dependenciesNormalizer;
        this.buildOperationExecutor = buildOperationExecutor;
        this.classLoaderHierarchyHasher = classLoaderHierarchyHasher;
        this.isolatableFactory = isolatableFactory;
        this.valueSnapshotter = valueSnapshotter;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileLookup = fileLookup;
        this.parameterPropertyWalker = parameterPropertyWalker;
        this.internalServices = internalServices;
        this.instanceFactory = actionInstantiationScheme.forType(implementationClass);
        this.requiresDependencies = this.instanceFactory.serviceInjectionTriggeredByAnnotation(InputArtifactDependencies.class);
        this.requiresInputChanges = this.instanceFactory.requiresService(InputChanges.class);
        this.cacheable = cacheable;
    }

    public static void validateInputFileNormalizer(String propertyName, @Nullable Class<? extends FileNormalizer> normalizer, boolean cacheable, TypeValidationContext validationContext) {
        if (cacheable && normalizer == AbsolutePathInputNormalizer.class) {
            validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, propertyName, "is declared to be sensitive to absolute paths. This is not allowed for cacheable transforms");
        }
    }

    @Override
    public Class<? extends FileNormalizer> getInputArtifactNormalizer() {
        return this.fileNormalizer;
    }

    @Override
    public Class<? extends FileNormalizer> getInputArtifactDependenciesNormalizer() {
        return this.dependenciesNormalizer;
    }

    @Override
    public boolean isIsolated() {
        return this.isolatedParameters.getOrNull() != null;
    }

    @Override
    public boolean requiresDependencies() {
        return this.requiresDependencies;
    }

    @Override
    public boolean requiresInputChanges() {
        return this.requiresInputChanges;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public HashCode getSecondaryInputHash() {
        return this.getIsolatedParameters().getSecondaryInputsHash();
    }

    @Override
    public ImmutableList<File> transform(Provider<FileSystemLocation> inputArtifactProvider, File outputDir, ArtifactTransformDependencies dependencies, @Nullable InputChanges inputChanges) {
        TransformAction<?> transformAction = this.newTransformAction(inputArtifactProvider, dependencies, inputChanges);
        DefaultTransformOutputs transformOutputs = new DefaultTransformOutputs(((FileSystemLocation)inputArtifactProvider.get()).getAsFile(), outputDir, this.fileLookup);
        transformAction.transform((TransformOutputs)transformOutputs);
        return transformOutputs.getRegisteredOutputs();
    }

    public void visitDependencies(final TaskDependencyResolveContext context) {
        if (this.parameterObject != null) {
            this.parameterPropertyWalker.visitProperties((Object)this.parameterObject, TypeValidationContext.NOOP, (PropertyVisitor)new PropertyVisitor.Adapter(){

                public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                    context.add((Object)value.getTaskDependencies());
                }
            });
        }
    }

    @Override
    public void isolateParameters(FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        if (!this.owner.hasMutableState()) {
            this.owner.forceAccessToMutableState(o -> this.doIsolateParameters(fingerprinterRegistry));
        } else {
            this.doIsolateParameters(fingerprinterRegistry);
        }
    }

    private void doIsolateParameters(FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        try {
            this.isolatedParameters.update(current -> {
                if (current != null) {
                    return current;
                }
                return this.isolateParametersExclusively(fingerprinterRegistry);
            });
        }
        catch (Exception e) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not isolate parameters ").appendValue((Object)this.parameterObject).append((CharSequence)" of artifact transform ").appendType(this.getImplementationClass());
            throw new VariantTransformConfigurationException(formatter.toString(), (Throwable)e);
        }
    }

    private IsolatedParameters isolateParametersExclusively(final FileCollectionFingerprinterRegistry fingerprinterRegistry) {
        Isolatable isolatedParameterObject = this.isolatableFactory.isolate((Object)this.parameterObject);
        final Hasher hasher = Hashing.newHasher();
        DefaultTransformer.appendActionImplementation(this.getImplementationClass(), hasher, this.classLoaderHierarchyHasher);
        if (this.parameterObject != null) {
            final TransformParameters isolatedTransformParameters = (TransformParameters)isolatedParameterObject.isolate();
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    DefaultTransformer.fingerprintParameters(DefaultTransformer.this.valueSnapshotter, fingerprinterRegistry, DefaultTransformer.this.fileCollectionFactory, DefaultTransformer.this.parameterPropertyWalker, hasher, isolatedTransformParameters, DefaultTransformer.this.cacheable);
                    context.setResult((Object)FingerprintTransformInputsOperation.Result.INSTANCE);
                }

                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName((String)"Fingerprint transformation inputs").details((Object)FingerprintTransformInputsOperation.Details.INSTANCE);
                }
            });
        }
        HashCode secondaryInputsHash = hasher.hash();
        return new IsolatedParameters((Isolatable<? extends TransformParameters>)isolatedParameterObject, secondaryInputsHash);
    }

    private static void fingerprintParameters(final ValueSnapshotter valueSnapshotter, final FileCollectionFingerprinterRegistry fingerprinterRegistry, final FileCollectionFactory fileCollectionFactory, PropertyWalker propertyWalker, Hasher hasher, final Object parameterObject, final boolean cacheable) {
        final ImmutableSortedMap.Builder inputParameterFingerprintsBuilder = ImmutableSortedMap.naturalOrder();
        final ImmutableSortedMap.Builder inputFileParameterFingerprintsBuilder = ImmutableSortedMap.naturalOrder();
        final DefaultTypeValidationContext validationContext = DefaultTypeValidationContext.withoutRootType((boolean)cacheable);
        propertyWalker.visitProperties(parameterObject, (TypeValidationContext)validationContext, (PropertyVisitor)new PropertyVisitor.Adapter(){

            public void visitInputProperty(String propertyName, PropertyValue value, boolean optional) {
                try {
                    Object preparedValue = InputParameterUtils.prepareInputParameterValue((Object)value);
                    if (preparedValue == null && !optional) {
                        validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, propertyName, "does not have a value specified");
                    }
                    inputParameterFingerprintsBuilder.put((Object)propertyName, (Object)valueSnapshotter.snapshot(preparedValue));
                }
                catch (Throwable e) {
                    throw new InvalidUserDataException(String.format("Error while evaluating property '%s' of %s", propertyName, DefaultTransformer.getParameterObjectDisplayName(parameterObject)), e);
                }
            }

            public void visitOutputFileProperty(String propertyName, boolean optional, PropertyValue value, OutputFilePropertyType filePropertyType) {
                validationContext.visitPropertyProblem(TypeValidationContext.Severity.WARNING, propertyName, "is annotated with an output annotation");
            }

            public void visitInputFileProperty(String propertyName, boolean optional, boolean skipWhenEmpty, boolean incremental, @Nullable Class<? extends FileNormalizer> fileNormalizer, PropertyValue value, InputFilePropertyType filePropertyType) {
                DefaultTransformer.validateInputFileNormalizer(propertyName, fileNormalizer, cacheable, (TypeValidationContext)validationContext);
                FileCollectionFingerprinter fingerprinter = fingerprinterRegistry.getFingerprinter(FileParameterUtils.normalizerOrDefault(fileNormalizer));
                FileCollectionInternal inputFileValue = FileParameterUtils.resolveInputFileValue((FileCollectionFactory)fileCollectionFactory, (InputFilePropertyType)filePropertyType, (Object)value);
                CurrentFileCollectionFingerprint fingerprint = fingerprinter.fingerprint((FileCollection)inputFileValue);
                inputFileParameterFingerprintsBuilder.put((Object)propertyName, (Object)fingerprint);
            }
        });
        ImmutableMap validationMessages = validationContext.getProblems();
        if (!validationMessages.isEmpty()) {
            throw new DefaultMultiCauseException(String.format(validationMessages.size() == 1 ? "A problem was found with the configuration of the artifact transform parameter %s." : "Some problems were found with the configuration of the artifact transform parameter %s.", DefaultTransformer.getParameterObjectDisplayName(parameterObject)), (Iterable)validationMessages.keySet().stream().sorted().map(InvalidUserDataException::new).collect(Collectors.toList()));
        }
        for (Map.Entry entry : inputParameterFingerprintsBuilder.build().entrySet()) {
            hasher.putString((CharSequence)entry.getKey());
            ((ValueSnapshot)entry.getValue()).appendToHasher(hasher);
        }
        for (Map.Entry entry : inputFileParameterFingerprintsBuilder.build().entrySet()) {
            hasher.putString((CharSequence)entry.getKey());
            hasher.putHash(((CurrentFileCollectionFingerprint)entry.getValue()).getHash());
        }
    }

    private static String getParameterObjectDisplayName(Object parameterObject) {
        return ModelType.of((Class)new DslObject(parameterObject).getDeclaredType()).getDisplayName();
    }

    private TransformAction<?> newTransformAction(Provider<FileSystemLocation> inputArtifactProvider, ArtifactTransformDependencies artifactTransformDependencies, @Nullable InputChanges inputChanges) {
        TransformParameters parameters = (TransformParameters)this.getIsolatedParameters().getIsolatedParameterObject().isolate();
        ServiceLookup services = new IsolationScheme(TransformAction.class, TransformParameters.class, TransformParameters.None.class).servicesForImplementation((Object)parameters, this.internalServices);
        services = new TransformServiceLookup(inputArtifactProvider, this.requiresDependencies ? artifactTransformDependencies : null, inputChanges, services);
        return (TransformAction)this.instanceFactory.newInstance(services, new Object[0]);
    }

    @Nullable
    public TransformParameters getParameterObject() {
        return this.parameterObject;
    }

    public IsolatedParameters getIsolatedParameters() {
        return (IsolatedParameters)this.isolatedParameters.get();
    }

    public static interface FingerprintTransformInputsOperation
    extends BuildOperationType<Details, Result> {

        public static interface Result {
            public static final Result INSTANCE = new Result(){};
        }

        public static interface Details {
            public static final Details INSTANCE = new Details(){};
        }
    }

    public static class IsolatedParameters {
        private final HashCode secondaryInputsHash;
        private final Isolatable<? extends TransformParameters> isolatedParameterObject;

        public IsolatedParameters(Isolatable<? extends TransformParameters> isolatedParameterObject, HashCode secondaryInputsHash) {
            this.secondaryInputsHash = secondaryInputsHash;
            this.isolatedParameterObject = isolatedParameterObject;
        }

        public HashCode getSecondaryInputsHash() {
            return this.secondaryInputsHash;
        }

        public Isolatable<? extends TransformParameters> getIsolatedParameterObject() {
            return this.isolatedParameterObject;
        }
    }

    private static class TransformServiceLookup
    implements ServiceLookup {
        private static final Type FILE_SYSTEM_LOCATION_PROVIDER = new TypeToken<Provider<FileSystemLocation>>(){}.getType();
        private final ImmutableList<InjectionPoint> injectionPoints;
        private final ServiceLookup delegate;

        public TransformServiceLookup(Provider<FileSystemLocation> inputFileProvider, @Nullable ArtifactTransformDependencies artifactTransformDependencies, @Nullable InputChanges inputChanges, ServiceLookup delegate) {
            this.delegate = delegate;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)InjectionPoint.injectedByAnnotation(InputArtifact.class, File.class, () -> {
                DeprecationLogger.deprecate((String)"Injecting the input artifact of a transform as a File").withAdvice("Declare the input artifact as Provider<FileSystemLocation> instead.").willBeRemovedInGradle7().withUserManual("artifact_transforms", "sec:implementing-artifact-transforms").nagUser();
                return ((FileSystemLocation)inputFileProvider.get()).getAsFile();
            }));
            builder.add((Object)InjectionPoint.injectedByAnnotation(InputArtifact.class, FILE_SYSTEM_LOCATION_PROVIDER, () -> inputFileProvider));
            if (artifactTransformDependencies != null) {
                builder.add((Object)InjectionPoint.injectedByAnnotation(InputArtifactDependencies.class, artifactTransformDependencies::getFiles));
            }
            if (inputChanges != null) {
                builder.add((Object)InjectionPoint.injectedByType(InputChanges.class, () -> inputChanges));
            }
            this.injectionPoints = builder.build();
        }

        @Nullable
        private Object find(Type serviceType, @Nullable Class<? extends Annotation> annotatedWith) {
            TypeToken serviceTypeToken = TypeToken.of((Type)serviceType);
            for (InjectionPoint injectionPoint : this.injectionPoints) {
                if (annotatedWith != injectionPoint.getAnnotation() || !serviceTypeToken.isSupertypeOf(injectionPoint.getInjectedType())) continue;
                return injectionPoint.getValueToInject();
            }
            return null;
        }

        @Nullable
        public Object find(Type serviceType) throws ServiceLookupException {
            Object result = this.find(serviceType, null);
            if (result != null) {
                return result;
            }
            return this.delegate.find(serviceType);
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType);
            if (result == null) {
                throw new UnknownServiceException(serviceType, "No service of type " + serviceType + " available.");
            }
            return result;
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType, annotatedWith);
            if (result != null) {
                return result;
            }
            return this.delegate.get(serviceType, annotatedWith);
        }

        private static class InjectionPoint {
            private final Class<? extends Annotation> annotation;
            private final Type injectedType;
            private final Supplier<Object> valueToInject;

            public static InjectionPoint injectedByAnnotation(Class<? extends Annotation> annotation, Supplier<Object> valueToInject) {
                return new InjectionPoint(annotation, InjectionPoint.determineTypeFromAnnotation(annotation), valueToInject);
            }

            public static InjectionPoint injectedByAnnotation(Class<? extends Annotation> annotation, Type injectedType, Supplier<Object> valueToInject) {
                return new InjectionPoint(annotation, injectedType, valueToInject);
            }

            public static InjectionPoint injectedByType(Class<?> injectedType, Supplier<Object> valueToInject) {
                return new InjectionPoint(null, injectedType, valueToInject);
            }

            private InjectionPoint(@Nullable Class<? extends Annotation> annotation, Type injectedType, Supplier<Object> valueToInject) {
                this.annotation = annotation;
                this.injectedType = injectedType;
                this.valueToInject = valueToInject;
            }

            private static Class<?> determineTypeFromAnnotation(Class<? extends Annotation> annotation) {
                Class[] supportedTypes = annotation.getAnnotation(InjectionPointQualifier.class).supportedTypes();
                if (supportedTypes.length != 1) {
                    throw new IllegalArgumentException("Cannot determine supported type for annotation " + annotation.getName());
                }
                return supportedTypes[0];
            }

            @Nullable
            public Class<? extends Annotation> getAnnotation() {
                return this.annotation;
            }

            public Type getInjectedType() {
                return this.injectedType;
            }

            public Object getValueToInject() {
                return this.valueToInject.get();
            }
        }
    }
}

