/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntryContext;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.normalization.java.ApiClassExtractor;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbiExtractingClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbiExtractingClasspathResourceHasher.class);

    @Nullable
    private HashCode hashClassBytes(byte[] classBytes) {
        ApiClassExtractor extractor = new ApiClassExtractor(Collections.emptySet());
        ClassReader reader = new ClassReader(classBytes);
        return extractor.extractApiClassFrom(reader).map(Hashing::hashBytes).orElse(null);
    }

    @Override
    @Nullable
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        try {
            if (!this.isClassFile(fileSnapshot.getName())) {
                return null;
            }
            Path path = Paths.get(fileSnapshot.getAbsolutePath(), new String[0]);
            byte[] classBytes = Files.readAllBytes(path);
            return this.hashClassBytes(classBytes);
        }
        catch (Exception e) {
            LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)fileSnapshot.getName(), (Object)e);
            return fileSnapshot.getHash();
        }
    }

    @Override
    public HashCode hash(ZipEntryContext zipEntryContext) throws IOException {
        ZipEntry zipEntry = zipEntryContext.getEntry();
        if (!this.isClassFile(zipEntry.getName())) {
            return null;
        }
        byte[] content = zipEntry.getContent();
        return this.hashClassBytes(content);
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString((CharSequence)this.getClass().getName());
    }
}

