/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl;

import gnu.trove.TIntStack;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;

public class CollectHighlightsUtil {
    private static final ExtensionPointName<Condition<PsiElement>> EP_NAME = ExtensionPointName.create("org.jetbrains.kotlin.com.intellij.elementsToHighlightFilter");
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil");

    private CollectHighlightsUtil() {
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root2, int startOffset, int endOffset) {
        if (root2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(0);
        }
        return CollectHighlightsUtil.getElementsInRange(root2, startOffset, endOffset, false);
    }

    @NotNull
    public static List<PsiElement> getElementsInRange(@NotNull PsiElement root2, int startOffset, int endOffset, boolean includeAllParents) {
        PsiElement commonParent;
        if (root2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(1);
        }
        if ((commonParent = CollectHighlightsUtil.findCommonParent(root2, startOffset, endOffset)) == null) {
            return new ArrayList<PsiElement>();
        }
        List<PsiElement> list2 = CollectHighlightsUtil.getElementsToHighlight(commonParent, startOffset, endOffset);
        PsiElement parent2 = commonParent;
        while (parent2 != null && parent2 != root2) {
            list2.add(parent2);
            parent2 = includeAllParents ? parent2.getParent() : null;
        }
        list2.add(root2);
        List<PsiElement> list3 = list2;
        if (list3 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @NotNull
    private static List<PsiElement> getElementsToHighlight(@NotNull PsiElement parent2, int startOffset, int endOffset) {
        if (parent2 == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(3);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        int currentOffset = parent2.getTextRange().getStartOffset();
        Condition<PsiElement>[] filters = FiltersHolder.FILTERS;
        int offset2 = currentOffset;
        TIntStack starts2 = new TIntStack(100);
        Stack<PsiElement> elements = new Stack<PsiElement>(100);
        Stack<PsiElement> children2 = new Stack<PsiElement>(100);
        PsiElement element = parent2;
        PsiElement child = PsiUtilCore.NULL_PSI_ELEMENT;
        while (true) {
            boolean startChildrenVisiting;
            ProgressIndicatorProvider.checkCanceled();
            for (Condition<PsiElement> filter2 : filters) {
                if (filter2.value(element)) continue;
                assert (child == PsiUtilCore.NULL_PSI_ELEMENT);
                child = null;
                break;
            }
            if (child == PsiUtilCore.NULL_PSI_ELEMENT) {
                startChildrenVisiting = true;
                child = element.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child == null) {
                if (startChildrenVisiting) {
                    offset2 += element.getTextLength();
                }
                if (elements.isEmpty()) break;
                int start = starts2.pop();
                if (startOffset <= start && offset2 <= endOffset) {
                    assert (element != null);
                    assert (element != PsiUtilCore.NULL_PSI_ELEMENT);
                    result2.add(element);
                }
                element = (PsiElement)elements.pop();
                child = (PsiElement)children2.pop();
                continue;
            }
            if (offset2 > endOffset) break;
            children2.push(child.getNextSibling());
            starts2.push(offset2);
            assert (element != null);
            assert (element != PsiUtilCore.NULL_PSI_ELEMENT);
            elements.push(element);
            element = child;
            child = PsiUtilCore.NULL_PSI_ELEMENT;
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            CollectHighlightsUtil.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    public static PsiElement findCommonParent(PsiElement root2, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return null;
        }
        PsiElement left = CollectHighlightsUtil.findElementAtInRoot(root2, startOffset);
        PsiElement right = CollectHighlightsUtil.findElementAtInRoot(root2, endOffset - 1);
        if (left == null || right == null) {
            return null;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(left, right);
        if (commonParent == null) {
            LOG.error("No common parent for " + left + " and " + right + "; root: " + root2 + "; startOffset: " + startOffset + "; endOffset: " + endOffset);
        }
        LOG.assertTrue(commonParent.getTextRange() != null, commonParent);
        for (PsiElement parent2 = commonParent.getParent(); parent2 != null && commonParent.getTextRange().equals(parent2.getTextRange()); parent2 = parent2.getParent()) {
            commonParent = parent2;
        }
        return commonParent;
    }

    @Nullable
    private static PsiElement findElementAtInRoot(PsiElement root2, int offset2) {
        if (root2 instanceof PsiFile) {
            return ((PsiFile)root2).getViewProvider().findElementAt(offset2, root2.getLanguage());
        }
        return root2.findElementAt(offset2);
    }

    static /* synthetic */ ExtensionPointName access$000() {
        return EP_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/daemon/impl/CollectHighlightsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsInRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementsInRange";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToHighlight";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class FiltersHolder {
        static final Condition<PsiElement>[] FILTERS = (Condition[])CollectHighlightsUtil.access$000().getExtensions();
    }
}

