/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.DelegatingExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.ExcludeFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.Intersections;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.Optimizations;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.factories.Unions;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.CompositeExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeAllOf;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeAnyOf;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeEverything;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeNothing;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.GroupSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleIdSetExclude;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ModuleSetExclude;
import org.gradle.internal.Cast;

public class NormalizingExcludeFactory
extends DelegatingExcludeFactory {
    private final Intersections intersections = new Intersections(this);
    private final Unions unions = new Unions(this);

    public NormalizingExcludeFactory(ExcludeFactory delegate) {
        super(delegate);
    }

    @Override
    public ExcludeSpec anyOf(ExcludeSpec one, ExcludeSpec two) {
        return this.simplify(ExcludeAllOf.class, one, two, (left, right) -> this.doUnion((Set<ExcludeSpec>)ImmutableSet.of((Object)left, (Object)right)));
    }

    @Override
    public ExcludeSpec allOf(ExcludeSpec one, ExcludeSpec two) {
        return this.simplify(ExcludeAnyOf.class, one, two, (left, right) -> this.doIntersect((Set<ExcludeSpec>)ImmutableSet.of((Object)left, (Object)right)));
    }

    private ExcludeSpec simplify(Class<? extends CompositeExclude> clazz, ExcludeSpec one, ExcludeSpec two, BiFunction<ExcludeSpec, ExcludeSpec, ExcludeSpec> orElse) {
        if (clazz.isInstance(one) && this.componentsOf(one).contains(two)) {
            return two;
        }
        if (clazz.isInstance(two) && this.componentsOf(two).contains(one)) {
            return one;
        }
        return orElse.apply(one, two);
    }

    private Set<ExcludeSpec> simplifySet(Class<? extends CompositeExclude> clazz, Set<ExcludeSpec> specs) {
        if (specs.stream().noneMatch(clazz::isInstance)) {
            return specs;
        }
        ExcludeSpec[] asArray = specs.toArray(new ExcludeSpec[0]);
        boolean doDrop = false;
        block0: for (int i = 0; i < asArray.length; ++i) {
            ExcludeSpec excludeSpec = asArray[i];
            if (!clazz.isInstance(excludeSpec)) continue;
            Set<ExcludeSpec> components = this.componentsOf(excludeSpec);
            for (int j = 0; j < asArray.length; ++j) {
                if (i == j || !components.contains(asArray[j])) continue;
                doDrop = true;
                asArray[i] = null;
                continue block0;
            }
        }
        if (doDrop) {
            specs = Arrays.stream(asArray).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return specs;
    }

    private Set<ExcludeSpec> componentsOf(ExcludeSpec spec) {
        return ((CompositeExclude)spec).getComponents();
    }

    @Override
    public ExcludeSpec anyOf(Set<ExcludeSpec> specs) {
        return this.doUnion(specs);
    }

    @Override
    public ExcludeSpec allOf(Set<ExcludeSpec> specs) {
        return this.doIntersect(specs);
    }

    private ExcludeSpec doUnion(Set<ExcludeSpec> specs) {
        ExcludeSpec excludeSpec;
        specs = this.simplifySet(ExcludeAllOf.class, specs);
        FlattenOperationResult flattened = this.flatten(ExcludeAnyOf.class, specs, ExcludeEverything.class::isInstance, ExcludeNothing.class::isInstance);
        if (flattened.fastExit) {
            return this.everything();
        }
        if (flattened.result.isEmpty()) {
            return this.nothing();
        }
        Map<UnionOf, List<ExcludeSpec>> byType = flattened.result.stream().collect(Collectors.groupingBy(UnionOf::typeOf));
        List moduleIdExcludes = UnionOf.MODULEID.fromMap(byType);
        ImmutableList moduleIdSetsExcludes = UnionOf.MODULEID_SET.fromMap(byType);
        List groupExcludes = UnionOf.GROUP.fromMap(byType);
        ImmutableList groupSetExcludes = UnionOf.GROUP_SET.fromMap(byType);
        List moduleExcludes = UnionOf.MODULE.fromMap(byType);
        ImmutableList moduleSetExcludes = UnionOf.MODULE_SET.fromMap(byType);
        List other = UnionOf.NOT_JOINABLE.fromMap(byType);
        if (!(moduleIdExcludes.isEmpty() || moduleIdExcludes.size() <= 1 && moduleIdSetsExcludes.isEmpty())) {
            excludeSpec = this.delegate.moduleIdSet(moduleIdExcludes.stream().map(ModuleIdExclude::getModuleId).collect(Collectors.toSet()));
            if (moduleIdSetsExcludes.isEmpty()) {
                moduleIdSetsExcludes = ImmutableList.of((Object)excludeSpec);
            } else {
                moduleIdSetsExcludes.add(excludeSpec);
            }
            moduleIdExcludes = Collections.emptyList();
        }
        if (!(groupExcludes.isEmpty() || groupExcludes.size() <= 1 && groupSetExcludes.isEmpty())) {
            excludeSpec = this.delegate.groupSet(groupExcludes.stream().map(GroupExclude::getGroup).collect(Collectors.toSet()));
            if (groupSetExcludes.isEmpty()) {
                groupSetExcludes = ImmutableList.of((Object)excludeSpec);
            } else {
                groupSetExcludes.add(excludeSpec);
            }
            groupExcludes = Collections.emptyList();
        }
        if (!(moduleExcludes.isEmpty() || moduleExcludes.size() <= 1 && moduleSetExcludes.isEmpty())) {
            excludeSpec = this.delegate.moduleSet(moduleExcludes.stream().map(ModuleExclude::getModule).collect(Collectors.toSet()));
            if (moduleSetExcludes.isEmpty()) {
                moduleSetExcludes = ImmutableList.of((Object)excludeSpec);
            } else {
                moduleSetExcludes.add(excludeSpec);
            }
            moduleExcludes = Collections.emptyList();
        }
        if (moduleIdSetsExcludes.size() > 1) {
            moduleIdSetsExcludes = ImmutableList.of((Object)this.delegate.moduleIdSet(moduleIdSetsExcludes.stream().flatMap(e -> e.getModuleIds().stream()).collect(Collectors.toSet())));
        }
        if (groupSetExcludes.size() > 1) {
            groupSetExcludes = ImmutableList.of((Object)this.delegate.groupSet(groupSetExcludes.stream().flatMap(e -> e.getGroups().stream()).collect(Collectors.toSet())));
        }
        if (moduleSetExcludes.size() > 1) {
            moduleSetExcludes = ImmutableList.of((Object)this.delegate.moduleSet(moduleSetExcludes.stream().flatMap(e -> e.getModules().stream()).collect(Collectors.toSet())));
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)(moduleIdExcludes.size() + groupExcludes.size() + moduleExcludes.size() + moduleIdSetsExcludes.size() + groupSetExcludes.size() + moduleSetExcludes.size() + other.size()));
        builder.addAll(moduleIdExcludes);
        builder.addAll(groupExcludes);
        builder.addAll(moduleExcludes);
        builder.addAll((Iterable)moduleIdSetsExcludes);
        builder.addAll((Iterable)groupSetExcludes);
        builder.addAll((Iterable)moduleSetExcludes);
        builder.addAll(other);
        Object elements = builder.build();
        if (elements.size() > 1) {
            ExcludeSpec[] asArray = elements.toArray(new ExcludeSpec[0]);
            boolean simplified = false;
            for (int i = 0; i < asArray.length; ++i) {
                ExcludeSpec left = asArray[i];
                if (left == null) continue;
                for (int j = 0; j < asArray.length; ++j) {
                    ExcludeSpec merged;
                    ExcludeSpec right = asArray[j];
                    if (right == null || i == j || (merged = this.unions.tryUnion(left, right)) == null) continue;
                    if (merged instanceof ExcludeEverything) {
                        return merged;
                    }
                    left = merged;
                    asArray[i] = merged;
                    asArray[j] = null;
                    simplified = true;
                }
            }
            if (simplified) {
                elements = Arrays.stream(asArray).filter(Objects::nonNull).collect(Collectors.toSet());
            }
        }
        if (elements.size() == 2) {
            Iterator specIterator = elements.iterator();
            ExcludeSpec first = (ExcludeSpec)specIterator.next();
            ExcludeSpec second = (ExcludeSpec)specIterator.next();
            if (first instanceof ExcludeAnyOf || second instanceof ExcludeAnyOf) {
                ImmutableSet.Builder newBuilder = ImmutableSet.builder();
                if (first instanceof ExcludeAnyOf) {
                    newBuilder.addAll(((ExcludeAnyOf)first).getComponents());
                } else {
                    builder.add((Object)first);
                }
                if (second instanceof ExcludeAnyOf) {
                    newBuilder.addAll(((ExcludeAnyOf)second).getComponents());
                } else {
                    builder.add((Object)second);
                }
                elements = builder.build();
            }
        }
        return Optimizations.optimizeCollection(this, elements, this.delegate::anyOf);
    }

    private <T extends ExcludeSpec> FlattenOperationResult flatten(Class<T> flattenType, Set<ExcludeSpec> specs, Predicate<ExcludeSpec> fastExit, Predicate<ExcludeSpec> ignoreSpec) {
        boolean filtered = false;
        boolean flatten = false;
        int size = 0;
        for (ExcludeSpec spec : specs) {
            if (fastExit.test(spec)) {
                return FlattenOperationResult.FAST_EXIT;
            }
            if (ignoreSpec.test(spec)) {
                filtered = true;
                continue;
            }
            if (flattenType.isInstance(spec)) {
                flatten = true;
                size += ((CompositeExclude)spec).size();
                continue;
            }
            ++size;
        }
        if (!filtered && !flatten) {
            return FlattenOperationResult.of(specs);
        }
        if (filtered && !flatten) {
            return this.filterOnly(specs, ignoreSpec);
        }
        return this.expensiveFlatten(flattenType, this.maybeFilter(specs, ignoreSpec, filtered), size);
    }

    private FlattenOperationResult filterOnly(Set<ExcludeSpec> specs, Predicate<ExcludeSpec> ignoreSpec) {
        return FlattenOperationResult.of(specs.stream().filter(e -> !ignoreSpec.test((ExcludeSpec)e)).collect(Collectors.toSet()));
    }

    private Stream<ExcludeSpec> maybeFilter(Set<ExcludeSpec> specs, Predicate<ExcludeSpec> ignoreSpec, boolean filtered) {
        Stream<ExcludeSpec> stream = specs.stream();
        if (filtered) {
            stream = stream.filter(e -> !ignoreSpec.test((ExcludeSpec)e));
        }
        return stream;
    }

    private <T extends ExcludeSpec> FlattenOperationResult expensiveFlatten(Class<T> flattenType, Stream<ExcludeSpec> stream, int size) {
        return FlattenOperationResult.of(stream.flatMap(e -> {
            if (flattenType.isInstance(e)) {
                CompositeExclude compositeExclude = (CompositeExclude)e;
                return compositeExclude.components();
            }
            return Stream.of(e);
        }).collect(Collectors.toCollection(() -> Sets.newHashSetWithExpectedSize((int)size))));
    }

    private ExcludeSpec doIntersect(Set<ExcludeSpec> specs) {
        specs = this.simplifySet(ExcludeAnyOf.class, specs);
        FlattenOperationResult flattened = this.flatten(ExcludeAllOf.class, specs, ExcludeNothing.class::isInstance, ExcludeEverything.class::isInstance);
        if (flattened.fastExit) {
            return this.nothing();
        }
        Set<ExcludeSpec> result = flattened.result;
        if (result.isEmpty()) {
            return this.everything();
        }
        if (result.size() > 1) {
            ExcludeSpec[] asArray = result.toArray(new ExcludeSpec[0]);
            boolean simplified = false;
            for (int i = 0; i < asArray.length; ++i) {
                ExcludeSpec left = asArray[i];
                if (left == null) continue;
                for (int j = 0; j < asArray.length; ++j) {
                    ExcludeSpec merged;
                    ExcludeSpec right = asArray[j];
                    if (right == null || i == j || (merged = this.intersections.tryIntersect(left, right)) == null) continue;
                    if (merged instanceof ExcludeNothing) {
                        return merged;
                    }
                    left = merged;
                    asArray[i] = merged;
                    asArray[j] = null;
                    simplified = true;
                }
            }
            if (simplified) {
                result = Arrays.stream(asArray).filter(Objects::nonNull).collect(Collectors.toSet());
            }
        }
        return Optimizations.optimizeCollection(this, result, this.delegate::allOf);
    }

    private static class FlattenOperationResult {
        private static final FlattenOperationResult FAST_EXIT = new FlattenOperationResult(null, true);
        private final Set<ExcludeSpec> result;
        private final boolean fastExit;

        private FlattenOperationResult(Set<ExcludeSpec> result, boolean fastExit) {
            this.result = result;
            this.fastExit = fastExit;
        }

        public static FlattenOperationResult of(Set<ExcludeSpec> specs) {
            return new FlattenOperationResult(specs, false);
        }
    }

    private static enum UnionOf {
        MODULEID(ModuleIdExclude.class),
        GROUP(GroupExclude.class),
        MODULE(ModuleExclude.class),
        MODULEID_SET(ModuleIdSetExclude.class),
        GROUP_SET(GroupSetExclude.class),
        MODULE_SET(ModuleSetExclude.class),
        NOT_JOINABLE(ExcludeSpec.class);

        private final Class<? extends ExcludeSpec> excludeClass;

        private UnionOf(Class<? extends ExcludeSpec> excludeClass) {
            this.excludeClass = excludeClass;
        }

        public <T extends ExcludeSpec> List<T> fromMap(Map<UnionOf, List<ExcludeSpec>> from) {
            return (List)Cast.uncheckedCast(from.getOrDefault((Object)this, Collections.emptyList()));
        }

        public static UnionOf typeOf(ExcludeSpec spec) {
            for (UnionOf unionOf : UnionOf.values()) {
                if (!unionOf.excludeClass.isInstance(spec)) continue;
                return unionOf;
            }
            return null;
        }
    }
}

