/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.repositories.AbstractResolutionAwareArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.AuthenticationSupporter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.internal.Cast;
import org.gradle.internal.artifacts.repositories.AuthenticationSupportedInternal;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.CollectionUtils;

public abstract class AbstractAuthenticationSupportedRepository
extends AbstractResolutionAwareArtifactRepository
implements AuthenticationSupportedInternal {
    private final AuthenticationSupporter delegate;
    private final ProviderFactory providerFactory;

    AbstractAuthenticationSupportedRepository(Instantiator instantiator, AuthenticationContainer authenticationContainer, ObjectFactory objectFactory, ProviderFactory providerFactory, FeaturePreviews featurePreviews) {
        super(objectFactory, featurePreviews);
        this.delegate = new AuthenticationSupporter(instantiator, objectFactory, authenticationContainer, providerFactory);
        this.providerFactory = providerFactory;
    }

    public PasswordCredentials getCredentials() {
        this.invalidateDescriptor();
        return this.delegate.getCredentials();
    }

    public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
        this.invalidateDescriptor();
        return this.delegate.getCredentials(credentialsType);
    }

    public Property<Credentials> getConfiguredCredentials() {
        return this.delegate.getConfiguredCredentials();
    }

    public void setConfiguredCredentials(Credentials credentials) {
        this.invalidateDescriptor();
        this.delegate.setConfiguredCredentials(credentials);
    }

    public void credentials(Action<? super PasswordCredentials> action) {
        this.invalidateDescriptor();
        this.delegate.credentials(action);
    }

    public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) throws IllegalStateException {
        this.invalidateDescriptor();
        this.delegate.credentials(credentialsType, action);
    }

    public void credentials(Class<? extends Credentials> credentialsType) {
        this.invalidateDescriptor();
        this.delegate.credentials(credentialsType, (Provider<String>)this.providerFactory.provider(this::getName));
    }

    public void authentication(Action<? super AuthenticationContainer> action) {
        this.invalidateDescriptor();
        this.delegate.authentication(action);
    }

    public AuthenticationContainer getAuthentication() {
        this.invalidateDescriptor();
        return this.delegate.getAuthentication();
    }

    public Collection<Authentication> getConfiguredAuthentication() {
        Collection<Authentication> configuredAuthentication = this.delegate.getConfiguredAuthentication();
        for (Authentication authentication : configuredAuthentication) {
            AuthenticationInternal authenticationInternal = (AuthenticationInternal)authentication;
            for (URI repositoryUrl : this.getRepositoryUrls()) {
                if (!repositoryUrl.getScheme().startsWith("http")) continue;
                authenticationInternal.addHost(repositoryUrl.getHost(), repositoryUrl.getPort());
            }
        }
        return configuredAuthentication;
    }

    protected Collection<URI> getRepositoryUrls() {
        return Collections.emptyList();
    }

    List<String> getAuthenticationSchemes() {
        return CollectionUtils.collect(this.getConfiguredAuthentication(), authentication -> ((AuthenticationInternal)Cast.cast(AuthenticationInternal.class, (Object)authentication)).getType().getSimpleName());
    }

    boolean usesCredentials() {
        return this.delegate.usesCredentials();
    }
}

