/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.verifier;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;

public class DependencyVerificationConfiguration {
    private final boolean verifyMetadata;
    private final boolean verifySignatures;
    private final List<TrustedArtifact> trustedArtifacts;
    private final List<URI> keyServers;
    private final Set<IgnoredKey> ignoredKeys;
    private final List<TrustedKey> trustedKeys;

    public DependencyVerificationConfiguration(boolean verifyMetadata, boolean verifySignatures, List<TrustedArtifact> trustedArtifacts, List<URI> keyServers, Set<IgnoredKey> ignoredKeys, List<TrustedKey> trustedKeys) {
        this.verifyMetadata = verifyMetadata;
        this.verifySignatures = verifySignatures;
        this.trustedArtifacts = ImmutableList.copyOf(trustedArtifacts);
        this.keyServers = keyServers;
        this.ignoredKeys = ignoredKeys;
        this.trustedKeys = trustedKeys;
    }

    public boolean isVerifySignatures() {
        return this.verifySignatures;
    }

    public boolean isVerifyMetadata() {
        return this.verifyMetadata;
    }

    public List<TrustedArtifact> getTrustedArtifacts() {
        return this.trustedArtifacts;
    }

    public List<URI> getKeyServers() {
        return this.keyServers;
    }

    public Set<IgnoredKey> getIgnoredKeys() {
        return this.ignoredKeys;
    }

    public List<TrustedKey> getTrustedKeys() {
        return this.trustedKeys;
    }

    public static class TrustedKey
    extends TrustCoordinates {
        private final String keyId;

        TrustedKey(String keyId, @Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex) {
            super(group, name, version, fileName, regex);
            this.keyId = keyId;
        }

        public String getKeyId() {
            return this.keyId;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TrustedKey that = (TrustedKey)o;
            return this.keyId.equals(that.keyId);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.keyId.hashCode();
            return result;
        }
    }

    public static class TrustedArtifact
    extends TrustCoordinates {
        TrustedArtifact(@Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex) {
            super(group, name, version, fileName, regex);
        }
    }

    public static abstract class TrustCoordinates {
        private final String group;
        private final String name;
        private final String version;
        private final String fileName;
        private final boolean regex;

        TrustCoordinates(@Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex) {
            this.group = group;
            this.name = name;
            this.version = version;
            this.fileName = fileName;
            this.regex = regex;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isRegex() {
            return this.regex;
        }

        public boolean matches(ModuleComponentArtifactIdentifier id) {
            ModuleComponentIdentifier moduleComponentIdentifier = id.getComponentIdentifier();
            return this.matches(this.group, moduleComponentIdentifier.getGroup()) && this.matches(this.name, moduleComponentIdentifier.getModule()) && this.matches(this.version, moduleComponentIdentifier.getVersion()) && this.matches(this.fileName, id.getFileName());
        }

        private boolean matches(@Nullable String value, String expr) {
            if (value == null) {
                return true;
            }
            if (!this.regex) {
                return expr.equals(value);
            }
            return expr.matches(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrustCoordinates that = (TrustCoordinates)o;
            if (this.regex != that.regex) {
                return false;
            }
            if (!Objects.equals(this.group, that.group)) {
                return false;
            }
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            if (!Objects.equals(this.version, that.version)) {
                return false;
            }
            return Objects.equals(this.fileName, that.fileName);
        }

        public int hashCode() {
            int result = this.group != null ? this.group.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
            result = 31 * result + (this.regex ? 1 : 0);
            return result;
        }
    }
}

