/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.filestore.ArtifactIdentifierFileStore;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.file.FileAccessTracker;
import org.gradle.internal.resource.local.FileStoreException;
import org.gradle.internal.resource.local.LocallyAvailableResource;

public class TwoStageArtifactIdentifierFileStore
implements ArtifactIdentifierFileStore {
    private final ArtifactIdentifierFileStore readOnlyStore;
    private final ArtifactIdentifierFileStore writableStore;
    private final FileAccessTracker fileAccessTracker;

    public TwoStageArtifactIdentifierFileStore(ArtifactIdentifierFileStore readOnlyStore, ArtifactIdentifierFileStore writableStore) {
        this.readOnlyStore = readOnlyStore;
        this.writableStore = writableStore;
        this.fileAccessTracker = new DelegatingFileAccessTracker();
    }

    @Override
    public File whereIs(ModuleComponentArtifactIdentifier artifactId, String checksum) {
        File file = this.writableStore.whereIs(artifactId, checksum);
        if (file.exists()) {
            return file;
        }
        return this.readOnlyStore.whereIs(artifactId, checksum);
    }

    @Override
    public FileAccessTracker getFileAccessTracker() {
        return this.fileAccessTracker;
    }

    public LocallyAvailableResource move(ModuleComponentArtifactIdentifier key, File source) throws FileStoreException {
        return this.writableStore.move(key, source);
    }

    public LocallyAvailableResource add(ModuleComponentArtifactIdentifier key, Action<File> addAction) throws FileStoreException {
        return this.writableStore.add(key, addAction);
    }

    public Set<? extends LocallyAvailableResource> search(ModuleComponentArtifactIdentifier key) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)this.writableStore.search(key));
        builder.addAll((Iterable)this.readOnlyStore.search(key));
        return builder.build();
    }

    private class DelegatingFileAccessTracker
    implements FileAccessTracker {
        private DelegatingFileAccessTracker() {
        }

        public void markAccessed(File file) {
            TwoStageArtifactIdentifierFileStore.this.readOnlyStore.getFileAccessTracker().markAccessed(file);
            TwoStageArtifactIdentifierFileStore.this.writableStore.getFileAccessTracker().markAccessed(file);
        }

        public void markAccessed(Collection<File> files) {
            TwoStageArtifactIdentifierFileStore.this.readOnlyStore.getFileAccessTracker().markAccessed(files);
            TwoStageArtifactIdentifierFileStore.this.writableStore.getFileAccessTracker().markAccessed(files);
        }
    }
}

