/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive.impl;

import com.google.common.base.Supplier;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.internal.file.archive.ZipEntry;

class JdkZipEntry
implements ZipEntry {
    private final java.util.zip.ZipEntry entry;
    private final Supplier<InputStream> inputStreamSupplier;

    public JdkZipEntry(java.util.zip.ZipEntry entry, Supplier<InputStream> inputStreamSupplier) {
        this.entry = entry;
        this.inputStreamSupplier = inputStreamSupplier;
    }

    @Override
    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    @Override
    public String getName() {
        return this.entry.getName();
    }

    @Override
    public byte[] getContent() throws IOException {
        int size = this.size();
        if (size >= 0) {
            byte[] content = new byte[size];
            ByteStreams.readFully((InputStream)this.getInputStream(), (byte[])content);
            return content;
        }
        return ByteStreams.toByteArray((InputStream)this.getInputStream());
    }

    @Override
    public InputStream getInputStream() {
        return (InputStream)this.inputStreamSupplier.get();
    }

    @Override
    public int size() {
        return (int)this.entry.getSize();
    }
}

