/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileFactory;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmMetadataDetector;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.jvm.toolchain.JavaDevelopmentKit;
import org.gradle.jvm.toolchain.JavaInstallation;
import org.gradle.jvm.toolchain.JavaInstallationRegistry;

@ServiceScope(value=Scopes.Build.class)
public class DefaultJavaInstallationRegistry
implements JavaInstallationRegistry {
    private final JvmMetadataDetector metadataDetector;
    private final ProviderFactory providerFactory;
    private final FileCollectionFactory fileCollectionFactory;
    private final FileFactory fileFactory;

    public DefaultJavaInstallationRegistry(JvmMetadataDetector metadataDetector, ProviderFactory providerFactory, FileCollectionFactory fileCollectionFactory, FileFactory fileFactory) {
        this.metadataDetector = metadataDetector;
        this.providerFactory = providerFactory;
        this.fileCollectionFactory = fileCollectionFactory;
        this.fileFactory = fileFactory;
    }

    @Override
    public Provider<JavaInstallation> getInstallationForCurrentVirtualMachine() {
        this.warnAboutDeprecation();
        return Providers.of((Object)new DefaultJavaInstallation(this.metadataDetector.getMetadata(Jvm.current().getJavaHome()), this.fileCollectionFactory, this.fileFactory));
    }

    @Override
    public Provider<JavaInstallation> installationForDirectory(final Directory javaHomeDir) {
        this.warnAboutDeprecation();
        return this.providerFactory.provider((Callable)new Callable<JavaInstallation>(){
            private DefaultJavaInstallation value;

            @Override
            public JavaInstallation call() {
                if (this.value == null) {
                    try {
                        if (!javaHomeDir.getAsFile().exists()) {
                            throw new FileNotFoundException(String.format("Directory %s does not exist.", javaHomeDir.getAsFile()));
                        }
                        this.value = new DefaultJavaInstallation(DefaultJavaInstallationRegistry.this.metadataDetector.getMetadata(javaHomeDir.getAsFile()), DefaultJavaInstallationRegistry.this.fileCollectionFactory, DefaultJavaInstallationRegistry.this.fileFactory);
                    }
                    catch (Exception e) {
                        throw new JavaInstallationDiscoveryException(String.format("Could not determine the details of Java installation in directory %s.", javaHomeDir), e);
                    }
                }
                return this.value;
            }
        });
    }

    @Override
    public Provider<JavaInstallation> installationForDirectory(Provider<Directory> installationDirectory) {
        this.warnAboutDeprecation();
        return installationDirectory.flatMap(this::installationForDirectory);
    }

    private void warnAboutDeprecation() {
        DeprecationLogger.deprecate((String)"Using JavaInstallationRegistry to detect Java installations").withAdvice("Consider using Java Toolchains instead.").willBeRemovedInGradle7().withUserManual("toolchains").nagUser();
    }

    private static class DefaultJavaInstallation
    implements JavaInstallation {
        private final Jvm jvm;
        private final String implementationName;
        private final FileCollectionFactory fileCollectionFactory;
        private final FileFactory fileFactory;

        public DefaultJavaInstallation(JvmInstallationMetadata metadata, FileCollectionFactory fileCollectionFactory, FileFactory fileFactory) {
            this.jvm = Jvm.discovered((File)metadata.getJavaHome().toFile(), (String)metadata.getImplementationVersion(), (JavaVersion)metadata.getLanguageVersion());
            this.implementationName = metadata.getDisplayName();
            this.fileCollectionFactory = fileCollectionFactory;
            this.fileFactory = fileFactory;
        }

        @Override
        public JavaVersion getJavaVersion() {
            return this.jvm.getJavaVersion();
        }

        @Override
        public Directory getInstallationDirectory() {
            return this.fileFactory.dir(this.jvm.getJavaHome());
        }

        @Override
        public RegularFile getJavaExecutable() {
            return this.fileFactory.file(this.jvm.getJavaExecutable());
        }

        @Override
        public String getImplementationName() {
            return this.implementationName;
        }

        @Override
        public Optional<JavaDevelopmentKit> getJdk() {
            if (this.jvm.isJdk()) {
                return Optional.of(new JavaDevelopmentKit(){

                    @Override
                    public RegularFile getJavacExecutable() {
                        return fileFactory.file(jvm.getJavacExecutable());
                    }

                    @Override
                    public RegularFile getJavadocExecutable() {
                        return fileFactory.file(jvm.getJavadocExecutable());
                    }

                    @Override
                    public FileCollection getToolsClasspath() {
                        File toolsJar = jvm.getToolsJar();
                        if (toolsJar != null) {
                            return fileCollectionFactory.fixed(new File[]{toolsJar});
                        }
                        return fileCollectionFactory.empty();
                    }
                });
            }
            return Optional.empty();
        }
    }

    @Contextual
    public static class JavaInstallationDiscoveryException
    extends GradleException {
        public JavaInstallationDiscoveryException(String message, @Nullable Throwable cause) {
            super(message, cause);
        }
    }
}

