/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeJdomFactory;
import org.jetbrains.kotlin.com.intellij.openapi.util.SafeStAXStreamBuilder;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;
import org.jetbrains.kotlin.com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.kotlin.org.jdom.Attribute;
import org.jetbrains.kotlin.org.jdom.Content;
import org.jetbrains.kotlin.org.jdom.Element;
import org.jetbrains.kotlin.org.jdom.JDOMException;
import org.jetbrains.kotlin.org.jdom.Namespace;
import org.jetbrains.kotlin.org.jdom.Text;
import org.jetbrains.kotlin.org.jdom.filter.Filter;
import org.jetbrains.kotlin.org.jdom.output.Format;
import org.jetbrains.kotlin.org.jdom.output.XMLOutputter;

public final class JDOMUtil {
    private static final Predicate<Attribute> NOT_EMPTY_VALUE_CONDITION = attribute -> !StringUtil.isEmpty(attribute.getValue());
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");
    private static volatile XMLInputFactory XML_INPUT_FACTORY;
    private static final EmptyTextFilter CONTENT_FILTER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory factory2 = XML_INPUT_FACTORY;
        if (factory2 != null) {
            return factory2;
        }
        Class<JDOMUtil> clazz = JDOMUtil.class;
        synchronized (JDOMUtil.class) {
            factory2 = XML_INPUT_FACTORY;
            if (factory2 != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return factory2;
            }
            String property2 = System.setProperty("javax.xml.stream.XMLInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl");
            try {
                factory2 = XMLInputFactory.newFactory();
            }
            finally {
                if (property2 != null) {
                    System.setProperty("javax.xml.stream.XMLInputFactory", property2);
                } else {
                    System.clearProperty("javax.xml.stream.XMLInputFactory");
                }
            }
            if (!SystemInfo.isIbmJvm) {
                try {
                    factory2.setProperty("http://java.sun.com/xml/stream/properties/report-cdata-event", true);
                }
                catch (Exception e) {
                    JDOMUtil.getLogger().error("cannot set \"report-cdata-event\" property for XMLInputFactory", e);
                }
            }
            factory2.setProperty("javax.xml.stream.isCoalescing", true);
            factory2.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            factory2.setProperty("javax.xml.stream.supportDTD", false);
            XML_INPUT_FACTORY = factory2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return factory2;
        }
    }

    private JDOMUtil() {
    }

    private static Logger getLogger() {
        return LoggerHolder.ourLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull Reader reader, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (reader == null) {
            JDOMUtil.$$$reportNull$$$0(19);
        }
        XMLStreamReader xmlStreamReader = JDOMUtil.getXmlInputFactory().createXMLStreamReader(reader);
        Element element = SafeStAXStreamBuilder.build(xmlStreamReader, true, factory2 == null ? SafeStAXStreamBuilder.FACTORY : factory2);
        xmlStreamReader.close();
        Element element2 = element;
        if (element2 == null) {
            JDOMUtil.$$$reportNull$$$0(20);
        }
        return element2;
        {
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
        }
        finally {
            reader.close();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull Path file2, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (file2 == null) {
            JDOMUtil.$$$reportNull$$$0(29);
        }
        return JDOMUtil.loadUsingStaX(new InputStreamReader(CharsetToolkit.inputStreamSkippingBOM(new BufferedInputStream(Files.newInputStream(file2, new OpenOption[0]))), StandardCharsets.UTF_8), factory2);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.load(stream, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull InputStream stream, @Nullable SafeJdomFactory factory2) throws JDOMException, IOException {
        if (stream == null) {
            JDOMUtil.$$$reportNull$$$0(31);
        }
        return JDOMUtil.loadUsingStaX(new InputStreamReader(stream, StandardCharsets.UTF_8), factory2);
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(66);
        }
        JDOMUtil.writeElement(element, writer, JDOMUtil.createOutputter(lineSeparator));
    }

    public static void writeElement(@NotNull Element element, @NotNull Writer writer, @NotNull XMLOutputter xmlOutputter) throws IOException {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(67);
        }
        if (writer == null) {
            JDOMUtil.$$$reportNull$$$0(68);
        }
        if (xmlOutputter == null) {
            JDOMUtil.$$$reportNull$$$0(69);
        }
        try {
            xmlOutputter.output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(70);
        }
        return JDOMUtil.writeElement(element, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        String string2;
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(71);
        }
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeElement(element, (Writer)writer, lineSeparator);
            string2 = writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(72);
        }
        return string2;
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        Format format = Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setEncoding("UTF-8").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator(lineSeparator);
        if (format == null) {
            JDOMUtil.$$$reportNull$$$0(78);
        }
        return format;
    }

    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        return new MyXMLOutputter(JDOMUtil.createFormat(lineSeparator));
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(80);
        }
        return JDOMUtil.escapeText(text2, false, escapeSpaces, escapeLineEnds);
    }

    @NotNull
    public static String escapeText(@NotNull String text2, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        if (text2 == null) {
            JDOMUtil.$$$reportNull$$$0(81);
        }
        StringBuilder buffer = null;
        for (int i = 0; i < text2.length(); ++i) {
            char ch = text2.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text2, buffer, i, quotation, ch);
        }
        String string2 = buffer == null ? text2 : buffer.toString();
        if (string2 == null) {
            JDOMUtil.$$$reportNull$$$0(82);
        }
        return string2;
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(83);
        }
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        if (element == null) {
            JDOMUtil.$$$reportNull$$$0(84);
        }
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        return new ElementInfo(buf, hasNullAttributes);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || !element.hasAttributes() && element.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        if (e == null) {
            JDOMUtil.$$$reportNull$$$0(88);
        }
        List<Attribute> list2 = e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
        if (list2 == null) {
            JDOMUtil.$$$reportNull$$$0(89);
        }
        return list2;
    }

    static {
        CONTENT_FILTER = new EmptyTextFilter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 1: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l1";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l2";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 30: 
            case 31: 
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resource";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 41: 
            case 43: 
            case 56: 
            case 61: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 58: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 70: 
            case 71: 
            case 73: 
            case 83: 
            case 84: 
            case 93: 
            case 97: 
            case 100: 
            case 102: 
            case 107: 
            case 110: 
            case 112: 
            case 117: 
            case 122: 
            case 124: 
            case 133: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 55: 
            case 60: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
            case 68: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlOutputter";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFiles";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFilePaths";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileDocuments";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 98: 
            case 103: 
            case 118: 
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 99: 
            case 104: 
            case 119: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "y";
                break;
            }
            case 101: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 108: 
            case 113: 
            case 120: 
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "width";
                break;
            }
            case 109: 
            case 114: 
            case 121: 
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "height";
                break;
            }
            case 111: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 123: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "legalizeChars";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDocumentUsingStaX";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "loadUsingStaX";
                break;
            }
            case 23: 
            case 34: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "loadResource";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "writeDocument";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "write";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "writeElement";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "writeChildren";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "createFormat";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeText";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "deepMerge";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "internElement";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "removeControlChars";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocation";
                break;
            }
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "setSize";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "setBounds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "areElementContentsEqual";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "legalizeText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "legalizeChars";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendLegalized";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAttributesEqual";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attEqual";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadDocumentUsingStaX";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadUsingStaX";
                break;
            }
            case 21: 
            case 24: 
            case 25: 
            case 30: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadDocument";
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "loadResourceDocument";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "loadResource";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 56: 
            case 57: 
            case 61: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "writeDocument";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 59: 
            case 60: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "writeElement";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "writeChildren";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "escapeText";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "printDiagnostics";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "updateFileSet";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "deepMerge";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "internElement";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "removeControlChars";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "getSize";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "getBounds";
                break;
            }
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "setBounds";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "copyMissingContent";
                break;
            }
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "hasContent";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 90: 
            case 91: 
            case 93: 
            case 95: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ElementInfo {
        @NotNull
        final CharSequence name;
        final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            if (name == null) {
                ElementInfo.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.hasNullAttributes = attributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$ElementInfo", "<init>"));
        }
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        MyXMLOutputter(@NotNull Format format) {
            if (format == null) {
                MyXMLOutputter.$$$reportNull$$$0(0);
            }
            super(format);
        }

        @Override
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(1);
            }
            String string2 = JDOMUtil.escapeText(str, false, true);
            if (string2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Override
        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            if (str == null) {
                MyXMLOutputter.$$$reportNull$$$0(3);
            }
            String string2 = JDOMUtil.escapeText(str, false, false);
            if (string2 == null) {
                MyXMLOutputter.$$$reportNull$$$0(4);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "format";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/JDOMUtil$MyXMLOutputter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeAttributeEntities";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "escapeElementEntities";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeAttributeEntities";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "escapeElementEntities";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class EmptyTextFilter
    implements Filter<Content> {
        private EmptyTextFilter() {
        }

        @Override
        public boolean matches(Object obj) {
            return !(obj instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)obj).getText());
        }
    }

    private static class LoggerHolder {
        private static final Logger ourLogger = Logger.getInstance(JDOMUtil.class);
    }
}

