/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.LatestModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ProjectDependencyForcingResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;

public class ConflictResolverFactory {
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;
    private final FeaturePreviews featurePreviews;

    public ConflictResolverFactory(VersionComparator versionComparator, VersionParser versionParser, FeaturePreviews featurePreviews) {
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.featurePreviews = featurePreviews;
    }

    public ModuleConflictResolver<ComponentState> createConflictResolver(ConflictResolution conflictResolution) {
        boolean releaseBias = true;
        if (this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.VERSION_ORDERING_V2)) {
            releaseBias = false;
        }
        ModuleConflictResolver<ComponentState> conflictResolver = new LatestModuleConflictResolver<ComponentState>(this.versionComparator, this.versionParser, releaseBias);
        if (conflictResolution == ConflictResolution.preferProjectModules) {
            conflictResolver = new ProjectDependencyForcingResolver<ComponentState>(conflictResolver);
        }
        return conflictResolver;
    }
}

