/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.launcher.exec.DefaultBuildActionParameters;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.provider.BuildModelAction;
import org.gradle.tooling.internal.provider.ConnectionOperationParameters;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

public class DaemonBuildActionExecuter
implements BuildActionExecuter<ConnectionOperationParameters, BuildRequestContext> {
    private final BuildActionExecuter<BuildActionParameters, BuildRequestContext> executer;

    public DaemonBuildActionExecuter(BuildActionExecuter<BuildActionParameters, BuildRequestContext> executer) {
        this.executer = executer;
    }

    @Override
    public BuildActionResult execute(BuildAction action, ConnectionOperationParameters parameters, BuildRequestContext buildRequestContext) {
        boolean continuous = action.getStartParameter() != null && action.getStartParameter().isContinuous() && this.isNotBuildingModel(action);
        ProviderOperationParameters operationParameters = parameters.getOperationParameters();
        ClassPath classPath = DefaultClassPath.of(operationParameters.getInjectedPluginClasspath());
        DaemonParameters daemonParameters = parameters.getDaemonParameters();
        DefaultBuildActionParameters actionParameters = new DefaultBuildActionParameters(daemonParameters.getEffectiveSystemProperties(), daemonParameters.getEnvironmentVariables(), SystemProperties.getInstance().getCurrentDir(), operationParameters.getBuildLogLevel(), daemonParameters.isEnabled(), continuous, classPath);
        return this.executer.execute(action, actionParameters, buildRequestContext);
    }

    private boolean isNotBuildingModel(BuildAction action) {
        if (!(action instanceof BuildModelAction)) {
            return true;
        }
        String modelName = ((BuildModelAction)action).getModelName();
        return modelName.equals(ModelIdentifier.NULL_MODEL);
    }
}

