/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.basic;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.codehaus.plexus.component.configurator.converters.basic.AbstractBasicConverter;

public class DateConverter
extends AbstractBasicConverter {
    private static final DateFormat[] formats = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S a"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ssa")};

    @Override
    public boolean canConvert(Class type) {
        return type.equals(Date.class);
    }

    @Override
    public Object fromString(String str) {
        for (DateFormat format : formats) {
            try {
                return format.parse(str);
            }
            catch (ParseException e) {
            }
        }
        return null;
    }

    public String toString(Object obj) {
        Date date = (Date)obj;
        return formats[0].format(date);
    }
}

