/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.tasks;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.CiManagement;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.IssueManagement;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Relocation;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.MavenDependency;
import org.gradle.api.publish.maven.MavenPomCiManagement;
import org.gradle.api.publish.maven.MavenPomContributor;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomMailingList;
import org.gradle.api.publish.maven.MavenPomOrganization;
import org.gradle.api.publish.maven.MavenPomRelocation;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.dependencies.VersionRangeMapper;
import org.gradle.api.publish.maven.internal.publication.MavenPomDistributionManagementInternal;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenProjectIdentity;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.util.GUtil;

public class MavenPomFileGenerator {
    private static final String POM_FILE_ENCODING = "UTF-8";
    private static final String POM_VERSION = "4.0.0";
    private static final Action<XmlProvider> ADD_GRADLE_METADATA_MARKER = new Action<XmlProvider>(){

        public void execute(XmlProvider xmlProvider) {
            StringBuilder builder = xmlProvider.asString();
            int idx = builder.indexOf("<modelVersion");
            builder.insert(idx, MavenPomFileGenerator.xmlComments(MetaDataParser.GRADLE_METADATA_MARKER_COMMENT_LINES) + "  " + MavenPomFileGenerator.xmlComment("do_not_remove: published-with-gradle-metadata") + "  ");
        }
    };
    private final Model model = new Model();
    private final XmlTransformer xmlTransformer = new XmlTransformer();
    private final VersionRangeMapper versionRangeMapper;
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private final ImmutableAttributes compileScopeAttributes;
    private final ImmutableAttributes runtimeScopeAttributes;

    public MavenPomFileGenerator(MavenProjectIdentity identity, VersionRangeMapper versionRangeMapper, VersionMappingStrategyInternal versionMappingStrategy, ImmutableAttributes compileScopeAttributes, ImmutableAttributes runtimeScopeAttributes, boolean gradleMetadataMarker) {
        this.versionRangeMapper = versionRangeMapper;
        this.versionMappingStrategy = versionMappingStrategy;
        this.compileScopeAttributes = compileScopeAttributes;
        this.runtimeScopeAttributes = runtimeScopeAttributes;
        this.model.setModelVersion(POM_VERSION);
        this.model.setGroupId((String)identity.getGroupId().get());
        this.model.setArtifactId((String)identity.getArtifactId().get());
        this.model.setVersion((String)identity.getVersion().get());
        if (gradleMetadataMarker) {
            this.xmlTransformer.addFinalizer(ADD_GRADLE_METADATA_MARKER);
        }
    }

    private static String xmlComments(String[] lines) {
        return Joiner.on((String)"  ").join(Iterables.transform(Arrays.asList(lines), MavenPomFileGenerator::xmlComment));
    }

    private static String xmlComment(String content) {
        return "<!-- " + content + " -->\n";
    }

    public MavenPomFileGenerator configureFrom(MavenPomInternal pom) {
        this.model.setPackaging(pom.getPackaging());
        this.model.setName((String)pom.getName().getOrNull());
        this.model.setDescription((String)pom.getDescription().getOrNull());
        this.model.setUrl((String)pom.getUrl().getOrNull());
        this.model.setInceptionYear((String)pom.getInceptionYear().getOrNull());
        if (pom.getOrganization() != null) {
            this.model.setOrganization(this.convertOrganization(pom.getOrganization()));
        }
        if (pom.getScm() != null) {
            this.model.setScm(this.convertScm(pom.getScm()));
        }
        if (pom.getIssueManagement() != null) {
            this.model.setIssueManagement(this.convertIssueManagement(pom.getIssueManagement()));
        }
        if (pom.getCiManagement() != null) {
            this.model.setCiManagement(this.convertCiManagement(pom.getCiManagement()));
        }
        if (pom.getDistributionManagement() != null) {
            this.model.setDistributionManagement(this.convertDistributionManagement(pom.getDistributionManagement()));
        }
        for (MavenPomLicense mavenPomLicense : pom.getLicenses()) {
            this.model.addLicense(this.convertLicense(mavenPomLicense));
        }
        for (MavenPomDeveloper mavenPomDeveloper : pom.getDevelopers()) {
            this.model.addDeveloper(this.convertDeveloper(mavenPomDeveloper));
        }
        for (MavenPomContributor mavenPomContributor : pom.getContributors()) {
            this.model.addContributor(this.convertContributor(mavenPomContributor));
        }
        for (MavenPomMailingList mavenPomMailingList : pom.getMailingLists()) {
            this.model.addMailingList(this.convertMailingList(mavenPomMailingList));
        }
        for (Map.Entry entry : ((Map)pom.getProperties().get()).entrySet()) {
            this.model.addProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private Organization convertOrganization(MavenPomOrganization source) {
        Organization target = new Organization();
        target.setName((String)source.getName().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private License convertLicense(MavenPomLicense source) {
        License target = new License();
        target.setName((String)source.getName().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setDistribution((String)source.getDistribution().getOrNull());
        target.setComments((String)source.getComments().getOrNull());
        return target;
    }

    private Developer convertDeveloper(MavenPomDeveloper source) {
        Developer target = new Developer();
        target.setId((String)source.getId().getOrNull());
        target.setName((String)source.getName().getOrNull());
        target.setEmail((String)source.getEmail().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setOrganization((String)source.getOrganization().getOrNull());
        target.setOrganizationUrl((String)source.getOrganizationUrl().getOrNull());
        target.setRoles(new ArrayList((Collection)source.getRoles().get()));
        target.setTimezone((String)source.getTimezone().getOrNull());
        target.setProperties(this.convertProperties((Provider<Map<String, String>>)source.getProperties()));
        return target;
    }

    private Contributor convertContributor(MavenPomContributor source) {
        Contributor target = new Contributor();
        target.setName((String)source.getName().getOrNull());
        target.setEmail((String)source.getEmail().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setOrganization((String)source.getOrganization().getOrNull());
        target.setOrganizationUrl((String)source.getOrganizationUrl().getOrNull());
        target.setRoles(new ArrayList((Collection)source.getRoles().get()));
        target.setTimezone((String)source.getTimezone().getOrNull());
        target.setProperties(this.convertProperties((Provider<Map<String, String>>)source.getProperties()));
        return target;
    }

    private Properties convertProperties(Provider<Map<String, String>> source) {
        Properties target = new Properties();
        target.putAll((Map<?, ?>)((Map)source.getOrElse(Collections.emptyMap())));
        return target;
    }

    private Scm convertScm(MavenPomScm source) {
        Scm target = new Scm();
        target.setConnection((String)source.getConnection().getOrNull());
        target.setDeveloperConnection((String)source.getDeveloperConnection().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        target.setTag((String)source.getTag().getOrNull());
        return target;
    }

    private IssueManagement convertIssueManagement(MavenPomIssueManagement source) {
        IssueManagement target = new IssueManagement();
        target.setSystem((String)source.getSystem().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private CiManagement convertCiManagement(MavenPomCiManagement source) {
        CiManagement target = new CiManagement();
        target.setSystem((String)source.getSystem().getOrNull());
        target.setUrl((String)source.getUrl().getOrNull());
        return target;
    }

    private DistributionManagement convertDistributionManagement(MavenPomDistributionManagementInternal source) {
        DistributionManagement target = new DistributionManagement();
        target.setDownloadUrl((String)source.getDownloadUrl().getOrNull());
        if (source.getRelocation() != null) {
            target.setRelocation(this.convertRelocation(source.getRelocation()));
        }
        return target;
    }

    private Relocation convertRelocation(MavenPomRelocation source) {
        Relocation target = new Relocation();
        target.setGroupId((String)source.getGroupId().getOrNull());
        target.setArtifactId((String)source.getArtifactId().getOrNull());
        target.setVersion((String)source.getVersion().getOrNull());
        target.setMessage((String)source.getMessage().getOrNull());
        return target;
    }

    private MailingList convertMailingList(MavenPomMailingList source) {
        MailingList target = new MailingList();
        target.setName((String)source.getName().getOrNull());
        target.setSubscribe((String)source.getSubscribe().getOrNull());
        target.setUnsubscribe((String)source.getUnsubscribe().getOrNull());
        target.setPost((String)source.getPost().getOrNull());
        target.setArchive((String)source.getArchive().getOrNull());
        target.setOtherArchives(new ArrayList((Collection)source.getOtherArchives().get()));
        return target;
    }

    public void addApiDependencyManagement(MavenDependency apiDependency) {
        this.addDependencyManagement((MavenDependencyInternal)apiDependency, "compile");
    }

    public void addRuntimeDependencyManagement(MavenDependency dependency) {
        this.addDependencyManagement((MavenDependencyInternal)dependency, "runtime");
    }

    public void addImportDependencyManagement(MavenDependency dependency) {
        this.addDependencyManagement((MavenDependencyInternal)dependency, "import");
    }

    public void addRuntimeDependency(MavenDependencyInternal dependency) {
        this.addDependency(dependency, "runtime");
    }

    public void addOptionalDependency(MavenDependencyInternal optionalDependency) {
        this.addDependency(optionalDependency, "compile", true);
    }

    public void addApiDependency(MavenDependencyInternal apiDependency) {
        this.addDependency(apiDependency, "compile");
    }

    private void addDependency(MavenDependencyInternal mavenDependency, String scope) {
        this.addDependency(mavenDependency, scope, false);
    }

    private void addDependency(MavenDependencyInternal mavenDependency, String scope, boolean optional) {
        if (mavenDependency.getArtifacts().size() == 0) {
            this.addDependency(mavenDependency, mavenDependency.getArtifactId(), scope, null, null, optional);
        } else {
            for (DependencyArtifact artifact : mavenDependency.getArtifacts()) {
                this.addDependency(mavenDependency, artifact.getName(), scope, artifact.getType(), artifact.getClassifier(), optional);
            }
        }
    }

    private void addDependency(MavenDependencyInternal dependency, String artifactId, String scope, String type, String classifier, boolean optional) {
        Dependency mavenDependency = new Dependency();
        String groupId = dependency.getGroupId();
        String dependencyVersion = dependency.getVersion();
        String projectPath = dependency.getProjectPath();
        ImmutableAttributes attributes = this.attributesForScope(scope);
        ModuleVersionIdentifier resolvedVersion = this.versionMappingStrategy.findStrategyForVariant(attributes).maybeResolveVersion(groupId, artifactId, projectPath);
        mavenDependency.setGroupId(resolvedVersion != null ? resolvedVersion.getGroup() : groupId);
        mavenDependency.setArtifactId(resolvedVersion != null ? resolvedVersion.getName() : artifactId);
        mavenDependency.setVersion(resolvedVersion != null ? resolvedVersion.getVersion() : this.mapToMavenSyntax(dependencyVersion));
        mavenDependency.setType(type);
        mavenDependency.setScope(scope);
        mavenDependency.setClassifier(classifier);
        if (optional) {
            mavenDependency.setOptional(true);
        }
        for (ExcludeRule excludeRule : dependency.getExcludeRules()) {
            Exclusion exclusion = new Exclusion();
            exclusion.setGroupId((String)GUtil.elvis((Object)excludeRule.getGroup(), (Object)"*"));
            exclusion.setArtifactId((String)GUtil.elvis((Object)excludeRule.getModule(), (Object)"*"));
            mavenDependency.addExclusion(exclusion);
        }
        this.model.addDependency(mavenDependency);
    }

    private ImmutableAttributes attributesForScope(String scope) {
        if ("compile".equals(scope)) {
            return this.compileScopeAttributes;
        }
        if ("runtime".equals(scope) || "import".equals(scope)) {
            return this.runtimeScopeAttributes;
        }
        throw new IllegalStateException("Unexpected scope : " + scope);
    }

    private void addDependencyManagement(MavenDependencyInternal dependency, String scope) {
        DependencyManagement dependencyManagement;
        Dependency mavenDependency = new Dependency();
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String projectPath = dependency.getProjectPath();
        ImmutableAttributes attributes = this.attributesForScope(scope);
        ModuleVersionIdentifier resolvedVersion = this.versionMappingStrategy.findStrategyForVariant(attributes).maybeResolveVersion(groupId, artifactId, projectPath);
        mavenDependency.setGroupId(resolvedVersion != null ? resolvedVersion.getGroup() : groupId);
        mavenDependency.setArtifactId(resolvedVersion != null ? resolvedVersion.getName() : artifactId);
        mavenDependency.setVersion(resolvedVersion == null ? this.mapToMavenSyntax(dependency.getVersion()) : resolvedVersion.getVersion());
        String type = dependency.getType();
        if (type != null) {
            mavenDependency.setType(type);
        }
        if ("import".equals(scope)) {
            mavenDependency.setScope(scope);
        }
        if ((dependencyManagement = this.model.getDependencyManagement()) == null) {
            dependencyManagement = new DependencyManagement();
            this.model.setDependencyManagement(dependencyManagement);
        }
        dependencyManagement.addDependency(mavenDependency);
    }

    private String mapToMavenSyntax(String version) {
        return this.versionRangeMapper.map(version);
    }

    public MavenPomFileGenerator withXml(Action<XmlProvider> action) {
        this.xmlTransformer.addAction(action);
        return this;
    }

    public MavenPomFileGenerator writeTo(File file) {
        MavenPomFileGenerator.writeTo(file, this.model, this.xmlTransformer);
        return this;
    }

    public MavenPomSpec toSpec() {
        return new MavenPomSpec(this.model, this.xmlTransformer);
    }

    private static void writeTo(File file, Model model, XmlTransformer xmlTransformer) {
        xmlTransformer.transform(file, POM_FILE_ENCODING, writer -> {
            try {
                new MavenXpp3Writer().write(writer, model);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        });
    }

    public static class MavenPomSpec {
        private final Model model;
        private final XmlTransformer xmlTransformer;

        public MavenPomSpec(Model model, XmlTransformer xmlTransformer) {
            this.model = model;
            this.xmlTransformer = xmlTransformer;
        }

        public void writeTo(File file) {
            MavenPomFileGenerator.writeTo(file, this.model, this.xmlTransformer);
        }
    }
}

