/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import com.google.common.collect.ImmutableSet;
import java.util.stream.Stream;
import net.rubygrapefruit.platform.file.FileSystemInfo;
import net.rubygrapefruit.platform.file.FileSystems;
import org.gradle.internal.watch.vfs.WatchableFileSystemDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWatchableFileSystemDetector
implements WatchableFileSystemDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWatchableFileSystemDetector.class);
    private static final ImmutableSet<String> SUPPORTED_FILE_SYSTEM_TYPES = ImmutableSet.of((Object)"apfs", (Object)"hfs", (Object)"ext3", (Object)"ext4", (Object)"btrfs", (Object)"ntfs", (Object[])new String[]{"NTFS", "msdos", "FAT32", "exfat", "exFAT", "vboxsf"});
    private final FileSystems fileSystems;

    public DefaultWatchableFileSystemDetector(FileSystems fileSystems) {
        this.fileSystems = fileSystems;
    }

    @Override
    public Stream<FileSystemInfo> detectUnsupportedFileSystems() {
        return this.fileSystems.getFileSystems().stream().filter(fileSystem -> {
            LOGGER.debug("Detected {}: {} from {} (remote: {})", new Object[]{fileSystem.getFileSystemType(), fileSystem.getMountPoint(), fileSystem.getDeviceName(), fileSystem.isRemote()});
            if (fileSystem.isRemote()) {
                return true;
            }
            return !SUPPORTED_FILE_SYSTEM_TYPES.contains((Object)fileSystem.getFileSystemType());
        });
    }
}

