/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.modules.TargetId;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0018\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00172\u0006\u0010\u001d\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/daemon/RemoteIncrementalCacheClient;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "facade", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "target", "Lorg/jetbrains/kotlin/modules/TargetId;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;Lorg/jetbrains/kotlin/modules/TargetId;Lorg/jetbrains/kotlin/daemon/common/Profiler;)V", "getFacade", "()Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "getProfiler", "()Lorg/jetbrains/kotlin/daemon/common/Profiler;", "getTarget", "()Lorg/jetbrains/kotlin/modules/TargetId;", "close", "", "getClassFilePath", "", "internalClassName", "getModuleMappingData", "", "getObsoleteMultifileClasses", "", "getObsoletePackageParts", "getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "partInternalName", "getStableMultifileFacadeParts", "facadeInternalName", "kotlin-daemon"})
public final class RemoteIncrementalCacheClient
implements IncrementalCache {
    @NotNull
    private final CompilerCallbackServicesFacade facade;
    @NotNull
    private final TargetId target;
    @NotNull
    private final Profiler profiler;

    public RemoteIncrementalCacheClient(@NotNull CompilerCallbackServicesFacade facade, @NotNull TargetId target, @NotNull Profiler profiler) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        this.facade = facade;
        this.target = target;
        this.profiler = profiler;
    }

    public /* synthetic */ RemoteIncrementalCacheClient(CompilerCallbackServicesFacade compilerCallbackServicesFacade, TargetId targetId, Profiler profiler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            profiler = new DummyProfiler();
        }
        this(compilerCallbackServicesFacade, targetId, profiler);
    }

    @NotNull
    public final CompilerCallbackServicesFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final TargetId getTarget() {
        return this.target;
    }

    @NotNull
    public final Profiler getProfiler() {
        return this.profiler;
    }

    @NotNull
    public Collection<String> getObsoletePackageParts() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Collection<String> res$iv = this.getFacade().incrementalCache_getObsoletePackageParts(this.getTarget());
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @NotNull
    public Collection<String> getObsoleteMultifileClasses() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Collection<String> res$iv = this.getFacade().incrementalCache_getObsoleteMultifileClassFacades(this.getTarget());
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @Nullable
    public Collection<String> getStableMultifileFacadeParts(@NotNull String facadeInternalName) {
        Intrinsics.checkNotNullParameter((Object)facadeInternalName, (String)"facadeInternalName");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        Collection<String> res$iv = this.getFacade().incrementalCache_getMultifileFacadeParts(this.getTarget(), facadeInternalName);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @Nullable
    public JvmPackagePartProto getPackagePartData(@NotNull String partInternalName) {
        Intrinsics.checkNotNullParameter((Object)partInternalName, (String)"partInternalName");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        JvmPackagePartProto res$iv = this.getFacade().incrementalCache_getPackagePartData(this.getTarget(), partInternalName);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @Nullable
    public byte[] getModuleMappingData() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        byte[] res$iv = this.getFacade().incrementalCache_getModuleMappingData(this.getTarget());
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    @NotNull
    public String getClassFilePath(@NotNull String internalClassName) {
        Intrinsics.checkNotNullParameter((Object)internalClassName, (String)"internalClassName");
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        String res$iv = this.getFacade().incrementalCache_getClassFilePath(this.getTarget(), internalClassName);
        $this$withMeasure$iv.endMeasure(this, startState$iv);
        return res$iv;
    }

    public void close() {
        Profiler $this$withMeasure$iv = this.profiler;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(this);
        boolean bl = false;
        this.getFacade().incrementalCache_close(this.getTarget());
        Unit res$iv = Unit.INSTANCE;
        $this$withMeasure$iv.endMeasure(this, startState$iv);
    }
}

