/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.deprecation.DeprecatedFeatureUsage;
import org.gradle.internal.featurelifecycle.DefaultDeprecatedUsageProgressDetails;
import org.gradle.internal.featurelifecycle.FeatureHandler;
import org.gradle.internal.featurelifecycle.FeatureUsage;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingDeprecatedFeatureHandler
implements FeatureHandler<DeprecatedFeatureUsage> {
    public static final String ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME = "org.gradle.deprecation.trace";
    public static final String WARNING_SUMMARY = "Deprecated Gradle features were used in this build, making it incompatible with Gradle";
    public static final String WARNING_LOGGING_DOCS_MESSAGE = "See";
    private static final DocumentationRegistry DOCUMENTATION_REGISTRY = new DocumentationRegistry();
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingDeprecatedFeatureHandler.class);
    private static final String ELEMENT_PREFIX = "\tat ";
    private static final String RUN_WITH_STACKTRACE_INFO = "\t(Run with --stacktrace to get the full stack trace of this deprecation warning.)";
    private static boolean traceLoggingEnabled;
    private final Set<String> messages = new HashSet<String>();
    private UsageLocationReporter locationReporter;
    private WarningMode warningMode = WarningMode.Summary;
    private BuildOperationProgressEventEmitter progressEventEmitter;
    private GradleException error;

    public LoggingDeprecatedFeatureHandler() {
        this.locationReporter = DoNothingReporter.INSTANCE;
    }

    public void init(UsageLocationReporter reporter, WarningMode warningMode, BuildOperationProgressEventEmitter progressEventEmitter) {
        this.locationReporter = reporter;
        this.warningMode = warningMode;
        this.progressEventEmitter = progressEventEmitter;
    }

    @Override
    public void featureUsed(DeprecatedFeatureUsage usage) {
        String featureMessage = usage.formattedMessage();
        if (this.messages.add(featureMessage)) {
            StringBuilder message = new StringBuilder();
            this.locationReporter.reportLocation(usage, message);
            if (message.length() > 0) {
                message.append(SystemProperties.getInstance().getLineSeparator());
            }
            message.append(featureMessage);
            LoggingDeprecatedFeatureHandler.appendLogTraceIfNecessary(usage.getStack(), message);
            if (this.warningMode.shouldDisplayMessages()) {
                LOGGER.warn(message.toString());
            }
            if (this.warningMode == WarningMode.Fail && this.error == null) {
                this.error = new GradleException("Deprecated Gradle features were used in this build, making it incompatible with Gradle " + GradleVersion.current().getNextMajor().getVersion());
            }
        }
        this.fireDeprecatedUsageBuildOperationProgress(usage);
    }

    private void fireDeprecatedUsageBuildOperationProgress(DeprecatedFeatureUsage usage) {
        if (this.progressEventEmitter != null) {
            this.progressEventEmitter.emitNowIfCurrent((Object)new DefaultDeprecatedUsageProgressDetails(usage));
        }
    }

    public void reset() {
        this.progressEventEmitter = null;
        this.messages.clear();
        this.error = null;
    }

    public void reportSuppressedDeprecations() {
        if (this.warningMode == WarningMode.Summary && !this.messages.isEmpty()) {
            LOGGER.warn("\n{} {}.\nUse '--{} {}' to show the individual deprecation warnings.\n{} {}", new Object[]{WARNING_SUMMARY, GradleVersion.current().getNextMajor().getVersion(), "warning-mode", WarningMode.All.name().toLowerCase(), WARNING_LOGGING_DOCS_MESSAGE, DOCUMENTATION_REGISTRY.getDocumentationFor("command_line_interface", "sec:command_line_warnings")});
        }
    }

    private static void appendLogTraceIfNecessary(List<StackTraceElement> stack, StringBuilder message) {
        String lineSeparator = SystemProperties.getInstance().getLineSeparator();
        if (LoggingDeprecatedFeatureHandler.isTraceLoggingEnabled()) {
            for (StackTraceElement frame : stack) {
                LoggingDeprecatedFeatureHandler.appendStackTraceElement(frame, message, lineSeparator);
            }
            return;
        }
        for (StackTraceElement element : stack) {
            if (!LoggingDeprecatedFeatureHandler.isGradleScriptElement(element)) continue;
            LoggingDeprecatedFeatureHandler.appendStackTraceElement(element, message, lineSeparator);
            LoggingDeprecatedFeatureHandler.appendRunWithStacktraceInfo(message, lineSeparator);
            return;
        }
    }

    private static void appendStackTraceElement(StackTraceElement frame, StringBuilder message, String lineSeparator) {
        message.append(lineSeparator);
        message.append(ELEMENT_PREFIX);
        message.append(frame.toString());
    }

    private static void appendRunWithStacktraceInfo(StringBuilder message, String lineSeparator) {
        message.append(lineSeparator);
        message.append(RUN_WITH_STACKTRACE_INFO);
    }

    private static boolean isGradleScriptElement(StackTraceElement element) {
        String fileName = element.getFileName();
        if (fileName == null) {
            return false;
        }
        return (fileName = fileName.toLowerCase(Locale.US)).endsWith(".gradle") || fileName.endsWith(".gradle.kts");
    }

    public static void setTraceLoggingEnabled(boolean traceLoggingEnabled) {
        LoggingDeprecatedFeatureHandler.traceLoggingEnabled = traceLoggingEnabled;
    }

    static boolean isTraceLoggingEnabled() {
        String value = System.getProperty(ORG_GRADLE_DEPRECATION_TRACE_PROPERTY_NAME);
        if (value == null) {
            return traceLoggingEnabled;
        }
        return Boolean.parseBoolean(value);
    }

    public GradleException getDeprecationFailure() {
        return this.error;
    }

    private static enum DoNothingReporter implements UsageLocationReporter
    {
        INSTANCE;


        @Override
        public void reportLocation(FeatureUsage usage, StringBuilder target) {
        }
    }
}

