/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Collection;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.composite.internal.IncludedBuildTaskGraph;
import org.gradle.composite.internal.IncludedBuildTaskResource;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.CompositeBuildParticipantBuildState;

public class DefaultIncludedBuildTaskGraph
implements IncludedBuildTaskGraph {
    private final IncludedBuildControllers includedBuilds;
    private final BuildStateRegistry buildRegistry;

    public DefaultIncludedBuildTaskGraph(IncludedBuildControllers includedBuilds, BuildStateRegistry buildRegistry) {
        this.includedBuilds = includedBuilds;
        this.buildRegistry = buildRegistry;
    }

    private boolean isRoot(BuildIdentifier targetBuild) {
        return targetBuild.equals(DefaultBuildIdentifier.ROOT);
    }

    private CompositeBuildParticipantBuildState rootBuild() {
        return (CompositeBuildParticipantBuildState)this.buildRegistry.getRootBuild();
    }

    public synchronized void addTask(BuildIdentifier requestingBuild, BuildIdentifier targetBuild, String taskPath) {
        if (this.isRoot(targetBuild)) {
            if (this.findTaskInRootBuild(taskPath) == null) {
                this.rootBuild().getBuild().getTaskGraph().addAdditionalEntryTask(taskPath);
            }
        } else {
            this.buildControllerFor(targetBuild).queueForExecution(taskPath);
        }
    }

    public void awaitTaskCompletion(Collection<? super Throwable> taskFailures) {
        this.includedBuilds.populateTaskGraphs();
        this.includedBuilds.startTaskExecution();
        this.includedBuilds.awaitTaskCompletion(taskFailures);
    }

    public IncludedBuildTaskResource.State getTaskState(BuildIdentifier targetBuild, String taskPath) {
        if (this.isRoot(targetBuild)) {
            TaskInternal task = this.getTask(targetBuild, taskPath);
            if (task.getState().getFailure() != null) {
                return IncludedBuildTaskResource.State.FAILED;
            }
            if (task.getState().getExecuted()) {
                return IncludedBuildTaskResource.State.SUCCESS;
            }
            return IncludedBuildTaskResource.State.WAITING;
        }
        return this.buildControllerFor(targetBuild).getTaskState(taskPath);
    }

    public TaskInternal getTask(BuildIdentifier targetBuild, String taskPath) {
        if (this.isRoot(targetBuild)) {
            TaskInternal task = this.findTaskInRootBuild(taskPath);
            if (task == null) {
                throw new IllegalStateException("Root build task '" + taskPath + "' was never scheduled for execution.");
            }
            return task;
        }
        return this.buildControllerFor(targetBuild).getTask(taskPath);
    }

    private IncludedBuildController buildControllerFor(BuildIdentifier buildId) {
        return this.includedBuilds.getBuildController(buildId);
    }

    private TaskInternal findTaskInRootBuild(String taskPath) {
        for (Task task : this.rootBuild().getBuild().getTaskGraph().getAllTasks()) {
            if (!task.getPath().equals(taskPath)) continue;
            return (TaskInternal)task;
        }
        return null;
    }
}

