/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.util;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmPrimitiveTypeKind;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.roots.ProjectRootModificationTracker;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullComputable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiBinaryExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiDisjunctionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiWildcardType;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaClassSupers;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypesDistinctProver;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class TypeConversionUtil {
    private static final Logger LOG = Logger.getInstance(TypeConversionUtil.class);
    private static final boolean[][] IS_ASSIGNABLE_BIT_SET = new boolean[][]{{true, true, false, true, true, true, true}, {false, true, false, true, true, true, true}, {false, false, true, true, true, true, true}, {false, false, false, true, true, true, true}, {false, false, false, false, true, true, true}, {false, false, false, false, false, true, true}, {false, false, false, false, false, false, true}};
    private static final TObjectIntHashMap<PsiType> TYPE_TO_RANK_MAP = new TObjectIntHashMap();
    public static final int BYTE_RANK = 1;
    public static final int SHORT_RANK = 2;
    public static final int CHAR_RANK = 3;
    public static final int INT_RANK = 4;
    public static final int LONG_RANK = 5;
    public static final int FLOAT_RANK = 6;
    public static final int DOUBLE_RANK = 7;
    public static final PsiType NULL_TYPE = new PsiEllipsisType(PsiType.NULL){

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NotNull
        public String getPresentableText(boolean annotated) {
            return "FAKE TYPE";
        }
    };
    private static final Key<PsiElement> ORIGINAL_CONTEXT = Key.create("ORIGINAL_CONTEXT");
    private static final Key<PsiType> LOWER_BOUND = Key.create("LowBound");
    private static final Key<PsiType> UPPER_BOUND = Key.create("UpperBound");
    private static final Key<CachedValue<Set<String>>> POSSIBLE_BOXED_HOLDER_TYPES;
    private static final RecursionGuard<PsiType> ourGuard;
    private static final Set<String> INTEGER_NUMBER_TYPES;
    private static final Set<String> PRIMITIVE_TYPES;
    private static final Set<String> PRIMITIVE_WRAPPER_FQNS;
    private static final Set<String> PRIMITIVE_WRAPPER_SIMPLE_NAMES;
    private static final Map<Class<?>, PsiType> WRAPPER_TO_PRIMITIVE;

    private TypeConversionUtil() {
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType) {
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(0);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(1);
        }
        return TypeConversionUtil.areTypesConvertible(fromType, toType, null);
    }

    public static boolean areTypesConvertible(@NotNull PsiType fromType, @NotNull PsiType toType, @Nullable LanguageLevel languageLevel) {
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(2);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(3);
        }
        if (fromType == toType) {
            return true;
        }
        boolean fromIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(fromType);
        boolean toIsPrimitive = TypeConversionUtil.isPrimitiveAndNotNull(toType);
        if (fromIsPrimitive || toIsPrimitive) {
            if (TypeConversionUtil.isVoidType(fromType) || TypeConversionUtil.isVoidType(toType)) {
                return false;
            }
            int fromTypeRank = TypeConversionUtil.getTypeRank(fromType);
            int toTypeRank = TypeConversionUtil.getTypeRank(toType);
            if (!toIsPrimitive) {
                if (fromTypeRank == toTypeRank) {
                    return true;
                }
                if (toType instanceof PsiIntersectionType) {
                    for (PsiType type2 : ((PsiIntersectionType)toType).getConjuncts()) {
                        if (TypeConversionUtil.areTypesConvertible(fromType, type2)) continue;
                        return false;
                    }
                    return true;
                }
                if (!(toType instanceof PsiClassType)) {
                    return false;
                }
                PsiClass toClass = ((PsiClassType)toType).resolve();
                if (toClass == null || toClass instanceof PsiTypeParameter) {
                    return false;
                }
                PsiClassType boxedType = ((PsiPrimitiveType)fromType).getBoxedType(toClass.getManager(), toType.getResolveScope());
                return boxedType != null && TypeConversionUtil.areTypesConvertible(boxedType, toType);
            }
            if (!fromIsPrimitive) {
                if ((fromTypeRank == 2 || fromTypeRank == 1) && toTypeRank == 3) {
                    return false;
                }
                if ((fromType = TypeConversionUtil.uncapture(fromType)) instanceof PsiClassType) {
                    if (languageLevel == null) {
                        languageLevel = ((PsiClassType)fromType).getLanguageLevel();
                    }
                    if (languageLevel.isAtLeast(LanguageLevel.JDK_1_7)) {
                        PsiClassType classType = (PsiClassType)fromType;
                        PsiClass psiClass = classType.resolve();
                        if (psiClass == null) {
                            return false;
                        }
                        PsiClassType boxedType = ((PsiPrimitiveType)toType).getBoxedType(psiClass.getManager(), psiClass.getResolveScope());
                        if (boxedType != null && TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, boxedType)) {
                            return true;
                        }
                    }
                }
                return fromTypeRank == toTypeRank || fromTypeRank < toTypeRank && toTypeRank <= 7;
            }
            return fromTypeRank == toTypeRank || fromTypeRank <= 7 && toTypeRank <= 7;
        }
        if (TypeConversionUtil.isAssignable(toType, fromType)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(fromType) || TypeConversionUtil.isNullType(toType)) {
            return true;
        }
        return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, toType);
    }

    private static boolean isNarrowingReferenceConversionAllowed(@NotNull PsiType fromType, @NotNull PsiType toType) {
        PsiSubstitutor derivedSubstitutor;
        PsiClass derived;
        PsiClassType.ClassResolveResult baseResult;
        if (fromType == null) {
            TypeConversionUtil.$$$reportNull$$$0(4);
        }
        if (toType == null) {
            TypeConversionUtil.$$$reportNull$$$0(5);
        }
        toType = TypeConversionUtil.uncapture(toType);
        fromType = TypeConversionUtil.uncapture(fromType);
        if (toType instanceof PsiPrimitiveType || fromType instanceof PsiPrimitiveType) {
            return fromType.equals(toType);
        }
        if (toType instanceof PsiDiamondType || fromType instanceof PsiDiamondType) {
            return false;
        }
        if (toType instanceof PsiArrayType && !(fromType instanceof PsiArrayType)) {
            PsiClass resolved;
            if (fromType instanceof PsiClassType && (resolved = ((PsiClassType)fromType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(boundType, toType)) continue;
                    return false;
                }
                return true;
            }
            return TypeConversionUtil.isAssignable(fromType, toType);
        }
        if (fromType instanceof PsiArrayType) {
            PsiClass resolved;
            if (toType instanceof PsiClassType && (resolved = ((PsiClassType)toType).resolve()) instanceof PsiTypeParameter) {
                for (PsiClassType boundType : resolved.getExtendsListTypes()) {
                    if (TypeConversionUtil.areTypesConvertible(fromType, boundType)) continue;
                    return false;
                }
                return true;
            }
            return toType instanceof PsiArrayType && TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiArrayType)fromType).getComponentType(), ((PsiArrayType)toType).getComponentType());
        }
        if (fromType instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)fromType).getConjuncts()) {
                if (!TypeConversionUtil.isNarrowingReferenceConversionAllowed(conjunct, toType)) continue;
                return true;
            }
            return false;
        }
        if (toType instanceof PsiIntersectionType) {
            if (fromType instanceof PsiClassType && ((PsiClassType)fromType).getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_8)) {
                for (PsiType conjunct : ((PsiIntersectionType)toType).getConjuncts()) {
                    if (TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, conjunct)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (fromType instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(((PsiDisjunctionType)fromType).getLeastUpperBound(), toType);
        }
        if (toType instanceof PsiDisjunctionType) {
            return false;
        }
        if (fromType instanceof PsiWildcardType) {
            PsiWildcardType fromWildcard = (PsiWildcardType)fromType;
            PsiType bound = fromWildcard.getBound();
            if (bound == null) {
                return true;
            }
            if (fromWildcard.isSuper()) {
                return TypeConversionUtil.isAssignable(toType, bound);
            }
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(bound, toType);
        }
        if (toType instanceof PsiWildcardType) {
            PsiWildcardType toWildcard = (PsiWildcardType)toType;
            if (toWildcard.isSuper()) {
                return false;
            }
            PsiType bound = toWildcard.getBound();
            return bound == null || TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, bound);
        }
        if (TypeConversionUtil.isAssignable(fromType, toType)) {
            return true;
        }
        if (!(fromType instanceof PsiClassType) || !(toType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType fromClassType = (PsiClassType)fromType;
        PsiClassType toClassType = (PsiClassType)toType;
        PsiClassType.ClassResolveResult fromResult = fromClassType.resolveGenerics();
        PsiClass fromClass = fromResult.getElement();
        if (fromClass == null) {
            return false;
        }
        if (fromClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)fromClass), toType);
        }
        PsiClassType.ClassResolveResult toResult = toClassType.resolveGenerics();
        PsiClass toClass = toResult.getElement();
        if (toClass == null) {
            return false;
        }
        if (toClass instanceof PsiTypeParameter) {
            return TypeConversionUtil.isNarrowingReferenceConversionAllowed(fromType, TypeConversionUtil.obtainSafeSuperType((PsiTypeParameter)toClass));
        }
        PsiManager manager = fromClass.getManager();
        LanguageLevel languageLevel = toClassType.getLanguageLevel();
        if (!fromClass.isInterface()) {
            if (toClass.isInterface()) {
                return (!fromClass.hasModifierProperty("final") || fromClass.isInheritor(toClass, true)) && TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            if (manager.areElementsEquivalent(fromClass, toClass)) {
                return TypeConversionUtil.areSameParameterTypes(fromClassType, toClassType);
            }
            if (toClass.isInheritor(fromClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            if (fromClass.isInheritor(toClass, true)) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(toResult, fromClass, manager, fromResult.getSubstitutor(), null, languageLevel);
            }
            return false;
        }
        if (!toClass.isInterface()) {
            if (!toClass.hasModifierProperty("final")) {
                return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(fromResult, toClass, manager, toResult.getSubstitutor(), null, languageLevel);
            }
            PsiSubstitutor toSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(fromClass, toClass, toResult.getSubstitutor());
            return toSubstitutor != null && TypeConversionUtil.areSameArgumentTypes(fromClass, fromResult.getSubstitutor(), toSubstitutor);
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            Collection<HierarchicalMethodSignature> fromClassMethodSignatures = fromClass.getVisibleSignatures();
            Collection<HierarchicalMethodSignature> toClassMethodSignatures = toClass.getVisibleSignatures();
            for (HierarchicalMethodSignature fromMethodSignature : fromClassMethodSignatures) {
                for (HierarchicalMethodSignature toMethodSignature : toClassMethodSignatures) {
                    if (!fromMethodSignature.equals(toMethodSignature)) continue;
                    PsiType fromClassReturnType = fromMethodSignature.getMethod().getReturnType();
                    PsiType toClassReturnType = toMethodSignature.getMethod().getReturnType();
                    if (fromClassReturnType == null || toClassReturnType == null || fromClassReturnType.equals(toClassReturnType)) continue;
                    return false;
                }
            }
            return true;
        }
        if (toClass.isInheritor(fromClass, true)) {
            baseResult = fromResult;
            derived = toClass;
            derivedSubstitutor = toResult.getSubstitutor();
        } else {
            baseResult = toResult;
            derived = fromClass;
            derivedSubstitutor = fromResult.getSubstitutor();
        }
        return TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, derived, manager, derivedSubstitutor, null, languageLevel);
    }

    @NotNull
    private static PsiClassType obtainSafeSuperType(@NotNull PsiTypeParameter typeParameter) {
        PsiClassType superType;
        PsiClassType.ClassResolveResult result2;
        PsiClass superClass2;
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(6);
        }
        if ((superClass2 = (result2 = (superType = typeParameter.getSuperTypes()[0]).resolveGenerics()).getElement()) != null) {
            PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(typeParameter.getProject());
            if (superClass2 instanceof PsiTypeParameter && InheritanceUtil.getCircularClass(superClass2) != null) {
                PsiClassType psiClassType = factory2.createTypeByFQClassName("java.lang.Object", typeParameter.getResolveScope());
                if (psiClassType == null) {
                    TypeConversionUtil.$$$reportNull$$$0(7);
                }
                return psiClassType;
            }
            PsiSubstitutor substitutor2 = result2.getSubstitutor().put(typeParameter, null);
            PsiClassType psiClassType = factory2.createType(superClass2, substitutor2);
            if (psiClassType == null) {
                TypeConversionUtil.$$$reportNull$$$0(8);
            }
            return psiClassType;
        }
        PsiClassType psiClassType = superType;
        if (psiClassType == null) {
            TypeConversionUtil.$$$reportNull$$$0(9);
        }
        return psiClassType;
    }

    private static boolean checkSuperTypesWithDifferentTypeArguments(@NotNull PsiClassType.ClassResolveResult baseResult, @NotNull PsiClass derived, @NotNull PsiManager manager, @NotNull PsiSubstitutor derivedSubstitutor, Set<? super PsiClass> visited2, @NotNull LanguageLevel languageLevel) {
        if (baseResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(10);
        }
        if (derived == null) {
            TypeConversionUtil.$$$reportNull$$$0(11);
        }
        if (manager == null) {
            TypeConversionUtil.$$$reportNull$$$0(12);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(13);
        }
        if (languageLevel == null) {
            TypeConversionUtil.$$$reportNull$$$0(14);
        }
        if (visited2 != null && visited2.contains(derived)) {
            return true;
        }
        if (languageLevel.compareTo(LanguageLevel.JDK_1_5) < 0) {
            return true;
        }
        PsiClass base = baseResult.getElement();
        PsiClass[] supers = derived.getSupers();
        if (manager.areElementsEquivalent(base, derived)) {
            derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor);
            return TypeConversionUtil.areSameArgumentTypes(derived, baseResult.getSubstitutor(), derivedSubstitutor, 1);
        }
        PsiSubstitutor baseSubstitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor(derived, base, baseResult.getSubstitutor());
        if (baseSubstitutor != null && !TypeConversionUtil.areSameArgumentTypes(derived, baseSubstitutor, derivedSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(derived, derived, derivedSubstitutor))) {
            return false;
        }
        if (visited2 == null) {
            visited2 = new THashSet();
        }
        visited2.add((PsiClass)derived);
        for (PsiClass aSuper : supers) {
            PsiSubstitutor s = TypeConversionUtil.getSuperClassSubstitutor(aSuper, derived, derivedSubstitutor);
            if (TypeConversionUtil.checkSuperTypesWithDifferentTypeArguments(baseResult, aSuper, manager, s, (Set<? super PsiClass>)visited2, languageLevel)) continue;
            return false;
        }
        return true;
    }

    private static boolean areSameParameterTypes(@NotNull PsiClassType type1, @NotNull PsiClassType type2) {
        if (type1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(16);
        }
        PsiClassType.ClassResolveResult resolveResult1 = type1.resolveGenerics();
        PsiClassType.ClassResolveResult resolveResult2 = type2.resolveGenerics();
        PsiClass aClass2 = resolveResult1.getElement();
        PsiClass bClass = resolveResult2.getElement();
        return aClass2 != null && bClass != null && aClass2.getManager().areElementsEquivalent(aClass2, bClass) && TypeConversionUtil.areSameArgumentTypes(aClass2, resolveResult1.getSubstitutor(), resolveResult2.getSubstitutor(), 1);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2) {
        if (aClass2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(17);
        }
        if (substitutor1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(18);
        }
        if (substitutor2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(19);
        }
        return TypeConversionUtil.areSameArgumentTypes(aClass2, substitutor1, substitutor2, 0);
    }

    private static boolean areSameArgumentTypes(@NotNull PsiClass aClass2, @NotNull PsiSubstitutor substitutor1, @NotNull PsiSubstitutor substitutor2, int level) {
        if (aClass2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(20);
        }
        if (substitutor1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(21);
        }
        if (substitutor2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(22);
        }
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable(aClass2)) {
            PsiType typeArg1 = substitutor1.substitute(typeParameter);
            PsiType typeArg2 = substitutor2.substitute(typeParameter);
            if (typeArg1 == null || typeArg2 == null) {
                return true;
            }
            if (!TypesDistinctProver.provablyDistinct(typeArg1, typeArg2, level)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveAndNotNull(PsiType type2) {
        return type2 instanceof PsiPrimitiveType && !TypeConversionUtil.isNullType(type2);
    }

    @Contract(value="null -> false")
    public static boolean isEnumType(PsiType type2) {
        if ((type2 = TypeConversionUtil.uncapture(type2)) instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            if (psiClass instanceof PsiTypeParameter) {
                return InheritanceUtil.isInheritor(psiClass, true, "java.lang.Enum");
            }
            return psiClass != null && psiClass.isEnum();
        }
        return false;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNullType(PsiType type2) {
        return PsiType.NULL.equals(type2);
    }

    @Contract(value="null -> false")
    public static boolean isFloatOrDoubleType(PsiType type2) {
        return TypeConversionUtil.isFloatType(type2) || TypeConversionUtil.isDoubleType(type2);
    }

    @Contract(value="null -> false")
    public static boolean isDoubleType(PsiType type2) {
        return PsiType.DOUBLE.equals(type2 = TypeConversionUtil.uncapture(type2)) || PsiType.DOUBLE.equals(PsiPrimitiveType.getUnboxedType(type2));
    }

    @Contract(value="null -> false")
    public static boolean isFloatType(PsiType type2) {
        return PsiType.FLOAT.equals(type2 = TypeConversionUtil.uncapture(type2)) || PsiType.FLOAT.equals(PsiPrimitiveType.getUnboxedType(type2));
    }

    @Contract(value="null -> false")
    public static boolean isLongType(PsiType type2) {
        return PsiType.LONG.equals(type2 = TypeConversionUtil.uncapture(type2)) || PsiType.LONG.equals(PsiPrimitiveType.getUnboxedType(type2));
    }

    public static boolean isVoidType(PsiType type2) {
        return PsiType.VOID.equals(type2);
    }

    public static boolean isBooleanType(@Nullable PsiType type2) {
        return PsiType.BOOLEAN.equals(type2 = TypeConversionUtil.uncapture(type2)) || PsiType.BOOLEAN.equals(PsiPrimitiveType.getUnboxedType(type2));
    }

    @Contract(value="null -> null")
    private static PsiType uncapture(PsiType type2) {
        while (type2 instanceof PsiCapturedWildcardType) {
            type2 = ((PsiCapturedWildcardType)type2).getUpperBound();
        }
        return type2;
    }

    public static boolean isNumericType(@TypeRank int typeRank) {
        return typeRank <= 7;
    }

    public static boolean isNumericType(PsiType type2) {
        return type2 != null && TypeConversionUtil.isNumericType(TypeConversionUtil.getTypeRank(type2));
    }

    public static boolean isIntegralNumberType(PsiType type2) {
        return type2 != null && TypeConversionUtil.getTypeRank(type2) <= 5;
    }

    @TypeRank
    public static int getTypeRank(@NotNull PsiType type2) {
        int rank;
        PsiPrimitiveType unboxedType;
        if (type2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(23);
        }
        if ((unboxedType = PsiPrimitiveType.getUnboxedType(type2 = TypeConversionUtil.uncapture(type2))) != null) {
            type2 = unboxedType;
        }
        if ((rank = TYPE_TO_RANK_MAP.get((Object)type2)) != 0) {
            return rank;
        }
        if (type2.equalsToText("java.lang.String")) {
            return 100;
        }
        return 1000;
    }

    public static boolean isBinaryOperatorApplicable(@NotNull IElementType tokenType, PsiExpression lOperand, PsiExpression rOperand, boolean strict) {
        if (tokenType == null) {
            TypeConversionUtil.$$$reportNull$$$0(24);
        }
        if (lOperand == null || rOperand == null) {
            return true;
        }
        PsiType ltype = lOperand.getType();
        PsiType rtype = rOperand.getType();
        return TypeConversionUtil.isBinaryOperatorApplicable(tokenType, ltype, rtype, strict);
    }

    public static boolean isBinaryOperatorApplicable(@NotNull IElementType tokenType, PsiType ltype, PsiType rtype, boolean strict) {
        if (tokenType == null) {
            TypeConversionUtil.$$$reportNull$$$0(25);
        }
        if (ltype == null || rtype == null) {
            return true;
        }
        int resultTypeRank = 10;
        boolean isApplicable = false;
        int ltypeRank = TypeConversionUtil.getTypeRank(ltype);
        int rtypeRank = TypeConversionUtil.getTypeRank(rtype);
        if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.EQEQ || tokenType == JavaTokenType.NE) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype) && (TypeConversionUtil.isPrimitiveAndNotNull(ltype) || TypeConversionUtil.isPrimitiveAndNotNull(rtype))) {
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7 || ltypeRank == 10 && rtypeRank == 10;
            } else {
                if (TypeConversionUtil.isPrimitiveAndNotNull(ltype)) {
                    if (rtype instanceof PsiClassType) {
                        LanguageLevel languageLevel = ((PsiClassType)rtype).getLanguageLevel();
                        return languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && !languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(ltype, rtype);
                    }
                    return false;
                }
                if (TypeConversionUtil.isPrimitiveAndNotNull(rtype)) {
                    if (ltype instanceof PsiClassType) {
                        LanguageLevel level = ((PsiClassType)ltype).getLanguageLevel();
                        return level.isAtLeast(LanguageLevel.JDK_1_7) && !level.isAtLeast(LanguageLevel.JDK_1_8) && TypeConversionUtil.areTypesConvertible(rtype, ltype);
                    }
                    return false;
                }
                isApplicable = TypeConversionUtil.areTypesConvertible(ltype, rtype) || TypeConversionUtil.areTypesConvertible(rtype, ltype);
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (ltype.equalsToText("java.lang.String")) {
                isApplicable = !TypeConversionUtil.isVoidType(rtype);
                resultTypeRank = 100;
            } else {
                if (rtype.equalsToText("java.lang.String")) {
                    if (TypeConversionUtil.isVoidType(ltype)) {
                        return false;
                    }
                    return !strict || ltype.isAssignableFrom(rtype);
                }
                if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                    resultTypeRank = Math.max(ltypeRank, rtypeRank);
                    isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
                }
            }
        } else if (tokenType == JavaTokenType.ASTERISK || tokenType == JavaTokenType.DIV || tokenType == JavaTokenType.PERC || tokenType == JavaTokenType.MINUS) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                resultTypeRank = Math.max(ltypeRank, rtypeRank);
                isApplicable = ltypeRank <= 7 && rtypeRank <= 7;
            }
        } else if (tokenType == JavaTokenType.LTLT || tokenType == JavaTokenType.GTGT || tokenType == JavaTokenType.GTGTGT) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5;
                resultTypeRank = 4;
            }
        } else if (tokenType == JavaTokenType.AND || tokenType == JavaTokenType.OR || tokenType == JavaTokenType.XOR) {
            if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
                isApplicable = ltypeRank <= 5 && rtypeRank <= 5 || TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
                resultTypeRank = ltypeRank <= 5 ? 4 : 10;
            }
        } else if ((tokenType == JavaTokenType.ANDAND || tokenType == JavaTokenType.OROR) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(ltype) && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper(rtype)) {
            boolean bl = isApplicable = TypeConversionUtil.isBooleanType(ltype) && TypeConversionUtil.isBooleanType(rtype);
        }
        if (isApplicable && strict && resultTypeRank > 7) {
            isApplicable = ltypeRank == resultTypeRank || ltype.equalsToText("java.lang.Object");
        }
        return isApplicable;
    }

    public static boolean isPrimitiveAndNotNullOrWrapper(PsiType type2) {
        if ((type2 = TypeConversionUtil.uncapture(type2)) instanceof PsiClassType) {
            return PsiPrimitiveType.getUnboxedType(type2) != null;
        }
        return TypeConversionUtil.isPrimitiveAndNotNull(type2);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, PsiExpression operand) {
        if (token == null) {
            TypeConversionUtil.$$$reportNull$$$0(26);
        }
        if (operand == null) {
            return false;
        }
        PsiType type2 = operand.getType();
        return type2 != null && TypeConversionUtil.isUnaryOperatorApplicable(token, type2);
    }

    public static boolean isUnaryOperatorApplicable(@NotNull PsiJavaToken token, @NotNull PsiType type2) {
        if (token == null) {
            TypeConversionUtil.$$$reportNull$$$0(27);
        }
        if (type2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(28);
        }
        IElementType i = token.getTokenType();
        int typeRank = TypeConversionUtil.getTypeRank(type2);
        if (i == JavaTokenType.MINUSMINUS || i == JavaTokenType.PLUSPLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.MINUS || i == JavaTokenType.PLUS) {
            return typeRank <= 7;
        }
        if (i == JavaTokenType.TILDE) {
            return typeRank <= 5;
        }
        if (i == JavaTokenType.EXCL) {
            return typeRank == 10;
        }
        LOG.error("unknown token: " + token);
        return true;
    }

    public static boolean isLValue(PsiExpression element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression2 = (PsiReferenceExpression)element;
            PsiElement resolved = expression2.resolve();
            return resolved instanceof PsiVariable;
        }
        if (element instanceof PsiParenthesizedExpression) {
            return TypeConversionUtil.isLValue(((PsiParenthesizedExpression)element).getExpression());
        }
        if (element instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)element;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            PsiType type2 = arrayExpression.getType();
            if (!(type2 instanceof PsiArrayType)) {
                return false;
            }
            PsiExpression indexExpression = arrayAccessExpression.getIndexExpression();
            if (indexExpression == null) {
                return false;
            }
            PsiType indexType = indexExpression.getType();
            if (indexType == null) {
                return false;
            }
            return TypeConversionUtil.getTypeRank(indexType) <= 4;
        }
        return false;
    }

    public static boolean areTypesAssignmentCompatible(PsiType lType, PsiExpression rExpr) {
        if (lType == null || rExpr == null) {
            return true;
        }
        PsiType rType = rExpr.getType();
        if (rType == null) {
            return false;
        }
        if (TypeConversionUtil.isAssignable(lType, rType)) {
            return true;
        }
        if (lType instanceof PsiClassType && (lType = PsiPrimitiveType.getUnboxedType(lType)) == null) {
            return false;
        }
        int rTypeRank = TypeConversionUtil.getTypeRank(rType);
        if (lType instanceof PsiPrimitiveType && rType instanceof PsiPrimitiveType && rTypeRank >= 1 && rTypeRank <= 4) {
            long value2;
            Object rValue = JavaPsiFacade.getInstance(rExpr.getProject()).getConstantEvaluationHelper().computeConstantExpression(rExpr);
            if (rValue instanceof Number) {
                value2 = ((Number)rValue).longValue();
            } else if (rValue instanceof Character) {
                value2 = ((Character)rValue).charValue();
            } else {
                return false;
            }
            if (PsiType.BYTE.equals(lType)) {
                return -128L <= value2 && value2 <= 127L;
            }
            if (PsiType.SHORT.equals(lType)) {
                return -32768L <= value2 && value2 <= 32767L;
            }
            if (PsiType.CHAR.equals(lType)) {
                return 0L <= value2 && value2 <= 65535L;
            }
        }
        return false;
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(29);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(30);
        }
        return TypeConversionUtil.isAssignable(left, right, true);
    }

    public static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(31);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(32);
        }
        return TypeConversionUtil.isAssignable(left, right, allowUncheckedConversion, true);
    }

    private static boolean isAssignable(@NotNull PsiType left, @NotNull PsiType right, boolean allowUncheckedConversion, boolean capture) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(33);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(34);
        }
        if (left == right) {
            return true;
        }
        if (left instanceof PsiClassType && left.equalsToText("java.lang.Object") && (right instanceof PsiMethodReferenceType || right instanceof PsiLambdaExpressionType)) {
            return false;
        }
        if (left.equals(right)) {
            return true;
        }
        if (TypeConversionUtil.isNullType(right)) {
            return !(left instanceof PsiPrimitiveType) || TypeConversionUtil.isNullType(left);
        }
        if (right instanceof PsiMethodReferenceType) {
            PsiMethodReferenceExpression methodReferenceExpression = ((PsiMethodReferenceType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiLambdaExpressionType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            if (left instanceof PsiMethodReferenceType) {
                PsiType rType = methodReferenceExpression.getFunctionalInterfaceType();
                PsiType lType = ((PsiMethodReferenceType)left).getExpression().getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            return !(left instanceof PsiArrayType) && methodReferenceExpression.isAcceptable(left);
        }
        if (right instanceof PsiLambdaExpressionType) {
            PsiLambdaExpression rLambdaExpression = ((PsiLambdaExpressionType)right).getExpression();
            if (left instanceof PsiLambdaExpressionType) {
                PsiLambdaExpression lLambdaExpression = ((PsiLambdaExpressionType)left).getExpression();
                PsiType rType = rLambdaExpression.getFunctionalInterfaceType();
                PsiType lType = lLambdaExpression.getFunctionalInterfaceType();
                return Comparing.equal(rType, lType);
            }
            return !(left instanceof PsiArrayType) && rLambdaExpression.isAcceptable(left);
        }
        if (left instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.isAssignable(conjunct, right, allowUncheckedConversion, capture)) continue;
                return false;
            }
            return true;
        }
        if (right instanceof PsiIntersectionType) {
            PsiType[] conjuncts;
            for (PsiType conjunct : conjuncts = ((PsiIntersectionType)right).getConjuncts()) {
                if (!TypeConversionUtil.isAssignable(left, conjunct, allowUncheckedConversion, capture)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiCapturedWildcardType) {
            return TypeConversionUtil.isAssignable(left, ((PsiCapturedWildcardType)right).getUpperBound(capture), allowUncheckedConversion, capture);
        }
        if (left instanceof PsiCapturedWildcardType) {
            return left.equals(right) || TypeConversionUtil.isAssignable(((PsiCapturedWildcardType)left).getLowerBound(), right, allowUncheckedConversion, capture);
        }
        if (left instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableToWildcard((PsiWildcardType)left, right);
        }
        if (right instanceof PsiWildcardType) {
            return TypeConversionUtil.isAssignableFromWildcard(left, (PsiWildcardType)right);
        }
        if (right instanceof PsiArrayType) {
            if (!(left instanceof PsiArrayType)) {
                if (left instanceof PsiPrimitiveType || PsiUtil.resolveClassInType(left) == null) {
                    return false;
                }
                PsiClass lClass = PsiUtil.resolveClassInType(left);
                if (lClass == null) {
                    return false;
                }
                if (lClass.isInterface()) {
                    String qualifiedName = lClass.getQualifiedName();
                    return "java.io.Serializable".equals(qualifiedName) || "java.lang.Cloneable".equals(qualifiedName);
                }
                return left.equalsToText("java.lang.Object");
            }
            PsiType lCompType = ((PsiArrayType)left).getComponentType();
            PsiType rCompType = ((PsiArrayType)right).getComponentType();
            if (lCompType instanceof PsiPrimitiveType) {
                return lCompType.equals(rCompType);
            }
            return !(rCompType instanceof PsiPrimitiveType) && TypeConversionUtil.isAssignable(lCompType, rCompType, allowUncheckedConversion, capture);
        }
        if (left instanceof PsiDisjunctionType) {
            for (PsiType type2 : ((PsiDisjunctionType)left).getDisjunctions()) {
                if (!TypeConversionUtil.isAssignable(type2, right, allowUncheckedConversion, capture)) continue;
                return true;
            }
            return false;
        }
        if (right instanceof PsiDisjunctionType) {
            return TypeConversionUtil.isAssignable(left, ((PsiDisjunctionType)right).getLeastUpperBound(), allowUncheckedConversion, capture);
        }
        if (left instanceof PsiArrayType) {
            PsiClass aClass2;
            if (right instanceof PsiClassType && (aClass2 = ((PsiClassType)right).resolve()) instanceof PsiTypeParameter) {
                PsiType upperBound = TypeConversionUtil.getInferredUpperBoundForSynthetic((PsiTypeParameter)aClass2);
                return upperBound != null && TypeConversionUtil.isAssignable(left, upperBound, allowUncheckedConversion, capture);
            }
            return false;
        }
        if (right instanceof PsiPrimitiveType) {
            if (TypeConversionUtil.isVoidType(right)) {
                return false;
            }
            if (!(left instanceof PsiPrimitiveType)) {
                return left instanceof PsiClassType && TypeConversionUtil.isBoxable((PsiClassType)left, (PsiPrimitiveType)right);
            }
            int leftTypeIndex = TYPE_TO_RANK_MAP.get((Object)left) - 1;
            int rightTypeIndex = TYPE_TO_RANK_MAP.get((Object)right) - 1;
            return leftTypeIndex >= 0 && rightTypeIndex >= 0 && rightTypeIndex < IS_ASSIGNABLE_BIT_SET.length && leftTypeIndex < IS_ASSIGNABLE_BIT_SET.length && IS_ASSIGNABLE_BIT_SET[rightTypeIndex][leftTypeIndex];
        }
        if (!(right instanceof PsiClassType)) {
            return false;
        }
        if (left instanceof PsiPrimitiveType) {
            return TypeConversionUtil.isUnboxable((PsiPrimitiveType)left, (PsiClassType)right, new HashSet());
        }
        PsiClassType.ClassResolveResult leftResult = PsiUtil.resolveGenericsClassInType(left);
        PsiClassType.ClassResolveResult rightResult = PsiUtil.resolveGenericsClassInType(right);
        PsiClass leftResultElement = leftResult.getElement();
        PsiClass rightResultElement = rightResult.getElement();
        if (leftResultElement == null || rightResultElement == null) {
            String rText;
            if (leftResultElement == null && rightResultElement != null && left instanceof PsiClassType && left.equalsToText("java.lang.Object")) {
                return true;
            }
            if (leftResultElement != rightResultElement) {
                return false;
            }
            String lText = left.getPresentableText();
            if (lText.equals(rText = right.getPresentableText())) {
                return true;
            }
            if (lText.length() > rText.length() && lText.endsWith(rText) && lText.charAt(lText.length() - rText.length() - 1) == '.') {
                return true;
            }
            return rText.length() > lText.length() && rText.endsWith(lText) && rText.charAt(rText.length() - lText.length() - 1) == '.';
        }
        return TypeConversionUtil.isClassAssignable(leftResult, rightResult, allowUncheckedConversion, left.getResolveScope(), capture);
    }

    private static boolean isAssignableFromWildcard(@NotNull PsiType left, @NotNull PsiWildcardType rightWildcardType) {
        PsiClass aClass2;
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(35);
        }
        if (rightWildcardType == null) {
            TypeConversionUtil.$$$reportNull$$$0(36);
        }
        if (rightWildcardType.isSuper() && (aClass2 = PsiUtil.resolveClassInType(rightWildcardType.getSuperBound())) instanceof PsiTypeParameter) {
            PsiClassType[] types2;
            for (PsiClassType type2 : types2 = aClass2.getExtendsListTypes()) {
                if (!TypeConversionUtil.isAssignable(left, type2)) continue;
                return true;
            }
        }
        return TypeConversionUtil.isAssignable(left, rightWildcardType.getExtendsBound());
    }

    private static boolean isAssignableToWildcard(@NotNull PsiWildcardType wildcardType, @NotNull PsiType right) {
        if (wildcardType == null) {
            TypeConversionUtil.$$$reportNull$$$0(37);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(38);
        }
        if (wildcardType.isSuper()) {
            return TypeConversionUtil.isAssignable(wildcardType.getSuperBound(), right);
        }
        return TypeConversionUtil.isAssignable(wildcardType.getExtendsBound(), right);
    }

    private static boolean isUnboxable(@NotNull PsiPrimitiveType left, @NotNull PsiClassType right, @NotNull Set<? super PsiClassType> types2) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(39);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(40);
        }
        if (types2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(41);
        }
        if (!right.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return false;
        }
        PsiClass psiClass = right.resolve();
        if (psiClass == null) {
            return false;
        }
        if (psiClass instanceof PsiTypeParameter) {
            for (PsiClassType bound : psiClass.getExtendsListTypes()) {
                if (!types2.add(bound) || !TypeConversionUtil.isUnboxable(left, bound, types2)) continue;
                return true;
            }
            return false;
        }
        PsiPrimitiveType rightUnboxedType = PsiPrimitiveType.getUnboxedType(right);
        return rightUnboxedType != null && TypeConversionUtil.isAssignable(left, rightUnboxedType);
    }

    public static boolean boxingConversionApplicable(PsiType left, PsiType right) {
        if (left instanceof PsiPrimitiveType && !PsiType.NULL.equals(left)) {
            return right instanceof PsiClassType && TypeConversionUtil.isAssignable(left, right);
        }
        if (left instanceof PsiIntersectionType) {
            for (PsiType lConjunct : ((PsiIntersectionType)left).getConjuncts()) {
                if (TypeConversionUtil.boxingConversionApplicable(lConjunct, right)) continue;
                return false;
            }
            return true;
        }
        return left instanceof PsiClassType && right instanceof PsiPrimitiveType && !PsiType.NULL.equals(right) && TypeConversionUtil.isAssignable(left, right);
    }

    private static boolean isBoxable(@NotNull PsiClassType left, @NotNull PsiPrimitiveType right) {
        if (left == null) {
            TypeConversionUtil.$$$reportNull$$$0(42);
        }
        if (right == null) {
            TypeConversionUtil.$$$reportNull$$$0(43);
        }
        if (!left.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_5)) {
            return false;
        }
        PsiClass psiClass = left.resolve();
        if (psiClass == null) {
            return false;
        }
        String qname = psiClass.getQualifiedName();
        if (qname == null || !(psiClass instanceof PsiTypeParameter) && !TypeConversionUtil.getAllBoxedTypeSupers(psiClass).contains(qname)) {
            return false;
        }
        PsiClassType rightBoxed = right.getBoxedType(psiClass.getManager(), left.getResolveScope());
        return rightBoxed != null && TypeConversionUtil.isAssignable(left, rightBoxed);
    }

    @NotNull
    private static Set<String> getAllBoxedTypeSupers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(44);
        }
        PsiManager manager = psiClass.getManager();
        Project project = psiClass.getProject();
        CachedValue<Set<String>> boxedHolderTypes = project.getUserData(POSSIBLE_BOXED_HOLDER_TYPES);
        if (boxedHolderTypes == null) {
            boxedHolderTypes = CachedValuesManager.getManager(manager.getProject()).createCachedValue(() -> {
                JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
                THashSet set = new THashSet();
                for (String qname : JvmPrimitiveTypeKind.getBoxedFqns()) {
                    PsiClass boxedClass = facade.findClass(qname, GlobalSearchScope.allScope(project));
                    InheritanceUtil.processSupers(boxedClass, true, arg_0 -> TypeConversionUtil.lambda$getAllBoxedTypeSupers$0((Set)set, arg_0));
                }
                return CachedValueProvider.Result.create(set, ProjectRootModificationTracker.getInstance(project));
            }, false);
            project.putUserData(POSSIBLE_BOXED_HOLDER_TYPES, boxedHolderTypes);
        }
        Set<String> set = boxedHolderTypes.getValue();
        if (set == null) {
            TypeConversionUtil.$$$reportNull$$$0(45);
        }
        return set;
    }

    private static boolean isClassAssignable(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion, GlobalSearchScope resolveScope, boolean capture) {
        if (leftResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(46);
        }
        if (rightResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(47);
        }
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        if (leftClass == null || rightClass == null) {
            return false;
        }
        PsiSubstitutor superSubstitutor = JavaClassSupers.getInstance().getSuperClassSubstitutor(leftClass, rightClass, resolveScope, rightResult.getSubstitutor());
        return superSubstitutor != null && TypeConversionUtil.typeParametersAgree(leftResult, rightResult, allowUncheckedConversion, superSubstitutor, capture);
    }

    private static boolean typeParametersAgree(@NotNull PsiClassType.ClassResolveResult leftResult, @NotNull PsiClassType.ClassResolveResult rightResult, boolean allowUncheckedConversion, PsiSubstitutor superSubstitutor, boolean capture) {
        if (leftResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(48);
        }
        if (rightResult == null) {
            TypeConversionUtil.$$$reportNull$$$0(49);
        }
        PsiSubstitutor rightSubstitutor = rightResult.getSubstitutor();
        PsiClass leftClass = leftResult.getElement();
        PsiClass rightClass = rightResult.getElement();
        Iterator<PsiTypeParameter> li = PsiUtil.typeParametersIterator(leftClass);
        if (!li.hasNext()) {
            return true;
        }
        PsiSubstitutor leftSubstitutor = leftResult.getSubstitutor();
        if (!leftClass.getManager().areElementsEquivalent(leftClass, rightClass)) {
            rightSubstitutor = superSubstitutor;
            rightClass = leftClass;
        } else if (!PsiUtil.typeParametersIterator(rightClass).hasNext()) {
            return true;
        }
        Iterator<PsiTypeParameter> ri = PsiUtil.typeParametersIterator(rightClass);
        while (li.hasNext()) {
            PsiType typeRight;
            if (!ri.hasNext()) {
                return false;
            }
            PsiTypeParameter lp = li.next();
            PsiTypeParameter rp = ri.next();
            PsiType typeLeft = leftSubstitutor.substitute(lp);
            if (typeLeft == null) continue;
            PsiType psiType2 = typeRight = PsiCapturedWildcardType.isCapture() && capture ? rightSubstitutor.substituteWithBoundsPromotion(rp) : rightSubstitutor.substitute(rp);
            if (typeRight == null) {
                return allowUncheckedConversion;
            }
            if (TypeConversionUtil.typesAgree(typeLeft, typeRight, allowUncheckedConversion)) continue;
            return false;
        }
        return true;
    }

    public static boolean typesAgree(@NotNull PsiType typeLeft, @NotNull PsiType typeRight, boolean allowUncheckedConversion) {
        if (typeLeft == null) {
            TypeConversionUtil.$$$reportNull$$$0(50);
        }
        if (typeRight == null) {
            TypeConversionUtil.$$$reportNull$$$0(51);
        }
        if (typeLeft instanceof PsiWildcardType) {
            PsiWildcardType leftWildcard = (PsiWildcardType)typeLeft;
            PsiType leftBound = leftWildcard.getBound();
            if (leftBound == null) {
                return true;
            }
            if (leftBound.equalsToText("java.lang.Object")) {
                if (!leftWildcard.isSuper()) {
                    return true;
                }
                if (typeRight.equalsToText("java.lang.Object")) {
                    return true;
                }
            }
            if (typeRight instanceof PsiWildcardType) {
                PsiWildcardType rightWildcard = (PsiWildcardType)typeRight;
                PsiType bound = rightWildcard.getBound();
                if (leftWildcard.isExtends() && bound != null) {
                    return rightWildcard.isExtends() && TypeConversionUtil.isAssignable(leftBound, bound, allowUncheckedConversion, false);
                }
                if (rightWildcard.isSuper() && bound != null) {
                    NotNullComputable checkAssignable = () -> TypeConversionUtil.isAssignable(bound, leftBound, allowUncheckedConversion, false);
                    Boolean assignable = (Boolean)ourGuard.doPreventingRecursion(rightWildcard, true, checkAssignable);
                    return assignable != null && assignable != false;
                }
                return false;
            }
            if (leftWildcard.isExtends()) {
                return TypeConversionUtil.isAssignable(leftBound, typeRight, false, false);
            }
            NotNullComputable checkAssignable = () -> TypeConversionUtil.isAssignable(typeRight, leftBound, false, false);
            Boolean assignable = (Boolean)ourGuard.doPreventingRecursion(leftWildcard, true, checkAssignable);
            return assignable == null || assignable != false;
        }
        return typeLeft.equals(typeRight);
    }

    @Nullable
    public static PsiSubstitutor getClassSubstitutor(@NotNull PsiClass superClassCandidate, @NotNull PsiClass derivedClassCandidate, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClassCandidate == null) {
            TypeConversionUtil.$$$reportNull$$$0(52);
        }
        if (derivedClassCandidate == null) {
            TypeConversionUtil.$$$reportNull$$$0(53);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(54);
        }
        if (superClassCandidate.getManager().areElementsEquivalent(superClassCandidate, derivedClassCandidate)) {
            PsiTypeParameter[] baseParams = superClassCandidate.getTypeParameters();
            PsiTypeParameter[] derivedParams = derivedClassCandidate.getTypeParameters();
            if (baseParams.length > 0 && derivedParams.length == 0) {
                return JavaPsiFacade.getElementFactory(superClassCandidate.getProject()).createRawSubstitutor(superClassCandidate);
            }
            return derivedSubstitutor;
        }
        return TypeConversionUtil.getMaybeSuperClassSubstitutor(superClassCandidate, derivedClassCandidate, derivedSubstitutor);
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass2, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(55);
        }
        if (derivedClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(56);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(57);
        }
        if (!superClass2.hasTypeParameters() && superClass2.getContainingClass() == null) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                TypeConversionUtil.$$$reportNull$$$0(58);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor substitutor2 = TypeConversionUtil.getMaybeSuperClassSubstitutor(superClass2, derivedClass, derivedSubstitutor);
        if (substitutor2 == null) {
            JavaClassSupers.getInstance().reportHierarchyInconsistency(superClass2, derivedClass);
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                TypeConversionUtil.$$$reportNull$$$0(59);
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = substitutor2;
        if (psiSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(60);
        }
        return psiSubstitutor;
    }

    @Nullable
    public static PsiSubstitutor getMaybeSuperClassSubstitutor(@NotNull PsiClass superClass2, @NotNull PsiClass derivedClass, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (superClass2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(61);
        }
        if (derivedClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(62);
        }
        if (derivedSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(63);
        }
        return JavaClassSupers.getInstance().getSuperClassSubstitutor(superClass2, derivedClass, derivedClass.getResolveScope(), derivedSubstitutor);
    }

    @NotNull
    public static PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass2, @NotNull PsiClassType classType) {
        if (superClass2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(64);
        }
        if (classType == null) {
            TypeConversionUtil.$$$reportNull$$$0(65);
        }
        PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
        return TypeConversionUtil.getSuperClassSubstitutor(superClass2, classResolveResult.getElement(), classResolveResult.getSubstitutor());
    }

    @NotNull
    public static PsiType binaryNumericPromotion(PsiType type1, PsiType type2) {
        type1 = TypeConversionUtil.uncapture(type1);
        type2 = TypeConversionUtil.uncapture(type2);
        if (TypeConversionUtil.isDoubleType(type1)) {
            return TypeConversionUtil.unbox(type1);
        }
        if (TypeConversionUtil.isDoubleType(type2)) {
            return TypeConversionUtil.unbox(type2);
        }
        if (TypeConversionUtil.isFloatType(type1)) {
            return TypeConversionUtil.unbox(type1);
        }
        if (TypeConversionUtil.isFloatType(type2)) {
            return TypeConversionUtil.unbox(type2);
        }
        if (TypeConversionUtil.isLongType(type1)) {
            return TypeConversionUtil.unbox(type1);
        }
        if (TypeConversionUtil.isLongType(type2)) {
            return TypeConversionUtil.unbox(type2);
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            TypeConversionUtil.$$$reportNull$$$0(66);
        }
        return psiPrimitiveType;
    }

    @NotNull
    private static PsiType unbox(@NotNull PsiType type2) {
        if (type2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(67);
        }
        if (type2 instanceof PsiPrimitiveType) {
            PsiType psiType2 = type2;
            if (psiType2 == null) {
                TypeConversionUtil.$$$reportNull$$$0(68);
            }
            return psiType2;
        }
        if (type2 instanceof PsiClassType) {
            LOG.assertTrue((type2 = PsiPrimitiveType.getUnboxedType(type2)) != null);
            PsiType psiType3 = type2;
            if (psiType3 == null) {
                TypeConversionUtil.$$$reportNull$$$0(69);
            }
            return psiType3;
        }
        LOG.error("Invalid type for unboxing " + type2);
        PsiType psiType4 = type2;
        if (psiType4 == null) {
            TypeConversionUtil.$$$reportNull$$$0(70);
        }
        return psiType4;
    }

    public static boolean isIntegerNumber(@NotNull String typeName) {
        if (typeName == null) {
            TypeConversionUtil.$$$reportNull$$$0(71);
        }
        return INTEGER_NUMBER_TYPES.contains(typeName);
    }

    public static boolean isPrimitive(@NotNull String typeName) {
        if (typeName == null) {
            TypeConversionUtil.$$$reportNull$$$0(72);
        }
        return PRIMITIVE_TYPES.contains(typeName);
    }

    public static boolean isPrimitiveWrapper(@NotNull String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            TypeConversionUtil.$$$reportNull$$$0(73);
        }
        return PRIMITIVE_WRAPPER_FQNS.contains(fullyQualifiedName);
    }

    @Contract(value="null -> false")
    public static boolean isAssignableFromPrimitiveWrapper(@Nullable PsiType type2) {
        PsiType[] psiTypeArray;
        if (type2 == null) {
            return false;
        }
        if (TypeConversionUtil.isPrimitiveWrapper(type2)) {
            return true;
        }
        if (type2 instanceof PsiIntersectionType) {
            psiTypeArray = ((PsiIntersectionType)type2).getConjuncts();
        } else {
            PsiType[] psiTypeArray2 = new PsiType[1];
            psiTypeArray = psiTypeArray2;
            psiTypeArray2[0] = type2;
        }
        for (PsiType component : psiTypeArray) {
            if (!(component instanceof PsiClassType)) {
                return false;
            }
            if (component.equalsToText("java.lang.Object") || component.equalsToText("java.lang.Number") || component.equalsToText("java.io.Serializable") || component.equalsToText("java.lang.constant.Constable") || component.equalsToText("java.lang.constant.ConstantDesc") || ((PsiClassType)component).rawType().equalsToText("java.lang.Comparable")) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> false")
    public static boolean isPrimitiveWrapper(@Nullable PsiType type2) {
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        String name = ((PsiClassType)type2).getClassName();
        return PRIMITIVE_WRAPPER_SIMPLE_NAMES.contains(name) && TypeConversionUtil.isPrimitiveWrapper(type2.getCanonicalText());
    }

    @Contract(value="null -> false")
    public static boolean isComposite(@Nullable PsiType type2) {
        return type2 instanceof PsiDisjunctionType || type2 instanceof PsiIntersectionType;
    }

    public static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(74);
        }
        return TypeConversionUtil.typeParameterErasure(typeParameter, PsiSubstitutor.EMPTY);
    }

    private static PsiType typeParameterErasure(@NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor beforeSubstitutor) {
        PsiClassType[] extendsList;
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(75);
        }
        if (beforeSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(76);
        }
        if ((extendsList = typeParameter.getExtendsList().getReferencedTypes()).length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                THashSet visited2 = new THashSet();
                visited2.add(psiClass);
                PsiTypeParameter boundTypeParameter = (PsiTypeParameter)psiClass;
                if (beforeSubstitutor.getSubstitutionMap().containsKey(boundTypeParameter)) {
                    return TypeConversionUtil.erasure(beforeSubstitutor.substitute(boundTypeParameter));
                }
                return TypeConversionUtil.typeParameterErasureInner(boundTypeParameter, (Set<? super PsiClass>)visited2, beforeSubstitutor);
            }
            if (psiClass != null) {
                return JavaPsiFacade.getElementFactory(typeParameter.getProject()).createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    private static PsiClassType typeParameterErasureInner(@NotNull PsiTypeParameter typeParameter, @NotNull Set<? super PsiClass> visited2, @NotNull PsiSubstitutor beforeSubstitutor) {
        PsiClassType[] extendsList;
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(77);
        }
        if (visited2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(78);
        }
        if (beforeSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(79);
        }
        if ((extendsList = typeParameter.getExtendsList().getReferencedTypes()).length > 0) {
            PsiClass psiClass = extendsList[0].resolve();
            if (psiClass instanceof PsiTypeParameter) {
                if (!visited2.contains(psiClass)) {
                    visited2.add(psiClass);
                    if (beforeSubstitutor.getSubstitutionMap().containsKey(psiClass)) {
                        return (PsiClassType)TypeConversionUtil.erasure(beforeSubstitutor.substitute((PsiTypeParameter)psiClass));
                    }
                    return TypeConversionUtil.typeParameterErasureInner((PsiTypeParameter)psiClass, visited2, beforeSubstitutor);
                }
            } else if (psiClass != null) {
                return JavaPsiFacade.getElementFactory(typeParameter.getProject()).createType(psiClass);
            }
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    @Contract(value="null -> null")
    public static PsiType erasure(@Nullable PsiType type2) {
        return TypeConversionUtil.erasure(type2, PsiSubstitutor.EMPTY);
    }

    @Contract(value="null, _ -> null")
    public static PsiType erasure(@Nullable PsiType type2, final @NotNull PsiSubstitutor beforeSubstitutor) {
        if (beforeSubstitutor == null) {
            TypeConversionUtil.$$$reportNull$$$0(80);
        }
        if (type2 == null) {
            return null;
        }
        return type2.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            @NotNull
            public PsiType visitType(@NotNull PsiType type2) {
                if (type2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiType psiType2 = type2;
                if (psiType2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return psiType2;
            }

            @Override
            public PsiType visitClassType(@NotNull PsiClassType classType) {
                PsiClass aClass2;
                if (classType == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((aClass2 = classType.resolve()) instanceof PsiTypeParameter && !TypeConversionUtil.isFreshVariable((PsiTypeParameter)aClass2)) {
                    return TypeConversionUtil.typeParameterErasure((PsiTypeParameter)aClass2, beforeSubstitutor);
                }
                return classType.rawType();
            }

            @Override
            public PsiType visitWildcardType(@NotNull PsiWildcardType wildcardType) {
                if (wildcardType == null) {
                    2.$$$reportNull$$$0(3);
                }
                return wildcardType;
            }

            @Override
            @Nullable
            public PsiType visitCapturedWildcardType(@NotNull PsiCapturedWildcardType capturedWildcardType) {
                if (capturedWildcardType == null) {
                    2.$$$reportNull$$$0(4);
                }
                return capturedWildcardType.getUpperBound().accept(this);
            }

            @Override
            public PsiType visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
                if (primitiveType == null) {
                    2.$$$reportNull$$$0(5);
                }
                return primitiveType;
            }

            @Override
            public PsiType visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
                if (ellipsisType == null) {
                    2.$$$reportNull$$$0(6);
                }
                return this.visitArrayType(ellipsisType);
            }

            @Override
            public PsiType visitArrayType(@NotNull PsiArrayType arrayType) {
                PsiType componentType;
                PsiType newComponentType;
                if (arrayType == null) {
                    2.$$$reportNull$$$0(7);
                }
                if ((newComponentType = (componentType = arrayType.getComponentType()).accept(this)) == componentType) {
                    return arrayType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            @Override
            public PsiType visitDisjunctionType(@NotNull PsiDisjunctionType disjunctionType) {
                PsiClassType lub;
                if (disjunctionType == null) {
                    2.$$$reportNull$$$0(8);
                }
                return (lub = PsiTypesUtil.getLowestUpperBoundClassType(disjunctionType)) != null ? TypeConversionUtil.erasure(lub, beforeSubstitutor) : disjunctionType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wildcardType";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "capturedWildcardType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "primitiveType";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ellipsisType";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayType";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "disjunctionType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitType";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitClassType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitWildcardType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitCapturedWildcardType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPrimitiveType";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "visitEllipsisType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "visitArrayType";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "visitDisjunctionType";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
    }

    public static Object computeCastTo(Object operand, PsiType castType2) {
        Object value2;
        if (operand == null || castType2 == null) {
            return null;
        }
        if (operand instanceof String && castType2.equalsToText("java.lang.String") || operand instanceof Boolean && PsiType.BOOLEAN.equals(castType2)) {
            value2 = operand;
        } else {
            PsiType primitiveType = TypeConversionUtil.wrapperToPrimitive(operand);
            if (primitiveType == null) {
                return null;
            }
            if (castType2.equals(primitiveType)) {
                return operand;
            }
            int rankTo = TypeConversionUtil.getTypeRank(castType2);
            value2 = TypeConversionUtil.cast(operand, rankTo);
        }
        return value2;
    }

    @NotNull
    public static PsiType unboxAndBalanceTypes(PsiType type1, PsiType type2) {
        if (type1 instanceof PsiClassType) {
            type1 = PsiPrimitiveType.getUnboxedType(type1);
        }
        if (type2 instanceof PsiClassType) {
            type2 = PsiPrimitiveType.getUnboxedType(type2);
        }
        if (PsiType.DOUBLE.equals(type1) || PsiType.DOUBLE.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.DOUBLE;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(81);
            }
            return psiPrimitiveType;
        }
        if (PsiType.FLOAT.equals(type1) || PsiType.FLOAT.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.FLOAT;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(82);
            }
            return psiPrimitiveType;
        }
        if (PsiType.LONG.equals(type1) || PsiType.LONG.equals(type2)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.LONG;
            if (psiPrimitiveType == null) {
                TypeConversionUtil.$$$reportNull$$$0(83);
            }
            return psiPrimitiveType;
        }
        PsiPrimitiveType psiPrimitiveType = PsiType.INT;
        if (psiPrimitiveType == null) {
            TypeConversionUtil.$$$reportNull$$$0(84);
        }
        return psiPrimitiveType;
    }

    public static IElementType convertEQtoOperation(IElementType eqOpSign) {
        IElementType opSign = null;
        if (eqOpSign == JavaTokenType.ANDEQ) {
            opSign = JavaTokenType.AND;
        } else if (eqOpSign == JavaTokenType.ASTERISKEQ) {
            opSign = JavaTokenType.ASTERISK;
        } else if (eqOpSign == JavaTokenType.DIVEQ) {
            opSign = JavaTokenType.DIV;
        } else if (eqOpSign == JavaTokenType.GTGTEQ) {
            opSign = JavaTokenType.GTGT;
        } else if (eqOpSign == JavaTokenType.GTGTGTEQ) {
            opSign = JavaTokenType.GTGTGT;
        } else if (eqOpSign == JavaTokenType.LTLTEQ) {
            opSign = JavaTokenType.LTLT;
        } else if (eqOpSign == JavaTokenType.MINUSEQ) {
            opSign = JavaTokenType.MINUS;
        } else if (eqOpSign == JavaTokenType.OREQ) {
            opSign = JavaTokenType.OR;
        } else if (eqOpSign == JavaTokenType.PERCEQ) {
            opSign = JavaTokenType.PERC;
        } else if (eqOpSign == JavaTokenType.PLUSEQ) {
            opSign = JavaTokenType.PLUS;
        } else if (eqOpSign == JavaTokenType.XOREQ) {
            opSign = JavaTokenType.XOR;
        }
        return opSign;
    }

    public static PsiType calcTypeForBinaryExpression(PsiType lType, PsiType rType, @NotNull IElementType sign, boolean accessLType) {
        if (sign == null) {
            TypeConversionUtil.$$$reportNull$$$0(85);
        }
        if (sign == JavaTokenType.PLUS) {
            if (rType == null) {
                return null;
            }
            if (rType.equalsToText("java.lang.String")) {
                return rType;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (lType.equalsToText("java.lang.String")) {
                return lType;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.MINUS || sign == JavaTokenType.ASTERISK || sign == JavaTokenType.DIV || sign == JavaTokenType.PERC) {
            if (rType == null) {
                return null;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            return TypeConversionUtil.unboxAndBalanceTypes(lType, rType);
        }
        if (sign == JavaTokenType.LTLT || sign == JavaTokenType.GTGT || sign == JavaTokenType.GTGTGT) {
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            if (PsiType.BYTE.equals(lType) || PsiType.CHAR.equals(lType) || PsiType.SHORT.equals(lType)) {
                return PsiType.INT;
            }
            return lType;
        }
        if (PsiBinaryExpression.BOOLEAN_OPERATION_TOKENS.contains(sign)) {
            return PsiType.BOOLEAN;
        }
        if (sign == JavaTokenType.OR || sign == JavaTokenType.XOR || sign == JavaTokenType.AND) {
            if (rType instanceof PsiClassType) {
                rType = PsiPrimitiveType.getUnboxedType(rType);
            }
            if (lType instanceof PsiClassType) {
                lType = PsiPrimitiveType.getUnboxedType(lType);
            }
            if (rType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(rType)) {
                return PsiType.BOOLEAN;
            }
            if (!accessLType) {
                return NULL_TYPE;
            }
            if (lType == null) {
                return null;
            }
            if (PsiType.BOOLEAN.equals(lType)) {
                return PsiType.BOOLEAN;
            }
            if (PsiType.LONG.equals(lType) || PsiType.LONG.equals(rType)) {
                return PsiType.LONG;
            }
            return PsiType.INT;
        }
        LOG.error("Unknown token: " + sign);
        return null;
    }

    public static boolean isFPZero(@NotNull String text2) {
        if (text2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(86);
        }
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (Character.isDigit(c) && c != '0') {
                return false;
            }
            char d = Character.toUpperCase(c);
            if (d == 'E' || d == 'P') break;
        }
        return true;
    }

    public static boolean areSameFreshVariables(@NotNull PsiTypeParameter p1, @NotNull PsiTypeParameter p2) {
        PsiElement originalContext;
        if (p1 == null) {
            TypeConversionUtil.$$$reportNull$$$0(87);
        }
        if (p2 == null) {
            TypeConversionUtil.$$$reportNull$$$0(88);
        }
        return (originalContext = p1.getUserData(ORIGINAL_CONTEXT)) != null && originalContext == p2.getUserData(ORIGINAL_CONTEXT);
    }

    public static boolean isFreshVariable(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(89);
        }
        return typeParameter.getUserData(ORIGINAL_CONTEXT) != null;
    }

    public static void markAsFreshVariable(@NotNull PsiTypeParameter parameter, PsiElement context2) {
        if (parameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(90);
        }
        parameter.putUserData(ORIGINAL_CONTEXT, context2);
    }

    public static PsiType getInferredUpperBoundForSynthetic(@NotNull PsiTypeParameter psiClass) {
        if (psiClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(91);
        }
        return psiClass.getUserData(UPPER_BOUND);
    }

    public static PsiType getInferredLowerBoundForSynthetic(@NotNull PsiTypeParameter psiClass) {
        if (psiClass == null) {
            TypeConversionUtil.$$$reportNull$$$0(92);
        }
        return psiClass.getUserData(LOWER_BOUND);
    }

    public static void setInferredBoundsForSynthetic(@NotNull PsiTypeParameter parameter, PsiType lowerBound, @NotNull PsiType upperBound) {
        if (parameter == null) {
            TypeConversionUtil.$$$reportNull$$$0(93);
        }
        if (upperBound == null) {
            TypeConversionUtil.$$$reportNull$$$0(94);
        }
        assert (!parameter.isPhysical()) : parameter;
        parameter.putUserData(UPPER_BOUND, upperBound);
        parameter.putUserData(LOWER_BOUND, lowerBound);
    }

    public static boolean isSafeConversion(PsiType target, PsiType source) {
        if (target == null || source == null) {
            return false;
        }
        if (target.equals(source)) {
            return true;
        }
        int sourceRank = TYPE_TO_RANK_MAP.get((Object)source);
        int targetRank = TYPE_TO_RANK_MAP.get((Object)target);
        if (sourceRank == 0 || sourceRank > 7 || targetRank == 0 || targetRank > 7 || !IS_ASSIGNABLE_BIT_SET[sourceRank - 1][targetRank - 1]) {
            return false;
        }
        if (PsiType.INT.equals(source) && PsiType.FLOAT.equals(target)) {
            return false;
        }
        return !PsiType.LONG.equals(source) || !TypeConversionUtil.isFloatOrDoubleType(target);
    }

    private static Object cast(@NotNull Object operand, @TypeRank int rankTo) {
        Number number;
        if (operand == null) {
            TypeConversionUtil.$$$reportNull$$$0(95);
        }
        Number number2 = operand instanceof Character ? (Number)Integer.valueOf(((Character)operand).charValue()) : (Number)(number = operand instanceof Number ? (Number)operand : null);
        if (number == null) {
            return null;
        }
        switch (rankTo) {
            case 1: {
                return number.byteValue();
            }
            case 2: {
                return number.shortValue();
            }
            case 3: {
                return Character.valueOf((char)number.intValue());
            }
            case 4: {
                return number.intValue();
            }
            case 5: {
                return number.longValue();
            }
            case 6: {
                return Float.valueOf(number.floatValue());
            }
            case 7: {
                return number.doubleValue();
            }
        }
        return null;
    }

    private static PsiType wrapperToPrimitive(@NotNull Object o) {
        if (o == null) {
            TypeConversionUtil.$$$reportNull$$$0(96);
        }
        return WRAPPER_TO_PRIMITIVE.get(o.getClass());
    }

    private static /* synthetic */ boolean lambda$getAllBoxedTypeSupers$0(Set set, PsiClass psiClass1) {
        ContainerUtil.addIfNotNull(set, psiClass1.getQualifiedName());
        return true;
    }

    static {
        TYPE_TO_RANK_MAP.put((Object)PsiType.BYTE, 1);
        TYPE_TO_RANK_MAP.put((Object)PsiType.SHORT, 2);
        TYPE_TO_RANK_MAP.put((Object)PsiType.CHAR, 3);
        TYPE_TO_RANK_MAP.put((Object)PsiType.INT, 4);
        TYPE_TO_RANK_MAP.put((Object)PsiType.LONG, 5);
        TYPE_TO_RANK_MAP.put((Object)PsiType.FLOAT, 6);
        TYPE_TO_RANK_MAP.put((Object)PsiType.DOUBLE, 7);
        TYPE_TO_RANK_MAP.put((Object)PsiType.BOOLEAN, 10);
        POSSIBLE_BOXED_HOLDER_TYPES = Key.create("Types that may be possibly assigned from primitive ones");
        ourGuard = RecursionManager.createGuard("isAssignable");
        INTEGER_NUMBER_TYPES = new THashSet(5);
        INTEGER_NUMBER_TYPES.add(PsiType.BYTE.getName());
        INTEGER_NUMBER_TYPES.add(PsiType.CHAR.getName());
        INTEGER_NUMBER_TYPES.add(PsiType.LONG.getName());
        INTEGER_NUMBER_TYPES.add(PsiType.INT.getName());
        INTEGER_NUMBER_TYPES.add(PsiType.SHORT.getName());
        ((THashSet)INTEGER_NUMBER_TYPES).compact();
        PRIMITIVE_TYPES = new THashSet(9);
        PRIMITIVE_TYPES.add(PsiType.VOID.getName());
        PRIMITIVE_TYPES.add(PsiType.BYTE.getName());
        PRIMITIVE_TYPES.add(PsiType.CHAR.getName());
        PRIMITIVE_TYPES.add(PsiType.DOUBLE.getName());
        PRIMITIVE_TYPES.add(PsiType.FLOAT.getName());
        PRIMITIVE_TYPES.add(PsiType.LONG.getName());
        PRIMITIVE_TYPES.add(PsiType.INT.getName());
        PRIMITIVE_TYPES.add(PsiType.SHORT.getName());
        PRIMITIVE_TYPES.add(PsiType.BOOLEAN.getName());
        ((THashSet)PRIMITIVE_TYPES).compact();
        PRIMITIVE_WRAPPER_FQNS = ContainerUtil.immutableSet("java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Integer", "java.lang.Short", "java.lang.Boolean");
        PRIMITIVE_WRAPPER_SIMPLE_NAMES = ContainerUtil.map2Set(PRIMITIVE_WRAPPER_FQNS, StringUtil::getShortName);
        WRAPPER_TO_PRIMITIVE = new THashMap(8);
        WRAPPER_TO_PRIMITIVE.put(Boolean.class, PsiType.BOOLEAN);
        WRAPPER_TO_PRIMITIVE.put(Byte.class, PsiType.BYTE);
        WRAPPER_TO_PRIMITIVE.put(Character.class, PsiType.CHAR);
        WRAPPER_TO_PRIMITIVE.put(Short.class, PsiType.SHORT);
        WRAPPER_TO_PRIMITIVE.put(Integer.class, PsiType.INT);
        WRAPPER_TO_PRIMITIVE.put(Long.class, PsiType.LONG);
        WRAPPER_TO_PRIMITIVE.put(Float.class, PsiType.FLOAT);
        WRAPPER_TO_PRIMITIVE.put(Double.class, PsiType.DOUBLE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toType";
                break;
            }
            case 6: 
            case 74: 
            case 75: 
            case 77: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseResult";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derived";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 13: 
            case 54: 
            case 57: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor1";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor2";
                break;
            }
            case 23: 
            case 28: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 35: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 30: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightWildcardType";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wildcardType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 44: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftResult";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightResult";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeLeft";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRight";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassCandidate";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClassCandidate";
                break;
            }
            case 55: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 56: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClass";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedName";
                break;
            }
            case 76: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeSubstitutor";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 90: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBound";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/util/TypeConversionUtil";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainSafeSuperType";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBoxedTypeSupers";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassSubstitutor";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "binaryNumericPromotion";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "unbox";
                break;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "unboxAndBalanceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areTypesConvertible";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNarrowingReferenceConversionAllowed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "obtainSafeSuperType";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkSuperTypesWithDifferentTypeArguments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "areSameParameterTypes";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "areSameArgumentTypes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeRank";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryOperatorApplicable";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isUnaryOperatorApplicable";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAssignable";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableFromWildcard";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToWildcard";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isUnboxable";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isBoxable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getAllBoxedTypeSupers";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isClassAssignable";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "typeParametersAgree";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "typesAgree";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getClassSubstitutor";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassSubstitutor";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getMaybeSuperClassSubstitutor";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "unbox";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "isIntegerNumber";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitive";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitiveWrapper";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "typeParameterErasure";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "typeParameterErasureInner";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "erasure";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "calcTypeForBinaryExpression";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isFPZero";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "areSameFreshVariables";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isFreshVariable";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "markAsFreshVariable";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getInferredUpperBoundForSynthetic";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getInferredLowerBoundForSynthetic";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "setInferredBoundsForSynthetic";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "cast";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "wrapperToPrimitive";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 45: 
            case 58: 
            case 59: 
            case 60: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static @interface TypeRank {
    }
}

