/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.types;

import java.util.ArrayList;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMapper;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.load.java.components.TypeUsage;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaAnnotations;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.TypeParameterResolver;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeAttributes;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeFlexibility;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.JavaTypeResolverKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawSubstitution;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.types.RawTypeImpl;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaArrayType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifier;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaWildcardType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.LazyWrappedType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaTypeResolver {
    @NotNull
    private final LazyJavaResolverContext c;
    @NotNull
    private final TypeParameterResolver typeParameterResolver;

    public JavaTypeResolver(@NotNull LazyJavaResolverContext c, @NotNull TypeParameterResolver typeParameterResolver) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)typeParameterResolver, (String)"typeParameterResolver");
        this.c = c;
        this.typeParameterResolver = typeParameterResolver;
    }

    @NotNull
    public final KotlinType transformJavaType(@Nullable JavaType javaType, @NotNull JavaTypeAttributes attr) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        JavaType javaType2 = javaType;
        if (javaType2 instanceof JavaPrimitiveType) {
            PrimitiveType primitiveType = ((JavaPrimitiveType)javaType).getType();
            SimpleType simpleType2 = primitiveType != null ? this.c.getModule().getBuiltIns().getPrimitiveKotlinType(primitiveType) : this.c.getModule().getBuiltIns().getUnitType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"{\n                val primitiveType = javaType.type\n                if (primitiveType != null) c.module.builtIns.getPrimitiveKotlinType(primitiveType)\n                else c.module.builtIns.unitType\n            }");
            kotlinType = simpleType2;
        } else if (javaType2 instanceof JavaClassifierType) {
            kotlinType = this.transformJavaClassifierType((JavaClassifierType)javaType, attr);
        } else if (javaType2 instanceof JavaArrayType) {
            kotlinType = JavaTypeResolver.transformArrayType$default(this, (JavaArrayType)javaType, attr, false, 4, null);
        } else if (javaType2 instanceof JavaWildcardType) {
            KotlinType kotlinType2;
            Object object = ((JavaWildcardType)javaType).getBound();
            if (object == null) {
                kotlinType2 = null;
            } else {
                JavaType javaType3 = object;
                boolean bl = false;
                boolean bl2 = false;
                JavaType it = javaType3;
                boolean bl3 = false;
                kotlinType2 = this.transformJavaType(it, attr);
            }
            KotlinType kotlinType3 = kotlinType2;
            if (kotlinType3 == null) {
                object = this.c.getModule().getBuiltIns().getDefaultBound();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"c.module.builtIns.defaultBound");
                kotlinType = (KotlinType)object;
            } else {
                kotlinType = kotlinType3;
            }
        } else if (javaType2 == null) {
            SimpleType simpleType3 = this.c.getModule().getBuiltIns().getDefaultBound();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"c.module.builtIns.defaultBound");
            kotlinType = simpleType3;
        } else {
            throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Unsupported type: ", (Object)javaType));
        }
        return kotlinType;
    }

    @NotNull
    public final KotlinType transformArrayType(@NotNull JavaArrayType arrayType, @NotNull JavaTypeAttributes attr, boolean isVararg) {
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        JavaType javaComponentType = arrayType.getComponentType();
        JavaPrimitiveType javaPrimitiveType = javaComponentType instanceof JavaPrimitiveType ? (JavaPrimitiveType)javaComponentType : null;
        PrimitiveType primitiveType = javaPrimitiveType == null ? null : javaPrimitiveType.getType();
        LazyJavaAnnotations annotations2 = new LazyJavaAnnotations(this.c, arrayType, true);
        if (primitiveType != null) {
            SimpleType simpleType2 = this.c.getModule().getBuiltIns().getPrimitiveArrayKotlinType(primitiveType);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"c.module.builtIns.getPrimitiveArrayKotlinType(primitiveType)");
            SimpleType jetType = simpleType2;
            jetType.replaceAnnotations(Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Iterable)jetType.getAnnotations())));
            return attr.isForAnnotationParameter() ? (KotlinType)jetType : (KotlinType)KotlinTypeFactory.flexibleType(jetType, jetType.makeNullableAsSpecified(true));
        }
        KotlinType componentType = this.transformJavaType(javaComponentType, JavaTypeResolverKt.toAttributes$default(TypeUsage.COMMON, attr.isForAnnotationParameter(), null, 2, null));
        if (attr.isForAnnotationParameter()) {
            Variance projectionKind = isVararg ? Variance.OUT_VARIANCE : Variance.INVARIANT;
            SimpleType simpleType3 = this.c.getModule().getBuiltIns().getArrayType(projectionKind, componentType, annotations2);
            Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"c.module.builtIns.getArrayType(projectionKind, componentType, annotations)");
            return simpleType3;
        }
        SimpleType simpleType4 = this.c.getModule().getBuiltIns().getArrayType(Variance.INVARIANT, componentType, annotations2);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType4, (String)"c.module.builtIns.getArrayType(INVARIANT, componentType, annotations)");
        return KotlinTypeFactory.flexibleType(simpleType4, this.c.getModule().getBuiltIns().getArrayType(Variance.OUT_VARIANCE, componentType, annotations2).makeNullableAsSpecified(true));
    }

    public static /* synthetic */ KotlinType transformArrayType$default(JavaTypeResolver javaTypeResolver, JavaArrayType javaArrayType, JavaTypeAttributes javaTypeAttributes, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return javaTypeResolver.transformArrayType(javaArrayType, javaTypeAttributes, bl);
    }

    private final KotlinType transformJavaClassifierType(JavaClassifierType javaType, JavaTypeAttributes attr) {
        boolean useFlexible = !attr.isForAnnotationParameter() && attr.getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
        boolean isRaw = javaType.isRaw();
        if (!isRaw && !useFlexible) {
            SimpleType simpleType2 = this.computeSimpleJavaClassifierType(javaType, attr, null);
            return simpleType2 == null ? (KotlinType)JavaTypeResolver.transformJavaClassifierType$errorType(javaType) : (KotlinType)simpleType2;
        }
        SimpleType simpleType3 = this.computeSimpleJavaClassifierType(javaType, attr.withFlexibility(JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND), null);
        if (simpleType3 == null) {
            return JavaTypeResolver.transformJavaClassifierType$errorType(javaType);
        }
        SimpleType lower = simpleType3;
        SimpleType simpleType4 = this.computeSimpleJavaClassifierType(javaType, attr.withFlexibility(JavaTypeFlexibility.FLEXIBLE_UPPER_BOUND), lower);
        if (simpleType4 == null) {
            return JavaTypeResolver.transformJavaClassifierType$errorType(javaType);
        }
        SimpleType upper = simpleType4;
        return isRaw ? (KotlinType)new RawTypeImpl(lower, upper) : (KotlinType)KotlinTypeFactory.flexibleType(lower, upper);
    }

    private final SimpleType computeSimpleJavaClassifierType(JavaClassifierType javaType, JavaTypeAttributes attr, SimpleType lowerResult) {
        Object object = lowerResult;
        Annotations annotations2 = object == null ? null : object.getAnnotations();
        Annotations annotations3 = annotations2 == null ? (Annotations)new LazyJavaAnnotations(this.c, javaType, false, 4, null) : annotations2;
        object = this.computeTypeConstructor(javaType, attr);
        if (object == null) {
            return null;
        }
        Object constructor = object;
        boolean isNullable = this.isNullable(attr);
        SimpleType simpleType2 = lowerResult;
        if (Intrinsics.areEqual((Object)(simpleType2 == null ? null : simpleType2.getConstructor()), (Object)constructor) && !javaType.isRaw() && isNullable) {
            return lowerResult.makeNullableAsSpecified(true);
        }
        List<TypeProjection> arguments2 = this.computeArguments(javaType, attr, (TypeConstructor)constructor);
        return KotlinTypeFactory.simpleType$default(annotations3, (TypeConstructor)constructor, arguments2, isNullable, null, 16, null);
    }

    private final TypeConstructor computeTypeConstructor(JavaClassifierType javaType, JavaTypeAttributes attr) {
        Object object;
        JavaClassifier javaClassifier = javaType.getClassifier();
        if (javaClassifier == null) {
            return this.createNotFoundClass(javaType);
        }
        JavaClassifier classifier2 = javaClassifier;
        if ((javaClassifier = classifier2) instanceof JavaClass) {
            FqName $this$sure$iv = ((JavaClass)classifier2).getFqName();
            boolean $i$f$sure = false;
            Object object2 = $this$sure$iv;
            if (object2 == null) {
                String string;
                boolean bl = false;
                String string2 = string = Intrinsics.stringPlus((String)"Class type should have a FQ name: ", (Object)classifier2);
                throw new AssertionError((Object)string2);
            }
            Object fqName2 = object2;
            Object object3 = this.mapKotlinClass(javaType, attr, (FqName)fqName2);
            ClassDescriptor classData = object3 == null ? this.c.getComponents().getModuleClassResolver().resolveClass((JavaClass)classifier2) : object3;
            object2 = classData;
            Object object4 = object3 = object2 == null ? null : object2.getTypeConstructor();
            object = object3 == null ? this.createNotFoundClass(javaType) : object3;
        } else if (javaClassifier instanceof JavaTypeParameter) {
            TypeParameterDescriptor typeParameterDescriptor = this.typeParameterResolver.resolveTypeParameter((JavaTypeParameter)classifier2);
            object = typeParameterDescriptor == null ? null : typeParameterDescriptor.getTypeConstructor();
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Unknown classifier kind: ", (Object)classifier2));
        }
        return object;
    }

    private final TypeConstructor createNotFoundClass(JavaClassifierType javaType) {
        Object object = ClassId.topLevel(new FqName(javaType.getClassifierQualifiedName()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"topLevel(FqName(javaType.classifierQualifiedName))");
        ClassId classId = object;
        object = this.c.getComponents().getDeserializedDescriptorResolver().getComponents().getNotFoundClasses().getClass(classId, CollectionsKt.listOf((Object)0)).getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"c.components.deserializedDescriptorResolver.components.notFoundClasses.getClass(classId, listOf(0)).typeConstructor");
        return object;
    }

    private final ClassDescriptor mapKotlinClass(JavaClassifierType javaType, JavaTypeAttributes attr, FqName fqName2) {
        if (attr.isForAnnotationParameter() && Intrinsics.areEqual((Object)fqName2, (Object)JavaTypeResolverKt.access$getJAVA_LANG_CLASS_FQ_NAME$p$s1946801611())) {
            return this.c.getComponents().getReflectionTypes().getKClass();
        }
        JavaToKotlinClassMapper javaToKotlin = JavaToKotlinClassMapper.INSTANCE;
        ClassDescriptor classDescriptor = JavaToKotlinClassMapper.mapJavaToKotlin$default(javaToKotlin, fqName2, this.c.getModule().getBuiltIns(), null, 4, null);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor kotlinDescriptor = classDescriptor;
        if (javaToKotlin.isReadOnly(kotlinDescriptor) && (attr.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND || attr.getHowThisTypeIsUsed() == TypeUsage.SUPERTYPE || this.argumentsMakeSenseOnlyForMutableContainer(javaType, kotlinDescriptor))) {
            return javaToKotlin.convertReadOnlyToMutable(kotlinDescriptor);
        }
        return kotlinDescriptor;
    }

    private final boolean argumentsMakeSenseOnlyForMutableContainer(JavaClassifierType $this$argumentsMakeSenseOnlyForMutableContainer, ClassDescriptor readOnlyContainer) {
        Variance variance;
        if (!JavaTypeResolver.argumentsMakeSenseOnlyForMutableContainer$isSuperWildcard((JavaType)CollectionsKt.lastOrNull($this$argumentsMakeSenseOnlyForMutableContainer.getTypeArguments()))) {
            return false;
        }
        List<TypeParameterDescriptor> list = JavaToKotlinClassMapper.INSTANCE.convertReadOnlyToMutable(readOnlyContainer).getTypeConstructor().getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"JavaToKotlinClassMapper.convertReadOnlyToMutable(readOnlyContainer)\n            .typeConstructor.parameters");
        TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)CollectionsKt.lastOrNull(list);
        Variance variance2 = variance = typeParameterDescriptor == null ? null : typeParameterDescriptor.getVariance();
        if (variance == null) {
            return false;
        }
        Variance variance3 = variance;
        Variance mutableLastParameterVariance = variance3;
        return mutableLastParameterVariance != Variance.OUT_VARIANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final List<TypeProjection> computeArguments(JavaClassifierType javaType, JavaTypeAttributes attr, TypeConstructor constructor) {
        isRaw = javaType.isRaw();
        if (isRaw) ** GOTO lbl-1000
        if (javaType.getTypeArguments().isEmpty()) {
            var6_5 = constructor.getParameters();
            Intrinsics.checkNotNullExpressionValue(var6_5, (String)"constructor.parameters");
            var6_5 = var6_5;
            var7_6 = false;
            ** if (!(var6_5.isEmpty() == false)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl13
        }
lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
lbl13:
        // 2 sources

        eraseTypeParameters = v0;
        var7_7 = constructor.getParameters();
        Intrinsics.checkNotNullExpressionValue(var7_7, (String)"constructor.parameters");
        typeParameters = var7_7;
        if (eraseTypeParameters) {
            $this$map$iv = typeParameters;
            $i$f$map = false;
            var9_12 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var14_27 = (TypeParameterDescriptor)item$iv$iv;
                var22_35 = destination$iv$iv;
                $i$a$-map-JavaTypeResolver$computeArguments$1 = false;
                erasedUpperBound = new LazyWrappedType(this.c.getStorageManager(), (Function0<? extends KotlinType>)((Function0)new Function0<KotlinType>((TypeParameterDescriptor)parameter, attr, constructor){
                    final /* synthetic */ TypeParameterDescriptor $parameter;
                    final /* synthetic */ JavaTypeAttributes $attr;
                    final /* synthetic */ TypeConstructor $constructor;
                    {
                        this.$parameter = $parameter;
                        this.$attr = $attr;
                        this.$constructor = $constructor;
                        super(0);
                    }

                    @NotNull
                    public final KotlinType invoke() {
                        TypeParameterDescriptor typeParameterDescriptor = this.$parameter;
                        Intrinsics.checkNotNullExpressionValue((Object)typeParameterDescriptor, (String)"parameter");
                        return JavaTypeResolverKt.getErasedUpperBound(typeParameterDescriptor, this.$attr.getUpperBoundOfTypeParameter(), (Function0<? extends KotlinType>)((Function0)new Function0<KotlinType>(this.$constructor){
                            final /* synthetic */ TypeConstructor $constructor;
                            {
                                this.$constructor = $constructor;
                                super(0);
                            }

                            @NotNull
                            public final KotlinType invoke() {
                                ClassifierDescriptor classifierDescriptor = this.$constructor.getDeclarationDescriptor();
                                Intrinsics.checkNotNull((Object)classifierDescriptor);
                                SimpleType simpleType2 = classifierDescriptor.getDefaultType();
                                Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"constructor.declarationDescriptor!!.defaultType");
                                return TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2);
                            }
                        }));
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
                var23_38 = RawSubstitution.INSTANCE.computeProjection((TypeParameterDescriptor)parameter, isRaw != false ? attr : attr.withFlexibility(JavaTypeFlexibility.INFLEXIBLE), erasedUpperBound);
                var22_35.add(var23_38);
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        if (typeParameters.size() != javaType.getTypeArguments().size()) {
            $this$map$iv = typeParameters;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                parameter = (TypeParameterDescriptor)item$iv$iv;
                var22_36 = destination$iv$iv;
                $i$a$-map-JavaTypeResolver$computeArguments$2 = false;
                var23_39 = new TypeProjectionImpl(ErrorUtils.createErrorType(p.getName().asString()));
                var22_36.add(var23_39);
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        $this$map$iv = CollectionsKt.withIndex((Iterable)javaType.getTypeArguments());
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            p = (IndexedValue)item$iv$iv;
            var22_37 = destination$iv$iv;
            $i$a$-map-JavaTypeResolver$computeArguments$3 = false;
            var16_34 = indexedArgument;
            i = var16_34.component1();
            javaTypeArgument = (JavaType)var16_34.component2();
            var19_44 = i < typeParameters.size();
            var20_45 = false;
            if (_Assertions.ENABLED && !var19_44) {
                $i$a$-assert-JavaTypeResolver$computeArguments$3$1 = false;
                var21_47 = "Argument index should be less then type parameters count, but " + i + " > " + typeParameters.size();
                throw (Throwable)new AssertionError((Object)var21_47);
            }
            parameter = typeParameters.get(i);
            v1 = JavaTypeResolverKt.toAttributes$default(TypeUsage.COMMON, false, null, 3, null);
            Intrinsics.checkNotNullExpressionValue((Object)parameter, (String)"parameter");
            var23_40 = this.transformToTypeProjection(javaTypeArgument, v1, parameter);
            var22_37.add(var23_40);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final TypeProjection transformToTypeProjection(JavaType javaType, JavaTypeAttributes attr, TypeParameterDescriptor typeParameter) {
        TypeProjection typeProjection;
        JavaType javaType2 = javaType;
        if (javaType2 instanceof JavaWildcardType) {
            Variance projectionKind;
            JavaType bound = ((JavaWildcardType)javaType).getBound();
            Variance variance = projectionKind = ((JavaWildcardType)javaType).isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
            typeProjection = bound == null || this.isConflictingArgumentFor(projectionKind, typeParameter) ? JavaTypeResolverKt.makeStarProjection(typeParameter, attr) : TypeUtilsKt.createProjection(this.transformJavaType(bound, JavaTypeResolverKt.toAttributes$default(TypeUsage.COMMON, false, null, 3, null)), projectionKind, typeParameter);
        } else {
            typeProjection = new TypeProjectionImpl(Variance.INVARIANT, this.transformJavaType(javaType, attr));
        }
        return typeProjection;
    }

    private final boolean isConflictingArgumentFor(Variance $this$isConflictingArgumentFor, TypeParameterDescriptor typeParameter) {
        if (typeParameter.getVariance() == Variance.INVARIANT) {
            return false;
        }
        return $this$isConflictingArgumentFor != typeParameter.getVariance();
    }

    private final boolean isNullable(JavaTypeAttributes $this$isNullable) {
        if ($this$isNullable.getFlexibility() == JavaTypeFlexibility.FLEXIBLE_LOWER_BOUND) {
            return false;
        }
        return !$this$isNullable.isForAnnotationParameter() && $this$isNullable.getHowThisTypeIsUsed() != TypeUsage.SUPERTYPE;
    }

    private static final SimpleType transformJavaClassifierType$errorType(JavaClassifierType $javaType) {
        SimpleType simpleType2 = ErrorUtils.createErrorType(Intrinsics.stringPlus((String)"Unresolved java class ", (Object)$javaType.getPresentableText()));
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"createErrorType(\"Unresolved java class ${javaType.presentableText}\")");
        return simpleType2;
    }

    private static final boolean argumentsMakeSenseOnlyForMutableContainer$isSuperWildcard(JavaType $this$argumentsMakeSenseOnlyForMutableContainer_u24isSuperWildcard) {
        boolean bl;
        JavaWildcardType javaWildcardType;
        JavaWildcardType javaWildcardType2 = javaWildcardType = $this$argumentsMakeSenseOnlyForMutableContainer_u24isSuperWildcard instanceof JavaWildcardType ? (JavaWildcardType)$this$argumentsMakeSenseOnlyForMutableContainer_u24isSuperWildcard : null;
        if (javaWildcardType == null) {
            bl = false;
        } else {
            boolean bl2;
            JavaWildcardType javaWildcardType3 = javaWildcardType;
            boolean bl3 = false;
            boolean bl4 = false;
            JavaWildcardType it = javaWildcardType3;
            boolean bl5 = false;
            bl = bl2 = it.getBound() != null && !it.isExtends();
        }
        return bl;
    }
}

