/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThrowsChecker;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeThrowsCheckerKt;
import org.jetbrains.kotlin.utils.DFS;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00180\u001a2\u0006\u0010\r\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d*\u00020\u0014H\u0002J\u001e\u0010\u001f\u001a\u00020\u0012*\u0006\u0012\u0002\b\u00030\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "cancellationExceptionAndSupersClassIds", "", "Lorg/jetbrains/kotlin/name/ClassId;", "cancellationExceptionFqName", "Lorg/jetbrains/kotlin/name/FqName;", "throwsFqName", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkInheritance", "", "throwsAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "reportLocation", "Lorg/jetbrains/kotlin/psi/KtElement;", "decodeThrowsFilter", "Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker$ThrowsFilter;", "findInheritedThrows", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getVariadicArguments", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "isGlobalClassWithId", "classIds", "ThrowsFilter", "frontend.native"})
public final class NativeThrowsChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeThrowsChecker INSTANCE = new NativeThrowsChecker();
    @NotNull
    private static final FqName throwsFqName = AnnotationUtilKt.getKOTLIN_THROWS_ANNOTATION_FQ_NAME();
    @NotNull
    private static final FqName cancellationExceptionFqName = new FqName("kotlin.coroutines.cancellation.CancellationException");
    @NotNull
    private static final Set<ClassId> cancellationExceptionAndSupersClassIds;

    private NativeThrowsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Call call2;
        KtElement reportLocation;
        AnnotationDescriptor annotationDescriptor;
        KtAnnotationEntry ktAnnotationEntry;
        AnnotationDescriptor throwsAnnotation;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AnnotationDescriptor annotationDescriptor2 = throwsAnnotation = descriptor2.getAnnotations().findAnnotation(throwsFqName);
        if (annotationDescriptor2 == null) {
            ktAnnotationEntry = null;
        } else {
            annotationDescriptor = annotationDescriptor2;
            boolean bl = false;
            boolean bl2 = false;
            AnnotationDescriptor it = annotationDescriptor;
            boolean bl3 = false;
            ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(it);
        }
        KtAnnotationEntry throwsAnnotationEntry = ktAnnotationEntry;
        annotationDescriptor = throwsAnnotationEntry;
        KtElement ktElement = reportLocation = annotationDescriptor == null ? (KtElement)declaration2 : (KtElement)((Object)annotationDescriptor);
        if (!this.checkInheritance(declaration2, descriptor2, context2, throwsAnnotation, reportLocation)) {
            return;
        }
        if (throwsAnnotation == null) {
            return;
        }
        Object object = context2.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.trace.bindingContext");
        BindingContext bindingContext = object;
        object = throwsAnnotationEntry;
        if (Intrinsics.areEqual(object == null ? null : ((call2 = CallUtilKt.getCall((KtElement)object, bindingContext)) == null ? null : Boolean.valueOf(NativeThrowsCheckerKt.access$hasUnresolvedArgumentsRecursive(call2, bindingContext))), (Object)true)) {
            return;
        }
        List<ConstantValue<?>> classes2 = this.getVariadicArguments(throwsAnnotation);
        if (classes2.isEmpty()) {
            context2.getTrace().report(ErrorsNative.THROWS_LIST_EMPTY.on((KtElement)((PsiElement)reportLocation)));
            return;
        }
        if (declaration2.hasModifier(KtTokens.SUSPEND_KEYWORD)) {
            boolean bl;
            block11: {
                Iterable $this$none$iv = classes2;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        ConstantValue it = (ConstantValue)element$iv;
                        boolean bl4 = false;
                        if (!this.isGlobalClassWithId(it, cancellationExceptionAndSupersClassIds)) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                context2.getTrace().report(ErrorsNative.MISSING_EXCEPTION_IN_THROWS_ON_SUSPEND.on((KtElement)((PsiElement)reportLocation), cancellationExceptionFqName));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkInheritance(KtDeclaration declaration2, DeclarationDescriptor descriptor2, DeclarationCheckerContext context2, AnnotationDescriptor throwsAnnotation, KtElement reportLocation) {
        Map.Entry entry;
        Map.Entry $this$mapTo$iv$iv;
        if (!(descriptor2 instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)descriptor2).getOverriddenDescriptors().isEmpty()) {
            return true;
        }
        Iterable $this$distinctBy$iv = this.findInheritedThrows((CallableMemberDescriptor)descriptor2).entrySet();
        boolean $i$f$distinctBy = false;
        HashSet<ThrowsFilter> set$iv = new HashSet<ThrowsFilter>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Map.Entry it = (Map.Entry)e$iv;
            boolean bl = false;
            ThrowsFilter key$iv = (ThrowsFilter)it.getValue();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List inherited = list$iv;
        if (inherited.size() >= 2) {
            Collection<DeclarationDescriptor> collection;
            void $this$map$iv;
            $this$distinctBy$iv = inherited;
            PsiElement psiElement = declaration2;
            DiagnosticFactory1<KtDeclaration, Collection<DeclarationDescriptor>> diagnosticFactory1 = ErrorsNative.INCOMPATIBLE_THROWS_INHERITED;
            BindingTrace bindingTrace = context2.getTrace();
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                Object item$iv$iv = iterator2.next();
                Map.Entry bl = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)it.getKey()).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"it.key.containingDeclaration");
                DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
                collection.add(declarationDescriptor2);
            }
            collection = (List)destination$iv$iv;
            bindingTrace.report(diagnosticFactory1.on((KtDeclaration)psiElement, collection));
            return false;
        }
        if (throwsAnnotation == null) {
            return true;
        }
        Map.Entry $i$f$map = (Map.Entry)CollectionsKt.firstOrNull((List)inherited);
        if ($i$f$map == null) {
            return true;
        }
        $this$mapTo$iv$iv = entry = $i$f$map;
        boolean bl = false;
        CallableMemberDescriptor overriddenMember = (CallableMemberDescriptor)$this$mapTo$iv$iv.getKey();
        Map.Entry entry2 = entry;
        boolean bl3 = false;
        ThrowsFilter overriddenThrows = (ThrowsFilter)entry2.getValue();
        if (!Intrinsics.areEqual((Object)this.decodeThrowsFilter(throwsAnnotation), (Object)overriddenThrows)) {
            context2.getTrace().report(ErrorsNative.INCOMPATIBLE_THROWS_OVERRIDE.on((KtElement)((PsiElement)reportLocation), overriddenMember.getContainingDeclaration()));
            return false;
        }
        return true;
    }

    private final Map<CallableMemberDescriptor, ThrowsFilter> findInheritedThrows(CallableMemberDescriptor descriptor2) {
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        DFS.dfs(descriptor2.getOverriddenDescriptors(), findInheritedThrows.1.INSTANCE, new DFS.AbstractNodeHandler<CallableMemberDescriptor, Unit>((Map<CallableMemberDescriptor, ThrowsFilter>)result2, this){
            final /* synthetic */ Map<CallableMemberDescriptor, ThrowsFilter> $result;
            final /* synthetic */ NativeThrowsChecker this$0;
            {
                this.$result = $result;
                this.this$0 = $receiver;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean beforeChildren(@NotNull CallableMemberDescriptor current2) {
                AnnotationDescriptor throwsAnnotation;
                Intrinsics.checkNotNullParameter((Object)current2, (String)"current");
                Map<CallableMemberDescriptor, ThrowsFilter> map = current2.getAnnotations().findAnnotation(NativeThrowsChecker.access$getThrowsFqName$p$s-2132298319());
                boolean bl = false;
                boolean bl2 = false;
                AnnotationDescriptor it = map;
                boolean bl3 = false;
                AnnotationDescriptor annotationDescriptor = throwsAnnotation = current2.getKind().isReal() ? map : null;
                if (throwsAnnotation == null) {
                    map = current2.getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(map, (String)"current.overriddenDescriptors");
                    bl = false;
                    if (!map.isEmpty()) {
                        return true;
                    }
                    boolean bl4 = false;
                    if (bl4) {
                        return true;
                    }
                }
                map = this.$result;
                CallableMemberDescriptor callableMemberDescriptor = current2.getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"current.original");
                ThrowsFilter throwsFilter = NativeThrowsChecker.access$decodeThrowsFilter(this.this$0, throwsAnnotation);
                boolean bl5 = false;
                map.put(callableMemberDescriptor, throwsFilter);
                return false;
            }

            public void result() {
            }
        });
        return result2;
    }

    private final List<ConstantValue<?>> getVariadicArguments(AnnotationDescriptor $this$getVariadicArguments) {
        ArrayValue arrayValue;
        ConstantValue<?> constantValue = DescriptorUtilsKt.firstArgument($this$getVariadicArguments);
        ArrayValue arrayValue2 = arrayValue = constantValue instanceof ArrayValue ? (ArrayValue)constantValue : null;
        if (arrayValue == null) {
            return CollectionsKt.emptyList();
        }
        ArrayValue argument = arrayValue;
        return (List)argument.getValue();
    }

    private final ThrowsFilter decodeThrowsFilter(AnnotationDescriptor throwsAnnotation) {
        Set set;
        AnnotationDescriptor annotationDescriptor = throwsAnnotation;
        if (annotationDescriptor == null) {
            set = null;
        } else {
            List<ConstantValue<?>> list2 = this.getVariadicArguments(annotationDescriptor);
            set = CollectionsKt.toSet((Iterable)list2);
        }
        return new ThrowsFilter(set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isGlobalClassWithId(ConstantValue<?> $this$isGlobalClassWithId, Set<ClassId> classIds) {
        if (!($this$isGlobalClassWithId instanceof KClassValue)) return false;
        KClassValue.Value value2 = (KClassValue.Value)((KClassValue)$this$isGlobalClassWithId).getValue();
        if (!(value2 instanceof KClassValue.Value.NormalClass)) {
            if (!(value2 instanceof KClassValue.Value.LocalClass)) throw new NoWhenBranchMatchedException();
            return false;
        }
        boolean bl = classIds.contains(((KClassValue.Value.NormalClass)value2).getClassId());
        if (!bl) return false;
        return true;
    }

    public static final /* synthetic */ FqName access$getThrowsFqName$p$s-2132298319() {
        return throwsFqName;
    }

    public static final /* synthetic */ ThrowsFilter access$decodeThrowsFilter(NativeThrowsChecker $this, AnnotationDescriptor throwsAnnotation) {
        return $this.decodeThrowsFilter(throwsAnnotation);
    }

    static {
        Object[] objectArray = new FqName[]{StandardNames.FqNames.throwable, new FqName("kotlin.Exception"), new FqName("kotlin.RuntimeException"), new FqName("kotlin.IllegalStateException"), cancellationExceptionFqName};
        cancellationExceptionAndSupersClassIds = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (Function1)cancellationExceptionAndSupersClassIds.1.INSTANCE));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\b\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\t\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeThrowsChecker$ThrowsFilter;", "", "classes", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "(Ljava/util/Set;)V", "getClasses", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "frontend.native"})
    private static final class ThrowsFilter {
        @Nullable
        private final Set<ConstantValue<?>> classes;

        public ThrowsFilter(@Nullable Set<? extends ConstantValue<?>> classes2) {
            this.classes = classes2;
        }

        @Nullable
        public final Set<ConstantValue<?>> getClasses() {
            return this.classes;
        }

        @Nullable
        public final Set<ConstantValue<?>> component1() {
            return this.classes;
        }

        @NotNull
        public final ThrowsFilter copy(@Nullable Set<? extends ConstantValue<?>> classes2) {
            return new ThrowsFilter(classes2);
        }

        public static /* synthetic */ ThrowsFilter copy$default(ThrowsFilter throwsFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = throwsFilter.classes;
            }
            return throwsFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "ThrowsFilter(classes=" + this.classes + ')';
        }

        public int hashCode() {
            return this.classes == null ? 0 : ((Object)this.classes).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ThrowsFilter)) {
                return false;
            }
            ThrowsFilter throwsFilter = (ThrowsFilter)other;
            return Intrinsics.areEqual(this.classes, throwsFilter.classes);
        }
    }
}

