/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.jetbrains.annotations.NotNull;

public class TransformBackedProvider<OUT, IN>
extends AbstractMinimalProvider<OUT> {
    private final Transformer<? extends OUT, ? super IN> transformer;
    private final ProviderInternal<? extends IN> provider;

    public TransformBackedProvider(Transformer<? extends OUT, ? super IN> transformer, ProviderInternal<? extends IN> provider) {
        this.transformer = transformer;
        this.provider = provider;
    }

    @Override
    @Nullable
    public Class<OUT> getType() {
        return null;
    }

    public Transformer<? extends OUT, ? super IN> getTransformer() {
        return this.transformer;
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return this.provider.getProducer();
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends OUT> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue<IN> value = this.provider.calculateExecutionTimeValue();
        if (value.hasChangingContent()) {
            return ValueSupplier.ExecutionTimeValue.changingValue(new TransformBackedProvider<OUT, IN>(this.transformer, value.toProvider()));
        }
        return ValueSupplier.ExecutionTimeValue.value(this.mapValue(value.toValue()));
    }

    @Override
    protected ValueSupplier.Value<? extends OUT> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        this.beforeRead();
        ValueSupplier.Value<? extends IN> value = this.provider.calculateValue(consumer);
        return this.mapValue(value);
    }

    @NotNull
    private ValueSupplier.Value<? extends OUT> mapValue(ValueSupplier.Value<? extends IN> value) {
        if (value.isMissing()) {
            return value.asType();
        }
        Object result = this.transformer.transform(value.get());
        if (result == null) {
            return ValueSupplier.Value.missing();
        }
        return ValueSupplier.Value.of(result);
    }

    private void beforeRead() {
        this.provider.getProducer().visitContentProducerTasks((Action<? super Task>)((Action)producer -> {
            if (!producer.getState().getExecuted()) {
                throw new InvalidUserCodeException(String.format("Querying the mapped value of %s before %s has completed is not supported", this.provider, producer));
            }
        }));
    }

    @Override
    public String toString() {
        return "map(" + this.provider + ")";
    }
}

