/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.security.internal.Fingerprint;
import org.gradle.security.internal.PublicKeyResultBuilder;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.SecuritySupport;

public class KeyringFilePublicKeyService
implements PublicKeyService {
    private static final Logger LOGGER = Logging.getLogger(KeyringFilePublicKeyService.class);
    private final Map<Fingerprint, PGPPublicKeyRing> keyToKeyring;
    private final Multimap<Long, PGPPublicKeyRing> longIdToPublicKeys;

    public KeyringFilePublicKeyService(File keyRingFile) {
        try {
            List<PGPPublicKeyRing> keyrings = SecuritySupport.loadKeyRingFile(keyRingFile);
            HashMap keyToKeyringBuilder = Maps.newHashMap();
            ImmutableListMultimap.Builder longIdLongPGPPublicKeyBuilder = ImmutableListMultimap.builder();
            for (PGPPublicKeyRing keyring : keyrings) {
                Iterator it = keyring.getPublicKeys();
                while (it.hasNext()) {
                    PGPPublicKey key = (PGPPublicKey)it.next();
                    Fingerprint fingerprint = Fingerprint.of(key);
                    keyToKeyringBuilder.put(fingerprint, keyring);
                    longIdLongPGPPublicKeyBuilder.put((Object)key.getKeyID(), (Object)keyring);
                }
            }
            this.keyToKeyring = ImmutableMap.copyOf((Map)keyToKeyringBuilder);
            this.longIdToPublicKeys = longIdLongPGPPublicKeyBuilder.build();
            LOGGER.info("Loaded {} keys from {}", (Object)this.keyToKeyring.size(), (Object)keyRingFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void findByLongId(long keyId, PublicKeyResultBuilder builder) {
        for (PGPPublicKeyRing keyring : this.longIdToPublicKeys.get((Object)keyId)) {
            builder.keyRing(keyring);
            Iterator pkIt = keyring.getPublicKeys();
            while (pkIt.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)pkIt.next();
                if (key.getKeyID() != keyId) continue;
                builder.publicKey(key);
            }
        }
    }

    @Override
    public void findByFingerprint(byte[] bytes, PublicKeyResultBuilder builder) {
        Fingerprint fingerprint = Fingerprint.wrap(bytes);
        PGPPublicKeyRing keyring = this.keyToKeyring.get(fingerprint);
        if (keyring != null) {
            builder.keyRing(keyring);
            Iterator pkIt = keyring.getPublicKeys();
            while (pkIt.hasNext()) {
                PGPPublicKey key = (PGPPublicKey)pkIt.next();
                if (!Arrays.equals(key.getFingerprint(), bytes)) continue;
                builder.publicKey(key);
            }
        }
    }
}

